/*
* recupera o mapper mybatis definido no arquivo XML
*/

/* global mapperFactory, message, java */
var mpPedidoEltr = mapperFactory.createMapper("EstPedEltr");


var usuario = message.get("usuario");
var filiais = message.get("filiais");
var fornecedor = message.get("fornecedor");

if(message.get("isAgenda") === true){
    var agenda = message.get("agenda");
}

var dtCad = new java.text.SimpleDateFormat('yyyy-MM-dd HH:mm:ss').format(new Date());
var dtGrpPed = new java.text.SimpleDateFormat('yyyy-MM-dd').format(new Date());

var bandeiras = [];
var idxBandeira = [];

try {
		
		var erroLog = '';
    for (i = 0; i < filiais.size(); i++) {
    
    		var varCdPed  = 0;
        var cabecalho = filiais.get(i);
        
        cabecalho.put("dtPed", dtGrpPed);
        cabecalho.put('cdEmp', message.get("cdEmp"));
        cabecalho.put('cdFilFat', cabecalho.get("cdFilial"));
        cabecalho.put('cdFilEntr', cabecalho.get("cdFilial"));
        cabecalho.put('cdUsu', usuario.get("cdUsu"));
        /**
         * Caso tiver fornecedor será gerado pedido e a demanda é fechada
         */
        if(fornecedor){
        	cabecalho.put('flagFechar', 1);
        }

        //inserir cabecalho pedido eletr
        mpPedidoEltr.insert("incluirEstPedEltr", cabecalho);

        //Inserindo itens do pedido eletronico
        var produtos = cabecalho.get("produtos");
        for (j = 0; j < produtos.size(); j++) {
            var item = produtos.get(j);

            item.put("cdPedSol", cabecalho.get("cdPedSol"));
            item.put("cdEmp", message.get("cdEmp"));

            mpPedidoEltr.insert("incluirEstPedEltrIt", item);
        }
        
        //Prepra para gerar grupo por bandeiras
        var idx = -1; 
        
        for(b=0; b< bandeiras.length; b++){
            if(bandeiras[b].cdBandeira == cabecalho.get('cdBandeira')){
                idx = b;
            }
        }
        
        if( idx > -1){            
            bandeiras[idx].filiais.push({cdFilial: cabecalho.get("cdFilial"), cdPedSol: cabecalho.get("cdPedSol"), cdPed : varCdPed});
        }else{
            bandeiras.push({cdBandeira: cabecalho.get('cdBandeira'), filiais: [ {cdFilial: cabecalho.get("cdFilial"), cdPedSol: cabecalho.get("cdPedSol"), cdPed : varCdPed} ]});
        }
        
        //gravando cabecalho do pedido de compra
        if(fornecedor){
            fornecedor.put("cdPedSol", cabecalho.get("cdPedSol"));
            fornecedor.put("cdEmp", message.get("cdEmp"));
            fornecedor.put("cdFilial", cabecalho.get("cdFilial"));
            fornecedor.put("aplicativo", "Gestao Suite");
            fornecedor.put("versaoAplicativo", "1.0.0");
            fornecedor.put("dtEmi", dtGrpPed);
            fornecedor.put("dtPrevEnt", new java.text.SimpleDateFormat('yyyy-MM-dd').format(new Date(cabecalho.get("dtEntr").toString())));
            fornecedor.put("stsPed", 0);
            fornecedor.put('cdUsu', usuario.get("cdUsu"));
            fornecedor.put("dtCad", dtCad);
            
            fornecedor.put("vlrTotProd", cabecalho.get("vlrTotalProduto"));
            fornecedor.put("vlrDesc", cabecalho.get("vlrDesc"));
            fornecedor.put("vlrPed", cabecalho.get("vlrTotal"));

            fornecedor.put("vlrIcms", 0);
            fornecedor.put("vlrIpi", 0);
            fornecedor.put("vlrBaseSubs", 0);
            fornecedor.put("vlrIcmsSubs", 0);
            fornecedor.put("vlrBaseIcms", 0);
            fornecedor.put("vlrFrete", 0);
            fornecedor.put("flagGerarCross", 0);
            fornecedor.put("stsForn", 0);
            fornecedor.put("cdPed", 0);

            var cdNtMov = mpPedidoEltr.selectOne("movimentacaoPadrao", null);
            
            fornecedor.put("cdNtMov", cdNtMov);

            mpPedidoEltr.insert("incluirEstPedCp", fornecedor);
            mpPedidoEltr.insert("incluirEstPedCpVinculada", fornecedor);

            mpPedidoEltr.insert("incluirEstPedEltrForn", fornecedor);
            mpPedidoEltr.insert("incluirEstPedEltrFornPedCP", fornecedor);
   
            varCdPed = fornecedor.get("cdPed");

            //inserindo os itens do pedido de compra
            for (jf = 0; jf < produtos.size(); jf++) {
                
                //erroLog += 'Linha 115 pegando item na posicao '+jf+' para filial: '+cabecalho.get("cdFilial")+' \n ';
                var item = produtos.get(jf);
                //erroLog += 'Linha 122 filial: '+cabecalho.get("cdFilial")+' \n ';
                //erroLog += 'Linha 118 pegando coversao do item da posicao '+jf+' para filial: '+cabecalho.get("cdFilial")+' \n ';
                var conversao = item.get("conversao");
                //erroLog += 'Linha 118 pegando nome do item da posicao '+jf+' para filial: '+cabecalho.get("cdFilial")+' \n ';
                var cdProd = item.get("cdProd").toString();

                //erroLog += 'Linha 128 filial: '+cabecalho.get("cdFilial")+' \n ';
                var tributacaoProduto = {
                    "cdEmp": message.get("cdEmp"),
                    "cdFilial" : cabecalho.get("cdFilial"),
                    "cdMovOp" :fornecedor.get("cdNtMov"),
                    "cdPessoa" :fornecedor.get("cdForn"),
                    "cdProd" : cdProd.substring(0, cdProd.indexOf('.'))

                };
                
                
                var mapperParamEmpresa = mapperFactory.createMapper("PrcEmpConfig");
                var flagNaoGerarTributacaoObjetoRequest = {
                	'cdChave': 'FLAG_N_GERAR_PED_COMPRA_TRIB'
                };
                var resultFlagNaoGerarTributacaoObjetoRequest = mapperParamEmpresa.selectOne("listarPrcEmpConfig",flagNaoGerarTributacaoObjetoRequest);
                
                
                
                if(resultFlagNaoGerarTributacaoObjetoRequest.get("valor") == 1){
                	
                		var tributacao = {
                				'cdNtOp' : 1,
                				'cdTrib' : 1
                		};
                	
                }else{
                	 	//erroLog += 'Linha 137 filial: '+cabecalho.get("cdFilial")+' \n ';
                  	var tributacao = mpPedidoEltr.selectOne("tributacaoProduto", tributacaoProduto);
                  
                  	//erroLog += 'Linha 141 filial: '+cabecalho.get("cdFilial")+' \n ';
                  	if(tributacao === null || tributacao.get("cdNtOp") === null){
                      var msg  = "Natureza de operação não encontrada para o produto \n";
                          msg += "Produto      " + cdProd + " " + item.get("dsProd") +"\n" ;
                          msg += "Filial       " + cabecalho.get("cdFilial") + " " + cabecalho.get("dsFilial") +"\n" ;
                          msg += "Movimentação " + cdNtMov ;
                      throw msg;
                  	}else{
                  	    var tributacao = {
                				'cdNtOp' :  tributacao.get("cdNtOp"),
                				'cdTrib' :  tributacao.get("cdTrib")
                		};
                  	}
                }
                	
                
                //erroLog += 'Linha 150 filial: '+cabecalho.get("cdFilial")+' \n ';
                item.put("cdNtOp", tributacao.cdNtOp);

                //erroLog += 'Linha 152 filial: '+cabecalho.get("cdFilial")+' \n ';
                item.put("cdTrib", tributacao.dTrib);
                //erroLog += 'Linha 154 filial: '+cabecalho.get("cdFilial")+' \n ';
                item.put("vlrIt", item.get("vlrProd"));
                //erroLog += 'Linha 156 filial: '+cabecalho.get("cdFilial")+' \n ';
                item.put("vlrCusto", item.get("vlrProd"));
                //erroLog += 'Linha 158 filial: '+cabecalho.get("cdFilial")+' \n ';
                item.put("cdPed", fornecedor.get("cdPed"));
                //erroLog += 'Linha 160 filial: '+cabecalho.get("cdFilial")+' \n ';
                item.put("qtEmb", conversao.get("qtCpXEmbCp"));
                //erroLog += 'Linha 162 filial: '+cabecalho.get("cdFilial")+' \n ';
                item.put("seqItem", jf + 1);

                item.put("vlrIcms", 0);
                item.put("vlrBaseSubs", 0);
                item.put("vlrIcmsSubs", 0);
                item.put("vlrBaseIcms", 0);
                item.put("aliqIcms", 0);   
                item.put("percIpi",0);
                item.put("vlrIpi",0);
                
               erroLog += 'Linha 192 do item da posicao '+jf+' para filial: '+cabecalho.get("cdFilial")+' \n ';
       
                mpPedidoEltr.insert("incluirEstPedCpIt", item);
            }  
        }   
    }


    bandeiras.forEach(function (bandeira) {
        var idGrupoPedido = mpPedidoEltr.selectOne("nextId", message);

        bandeira.idGrupoPedido = idGrupoPedido;
        var nmUsu = (usuario.get("nmUsu").length() > 20 ? usuario.get("nmUsu").substring(0, 20) : usuario.get("nmUsu"));

        var mapGrupoPedido = {
            'cdEmp': message.get("cdEmp"),
            'cdUsu': usuario.get("cdUsu"),
            'dsGrpPed': 'DEMANDA ' + dtCad + ' ' + nmUsu,
            'dtGrpPed': dtGrpPed,
            'stsGrpPed': 0,
            'cdGrpPed': idGrupoPedido
        };

        if (message.get("dsGrpDemanda") !== "") {
            mapGrupoPedido.dsGrpPed = message.get("dsGrpDemanda") + ' ' + dtCad + ' ' + nmUsu;
        }

        mpPedidoEltr.insert("incluirEstPedEltrGrpPed", mapGrupoPedido);

        bandeira.filiais.forEach(function (filial) {
            mpPedidoEltr.insert("incluirEstPedEltrGrpPedEstPedEltr", {'cdEmp': message.get("cdEmp"), 'cdGrpPed': idGrupoPedido, 'cdPedSol': filial.cdPedSol});
        });
    });

    if (message.get("isAgenda") === true && agenda.get("cdAgenda") > 0) {
        mpPedidoEltr.update("alterarEstProdAgendaCompraAgendamento", agenda);
        mpPedidoEltr.insert("incluirEstProdAgendaCompraRealizado", agenda);
    }

    mpPedidoEltr.commit();

} catch (err) {
    java.lang.System.out.println(err);
    mpPedidoEltr.rollback();
    //throw "Ocorreu um erro: " + err;
    throw "<msg>" + err +"</msg>";
}

var resultado = {'result' : bandeiras};
resultado;