load('/rules/notaEntrada/validaDados.js');
var nota = mapperFactory.createMapperMult(["Importador", "EstNfEnt", "EstNfEntIt", "GlbMovOp", "EstNfEntDanfeProvisorio", "EstNfEntRcCli", "EstNfEntPgForn", "EstNfEntPrcFilial", "EstNfEntDanfeProvisorioEstNfEnt", "EstNfSerie"]);
try {
  var log = {};
  var obj = message.get("obj");
  var itens = obj.get("itens");

  //variaveis de validação de dados
  var variaveis = {};
  variaveis.cdEmp = obj.get("cdEmp");
  variaveis.cdFilial = obj.get("cdFilial");
  variaveis.cdForn = obj.get("cdForn");
  variaveis.nrNf = obj.get("nrNf");
  variaveis.dtEmiNf = obj.get("dtEmiNf");
  var validaNota = nota.selectOne("EstNfEnt.listarEstNfEnt", variaveis);

  if (validaNota) {
    throw { code: 500, message: "Nota " + variaveis.nrNf + ' Com entrada ja realizada na data ' + validaNota.get("dtEnt") };
  }

  validaDadosEnt(obj);

  if (parseInt(obj.get("cdNtMov")) > 0) {
    variaveis.cdMovOp = obj.get("cdNtMov");
    var destOrig = nota.selectOne("GlbMovOp.listarGlbMovOp", variaveis);
    if (!destOrig) {
      throw { code: 900, message: 'Natureza de movimentação ' + obj.get("cdNtMov") + ' nao cadastrada.' };
    }
  } else {
    throw { code: 900, message: 'Natureza de movimentacao Nao informada' };
  }


  if (parseInt(obj.get("flagNotaIntegracao")) > 0) {
    if (obj.get("nrAut")) {
      var nrAutorizador = {};
      nrAutorizador.nrAutorizador = obj.get("nrAut");
      danfeProvisorio = nota.selectOne("EstNfEntDanfeProvisorio.listarEstNfEntDanfeProvisorio", nrAutorizador);
      if (!danfeProvisorio) {
        throw { code: 900, message: 'Danfe de Numero ' + nrAutorizador.nrAutorizador + ' Nao Encontrado' };
      }
    }

    if (obj.get("cdNfSerie")) {
      var serieNf = {};                                                     // Variaveis para a validação da serie enviada
      serieNf.serie = String(parseInt(obj.get("cdNfSerie")));
      serieNf.espc = 'NFE';
      serieNf.codModelo = '55';
      serieNf.modelo = '55';
      cdNfSerie = nota.selectList("EstNfSerie.listarEstNfSerie", serieNf);
      if (!cdNfSerie) {
        throw { code: 900, message: 'Serie de nota fiscal ' + obj.get("cdNfSerie") + ' nao cadastrada.' };
      } else {
        obj.put("cdNfSerie", cdNfSerie.get(0).get("cdNfSerie"));     // pega a primeira serie do Retorno, pois pode haver mais de uma serie cadastrada com a mesma numeração
      }
    } else {
      throw { code: 900, message: 'Serie de nota fiscal nao informada' };
    }
  }

  log.msg = 'Incluindo Cabeçalho da Nota (EST_NF_ENT) nrNf: ' + obj.get("nrNf");
  nota.insert("EstNfEnt.incluirEstNfEnt", obj);        //INSERE Cabeçalho da Nota Fiscal

  if (parseInt(obj.get("flagNotaIntegracao")) > 0 && obj.get("nrAut") && (danfeProvisorio)) {   //Validação feita novamente pela a falta do dados do cabeçalho o qual é FK deste insert
    obj.put("cdCtr", danfeProvisorio.get("cdCtr"));
    obj.put("versaoAplicativo", '0.0.15');
    obj.put("aplicativo", 'TENTACLE');
    log.msg1 = 'Incluindo Vinculo da Nota de Entrada Com o Danfe Provisorio  (EST_NF_ENT_DANFE_PROVISORIO_EST_NF_ENT) nrNf: ' + obj.get("nrNf") + ' cdCtr: ' + danfeProvisorio.get("cdCtr");
    nota.insert("EstNfEntDanfeProvisorioEstNfEnt.incluirEstNfEntDanfeProvisorioEstNfEnt", obj);
  }
  
  for (i = 0; i < itens.size(); i++) {      // Insere Itens da Nota Fiscal
    var item = itens.get(i);
    item.put("cdNf", obj.get("cdNf"));
    log.msg2 += ' Incluindo Itens da Nota (EST_NF_ENT_IT) nrNf: ' + obj.get("nrNf") + ' Item: ' + i + ' cdProd: ' + item.get("cdProd") + ' cdFilial: ' + item.get("cdFilial");
    nota.insert("EstNfEntIt.incluirEstNfEntIt", item);
  }

  switch (parseInt(destOrig)) {
    case 0:
      obj.put("cdCli", obj.get("cdForn"));
      log.msg3 = 'Incluindo Vinculo com Cliente nrNf: ' + obj.get("nrNf") + ' cdCli: ' + obj.get("cdCli");
      nota.insert("EstNfEntPgForn.incluirEstNfEntRcCli", obj);
      break;
    case 1:
      log.msg3 = 'Incluindo Vinculo com Fornecedor nrNf: ' + obj.get("nrNf") + ' cdForn: ' + obj.get("cdForn");
      nota.insert("EstNfEntPgForn.incluirEstNfEntPgForn", obj);
      break;
    case 2:
      obj.put("cdFilialDest", obj.get("cdForn"));
      log.msg3 = 'Incluindo Vinculo com Cliente nrNf: ' + obj.get("nrNf") + ' cdFilialDest: ' + obj.get("cdFilialDest");
      nota.insert("EstNfEntPrcFilial.incluirEstNfEntPrcFilial", obj);
      break;
  }

  nota.commit();

} catch (err) {
  java.lang.System.out.println(err);
  nota.rollback();
  if (err.code) {
    throw JSON.stringify(err);
  }
  throw "{erro:true,  message:'" + escape(err) + "', log: " + JSON.stringify(log) + "}";
}
