load( "/rules/produto/validaDados.js" );
var mapper = mapperFactory.createMapperMult(["EstProdPrcBandeira", "PrcBandeiraPrcFilial"]);
var validaProduto = new ValidaProduto();

var getChave = function(list){
    let chaves = '';
    
    for(let i=0; i<list.size(); i++)
        chaves = chaves + list.get(i).get('cdFilial') + ',';
    
    return chaves.substring(0, chaves.length - 1);
};

try{

    var filiais = mapper.selectList('PrcBandeiraPrcFilial.listarPrcBandeiraPrcFilial', {'cdBandeira': message.get('cdBandeira')});
    validaProduto.validarStatusDoProdutoNoCadastro(message, (filiais.size() > 0 ? getChave(filiais) : null));
    mapper.update('EstProdPrcBandeira.alterarEstProdPrcBandeira', message);
    mapper.commit();

}catch(err){
    mapper.rollback();

	if(err.code)
	    throw JSON.stringify(err);
	else
	    throw err;
}