var mapper = mapperFactory.createMapperMult(["EstProd", "EstProdPrcBandeira", "PrcBandeira", "UtilDataBase"]);

var atualizarByEstProd = function(){

     let param = {
        'flag': message.get('flag'),
        'produtos': []
    };
    let numMarkers = 0;

    for(let i = 0; i<message.get('produtos').size(); i++){
         let item = message.get('produtos').get(i);
         item.put('valor', item.get(message.get('flag')));
         if((numMarkers + 2) > 2000){

             mapper.update('EstProd.atualizarFlagsProduto', param);
             param.produtos = [];
             numMarkers = 0;
             i --;
         }else{
             param.produtos.push(item);
             numMarkers = numMarkers + 2;
         }
    }

    if(param.produtos.length > 0)
        mapper.update('EstProd.atualizarFlagsProduto', param);

};


var jsonToColuna = function(attr){

	let colunaDoBanco = '';
	let stringFlag = new java.lang.String(attr);
	
	for(let i = 0; i<stringFlag.length(); i++){
		if(stringFlag.substring(i, (i+1)).equals(stringFlag.substring(i, (i+1)).toUpperCase()))
		     colunaDoBanco += '_'+stringFlag.substring(i, (i+1));
		else
		    colunaDoBanco += stringFlag.substring(i, (i+1)).toUpperCase();
	}
	return colunaDoBanco;
};


var atualizarByEstProdPrcBandeira = function(){

	let isColunaEstProdPrcBandeira = mapper.selectOne('UtilDataBase.isColunaValida', {'tabela': 'EST_PROD_PRC_BANDEIRA', 'coluna': jsonToColuna(message.get("flag"))});
	if(isColunaEstProdPrcBandeira.get("isValido") == 1){
		for(let i = 0; i<message.get('produtos').size(); i++){
            let param = {'produto': message.get('produtos').get(i), 'flag': message.get('flag')};
            mapper.update('EstProdPrcBandeira.atualizarFlagsProduto', param);
        }
	}else{
	    atualizarByEstProd();
	}
};

try{
    if(message.get("porBandeira") == 1)
       atualizarByEstProdPrcBandeira();
    else
       atualizarByEstProd();

    mapper.commit();
}catch(err){
    java.lang.System.out.println(err);
    mapper.rollback();
}