load('/rules/notaSaida/validaDados.js');
load('/model/erro/admErroEstNfIntegracoes.js');
var notaSaida = new NotaSaida();
var mapper      = mapperFactory.createMapperMult(["EfNfCtrNr","EstNfSai","EstNfSaiIt","EstNfSaiPrcFilial","EstNfSaiNfe","EstNfSaiRcCli","EstNfSaiPgForn","EstProdTransfConf","EstProdTransfConfFases","EstProdTransfConfFasesItens","EstProdTransf","EstProdTransfIt","EstNfSaiPedVd","EstPedVd","EstPedVdIt","EstProdCpl","EstNfSaiVendas","EstProdTransfPedVd"]);
if(message.get("obj")){
    var obj = message.get("obj");
}else{
    var obj = message;
}

try{
  var jsonItens   = obj.get("itens");
  var jsonValidado;
  jsonValidado = notaSaida.validaDadosNotaSaida(obj);
  jsonValidado.put("nrSeloSaida", 0);
  jsonValidado.put("nrNf", jsonValidado.get("nfNf"));

  mapper.insert("EfNfCtrNr.incluirEfNfCtrNr",jsonValidado);		// Insere a Numeração de Nota na tabela de controle de numeração
  mapper.insert("EstNfSai.incluirEstNfSai",jsonValidado); 		// Insere o Cabeçalho da Nota Fiscal de Saida
  if  (jsonValidado.get("flagNotaIntegracao") > 0){
    variaveis = {};
    variaveis.cdEmp         = jsonValidado.get("cdEmp");
    variaveis.cdFilial      = jsonValidado.get("cdFilial");
    variaveis.cdNf          = jsonValidado.get("cdNf");
    variaveis.nrAutorizador = jsonValidado.get("nrAut");
    variaveis.nrProtocolo   = " ";
    variaveis.vsProtocolo   = " ";
    variaveis.vsAplic       = " ";
    variaveis.dtRecbto      = jsonValidado.get("dtEmiNf");
    variaveis.dgValidador   = " ";
    variaveis.tpAmb         = 0;
    variaveis.cdUf          = 0;
    variaveis.cdNfeLote     = 1;
    variaveis.stsImp        = 0;
    variaveis.regContg      = 0;
    variaveis.cStatNfe      = 0;
    mapper.insert("EstNfSaiNfe.incluirEstNfSaiNfe",variaveis);
  }

  for (var i = 0; i < jsonItens.size(); i++) {
    var item = jsonItens.get(i);
    item.put("cdNf", jsonValidado.get("cdNf"));
    item.put("vlrCusto",0);
    item.put("vlrProdPed",0);
    item.put("vlrSuframa",0);
    item.put("percDescIt",0);
    item.put("vlrDescIt",0);
    item.put("percDescCtr",0);
    item.put("percComi",0);
    item.put("percComiCtr",0);
    mapper.insert("EstNfSaiIt.incluirEstNfSaiIt",item); // Insere os Itens da Nota Fiscal
    mapper.insert("EstProdCpl.alterarEstoqueProdCpl", {'cdEmp':item.get("cdEmp") , 'cdFilial':item.get("cdFilial") , 'qtEst':item.get("qtIt"), 'cdProd':item.get("cdProd"),'tipoAtu':parseInt(1)});		
  }

  switch (parseInt(jsonValidado.get("movOp").get("destOrig"))) {
    case 0:
      mapper.insert("EstNfSaiRcCli.incluirEstNfSaiRcCli",obj);
      break;
    case 1:
      jsonValidado.put("cdForn", jsonValidado.get("cdCli"));
      mapper.insert("EstNfSaiPgForn.incluirEstNfSaiPgForn",obj);
      break;
    case 2:
      jsonValidado.put("cdFilialDest", jsonValidado.get("cdCli"));
      mapper.insert("EstNfSaiPrcFilial.incluirEstNfSaiPrcFilial",obj);
      break;
  }

    // INCLUSAO DE NOTAS DE SAIDA DE VENDA
  if (jsonValidado.get("nfVenda") && parseInt(jsonValidado.get("nfVenda") == 1 )){
      gravaNfSaidaVenda(jsonValidado);
  }
  // INCLUSAO DO PEDIDO DE COMPRA
  if (jsonValidado.get("flagNotaIntegracao") > 0 && jsonValidado.get("cdPed") > 0  && jsonValidado.get("xpedNotaFiscal") > 0 && (jsonValidado.get("cdPed") == jsonValidado.get("xpedNotaFiscal")) && jsonValidado.get("cdNtMov") == 11){
    gravaCheckOutRessuprimento(jsonValidado);
    gravaPreFatura(jsonValidado);
  }
      // Vinculo Pedido de Compra caso tenha
  if (jsonValidado.get("flagNotaIntegracao") > 0 && jsonValidado.get("cdPed") && !jsonValidado.get("xpedNotaFiscal") && jsonValidado.get("cdNtMov") == 11){
    gravaVinculoPreFaturaNotaSaida(jsonValidado);
  }


  msgOk = 'Nota Fiscal de Saida de Numero ' + jsonValidado.get("nfNf") + ' inserida com sucesso';

  var gravaErro         = new AdmErroIntegracoes();
  var jsonConvert       = new com.google.gson.GsonBuilder().create();
  var metodo            = 'POST';
  var msgErro           = {};
  msgErro.nrNf          = jsonValidado.get("nfNf");
  msgErro.dtEmiNf       = jsonValidado.get("dtEmiNf");
  msgErro.cdForn        = jsonValidado.get("cdCli");
  msgErro.serieNf       = jsonValidado.get("cdNfSerie");
  msgErro.tpTransa      = 1; // saida
  msgErro.cnpjForn      = jsonValidado.get("cnpjEmitente") || ' ';
  msgErro.nrAutorizador = jsonValidado.get("nrAut") || ' ';
  msgErro.jsonEnviado   = jsonConvert.toJson(jsonValidado);
  msgErro.stsErro       = 1; // Importado com sucesso
  msgErro.cdUsuCorrecao = 0;
  msgErro.laudo         = msgOk;
  gravaErro.gerenciaErro(metodo,msgErro);

  mapper.commit();
  //mapper.rollback();
  msgOk;
}catch(err) {
  java.lang.System.out.println(err);
  mapper.rollback();
  if(jsonValidado){
    var gravaErro         = new AdmErroIntegracoes();
    var jsonConvert       = new com.google.gson.GsonBuilder().create();
    var metodo            = 'POST';
    var msgErro           = {};
    msgErro.nrNf          = jsonValidado.get("nfNf");
    msgErro.dtEmiNf       = jsonValidado.get("dtEmiNf");
    msgErro.cdForn        = jsonValidado.get("cdCli");
    msgErro.serieNf       = jsonValidado.get("cdNfSerie");
    msgErro.tpTransa      = 1; // saida
    msgErro.cnpjForn      = jsonValidado.get("cnpjEmitente") || ' ';
    msgErro.nrAutorizador = jsonValidado.get("nrAut") || ' ';
    msgErro.jsonEnviado   = jsonConvert.toJson(jsonValidado);
    msgErro.stsErro       = 2; // Erro
    msgErro.cdUsuCorrecao = 0;
    msgErro.laudo         = jsonConvert.toJson(err);
    gravaErro.gerenciaErro(metodo,msgErro);
  }
  if(err.code){
      throw JSON.stringify(err);
  }
    throw "{erro:true,  message:'" + escape(err)+"'}";
}


function gravaCheckOutRessuprimento(json) {
  variaveis = {};
  variaveis.cdEmp       = json.get("cdEmp");
  variaveis.cdFilial    = json.get("cdFilial");
  variaveis.cdCtr       = json.get("cdPed");
  variaveis.dtUltAtu    = json.get("dtEmiNf");
  variaveis.stsTransf   = 2;
  gravaAtualizaStsTransf(variaveis);

  variaveis.cdCtrFases  = 0;
  variaveis.cdUsu       = 1;
  variaveis.dtConfFases = json.get("dtEmiNf");
  variaveisItens        = json.get("itens");

  gravaConfFases(variaveis);

  var cdControle = mapper.selectOne("EstProdTransfConfFases.listarIdentity",null);

  for(var i = 0; i < variaveisItens.size(); i++){
    varItens = {};
    varItens.cdEmp        = json.get("cdEmp");
    varItens.cdCtrFases   = 0;
    varItens.cdProd       = variaveisItens.get(i).get("cdProd");
    varItens.qtdeProdConf = variaveisItens.get(i).get("qtIt");
    varItens.cdControle   = cdControle.get("cdControle");

    gravaConfFasesItens(varItens);

    varItens.cdCtr        = json.get("cdPed");
    varItens.cdFilial     = json.get("cdFilial");
    varItens.qtAt         = variaveisItens.get(i).get("qtIt");

    gravaAtualizaQntAtendida(varItens);

  }
}

function gravaAtualizaStsTransf (json){
  mapper.update("EstProdTransf.alterarEstProdTransf",json);
}

function gravaConfFases(json) {
  mapper.insert("EstProdTransfConfFases.incluirEstProdTransfConfFases",json);
}

function gravaConfFasesItens(json) {
  mapper.insert("EstProdTransfConfFasesItens.incluirEstProdTransfConfFasesItens",json);
}

function gravaAtualizaQntAtendida(json) {
  mapper.update("EstProdTransfIt.alterarEstProdTransfIt",json);
}

function gravaPreFatura(json){
  if (json.get("flagNotaIntegracao") > 0 && (json.get("cdPed") == json.get("xpedNotaFiscal")) && json.get("cdNtMov") == 11){

    json.put("cdRessup",json.get("cdPed"));
    gravaCabecalhoPreFatura(json);
    gravaItensPreFatura(json);
    gravaVinculoPreFaturaNotaSaida(json);
    atualizaCdPedEstNfSai(json);
    gravaVinculoPreFaturaRessuprimento(json);
  }
}

function gravaCabecalhoPreFatura(json){
  json.put("flagRealizarFat",0);
  json.put("stsPed",1);
  json.put("dtEmiPed",json.get("dtEmiNf"));
  json.put("vlrTotPed",json.get("vlrNf"));
  json.put("dtFat",json.get("dtEmiNf"));
  json.put("dtValid",json.get("dtEmiNf"));
  json.put("horaCad",json.get("hrEmiNf"));
  json.put("frete",9);
  defaultEstPedVd(json);
  mapper.insert("EstPedVd.incluirEstPedVd",json);
}

function gravaItensPreFatura(json){
  itensPrefatura = json.get("itens");
  for (var i = 0; i < itensPrefatura.size(); i++) {
    var item = itensPrefatura.get(i);
    item.put("cdPed", json.get("cdPed"));
    item.put("vlrIcmsSubsFut",0);
    item.put("vlrProdPed",item.get("vlrIt"));
    item.put("vlrSuframa",0);
    item.put("ordGrava",0);
    item.put("percDescCtr",0);
    item.put("percComi",0);
    item.put("percComiCtr",0);
    item.put("validade",0);
    mapper.insert("EstPedVdIt.incluirEstPedVdIt",item); //INSERE Itens da Pre-Fatura
  }
}

function gravaVinculoPreFaturaNotaSaida(json){
  variaveis = {};
  variaveis.cdEmp    = json.get("cdEmp");
  variaveis.cdFilial = json.get("cdFilial");
  variaveis.cdPed    = json.get("cdPed");
  variaveis.cdNf     = json.get("cdNf");
  mapper.insert("EstNfSaiPedVd.incluirEstNfSaiPedVd",variaveis);
}

function gravaVinculoPreFaturaRessuprimento(json){
  variaveis = {};
  variaveis.cdEmp    = json.get("cdEmp");
  variaveis.cdFilial = json.get("cdFilial");
  variaveis.cdPed    = json.get("cdPed");
  variaveis.cdCtr    = json.get("cdRessup");
  mapper.insert("EstProdTransfPedVd.incluirEstProdTransfPedVd",variaveis);
}

function atualizaCdPedEstNfSai(json){
  variaveis = {};
  variaveis.cdEmp    = json.get("cdEmp");
  variaveis.cdFilial = json.get("cdFilial");
  variaveis.cdPed    = json.get("cdPed");
  variaveis.cdNf     = json.get("cdNf");
  mapper.update("EstNfSai.alterarEstNfSai",variaveis);
}


function gravaNfSaidaVenda(json){
  variaveis = {};
  variaveis.cdEmp    = json.get("cdEmp");
  variaveis.cdFilial = json.get("cdFilial");
  variaveis.cdNf     = json.get("cdNf");
  mapper.update("EstNfSaiVendas.incluirEstNfSaiVendas",variaveis);
}

function defaultEstPedVd(json){
  if(!json.get("bloqFaturamento") || json.get("bloqFaturamento") === null || json.get("bloqFaturamento") === undefined){
    json.put("bloqFaturamento", 0);
  }
  if(!json.get("cdCli") || json.get("cdCli") === null || json.get("cdCli") === undefined){
    json.put("cdCli", 0);
  }
  if(!json.get("cdCondPgto") || json.get("cdCondPgto") === null || json.get("cdCondPgto") === undefined){
    json.put("cdCondPgto", 0);
  }
  if(!json.get("cdCtrDevo") || json.get("cdCtrDevo") === null || json.get("cdCtrDevo") === undefined){
    json.put("cdCtrDevo", '');
  }
  if(!json.get("cdEmp") || json.get("cdEmp") === null || json.get("cdEmp") === undefined){
    json.put("cdEmp", 1);
  }
  if(!json.get("cdFilial") || json.get("cdFilial") === null || json.get("cdFilial") === undefined){
    json.put("cdFilial", 0);
  }
  if(!json.get("cdNtMov") || json.get("cdNtMov") === null || json.get("cdNtMov") === undefined){
    json.put("cdNtMov", 0);
  }
  if(!json.get("cdTransp") || json.get("cdTransp") === null || json.get("cdTransp") === undefined){
    json.put("cdTransp", 0);
  }
  if(!json.get("cdUsu") || json.get("cdUsu") === null || json.get("cdUsu") === undefined){
    json.put("cdUsu", 0);
  }
  if(!json.get("cdVend") || json.get("cdVend") === null || json.get("cdVend") === undefined){
    json.put("cdVend", 0);
  }
  if(!json.get("cgcCpfTransp") || json.get("cgcCpfTransp") === null || json.get("cgcCpfTransp") === undefined){
    json.put("cgcCpfTransp", '');
  }
  if(!json.get("cob") || json.get("cob") === null || json.get("cob") === undefined){
    json.put("cob", 0);
  }
  if(!json.get("dsCidTransp") || json.get("dsCidTransp") === null || json.get("dsCidTransp") === undefined){
    json.put("dsCidTransp", '');
  }
  if(!json.get("dtBx") || json.get("dtBx") === null || json.get("dtBx") === undefined){
    json.put("dtBx", " ");
  }
  if(!json.get("dtCad") || json.get("dtCad") === null || json.get("dtCad") === undefined){
    json.put("dtCad", " ");
  }
  if(!json.get("dtEmiPed") || json.get("dtEmiPed") === null || json.get("dtEmiPed") === undefined){
    json.put("dtEmiPed", " ");
  }
  if(!json.get("dtFat") || json.get("dtFat") === null || json.get("dtFat") === undefined){
    json.put("dtFat", " ");
  }
  if(!json.get("dtNfSaida") || json.get("dtNfSaida") === null || json.get("dtNfSaida") === undefined){
    json.put("dtNfSaida", " ");
  }
  if(!json.get("dtUltAtu") || json.get("dtUltAtu") === null || json.get("dtUltAtu") === undefined){
    json.put("dtUltAtu", " ");
  }
  if(!json.get("dtValid") || json.get("dtValid") === null || json.get("dtValid") === undefined){
    json.put("dtValid", " ");
  }
  if(!json.get("emailTransp") || json.get("emailTransp") === null || json.get("emailTransp") === undefined){
    json.put("emailTransp", '');
  }
  if(!json.get("endeTransp") || json.get("endeTransp") === null || json.get("endeTransp") === undefined){
    json.put("endeTransp", '');
  }
  if(!json.get("espVol") || json.get("espVol") === null || json.get("espVol") === undefined){
    json.put("espVol", '');
  }
  if(!json.get("flagEcomerce") || json.get("flagEcomerce") === null || json.get("flagEcomerce") === undefined){
    json.put("flagEcomerce", 0);
  }
  if(!json.get("flagGravaPendencia") || json.get("flagGravaPendencia") === null || json.get("flagGravaPendencia") === undefined){
    json.put("flagGravaPendencia", 0);
  }
  if(!json.get("flagNaoCalcularImposto") || json.get("flagNaoCalcularImposto") === null || json.get("flagNaoCalcularImposto") === undefined){
    json.put("flagNaoCalcularImposto", 0);
  }
  if(!json.get("flagRealizarFat") || json.get("flagRealizarFat") === null || json.get("flagRealizarFat") === undefined){
    json.put("flagRealizarFat", 0);
  }
  if(!json.get("flagValidTrib") || json.get("flagValidTrib") === null || json.get("flagValidTrib") === undefined){
    json.put("flagValidTrib", 0);
  }
  if(!json.get("frete") || json.get("frete") === null || json.get("frete") === undefined){
    json.put("frete", 0);
  }
  if(!json.get("horaCad") || json.get("horaCad") === null || json.get("horaCad") === undefined){
    json.put("horaCad", " ");
  }
  if(!json.get("inscEstTransp") || json.get("inscEstTransp") === null || json.get("inscEstTransp") === undefined){
    json.put("inscEstTransp", '');
  }
  if(!json.get("mcVol") || json.get("mcVol") === null || json.get("mcVol") === undefined){
    json.put("mcVol", '');
  }
  if(!json.get("nmComprador") || json.get("nmComprador") === null || json.get("nmComprador") === undefined){
    json.put("nmComprador", " ");
  }
  if(!json.get("nmTransp") || json.get("nmTransp") === null || json.get("nmTransp") === undefined){
    json.put("nmTransp", " ");
  }
  if(!json.get("nrProtocolo") || json.get("nrProtocolo") === null || json.get("nrProtocolo") === undefined){
    json.put("nrProtocolo", " ");
  }
  if(!json.get("nrVol") || json.get("nrVol") === null || json.get("nrVol") === undefined){
    json.put("nrVol", 0);
  }
  if(!json.get("obs") || json.get("obs") === null || json.get("obs") === undefined){
    json.put("obs", " ");
  }
  if(!json.get("obsNf1") || json.get("obsNf1") === null || json.get("obsNf1") === undefined){
    json.put("obsNf1", " ");
  }
  if(!json.get("obsNf10") || json.get("obsNf10") === null || json.get("obsNf10") === undefined){
    json.put("obsNf10", '');
  }
  if(!json.get("obsNf11") || json.get("obsNf11") === null || json.get("obsNf11") === undefined){
    json.put("obsNf11", '');
  }
  if(!json.get("obsNf2") || json.get("obsNf2") === null || json.get("obsNf2") === undefined){
    json.put("obsNf2", " ");
  }
  if(!json.get("obsNf4") || json.get("obsNf4") === null || json.get("obsNf4") === undefined){
    json.put("obsNf4", '');
  }
  if(!json.get("obsNf5") || json.get("obsNf5") === null || json.get("obsNf5") === undefined){
    json.put("obsNf5", '');
  }
  if(!json.get("obsNf6") || json.get("obsNf6") === null || json.get("obsNf6") === undefined){
    json.put("obsNf6", '');
  }
  if(!json.get("obsNf7") || json.get("obsNf7") === null || json.get("obsNf7") === undefined){
    json.put("obsNf7", '');
  }
  if(!json.get("obsNf8") || json.get("obsNf8") === null || json.get("obsNf8") === undefined){
    json.put("obsNf8", '');
  }
  if(!json.get("obsNf9") || json.get("obsNf9") === null || json.get("obsNf9") === undefined){
    json.put("obsNf9", '');
  }
  if(!json.get("pesoLiqVol") || json.get("pesoLiqVol") === null || json.get("pesoLiqVol") === undefined){
    json.put("pesoLiqVol", 0);
  }
  if(!json.get("pesoVol") || json.get("pesoVol") === null || json.get("pesoVol") === undefined){
    json.put("pesoVol", 0);
  }
  if(!json.get("placaUf") || json.get("placaUf") === null || json.get("placaUf") === undefined){
    json.put("placaUf", '');
  }
  if(!json.get("placaVeic") || json.get("placaVeic") === null || json.get("placaVeic") === undefined){
    json.put("placaVeic", '');
  }
  if(!json.get("przEntrg") || json.get("przEntrg") === null || json.get("przEntrg") === undefined){
    json.put("przEntrg", 0);
  }
  if(!json.get("przVld") || json.get("przVld") === null || json.get("przVld") === undefined){
    json.put("przVld", 0);
  }
  if(!json.get("qtVol") || json.get("qtVol") === null || json.get("qtVol") === undefined){
    json.put("qtVol", 0);
  }
  if(!json.get("stsPed") || json.get("stsPed") === null || json.get("stsPed") === undefined){
    json.put("stsPed", 0);
  }
  if(!json.get("tpBx") || json.get("tpBx") === null || json.get("tpBx") === undefined){
    json.put("tpBx", 0);
  }
  if(!json.get("tpPed") || json.get("tpPed") === null || json.get("tpPed") === undefined){
    json.put("tpPed", 0);
  }
  if(!json.get("ufTransp") || json.get("ufTransp") === null || json.get("ufTransp") === undefined){
    json.put("ufTransp", '');
  }
  if(!json.get("vlrAdjBaseIcms") || json.get("vlrAdjBaseIcms") === null || json.get("vlrAdjBaseIcms") === undefined){
    json.put("vlrAdjBaseIcms", 0);
  }
  if(!json.get("vlrAdjIcms") || json.get("vlrAdjIcms") === null || json.get("vlrAdjIcms") === undefined){
    json.put("vlrAdjIcms", 0);
  }
  if(!json.get("vlrBaseIcms") || json.get("vlrBaseIcms") === null || json.get("vlrBaseIcms") === undefined){
    json.put("vlrBaseIcms", 0);
  }
  if(!json.get("vlrBaseIcmsSt") || json.get("vlrBaseIcmsSt") === null || json.get("vlrBaseIcmsSt") === undefined){
    json.put("vlrBaseIcmsSt", 0);
  }
  if(!json.get("vlrDesc") || json.get("vlrDesc") === null || json.get("vlrDesc") === undefined){
    json.put("vlrDesc", 0);
  }
  if(!json.get("vlrFrete") || json.get("vlrFrete") === null || json.get("vlrFrete") === undefined){
    json.put("vlrFrete", 0);
  }
  if(!json.get("vlrIcms") || json.get("vlrIcms") === null || json.get("vlrIcms") === undefined){
    json.put("vlrIcms", 0);
  }
  if(!json.get("vlrIcmsRetido") || json.get("vlrIcmsRetido") === null || json.get("vlrIcmsRetido") === undefined){
    json.put("vlrIcmsRetido", 0);
  }
  if(!json.get("vlrIcmsSubs") || json.get("vlrIcmsSubs") === null || json.get("vlrIcmsSubs") === undefined){
    json.put("vlrIcmsSubs", 0);
  }
  if(!json.get("vlrIpi") || json.get("vlrIpi") === null || json.get("vlrIpi") === undefined){
    json.put("vlrIpi", 0);
  }
  if(!json.get("vlrOutrosIt") || json.get("vlrOutrosIt") === null || json.get("vlrOutrosIt") === undefined){
    json.put("vlrOutrosIt", 0);
  }
  if(!json.get("vlrRessarcimentoBaseSubst") || json.get("vlrRessarcimentoBaseSubst") === null || json.get("vlrRessarcimentoBaseSubst") === undefined){
    json.put("vlrRessarcimentoBaseSubst", 0);
  }
  if(!json.get("vlrRessarcimentoIcmsSubst") || json.get("vlrRessarcimentoIcmsSubst") === null || json.get("vlrRessarcimentoIcmsSubst") === undefined){
    json.put("vlrRessarcimentoIcmsSubst", 0);
  }
  if(!json.get("vlrTotPed") || json.get("vlrTotPed") === null || json.get("vlrTotPed") === undefined){
    json.put("vlrTotPed", 0);
  }
  if(!json.get("vlrTotProd") || json.get("vlrTotProd") === null || json.get("vlrTotProd") === undefined){
    json.put("vlrTotProd", 0);
  }

  return json;
}