load('/rules/notaEntrada/validaDados.js');
load('/model/erro/admErroEstNfIntegracoes.js');

var notaEntrada = new NotaEntrada();
var mapper      = mapperFactory.createMapperMult(["Importador","EstNfEnt","EstNfEntIt","GlbMovOp","EstNfEntDanfeProvisorio","EstNfEntRcCli","EstNfEntPgForn","EstNfEntPrcFilial","EstNfEntDanfeProvisorioEstNfEnt","EstNfSerie","EstNfEntDanfeProvisorioNaoEncontrado","EstNfEntPedCp","EstPedCp","EstProdCpl","RcCli"]);
if(message.get("obj")){
    var obj = message.get("obj");
}else{
    var obj = message;
}
try{
  var jsonItens   = obj.get("itens");
  var jsonValidado;

  jsonValidado = notaEntrada.validaDadosNotaEntrada(obj,true);
  println('JSONVALIDADO '+ jsonValidado);
  mapper.insert("EstNfEnt.incluirEstNfEnt",jsonValidado);        //INSERE Cabe�alho da Nota Fiscal
  for (i = 0; i < jsonItens.size(); i++) {      // Insere Itens da Nota Fiscal
  	  item = jsonItens.get(i);
  	  item.put("cdNf", jsonValidado.get("cdNf"));
  	  mapper.insert("EstNfEntIt.incluirEstNfEntIt",item);
      mapper.insert("EstProdCpl.alterarEstoqueProdCpl", {'cdEmp':item.get("cdEmp") , 'cdFilial':item.get("cdFilial") , 'qtEst':item.get("qtIt"), 'cdProd':item.get("cdProd"),'tipoAtu':parseInt(2)});	
  }

    //Vinculo da Entrada com o pedido de compra
   if( parseInt(jsonValidado.get("flagNotaIntegracao")) > 0 && jsonValidado.get("cdPed")){
        var cdPedForn = mapper.selectOne("EstPedCp.listarEstPedCp",{'cdEmp':jsonValidado.get("cdEmp"),'cdForn':jsonValidado.get("cdForn"),'cdPed':jsonValidado.get("cdPed"),'cdFilial':jsonValidado.get("cdFilial")});
        if(cdPedForn){
          	var variaveis = {
              'cdFilial': jsonValidado.get('cdFilial'),
              'cdEmp':jsonValidado.get('cdEmp'),
              'cdPed': cdPedForn.get('cdPed'),
              'cdNf': jsonValidado.get('cdNf'),
            };
          mapper.insert("EstNfEntPedCp.incluirEstNfEntPedCp", variaveis);
        }
      }else{
      
          if( parseInt(jsonValidado.get("flagNotaIntegracao")) > 0 && jsonValidado.get("xPed") && (/^[0-9]+$/.test(jsonValidado.get("xPed"))) && jsonValidado.get("xPed").length() < 10 ){
            var cdPedForn = mapper.selectOne("EstPedCp.listarEstPedCp",{'cdEmp':jsonValidado.get("cdEmp"),'cdForn':jsonValidado.get("cdForn"),'cdPedForn':jsonValidado.get("xPed"),'cdFilial':jsonValidado.get("cdFilial")});
            if(cdPedForn){
              	var variaveis = {
                  'cdFilial': jsonValidado.get('cdFilial'),
                  'cdEmp':jsonValidado.get('cdEmp'),
                  'cdPed': cdPedForn.get('cdPed'),
                  'cdNf': jsonValidado.get('cdNf'),
                };
              mapper.insert("EstNfEntPedCp.incluirEstNfEntPedCp", variaveis);
            }
          }
      }
    switch (parseInt(jsonValidado.get("movOp").get("destOrig"))) {
    	case 0:
        var cliente = mapper.selectOne("RcCli.listarRcCli",{'cdCli':jsonValidado.get("cdForn")});
        if(cliente){
          jsonValidado.put("cdCli", jsonValidado.get("cdForn"));
          mapper.insert("EstNfEntRcCli.incluirEstNfEntRcCli",jsonValidado);
          break;
        } else{
         throw {code: 599, message: "Cliente " + jsonValidado.get("cdForn") + ' N�o Cadastrado no Sistema'}; 
        }
    	case 1:
    		mapper.insert("EstNfEntPgForn.incluirEstNfEntPgForn",{'cdEmp':jsonValidado.get("cdEmp"),'cdForn':jsonValidado.get("cdForn"),'cdFilial':jsonValidado.get("cdFilial"),'cdNf':jsonValidado.get("cdNf")});
    		break;
    	case 2:
    	  jsonValidado.put("cdFilialDest", jsonValidado.get("cdForn"));
    		mapper.insert("EstNfEntPrcFilial.incluirEstNfEntPrcFilial",jsonValidado);
    		break;
    }

  msgOk = 'Nota Fiscal de Entrada de Numero ' + jsonValidado.get("nrNf") + ' inserida com sucesso';

  var gravaErro         = new AdmErroIntegracoes();
  var jsonConvert       = new com.google.gson.GsonBuilder().create();
  var metodo            = 'POST';
  var msgErro           = {};
  msgErro.nrNf          = jsonValidado.get("nrNf");
  msgErro.dtEmiNf       = jsonValidado.get("dtEmiNf");
  msgErro.cdForn        = jsonValidado.get("cdForn");
  msgErro.serieNf       = jsonValidado.get("cdNfSerie");
  msgErro.tpTransa      = 0; // entrada
  msgErro.cnpjForn      = jsonValidado.get("cnpjEmitente") || ' ';
  msgErro.nrAutorizador = jsonValidado.get("nrAut") || ' ';
  msgErro.jsonEnviado   = jsonConvert.toJson(jsonValidado);
  msgErro.stsErro       = 1; // Importado com sucesso
  msgErro.cdUsuCorrecao = 0;
  msgErro.laudo         = msgOk;
  gravaErro.gerenciaErro(metodo,msgErro);

  mapper.commit();

  msgOk;
}catch(err) {
  java.lang.System.out.println(err);
  mapper.rollback();
  if(jsonValidado){
    var gravaErro         = new AdmErroIntegracoes();
    var jsonConvert       = new com.google.gson.GsonBuilder().create();
    var metodo            = 'POST';
    var msgErro           = {};
    msgErro.nrNf          = jsonValidado.get("nrNf");
    msgErro.dtEmiNf       = jsonValidado.get("dtEmiNf");
    msgErro.cdForn        = jsonValidado.get("cdForn");
    msgErro.serieNf       = jsonValidado.get("cdNfSerie");
    msgErro.tpTransa      = 0; // entrada
    msgErro.cnpjForn      = jsonValidado.get("cnpjEmitente") || ' ';
    msgErro.nrAutorizador = jsonValidado.get("nrAut") || ' ';
    msgErro.jsonEnviado   = jsonConvert.toJson(jsonValidado);
    msgErro.stsErro       = 2; // Erro
    msgErro.cdUsuCorrecao = 0;
    msgErro.laudo         = jsonConvert.toJson(err);
    gravaErro.gerenciaErro(metodo,msgErro);
  }
  if(err.code){
      throw JSON.stringify(err);
  }
    throw "{erro:true,  message:'" + escape(err)+"'}";
}
