load('/service/notaFiscal/NotaFiscalService.js');
load('/service/cupom/CupomFiscalService.js');
var i = JavaImporter( // importando pacote do java
    Packages.java.io,
    Packages.java.lang
);

ProcessarNfe = function() {

}



ProcessarNfe.prototype.proccess = function(tpNf) {

    with(i) {
		
		var df = java.text.SimpleDateFormat("yyyyMMddHHmmss");
		var createdAt = new Date();

        var mapperForFilial = mapperFactory.createMapper("ProcessarNfe");

        try {
            println("Iniciou a consulta!");
            var listNfe = this.getNfeToProccess(mapperForFilial, tpNf);
            
            println("lista de notas");
            println(listNfe);
            
            if(listNfe != null){
                this.setProcessando(mapperForFilial, listNfe);
                mapperForFilial.commit();
                
                var obj = {
                    list: listNfe,
                    run: function() {
                        
                        for (var x = 0; x < this.list.size(); x++) {
                            var objectMapper = new com.google.gson.GsonBuilder().create();
                            var notaFiscalService = new NotaFiscalService();
                            var cupomFiscalService = new CupomFiscalService();
                            var mapper = mapperFactory.createMapper("ProcessarNfe");
    
                            var controle = this.list.get(x).get("controle");
                            try {
                                
                                var arquivo = mapper.selectOne("arquivoNotaFiscal", {
                                    "controle": controle
                                });
                               
                                var objCupomFiscal = JSON.parse(arquivo.get("arqNf"));
            
                                objCupomFiscal.tpNf = arquivo.get("tpNf");

                                if (objCupomFiscal.tpNf == 99) {
                                    
                                    var cdVdExistente = cupomFiscalService.saveNfce(objCupomFiscal);
                                    if (!cdVdExistente.error || cdVdExistente.gravar == 0) {
                                        print("Arquivo de NFce controle [" + controle + "] foi processado com sucesso!\n");
                                        mapper.update("alterarStatusImportacao", {
                                            "stsImport": 1,
                                            "cdControle": controle
                                        });
                                        
                                    } else {
                                        print("Arquivo de NFce controle [" + controle + "] com erro.!\n");
                                        mapper.update("alterarStatusImportacao", {
                                            "stsImport": 3,
                                            "cdControle": controle
                                        });
                                    }


                                } else {
                                
                                    var cdVdExistente = notaFiscalService.save(objCupomFiscal);
                                    if (!cdVdExistente.error || cdVdExistente.gravar == 0) {
                                        print("Arquivo de NFe controle [" + controle + "] foi processado com sucesso!\n");
                                        mapper.update("alterarStatusImportacao", {
                                            "stsImport": 1,
                                            "cdControle": controle
                                        });
                                        
                                    } else {
                                        print("Arquivo de NFe controle [" + controle + "] com erro.!\n");
                                        mapper.update("alterarStatusImportacao", {
                                            "stsImport": 3,
                                            "cdControle": controle
                                        });
                                    }
                                }        
    
                            } catch (err) {
                                println(err);
                                println("Arquivo de cupom controle [" + controle + "] com erro inesperado para gravacao.");
                                mapper.update("alterarStatusImportacao", {
                                    "stsImport": 0,
                                    "cdControle": controle
                                });
                            } finally {
                                mapper.commit();
                                mapper.close();
                            }
                        }
                        print("Thread para finalizada com sucesso\n");
                    }
                };
    
                var r = new java.lang.Runnable(obj);
                var t = new java.lang.Thread(r);
    
                t.name = "Thread_NFE_" + df.format(createdAt);
    
                t.start();
    
                print("Thread para " + df.format(createdAt)+ " iniciada com sucesso\n");
                
            }
            
            

        } catch (err) {
            retorno = {
                message: "Operação de geração de arquivo de Boletim de caixa falhou ao iniciar!"
            };
        } finally {
            mapperForFilial.close();
        }
    }
}


ProcessarNfe.prototype.setProcessando = function(mapperForFilial, listCupons) {

    with(i) {

        for (var x = 0; x < listCupons.size(); x++) {
            mapperForFilial.update("alterarStatusImportacao", {
                "stsImport": 2,
                "cdControle": listCupons.get(x).get("controle")
            });
        }
    }
}


ProcessarNfe.prototype.getNfeToProccess = function(mapperForFilial, tpNf) {

    with(i) {
        var controles = mapperForFilial.selectList("listarArquivosPendentes", {
            "tpNf": tpNf
        });
        return controles;
    }
}

