load("/model/cliente/insereRegistro.js");

var i = JavaImporter( // importando pacote do java
    Packages.java.io,
    Packages.java.lang
);

NotaFiscalSaida = function () {
    this.clienteService = new Cliente(); 
}

NotaFiscalSaida.prototype.save = function (mapper, json) {

    json.cdNf = mapper.selectOne("EstNfSai.buscaMaxCdNf", json);
    println("selecionou EstNfSai.buscaMaxCdNf");

    if ((!json.nrNf || json.nrNf == 0) && json.nfNf) {
        json.nrNf = json.nfNf
    }

    mapper.insert("EfNfCtrNr.incluirEfNfCtrNr", json);		// Insere a Numeração de Nota na tabela de controle de numeração
    println("inseriu EfNfCtrNr.incluirEfNfCtrNr");

    mapper.insert("EstNfSai.incluirEstNfSai", json); 		// Insere o Cabeçalho da Nota Fiscal de Saida
    println("inseriu EstNfSai.incluirEstNfSai");

    if (json.flagNotaIntegracao > 0) {
        variaveis = {};
        variaveis.cdEmp = json.cdEmp
        variaveis.cdFilial = json.cdFilial
        variaveis.cdNf = json.cdNf
        variaveis.nrAutorizador = json.nrAut;
        variaveis.nrProtocolo = "";
        variaveis.vsProtocolo = "";
        variaveis.vsAplic = "";
        variaveis.dtRecbto = json.dtEmiNf;
        variaveis.dgValidador = "";
        variaveis.tpAmb = 0;
        variaveis.cdUf = 0;
        variaveis.cdNfeLote = 1;
        variaveis.stsImp = 0;
        variaveis.regContg = 0;
        variaveis.cStatNfe = 0;

        mapper.insert("EstNfSaiNfe.incluirEstNfSaiNfe", variaveis);
        println("inseriu incluirEstNfSaiNfe");
    }


    for (var y = 0; y < json.itens.length; y++) { // Insere Itens da Nota Fiscal
        var item = json.itens[y];
        item.cdNf = json.cdNf;

        mapper.insert("EstNfSaiIt.incluirEstNfSaiIt", item); // Insere os Itens da Nota Fiscal
        mapper.insert("EstProdCpl.alterarEstoqueProdCpl", {
            "cdEmp": item.cdEmp,
            "cdFilial": item.cdFilial,
            "qtEst": item.qtIt,
            "cdProd": item.cdProd,
            "tipoAtu": parseInt(1)
        });
	}

    println("inseriu EstNfSaiIt.incluirEstNfSaiIt");
	println("inseriu EstProdCpl.alterarEstoqueProdCpl");

    switch (parseInt(json.movOp.destOrig)) {
        case 0:
            this.setCliente(mapper, json);
            mapper.insert("EstNfSaiRcCli.incluirEstNfSaiRcCli", json);
			println("inseriu EstNfSaiRcCli.incluirEstNfSaiRcCli");
            break;
        case 1:
            json.cdForn = json.cdCli;
            mapper.insert("EstNfSaiPgForn.incluirEstNfSaiPgForn", json);
			println("inseriu EstNfSaiPgForn.incluirEstNfSaiPgForn");
            break;
        case 2:
            json.cdFilialDest = json.cdCli;
            mapper.insert("EstNfSaiPrcFilial.incluirEstNfSaiPrcFilial", json);
			println("inseriu EstNfSaiPrcFilial.incluirEstNfSaiPrcFilial");
            break;
    }




    if (json.nfVenda && parseInt(json.nfVenda) === 1) {
        mapper.update("EstNfSaiVendas.incluirEstNfSaiVendas", {
        "cdEmp":json.cdEmp
        ,"cdFilial":json.cdFilial
        ,"cdNf":json.cdNf
        });

        println("inseriu EstNfSaiVendas.incluirEstNfSaiVendas");
    }



    // INCLUSAO DO PEDIDO DE COMPRA
    if (json.flagNotaIntegracao && json.flagNotaIntegracao > 0 && (json.cdPed && json.xpedNotaFiscal && json.cdPed == json.xpedNotaFiscal) && parseInt(json.cdNtMov) == 11) {
        this.gravaCheckOutRessuprimento(mapper, json);
        this.gravaPreFatura(mapper, json);
    }
    // Vinculo Pedido de Compra caso tenha
    if (json.flagNotaIntegracao && json.flagNotaIntegracao > 0 && (json.cdPed && !json.xpedNotaFiscal ) && parseInt(json.cdNtMov) == 11) {
        this.gravaVinculoPreFaturaNotaSaida(mapper, json);
    }

    return json;
}

NotaFiscalSaida.prototype.gravaCheckOutRessuprimento = function (mapper, json) {
    var variaveis = {};
    variaveis.cdEmp = json.cdEmp;
    variaveis.cdFilial = json.cdFilial;
    variaveis.cdCtr = json.cdPed;
    variaveis.dtUltAtu = json.dtEmiNf;
    variaveis.stsTransf = 2;

    mapper.update("EstProdTransf.alterarEstProdTransf", variaveis);
    println("alterou EstProdTransf.alterarEstProdTransf");

    variaveis.cdCtrFases = 0;
    variaveis.cdUsu = 1;
    variaveis.dtConfFases = json.dtEmiNf;
    mapper.insert("EstProdTransfConfFases.incluirEstProdTransfConfFases", variaveis);
    println("inseriu EstProdTransfConfFases.incluirEstProdTransfConfFases");

    var cdControle = mapper.selectOne("EstProdTransfConfFases.listarIdentity", null);
	println("selecionou EstProdTransfConfFases.listarIdentity");

    for (var i = 0; i < json.itens.length; i++) {
        var item = json.itens[i];
        varItens = {};
        varItens.cdEmp = json.cdEmp;
        varItens.cdCtrFases = 0;
        varItens.cdProd = item.cdProd;
        varItens.qtdeProdConf = item.qtIt;
        varItens.cdControle = cdControle.get("cdControle");

        mapper.insert("EstProdTransfConfFasesItens.incluirEstProdTransfConfFasesItens", varItens);

        varItens.cdCtr = json.cdPed;
        varItens.cdFilial = json.cdFilial;
        varItens.qtAt = item.qtIt;

        mapper.update("EstProdTransfIt.alterarEstProdTransfIt", varItens);

    }
    println("inseriu EstProdTransfConfFasesItens.incluirEstProdTransfConfFasesItens");
	println("alterou EstProdTransfIt.alterarEstProdTransfIt");


    return 0;
}

NotaFiscalSaida.prototype.gravaPreFatura = function (mapper, json) {
    if (json.flagNotaIntegracao && json.flagNotaIntegracao > 0 && (json.cdPed == json.xpedNotaFiscal) && parseInt(json.cdNtMov) == 11) {

        json.cdRessup = json.cdPed;

        this.gravaCabecalhoPreFatura(mapper, json);
        this.gravaItensPreFatura(mapper, json);
        this.gravaVinculoPreFaturaNotaSaida(mapper, json);
        this.atualizaCdPedEstNfSai(mapper, json);
        this.gravaVinculoPreFaturaRessuprimento(mapper, json);
    }
    return 0;
}

NotaFiscalSaida.prototype.gravaCabecalhoPreFatura = function (mapper, json) {
    
    json.cdPed = mapper.selectOne("EstPedVd.maxId", {cdEmp : 1, cdFilial : json.cdFilial});
    println("selecionou EstPedVd.maxId");

    json.flagRealizarFat =  0;
    json.stsPed = 1;
    json.dtEmiPed = json.dtEmiNf;
    json.vlrTotPed = json.vlrNf;
    json.dtFat = json.dtEmiNf;
    json.dtValid = json.dtEmiNf;
    json.horaCad = json.hrEmiNf;
    json.frete = 9;

    var jsonEstPed = this.defaultEstPedVd(json);
    mapper.insert("EstPedVd.incluirEstPedVd", jsonEstPed);

    println("incluiu EstPedVd.incluirEstPedVd");
    return 0;
}

NotaFiscalSaida.prototype.gravaItensPreFatura = function (mapper, json) {
    for (var i = 0; i < json.itens.length; i++) {
        var item = json.itens[i];
        item.cdPed = json.cdPed;
        item.vlrIcmsSubsFut =  0;
        item.vlrProdPed = item.vlrIt;
        item.vlrSuframa = 0;
        item.ordGrava = 0;
        item.percDescCtr = 0;
        item.percComi = 0;
        item.percComiCtr = 0;
        item.validade = 0;
        mapper.insert("EstPedVdIt.incluirEstPedVdIt", item); //INSERE Itens da Pre-Fatura
    }
    println("incluiu EstPedVdIt.incluirEstPedVdIt");
    return 0;
}

NotaFiscalSaida.prototype.gravaVinculoPreFaturaNotaSaida = function (mapper, json) {
    var variaveis = {};
    variaveis.cdEmp = json.cdEmp;
    variaveis.cdFilial = json.cdFilial;
    variaveis.cdPed = json.cdPed;
    variaveis.cdNf = json.cdNf;
    mapper.insert("EstNfSaiPedVd.incluirEstNfSaiPedVd", variaveis);
    println("incluiu EstNfSaiPedVd.incluirEstNfSaiPedVd");
    return 0;
}

NotaFiscalSaida.prototype.gravaVinculoPreFaturaRessuprimento = function (mapper, json) {
    var variaveis = {};
    variaveis.cdEmp = json.cdEmp;
    variaveis.cdFilial = json.cdFilial;
    variaveis.cdPed = json.cdPed;
    variaveis.cdCtr = json.cdRessup;
    mapper.insert("EstProdTransfPedVd.incluirEstProdTransfPedVd", variaveis);
    println("incluiu EstProdTransfPedVd.incluirEstProdTransfPedVd");
    return 0;
}

NotaFiscalSaida.prototype.atualizaCdPedEstNfSai = function (mapper, json) {
    var variaveis = {};
    variaveis.cdEmp = json.cdEmp;
    variaveis.cdFilial = json.cdFilial;
    variaveis.cdPed = json.cdPed;
    variaveis.cdNf = json.cdNf;
    mapper.update("EstNfSai.alterarEstNfSai", variaveis);
    println("incluiu EstNfSai.alterarEstNfSai");
    return 0;
}

NotaFiscalSaida.prototype.defaultEstPedVd = function (json) {
    if (!json.bloqFaturamento || json.bloqFaturamento === null || json.bloqFaturamento === undefined) {
        json.bloqFaturamento = 0;
    }
    if (!json.cdCli || json.cdCli === null || json.cdCli === undefined) {
        json.cdCli = 0;
    }
    if (!json.cdCondPgto || json.cdCondPgto === null || json.cdCondPgto === undefined) {
        json.cdCondPgto = 0;
    }
    if (!json.cdCtrDevo || json.cdCtrDevo === null || json.cdCtrDevo === undefined) {
        json.cdCtrDevo = "";
    }
    if (!json.cdEmp || json.cdEmp === null || json.cdEmp === undefined) {
        json.cdEmp = 0;
    }
    if (!json.cdFilial || json.cdFilial === null || json.cdFilial === undefined) {
        json.cdFilial = 0;
    }
    if (!json.cdNtMov || json.cdNtMov === null || json.cdNtMov === undefined) {
        json.cdNtMov = 0;
    }
    if (!json.cdPed || json.cdPed === null || json.cdPed === undefined) {
        json.cdPed = 0;
    }
    if (!json.cdTransp || json.cdTransp === null || json.cdTransp === undefined) {
        json.cdTransp = 0;
    }
    if (!json.cdUsu || json.cdUsu === null || json.cdUsu === undefined) {
        json.cdUsu = 0;
    }
    if (!json.cdVend || json.cdVend === null || json.cdVend === undefined) {
        json.cdVend = 0;
    }
    if (!json.cgcCpfTransp || json.cgcCpfTransp === null || json.cgcCpfTransp === undefined) {
        json.cgcCpfTransp = "";
    }
    if (!json.cob || json.cob === null || json.cob === undefined) {
        json.cob = 0;
    }
    if (!json.dsCidTransp || json.dsCidTransp === null || json.dsCidTransp === undefined) {
        json.dsCidTransp = "";
    }
    if (!json.dtBx || json.dtBx === null || json.dtBx === undefined) {
        json.dtBx = "";
    }
    if (!json.dtCad || json.dtCad === null || json.dtCad === undefined) {
        json.dtCad = "";
    }
    if (!json.dtEmiPed || json.dtEmiPed === null || json.dtEmiPed === undefined) {
        json.dtEmiPed = "";
    }
    if (!json.dtFat || json.dtFat === null || json.dtFat === undefined) {
        json.dtFat = "";
    }

    if (!json.dtNfSaida || json.dtNfSaida === null || json.dtNfSaida === undefined) {
        json.dtNfSaida = "";
    }
    if (!json.dtUltAtu || json.dtUltAtu === null || json.dtUltAtu === undefined) {
        json.dtUltAtu = "";
    }
    if (!json.dtValid || json.dtValid === null || json.dtValid === undefined) {
        json.dtValid = "";
    }
    if (!json.emailTransp || json.emailTransp === null || json.emailTransp === undefined) {
        json.emailTransp = "";
    }
    if (!json.endeTransp || json.endeTransp === null || json.endeTransp === undefined) {
        json.endeTransp = "";
    }
    if (!json.espVol || json.espVol === null || json.espVol === undefined) {
        json.espVol = "";
    }
    if (!json.flagEcomerce || json.flagEcomerce === null || json.flagEcomerce === undefined) {
        json.flagEcomerce = 0;
    }
    if (!json.flagGravaPendencia || json.flagGravaPendencia === null || json.flagGravaPendencia === undefined) {
        json.flagGravaPendencia = 0;
    }
    if (!json.flagNaoCalcularImposto || json.flagNaoCalcularImposto === null || json.flagNaoCalcularImposto === undefined) {
        json.flagNaoCalcularImposto = 0;
    }
    if (!json.flagRealizarFat || json.flagRealizarFat === null || json.flagRealizarFat === undefined) {
        json.flagRealizarFat = 0;
    }
    if (!json.flagValidTrib || json.flagValidTrib === null || json.flagValidTrib === undefined) {
        json.flagValidTrib = 0;
    }
    if (!json.frete || json.frete === null || json.frete === undefined) {
        json.frete = 0;
    }
    if (!json.horaCad || json.horaCad === null || json.horaCad === undefined) {
        json.horaCad = "";
    }
    if (!json.inscEstTransp || json.inscEstTransp === null || json.inscEstTransp === undefined) {
        json.inscEstTransp = "";
    }
    if (!json.mcVol || json.mcVol === null || json.mcVol === undefined) {
        json.mcVol = "";
    }
    if (!json.nmComprador || json.nmComprador === null || json.nmComprador === undefined) {
        json.nmComprador = "";
    }
    if (!json.nmTransp || json.nmTransp === null || json.nmTransp === undefined) {
        json.nmTransp = "";
    }
    if (!json.nrProtocolo || json.nrProtocolo === null || json.nrProtocolo === undefined) {
        json.nrProtocolo = "";
    }
    if (!json.nrVol || json.nrVol === null || json.nrVol === undefined) {
        json.nrVol = 0;
    }
    if (!json.obs || json.obs === null || json.obs === undefined) {
        json.obs = "";
    }
    if (!json.obsNf1 || json.obsNf1 === null || json.obsNf1 === undefined) {
        json.obsNf1 = "";
    }
    if (!json.obsNf10 || json.obsNf10 === null || json.obsNf10 === undefined) {
        json.obsNf10 = "";
    }
    if (!json.obsNf11 || json.obsNf11 === null || json.obsNf11 === undefined) {
        json.obsNf11 = "";
    }
    if (!json.obsNf2 || json.obsNf2 === null || json.obsNf2 === undefined) {
        json.obsNf2 = "";
    }
    if (!json.obsNf4 || json.obsNf4 === null || json.obsNf4 === undefined) {
        json.obsNf4 = "";
    }
    if (!json.obsNf5 || json.obsNf5 === null || json.obsNf5 === undefined) {
        json.obsNf5 = "";
    }
    if (!json.obsNf6 || json.obsNf6 === null || json.obsNf6 === undefined) {
        json.obsNf6 = "";
    }
    if (!json.obsNf7 || json.obsNf7 === null || json.obsNf7 === undefined) {
        json.obsNf7 = "";
    }
    if (!json.obsNf8 || json.obsNf8 === null || json.obsNf8 === undefined) {
        json.obsNf8 = "";
    }
    if (!json.obsNf9 || json.obsNf9 === null || json.obsNf9 === undefined) {
        json.obsNf9 = "";
    }
    if (!json.pesoLiqVol || json.pesoLiqVol === null || json.pesoLiqVol === undefined) {
        json.pesoLiqVol = 0;
    }
    if (!json.pesoVol || json.pesoVol === null || json.pesoVol === undefined) {
        json.pesoVol = 0;
    }
    if (!json.placaUf || json.placaUf === null || json.placaUf === undefined) {
        json.placaUf = "";
    }
    if (!json.placaVeic || json.placaVeic === null || json.placaVeic === undefined) {
        json.placaVeic = "";
    }
    if (!json.przEntrg || json.przEntrg === null || json.przEntrg === undefined) {
        json.przEntrg = 0;
    }
    if (!json.przVld || json.przVld === null || json.przVld === undefined) {
        json.przVld = 0;
    }
    if (!json.qtVol || json.qtVol === null || json.qtVol === undefined) {
        json.qtVol = 0;
    }
    if (!json.stsPed || json.stsPed === null || json.stsPed === undefined) {
        json.stsPed = 0;
    }
    if (!json.tpBx || json.tpBx === null || json.tpBx === undefined) {
        json.tpBx = 0;
    }
    if (!json.tpPed || json.tpPed === null || json.tpPed === undefined) {
        json.tpPed = 0;
    }
    if (!json.ufTransp || json.ufTransp === null || json.ufTransp === undefined) {
        json.ufTransp = "";
    }
    if (!json.vlrAdjBaseIcms || json.vlrAdjBaseIcms === null || json.vlrAdjBaseIcms === undefined) {
        json.vlrAdjBaseIcms = 0;
    }
    if (!json.vlrAdjIcms || json.vlrAdjIcms === null || json.vlrAdjIcms === undefined) {
        json.vlrAdjIcms = 0;
    }
    if (!json.vlrBaseIcms || json.vlrBaseIcms === null || json.vlrBaseIcms === undefined) {
        json.vlrBaseIcms = 0;
    }
    if (!json.vlrBaseIcmsSt || json.vlrBaseIcmsSt === null || json.vlrBaseIcmsSt === undefined) {
        json.vlrBaseIcmsSt = 0;
    }
    if (!json.vlrDesc || json.vlrDesc === null || json.vlrDesc === undefined) {
        json.vlrDesc = 0;
    }
    if (!json.vlrFrete || json.vlrFrete === null || json.vlrFrete === undefined) {
        json.vlrFrete = 0;
    }
    if (!json.vlrIcms || json.vlrIcms === null || json.vlrIcms === undefined) {
        json.vlrIcms = 0;
    }
    if (!json.vlrIcmsRetido || json.vlrIcmsRetido === null || json.vlrIcmsRetido === undefined) {
        json.vlrIcmsRetido = 0;
    }
    if (!json.vlrIcmsSubs || json.vlrIcmsSubs === null || json.vlrIcmsSubs === undefined) {
        json.vlrIcmsSubs = 0;
    }
    if (!json.vlrIpi || json.vlrIpi === null || json.vlrIpi === undefined) {
        json.vlrIpi = 0;
    }
    if (!json.vlrOutrosIt || json.vlrOutrosIt === null || json.vlrOutrosIt === undefined) {
        json.vlrOutrosIt = 0;
    }
    if (!json.vlrRessarcimentoBaseSubst || json.vlrRessarcimentoBaseSubst === null || json.vlrRessarcimentoBaseSubst === undefined) {
        json.vlrRessarcimentoBaseSubst = 0;
    }
    if (!json.vlrRessarcimentoIcmsSubst || json.vlrRessarcimentoIcmsSubst === null || json.vlrRessarcimentoIcmsSubst === undefined) {
        json.vlrRessarcimentoIcmsSubst = 0;
    }
    if (!json.vlrTotPed || json.vlrTotPed === null || json.vlrTotPed === undefined) {
        json.vlrTotPed = 0;
    }
    if (!json.vlrTotProd || json.vlrTotProd === null || json.vlrTotProd === undefined) {
        json.vlrTotProd = 0;
    }

	/*if (!json.dtGravacao || json.dtGravacao === null || json.dtGravacao === undefined) {
        json.dtGravacao = getdate;
    }

    if (!json.dtTransacao || json.dtTransacao === null || json.dtTransacao === undefined) {
        json.dtTransacao = getdate;
    }*/

    return json;
};

NotaFiscalSaida.prototype.setCliente = function(mapper, json){
    println("Inserindo cliente: "+json.cdCli);
    if(mapper.selectList('RcCli.listarRcCli', {'cdCli': json.cdCli}).size() == 0){
        let copy = new java.util.HashMap();
        this.clienteService.validaCliente.validaDadosDefault(copy);
        copy.put("cdEmp", json.cdEmp);
        copy.put("cdUsu", json.cdUsu);
        copy.put("cdFilial", json.cdFilial);
        copy.put("cdCli", json.cdCli);
        copy.put("importador", 1);
        mapper.insert("RcCli.incluirRcCli", copy);

        println("Cliente inserido: "+copy.get('cdCli'));
    } 
};