var i = JavaImporter( // importando pacote do java
    Packages.java.io,
    Packages.java.lang
);

NotaFiscalEntrada = function() {

}

NotaFiscalEntrada.prototype.save = function(mapper, json) {

    syncGravarNotaDeEntrada = sync(function(mapper, json){
        json.cdNf = mapper.selectOne("EstNfEnt.buscaMaxCdNf", json);
        //println("selecionou EstNfEnt.buscaMaxCdNf");
    
        mapper.insert("EstNfEnt.incluirEstNfEnt", json); //INSERE Cabeçalho da Nota Fiscal
    });

    syncGravarNotaDeEntrada(mapper, json);

    for (var y = 0; y < json.itens.length; y++) { // Insere Itens da Nota Fiscal
        var item = json.itens[y];
        item.cdNf = json.cdNf;
		
        mapper.insert("EstNfEntIt.incluirEstNfEntIt", item);
        

        mapper.insert("EstProdCpl.alterarEstoqueProdCpl", {
            'cdEmp': item.cdEmp,
            'cdFilial': item.cdFilial,
            'qtEst': item.qtIt,
            'cdProd': item.cdProd,
            'tipoAtu': parseInt(2)
        });
        
       
        //Valida se o produto esta na tabela de preco de custo por grupo economico
        //caso esteja da update no valor de custo para o valor de custo da notaFiscal
        //caso nao esteja faz o insert
        
       
        
        if (mapper.selectOne("EstProdEntGrpEcon.listarEstProdEntGrpEcon", {cdEmp:item.cdEmp , cdProd:item.cdProd})) {
            
            mapper.insert("EstProdEntGrpEcon.alterarEstProdEntGrpEcon", {
                'cdEmp': item.cdEmp,
                'cdProd': item.cdProd,
                'vlrIt': item.vlrIt,
                'vlrIcmsIt': item.vlrIcmsIt,
                'vlrDescIt': item.vlrDesc,
                'percIcms': 0,
                'percIva': 0,
                'vlrIcmsSubstIt': 0,
                'vlrCustoIt': item.vlrIt,
                'origLanc': 0
            });
        } else {
       
            mapper.insert("EstProdEntGrpEcon.incluirEstProdEntGrpEcon", {
                'cdEmp': item.cdEmp,
                'cdProd': item.cdProd,
                'vlrIt': item.vlrIt,
                'vlrIcmsIt': item.vlrIcmsIt,
                'vlrDescIt': item.vlrDesc,
                'percIcms': 0,
                'percIva': 0,
                'vlrIcmsSubstIt': 0,
                'vlrCustoIt': item.vlrIt,
                'origLanc': 0
            });
        }
        
        //println("selecionou EstProdEntGrpEcon.listarEstProdEntGrpEcon");
        
        //Validação para não haver erro de PK, pois o 1 produto pode estar mais de 1 vez na Nota Fiscal
        if (!mapper.selectOne("EstProdEntGrpEconEstNfEntIt.listarEstProdEntGrpEconEstNfEntIt", {cdEmp:item.cdEmp, cdFilial : item.cdFilial, cdNf:item.cdNf, cdProd:item.cdProd})) {
            mapper.insert("EstProdEntGrpEconEstNfEntIt.incluirEstProdEntGrpEconEstNfEntIt", item);
        }
        
        //println("selecionou EstProdEntGrpEconEstNfEntIt.listarEstProdEntGrpEconEstNfEntIt");
    }
    
    //println("\nitem inseridos\n");

    //Vinculo da Entrada com o pedido de compra
    if (parseInt(json.flagNotaIntegracao) > 0 && json.cdPed) {
        var cdPedForn = mapper.selectOne("EstPedCp.listarEstPedCp", {cdEmp:json.cdEmp, cdForn:json.cdForn, cdPed:json.cdPed, cdFilial:json.cdFilial});
        //println("selecionou EstPedCp.listarEstPedCp");
        if (cdPedForn) {
            mapper.insert("EstNfEntPedCp.incluirEstNfEntPedCp", json);
        }
    } else {

        if (parseInt(json.flagNotaIntegracao) > 0 && json.xPed && (/^[0-9]+$/.test(json.xPed)) && json.xPed.length() < 10) {
            var cdPedForn = mapper.selectOne("EstPedCp.listarEstPedCp", {
                'cdEmp': json.cdEmp,
                'cdForn': json.cdForn,
                'cdPedForn': json.xPed,
                'cdFilial': json.cdFilial
            });
            //println("selecionou EstPedCp.listarEstPedCp");
            if (cdPedForn) {
                var variaveis = {
                    'cdFilial': json.cdFilial,
                    'cdEmp': json.cdEmp,
                    'cdPed': cdPedForn.get('cdPed'),
                    'cdNf': json.cdNf,
                };
                mapper.insert("EstNfEntPedCp.incluirEstNfEntPedCp", variaveis);
            }
        }
    }
    switch (parseInt(json.movOp.destOrig)) {
        case 0:
            var cliente = mapper.selectOne("RcCli.listarRcCli", {cdCli: json.cdForn});
            //println("selecionou RcCli.listarRcCli");
            if (cliente) {
                json.cdCli =  json.cdForn;
                mapper.insert("EstNfEntRcCli.incluirEstNfEntRcCli", json);
            } else {
                return {
					error : true,
                    code: 599,
                    message: "Cliente " + json.cdForn + " Não Cadastrado no Sistema"
                };
            }
            break;
        case 1:
            mapper.insert("EstNfEntPgForn.incluirEstNfEntPgForn", json);
            break;
        case 2:
            json.cdFilialDest =  json.cdForn;
            mapper.insert("EstNfEntPrcFilial.incluirEstNfEntPrcFilial", json);
            break;
    }

    return json;
}