load("/service/cupom/CupomFiscalService.js");
var i = JavaImporter( // importando pacote do java
    Packages.java.io,
    Packages.java.lang
);

ProcessarCupomNFCe = function() {
    with(i) {
        this.createdAt = new Date();
    }
}

ProcessarCupomNFCe.prototype.proccess = function() {

    with(i) {

        var mapperLoad = mapperFactory.createMapperMult(["ProcessarCupomNFCe","PrcFilial"]);

        try{

            var filiais = this.getFiliaisToProccess(mapperLoad);
        
            if(filiais != null){
                print("Encontrado ["+filiais.size()+"] filiais com cupons para processar\n");
                for(var y=0; y < filiais.size(); y++){

                    var filial = filiais.get(y).get("controle");

                    print("Tratando Filial ["+filial+"]\n");

                    if(this.filialValida(mapperLoad,filial)){
                        var mapperForFilial = mapperFactory.createMapper("ProcessarCupomNFCe");

                        try {
                            var listCupons = this.getCuponsNFCeToProccess(mapperForFilial, filial);
                            this.setProcessando(mapperForFilial, listCupons);
                            
                            mapperForFilial.commit();
                
                            var obj = {
                                list : listCupons,
                                f : filial,
                                run: function() {
                                    var cupomFiscalService = new CupomFiscalService();
                                    for(var x=0; x < this.list.size(); x++){
                                        
                                        var mapper =  mapperFactory.createMapper("ProcessarCupomNFCe");
                                        
                                        var controle = this.list.get(x).get("controle");
                                        try{
                                            
                                            var arquivo = mapper.selectOne("arquivoCupomFiscal", {"controle":controle});

                                            var objCupomFiscal = JSON.parse(arquivo.get("arqVd")); 
                
                                            var cdVdExistente = cupomFiscalService.save(objCupomFiscal);

                                            if(cdVdExistente == 0){
                                                print("Arquivo de cupom controle [" +controle+ "] foi processado com sucesso!\n");
                                            }else{
                                                print("Arquivo de cupom controle [" +controle+ "] ja inserido anteriormente com CD_VD ["+cdVdExistente+"]!\n");
                                            }
                
                                            mapper.update("alterarStatusImportacao", {"stsImport":1, "cdControle" : controle});
                                            
                                        }catch(err){
                                            print("Arquivo de cupom controle [" +controle+ "] foi processado com erro!\n");
                                            mapper.update("alterarStatusImportacao", {"stsImport":3, "cdControle" : controle});
                                        }finally{
                                            mapper.commit();
                                            mapper.close();
                                        }
                                    }
                                    print("Thread para filial " + this.f + " finalizada com sucesso\n");
                                }
                            };
                
                            var r = new java.lang.Runnable(obj);
                            var t = new java.lang.Thread(r);
                            
                            t.name = "Thread_Filial_" + filial;
                
                            t.start();
                            
                            print("Thread para filial " + filial + " iniciada com sucesso\n");
                            
                        } catch (err) {
                            retorno = {
                                message: "Operação de geração de arquivo de Boletim de caixa falhou ao iniciar!"
                            };
                        }finally{
                            mapperForFilial.close();
                        }
                    }else{
                        mapperLoad.update("alterarStatusImportacao", {"stsImport": 4, "cdFilial" : filial });
                        mapperLoad.commit();
                    }
                }
            }

        }finally{
            mapperLoad.close();
        }
    }
}

ProcessarCupomNFCe.prototype.getFiliaisToProccess = function(mapperLoad) {

    with(i) {
		
		var filialPendente = mapperLoad.selectList("listarFilialComArquivoPendencia", null);
		
		if(filialPendente){
		    return filialPendente;
		}
		
		return null;
    }

}

ProcessarCupomNFCe.prototype.filialValida = function(mapperLoad, cdfilial) {
    with(i) {
		var filial = mapperLoad.selectOne( "PrcFilial.isValidPrcFilial", {"cdEmp" : 1, "cdFilial" : cdfilial} );
        if ( !filial ) {
    		return false
    	} else {
    		if ( filial.get( "stsFilial" ) > 0 ) {
    			return false;
    		}else{
                if (!filial.get( "dtIniSistema" )) {
                   return false;
                }else{
                    return true;
                }
            }    		
    	}        
    }
}



ProcessarCupomNFCe.prototype.setProcessando = function(mapperForFilial, listCupons) {

    with(i) {		
        
		for(var x=0; x < listCupons.size(); x++){
            mapperForFilial.update("alterarStatusImportacao", {"stsImport":2, "cdControle" : listCupons.get(x).get("controle")});
		}
    }
}

ProcessarCupomNFCe.prototype.getCuponsNFCeToProccess = function(mapperForFilial, cdFilial) {

    with(i) {		
		var controles = mapperForFilial.selectList("listarArquivoPendenciaPorFilial", {"controle":cdFilial});
		return controles;
    }
}