var i = JavaImporter( // importando pacote do java
    Packages.java.io,
    Packages.java.lang
);

CupomFiscalService = function() {

}



CupomFiscalService.prototype.save = function(cupomRecebido){
	
	with(i) {
	    var mapperPdv  = mapperFactory.createMapperMult(["PdvVd","PdvVdIt","PdvVdItRec","PdvVdTef","PdvVdChqs","EstProdCpl"]);
        try{
           
		    cupomRecebido.cdVd = 0; //Removendo codigo de venda da origem 
            var existisCodigoVenda = this.existisCodigoVenda(mapperPdv, cupomRecebido);

            if(existisCodigoVenda == 0){
                cupomRecebido.cdVd = mapperPdv.selectOne("maxPdvVd", cupomRecebido);
                
    			mapperPdv.insert("PdvVd.incluirPdvVd",cupomRecebido); //INSERE PDV_VD
    			if(cupomRecebido.itens.length < 8){
    				mapperPdv.insert("PdvVdIt.incluirMultiplosPdvVdIt",cupomRecebido); //INSERE PDV_VD_IT
    				var itens = cupomRecebido.itens;
    				for (var x = 0; x < itens.length; x++) {
    					var item = itens[x];
    					mapperPdv.insert("EstProdCpl.alterarEstoqueProdCpl", {'cdEmp':item.cdEmp , 'cdFilial':item.cdFilial , 'qtEst':item.qtIt, 'cdProd':item.cdProd,'tipoAtu':parseInt(1)});	
    				}
    			}else{ 
    				var itens = cupomRecebido.itens;
    				for (var x = 0; x < itens.length; x++) {
    					var item = itens[x];
    					item.cdVd = cupomRecebido.cdVd;
    					mapperPdv.insert("PdvVdIt.incluirPdvVdIt",item); //INSERE PDV_VD_IT
    					mapperPdv.insert("EstProdCpl.alterarEstoqueProdCpl", {'cdEmp':item.cdEmp , 'cdFilial':item.cdFilial , 'qtEst':item.qtIt, 'cdProd':item.cdProd,'tipoAtu':parseInt(1)});	
    				};
    			}
    			mapperPdv.commit();

				return 0;
            }else{
				return existisCodigoVenda;
			}
			
		}catch(err){
		    
	    	mapperPdv.rollback();

			var errorMessage = JSON.stringify({"code":599, "message" : escape(err)});

			if(cupomRecebido){

			    var mapperErro        = mapperFactory.createMapperMult(["AdmErroPdvVdIntegracoes"]);
				var msgErro           = {};
				msgErro.cdVd          = cupomRecebido.cdVd;
				msgErro.nrEcf         = cupomRecebido.nrEcf;
				msgErro.dtVd          = cupomRecebido.dtVd;
				msgErro.cdFilial      = cupomRecebido.cdFilial;
				msgErro.cdCx          = cupomRecebido.cdCx;
				msgErro.jsonEnviado   = JSON.stringify(cupomRecebido);
				msgErro.stsErro       = 2; // Erro
				msgErro.cdUsuCorrecao = 0;
				msgErro.laudo         = errorMessage;
				try{
				    mapperErro.insert("AdmErroPdvVdIntegracoes.incluirAdmErroPdvVdIntegracoes", msgErro);
				    mapperErro.commit();
				}catch(err1){
				    mapperErro.rollback();
				    if (err1.javaException != null && err1.javaException instanceof org.apache.ibatis.exceptions.PersistenceException) {
                      var errorMessage1 = err1.javaException.cause.message;
                    }else{
                      var errorMessage1 = JSON.stringify(err1);
                    }
                    throw errorMessage1;
				} finally{
		            mapperErro.close();
		        }   
			}
			throw errorMessage;
		}finally{
		    mapperPdv.close();
		}
    }
}

CupomFiscalService.prototype.existisCodigoVenda = function(mapperPdv, json){
	var pdvVd = mapperPdv.selectOne("PdvVd.isValidPdvVd", json);

	if(pdvVd){
		return pdvVd.get("cdVd");
	}

	return 0;
}





CupomFiscalService.prototype.saveNfce = function(cupomRecebido){
	
	with(i) {
	    var mapperPdv  = mapperFactory.createMapperMult(["PdvVd","PdvVdIt","PdvVdItRec","PdvVdTef","PdvVdChqs","EstProdCpl"]);
        try{
           
		    cupomRecebido.cdVd = 0; //Removendo codigo de venda da origem 
            var existisCodigoVenda = this.existisCodigoVendaNfce(mapperPdv, cupomRecebido);

            if(existisCodigoVenda == 0){
				var caixaExiste = mapperPdv.selectOne("consultaCaixa", cupomRecebido); 
				if(caixaExiste && caixaExiste == 0 ){
					mapperPdv.insert("insereCaixaNfce", cupomRecebido); 
				}
                cupomRecebido.cdVd = mapperPdv.selectOne("maxPdvVd", cupomRecebido);                
    			mapperPdv.insert("PdvVd.incluirPdvVdNfce",cupomRecebido); //INSERE PDV_VD
    			if(cupomRecebido.itens.length < 8){
    				mapperPdv.insert("PdvVdIt.incluirMultiplosPdvVdItNfce",cupomRecebido); //INSERE PDV_VD_IT
    				var itens = cupomRecebido.itens;
    				for (var x = 0; x < itens.length; x++) {
    					var item = itens[x];
    					mapperPdv.insert("EstProdCpl.alterarEstoqueProdCpl", {'cdEmp':item.cdEmp , 'cdFilial':item.cdFilial , 'qtEst':item.qtIt, 'cdProd':item.cdProd,'tipoAtu':parseInt(1)});	
    				}
    			}else{ 
    				var itens = cupomRecebido.itens;
    				for (var x = 0; x < itens.length; x++) {
    					var item = itens[x];
    					item.cdVd = cupomRecebido.cdVd;
    					mapperPdv.insert("PdvVdIt.incluirPdvVdItNfce",item); //INSERE PDV_VD_IT
    					mapperPdv.insert("EstProdCpl.alterarEstoqueProdCpl", {'cdEmp':item.cdEmp , 'cdFilial':item.cdFilial , 'qtEst':item.qtIt, 'cdProd':item.cdProd,'tipoAtu':parseInt(1)});	
    				};
    			}
    			mapperPdv.commit();

				return 0;
            }else{
				return existisCodigoVenda;
			}
			
		}catch(err){
		    println('Erro')
	    	mapperPdv.rollback();

			var errorMessage = JSON.stringify({"code":599, "message" : escape(err)});

			if(cupomRecebido){

			    var mapperErro        = mapperFactory.createMapperMult(["AdmErroEstNfIntegracoes"]);
				var msgErro           = {};

				msgErro.nrNf = cupomRecebido.nrNf;
                msgErro.dtEmiNf = cupomRecebido.dtEmiNf;
                msgErro.cdForn = cupomRecebido.cdForn || 0;
                msgErro.serieNf = cupomRecebido.cdNfSerie;
                msgErro.tpTransa = cupomRecebido.tpNf;
                msgErro.cnpjForn = cupomRecebido.cnpjEmitente || '';
                msgErro.nrAutorizador = cupomRecebido.nrAut || '';
                msgErro.jsonEnviado = '';
                msgErro.stsErro = 2; // Erro
                msgErro.cdUsuCorrecao = 0;
                msgErro.laudo = errorMessage;
				try{
				    mapperErro.insert("AdmErroEstNfIntegracoes.incluirAdmErroEstNfIntegracoes", msgErro);
				    mapperErro.commit();
				}catch(err1){
				    mapperErro.rollback();
				    if (err1.javaException != null && err1.javaException instanceof org.apache.ibatis.exceptions.PersistenceException) {
                      var errorMessage1 = err1.javaException.cause.message;
                    }else{
                      var errorMessage1 = JSON.stringify(err1);
                    }
                    throw errorMessage1;
				} finally{
		            mapperErro.close();
		        }   
			}
			throw errorMessage;
		}finally{
		    mapperPdv.close();
		}
    }
}

CupomFiscalService.prototype.existisCodigoVendaNfce = function(mapperPdv, json){
	var pdvVd = mapperPdv.selectOne("PdvVd.isValidPdvVdNfce", json);

	if(pdvVd){
		return pdvVd.get("cdVd");
	}

	return 0;
}

