var mapper =  mapperFactory.createMapperMult(['GlbScheduleArquivos', 'GlbScheduleJob', 'EstProd', 'EstProdStatusProc']);
var job = new java.util.HashMap();
var scheduleArquivo = new java.util.HashMap();

var atualizar = function(arquivo){
    java.lang.System.out.println("Atualizando dados de status do produto");

    let paramCab = new java.util.HashMap();
    paramCab.put('cdUsu', scheduleArquivo.get('cdUsu'));
    paramCab.put('cdCtrScheduleJob', job.get('cdCtrJob'));
    paramCab.put('nivel', 0);

    if(arquivo.get('atualizarPor') == 'bandeira')
        paramCab.put('nivel', 1);
    else if(arquivo.get('atualizarPor') == 'filial')
        paramCab.put('nivel', 2);

    mapper.insert('EstProdStatusProc.incluirEstProdStatusProc', paramCab);

    let param = {
        'cdCtrStatusProc': paramCab.get('cdCtr'),
        'nivel': paramCab.get('nivel'),
        'produtos': [],
    };
    let numMarkers = 0;

    for(let i = 0; i < arquivo.get('itens').size(); i++){
         let item = arquivo.get('itens').get(i);
         if((numMarkers + 7) > 2000){

             mapper.insert('EstProdStatusProc.incluirItens', param);
             param.produtos = [];
             numMarkers = 0;
             i --;
         }else{
             param.produtos.push(item);
             numMarkers = numMarkers + 7;
         }
    }

    if(param.produtos.length > 0)
        mapper.insert('EstProdStatusProc.incluirItens', param);
};

var processar = function(){
    mapper.update("GlbScheduleJob.alterarGlbScheduleJob", {'sts': 2, 'cdCtr': job.get('cdCtrJob')});
    scheduleArquivo =  mapper.selectOne("GlbScheduleArquivos.listarGlbScheduleArquivos", {'cdCtr': job.get('cdCtr')});
    var arquivo = mapperFactory.mapFromStringJson(scheduleArquivo.get('arquivo'));
    atualizar(arquivo);
    mapper.update("GlbScheduleJob.alterarGlbScheduleJob", {'sts': 1, 'cdCtr': job.get('cdCtrJob')});
};


try{
    java.lang.System.out.println("Iniciando schedule de atualizacao do status do produto");
    job = mapper.selectOne("GlbScheduleJob.listarCdCtrProcessar", {'nmSchedule': 'IMPORTACAO_STATUS_PRODUTO'});

    if(job != null && job.get('cdCtrJob') != null){
        processar();
        mapper.commit();
    }

}catch(err){
    mapper.rollback();

    var mapperError =  mapperFactory.createMapperMult(['GlbScheduleJob']);
    mapperError.update("GlbScheduleJob.alterarGlbScheduleJob", {'sts': 3, 'cdCtr': job.get('cdCtrJob')});
    mapperError.commit();

    java.lang.System.out.println(err);
}