/**
 * Created by maurodouglas on 01/11/16.
 */

var ValidaCdBarra = function( ) {
	this.mapper = mapperFactory.createMapperMult([ "EstProdCdBarra", "EstProd" ]);
};

ValidaCdBarra.prototype.validaCdBarra = function( json ) {
	if ( !json ) {
		throw { code: 599, message: "Dados passados ao servidor inválido!" };
	}
	if ( !json.get( "tpCdBarra" ) || json.get( "tpCdBarra" ) == null || json.get( "tpCdBarra" ) == undefined ) {
		item.put( "tpCdBarra", 0 );
	}
	if ( !json.get( "naoExportar" ) || json.get( "naoExportar" ) == null || json.get( "naoExportar" ) == undefined ) {
		item.put( "naoExportar", 0 );
	}
	if ( !json.get( "eanCaixaFechada" ) || json.get( "eanCaixaFechada" ) == null || json.get( "eanCaixaFechada" ) == undefined ) {
		item.put( "eanCaixaFechada", 0 );
	}

	isValido = this.isValido(json.get( "cdBarra" ));
	return json;

};

ValidaCdBarra.prototype.isValido = function( ean ) {

	if ( ean.length() > 18 ) {
		msg = ( "O número deve possuir no máximo 17 dígitos" );
		throw msg;
	}

	if ((((( ean.length() != 8 ) && ( ean.length() != 12 )) && ( ean.length() != 13 )) && ( ean.length() != 14 )) && ( ean.length() != 18 )) {
		msg = ( "O número deve possuir 8 (EAN/UCC-8), 12 (UCC-12), 13 (EAN/UCC-13), 14 (EAN/UCC-14) ou 18 (SSCC) dígitos" );
		throw msg;
	}

	factor = 3;
	sum = 0;
	numeros = ean.substring( 0, ean.length() - 1 );
	//java.lang.System.out.println('ean.length ' + ean.length + ' ean ' + ean + ' numeros ' + numeros);
	for ( i = numeros.length(); i > 0; --i ) {
		sum = sum + ean.substring( i - 1, i ) * factor;
		factor = 4 - factor;
	}

	cc = ( ( 1000 - sum ) % 10 );

	//  java.lang.System.out.println('cc ' + cc + ' parseInt(ean.substring(ean.length - 1,ean.length)) ' + parseInt(ean.substring(ean.length - 1,ean.length)) + ' sum ' + sum);
	if (cc != parseInt(ean.substring( ean.length() - 1, ean.length() ))) {
		return false;
	} else {
		return true;
	}
};

/**
  * Metodo valida os dados enviados para o cadasto do Codigo de Barra
  * @param {HashMap JAVA} json
  * @throws {InvalidArgumentException}
  */
ValidaCdBarra.prototype.validaDadosParaCadastro = function( json ) {
	if ( !json ) {
		throw { code: 599, message: "Dados passados ao servidor inválido!" };
	}
    if ( !json.get( "importador" ) || json.get( "importador" ) === null || json.get( "importador" ) === undefined || json.get("importador") == 0 ) {
    	if (json.get( "cdBarra" ) !== null && json.get( "cdBarra" ).length( ) >= 8 && !this.isValido(json.get( "cdBarra" ))) {
    		throw {
    			code: 599,
    			message: "EAN " + json.get( "cdBarra" ) + " informado no cadastro não é um EAN Valido!"
    		};
    	}
    }
	var dadosDefault = this.dadosDefault( json );
	return dadosDefault;
};

ValidaCdBarra.prototype.dadosDefault = function( json ) {

	if ( !json.get( "cdEmp" ) || json.get( "cdEmp" ) === null || json.get( "cdEmp" ) === undefined ) {
		json.put( "cdEmp", 1 );
	}
	if ( !json.get( "cdProd" ) || json.get( "cdProd" ) === null || json.get( "cdProd" ) === undefined ) {
		json.put( "cdProd", 0 );
	}
	if ( !json.get( "eanCaixaFechada" ) || json.get( "eanCaixaFechada" ) === null || json.get( "eanCaixaFechada" ) === undefined ) {
		json.put( "eanCaixaFechada", 0 );
	}
	if ( !json.get( "naoEnviaWms" ) || json.get( "naoEnviaWms" ) === null || json.get( "naoEnviaWms" ) === undefined ) {
		json.put( "naoEnviaWms", 0 );
	}
	if ( !json.get( "naoExportar" ) || json.get( "naoExportar" ) === null || json.get( "naoExportar" ) === undefined ) {
		json.put( "naoExportar", 0 );
	}
	if ( !json.get( "naoUsarPedEletr" ) || json.get( "naoUsarPedEletr" ) === null || json.get( "naoUsarPedEletr" ) === undefined ) {
		json.put( "naoUsarPedEletr", 0 );
	}
	if ( !json.get( "qtdeEmbalagem" ) || json.get( "qtdeEmbalagem" ) === null || json.get( "qtdeEmbalagem" ) === undefined ) {
		json.put( "qtdeEmbalagem", 0 );
	}
	if ( !json.get( "tpCdBarra" ) || json.get( "tpCdBarra" ) === null || json.get( "tpCdBarra" ) === undefined ) {
		json.put( "tpCdBarra", 0 );
	}
	return json;
};
