/**
 * Created by maurodouglas on 01/11/16.
 */
var ValidaArvore = function( ) {
	this.mapper = mapperFactory.createMapperMult([ "EstArvMercLinha", "EstArvMercFamilia" ]);
	this.jsonConvert   = new com.google.gson.GsonBuilder( ).create( );
};

ValidaArvore.prototype.validaDadosParaCadastroFamilia = function( json ) {
	if ( !json ) {
		throw { code: 599, message: "Dados passados ao servidor inválido!" };
	}
	if (json.get( "dsArvMercFamilia") !== null && json.get( "dsArvMercFamilia").length() > 0){
      var variaveis = {};
      variaveis.dsArvMercFamilia = json.get( "dsArvMercFamilia");
      var familia   = this.mapper.selectOne("EstArvMercFamilia.isJaCadastrado",variaveis);
      if(familia){
        throw { code: 599, message: "Familia " + familia.get("dsArvMercFamilia") + " já cadastrada anteriormente, Codigo " + familia.get("cdArvMercFamilia")};
      }
  }else{
    throw { code: 599, message: "Dados invalidos de descrição da Familia"};
  }
      var dadosDefault = this.validaDadosDefaultFamilia(json);

      return dadosDefault;
	};

ValidaArvore.prototype.validaDadosDefaultFamilia = function( json ) {
	if ( !json ) {
		throw { code: 599, message: "Dados passados ao servidor inválido!" };
	}
	if ( !json.get( "cdArvMercFamilia" ) || json.get( "cdArvMercFamilia" ) === null || json.get( "cdArvMercFamilia" ) === undefined ) {
		json.put("cdArvMercFamilia", 0);
	}
	if ( !json.get( "cdEmp" ) || json.get( "cdEmp" ) === null || json.get( "cdEmp" ) === undefined ) {
		json.put("cdEmp", 1);
	}
	if ( !json.get( "dsArvMercFamilia" ) || json.get( "dsArvMercFamilia" ) === null || json.get( "dsArvMercFamilia" ) === undefined ) {
		json.put("dsArvMercFamilia", " ");
	}
	return json;
};

ValidaArvore.prototype.validaDadosParaCadastroLinha = function( json ) {
	if ( !json ) {
		throw { code: 599, message: "Dados passados ao servidor inválido!" };
	}
	if (json.get( "dsArvMercLinha") !== null && json.get( "dsArvMercLinha").length() > 0){
      var variaveis = {};
      variaveis.dsArvMercLinha = json.get( "dsArvMercLinha");
      var linha   = this.mapper.selectOne("EstArvMercLinha.listarEstArvMercLinha",variaveis);
      if(linha){
        throw { code: 599, message: "Linha " + familia.get("dsArvMercLinha") + " já cadastrada anteriormente, Codigo " + familia.get("cdArvMercLinha")};
      }
  }else{
    throw { code: 599, message: "Dados invalidos de descrição da Linha"};
  }
      var dadosDefault = this.validaDadosDefaultLinha(json);

      return dadosDefault;
	};

ValidaArvore.prototype.validaDadosDefaultLinha = function( json ) {
	if ( !json ) {
		throw { code: 599, message: "Dados passados ao servidor inválido!" };
	}
  if(!json.get("cdArvMercClassificacao") || json.get("cdArvMercClassificacao") === null || json.get("cdArvMercClassificacao") === undefined){
	json.put("cdArvMercClassificacao", 0);
}
  if(!json.get("cdArvMercLinha") || json.get("cdArvMercLinha") === null || json.get("cdArvMercLinha") === undefined){
	json.put("cdArvMercLinha", 0);
}
  if(!json.get("cdEmp") || json.get("cdEmp") === null || json.get("cdEmp") === undefined){
	json.put("cdEmp", 1);
}
  if(!json.get("dsArvMercLinha") || json.get("dsArvMercLinha") === null || json.get("dsArvMercLinha") === undefined){
	json.put("dsArvMercLinha", " ");
}
  if(!json.get("dsSiglaLinha") || json.get("dsSiglaLinha") === null || json.get("dsSiglaLinha") === undefined){
	json.put("dsSiglaLinha", " ");
}
  if(!json.get("flagLinhaMix") || json.get("flagLinhaMix") === null || json.get("flagLinhaMix") === undefined){
	json.put("flagLinhaMix", 0);
}
  if(!json.get("flagLinhaNaoFazBalanco") || json.get("flagLinhaNaoFazBalanco") === null || json.get("flagLinhaNaoFazBalanco") === undefined){
	json.put("flagLinhaNaoFazBalanco", 0);
}
  if(!json.get("flagLinhaPrecificacao") || json.get("flagLinhaPrecificacao") === null || json.get("flagLinhaPrecificacao") === undefined){
	json.put("flagLinhaPrecificacao", 0);
}
  if(!json.get("flagNaoParticIndic") || json.get("flagNaoParticIndic") === null || json.get("flagNaoParticIndic") === undefined){
	json.put("flagNaoParticIndic", 0);
}
  if(!json.get("flagParticPrecificacao") || json.get("flagParticPrecificacao") === null || json.get("flagParticPrecificacao") === undefined){
	json.put("flagParticPrecificacao", 0);
}
	return json;
};
