/*
 Funções de validação de dados de Nota Fiscal de Saida
 Data de Criação: 25/10/2016
 */

load('/basicos/validaCpfCnpj.js');
load('/rules/filial/validaDados.js');
load('/rules/fornecedor/validaDados.js');
load('/rules/produto/validaDados.js');
load('/rules/empresa/buscaParametros.js');
load('/model/erro/admErroEstNfIntegracoes.js');

var NotaSaida = function () {
    //this.mapper = mapperFactory.createMapperMult(["EstNfSai","AdmErroEstNfIntegracoes","GlbMovOp","EstNfSerie"]);
};

NotaSaida.prototype.validaDadosNotaSaida = function (json, gravarErro) {


    var mapper = mapperFactory.createMapperMult(["EstNfSai", "AdmErroEstNfIntegracoes", "GlbMovOp", "EstNfSerie"]);

    try {
        if (json === null) {
            return { error: true, code: 599, message: "Dados passados ao servidor inválido!" };
        }

        println("Nota não improtada");
        var jaImportada = this.isNotaImportada(mapper, json);
        
        println("mersd");
        if (jaImportada) {
            println("Nota improtada");
            return { error: true, code: 599, message: "Nota " + jaImportada.get("nfNf") + " Com saida ja realizada na data " + jaImportada.get("dtCad") };
        } else {
            println("Nota não improtada");
            ///setando valores default		
            json = this.defaultData(json);

            println("Default validados");

            //######### Valida Dados da Filial #########
            var validaFilial = new ValidaFilial();
            var filial = validaFilial.validaDadosFilialByJSON(json);

            if (filial.error) {
                return filial;
            }
            //######### Valida Dados da Natureza de Movimentaçâo #########
            if (!json.cdNtMov || json.cdNtMov === null || json.cdNtMov === undefined) {
                return { error: true, code: 599, message: 'Natureza de movimentacao nao informada' };
            } else {
                var movOp = mapper.selectOne("GlbMovOp.listarGlbMovOp", { cdMovOp: json.cdNtMov });
                if (!movOp) {
                    return { error: true, code: 599, message: 'Natureza de movimentacao ' + json.cdNtMov + ' nao cadastrada.' };
                } else {
                    json.movOp = this.javaToJavaScript(movOp);
                }
            }
            //######### Valida Serie Nfe #########
            if (!json.cdNfSerie || json.cdNfSerie === null || json.cdNfSerie === undefined) {
                return { error: true, code: 599, message: 'Serie de Nota Fiscal nao informado' };
            } else {

                var variaveis = {};
                if (parseInt(json.flagNotaIntegracao) > 0) {
                    variaveis.serie = String(parseInt(json.cdNfSerie));
                    variaveis.espc = 'NFE';
                    variaveis.codModelo = '55';
                } else {
                    variaveis.cdNfSerie = json.cdNfSerie;
                }

                var serieNfe = mapper.selectList("EstNfSerie.listarEstNfSerie", variaveis);
                if (serieNfe.size() === 0) {
                    return { error: true, code: 599, message: 'Serie de nota fiscal eletronica (modelo 55) ' + json.cdNfSerie + ' nao cadastrada.' };
                } else {
                    json.cdNfSerie = serieNfe.get(0).get("cdNfSerie");     // pega a primeira serie do Retorno, pois pode haver mais de uma serie cadastrada com a mesma numeração
                }
            }
            return json;
        }
    } finally {
        mapper.close();
    }

};


NotaSaida.prototype.isNotaImportada = function (mapper, json) {
    if (json === null) {
        return { error: true, code: 599, message: "Dados passados ao servidor inválido!" };
    }

    
    var variaveis = {};
    variaveis.cdEmp = json.cdEmp;
    variaveis.cdFilial = json.cdFilial;
    variaveis.nfNf = json.nfNf;
    variaveis.dtEmiNf = json.dtEmiNf;
    variaveis.cdNfSerie = json.cdNfSerie;
    
    return mapper.selectOne("EstNfSai.listarEstNfSai", variaveis);

};


NotaSaida.prototype.validaRemetenteDestinatarioTransport = function (json) {
    if (!json.get("cnpjDestinatario")) {
        throw { code: 900, message: "CPF/CNPJ do destinatário nao informado" };
    } else {
        if (validarCNPJ(json.get("cnpjDestinatario")) === false) {
            throw { code: 900, message: "CPF/CNPJ do destinatário inválido" };
        }
    }
    if (!json.get("cnpjEmitente")) {
        throw { code: 900, message: "CPF/CNPJ do emitente nao informado" };
    } else {
        if (validarCNPJ(json.get("cnpjEmitente")) === false) {
            throw { code: 900, message: "CPF/CNPJ do emitente inválido" };
        }
    }
    if (!json.get("cgcCpfTransp")) {
        throw { code: 900, message: "CPF/CNPJ da transportadora nao informado" };
    } else {
        if (validarCNPJ(json.get("cgcCpfTransp")) === false) {
            throw { code: 900, message: "CPF/CNPJ da transportadora inválido" };
        }
    }

};

NotaSaida.prototype.validaItens = function (json) {
    itens = json.get("itens");
    i = 0;
    variaveis = {};
    prod = [];
    filial = [];
    for (i = 0; i < itens.size(); i++) {
        prod[i] = itens.get(i).get("cdProd");
    }
    filial[0] = json.get("cdFilial");
    variaveis.cdProd = prod;
    variaveis.cdFilial = filial;

    var jsonConvert = new com.google.gson.GsonBuilder().create();
    var validaProduto = new ValidaProduto();
    validaProduto.validaStatusProdutosVenda(variaveis);
    //this.validaValoresItens(json);
};

NotaSaida.prototype.validaValoresItens = function (json) {
    itens = json.get("itens");
    i = 0;
    vlrItem = {};
    diferenca = {};

    //INICIA AS VARIAVEIS
    vlrItem.vlrTotIt = 0;
    vlrItem.vlrDesc = 0;
    vlrItem.vlrBaseIcms = 0;
    vlrItem.vlrIcmsSubs = 0;
    vlrItem.vlrBaseSubs = 0;
    vlrItem.vlrIcmsDesonerado = 0;
    vlrItem.vlrFreteIt = 0;
    vlrItem.vlrIpi = 0;
    vlrItem.vlrOutrasDespesas = 0;
    diferenca.vlrTotProd = 0;
    diferenca.vlrDesc = 0;
    diferenca.vlrBaseIcms = 0;
    diferenca.vlrIcmsSubs = 0;
    diferenca.vlrBaseIcmsSubs = 0;
    diferenca.vlrIcmsDesonerado = 0;
    diferenca.vlrFrete = 0;
    diferenca.vlrIpi = 0;
    diferenca.vlrOutrasDespesas = 0;
    diferenca.vlrNf = 0;

    for (i = 0; i < itens.size(); i++) {
        var item = itens.get(i);

        vlrItem.vlrTotIt += item.get("vlrIt") * item.get("qtIt");
        vlrItem.vlrDesc += item.get("vlrDesc") * item.get("qtIt");
        vlrItem.vlrBaseIcms += item.get("vlrBaseIcms");
        vlrItem.vlrIcmsSubs += item.get("vlrIcmsSubs");
        vlrItem.vlrBaseSubs += item.get("vlrBaseSubs");
        vlrItem.vlrIcmsDesonerado += item.get("vlrIcmsDesonerado");
        vlrItem.vlrFreteIt += item.get("vlrFreteIt");
        vlrItem.vlrIpi += item.get("vlrIpi");
        vlrItem.vlrOutrasDespesas += item.get("vlrOutrasDespesas");
    }

    diferenca.vlrTotProd = json.get("vlrTotProd") - (vlrItem.vlrTotIt);
    diferenca.vlrDesc = json.get("vlrDesc") - vlrItem.vlrDesc;
    diferenca.vlrBaseIcms = json.get("vlrBaseIcms") - vlrItem.vlrBaseIcms;
    diferenca.vlrIcmsSubs = json.get("vlrIcmsSubs") - vlrItem.vlrIcmsSubs;
    diferenca.vlrBaseIcmsSubs = json.get("vlrBaseIcmsSubs") - vlrItem.vlrBaseSubs;
    diferenca.vlrIcmsDesonerado = json.get("vlrIcmsDesonerado") - vlrItem.vlrIcmsDesonerado;
    diferenca.vlrFrete = json.get("vlrFrete") - vlrItem.vlrFreteIt;
    diferenca.vlrIpi = json.get("vlrIpi") - vlrItem.vlrIpi;
    diferenca.vlrOutrasDespesas = json.get("vlrOutrasDespesas") - vlrItem.vlrOutrasDespesas;
    var totalItens = (vlrItem.vlrOutrasDespesas + vlrItem.vlrFreteIt + vlrItem.vlrIcmsSubs + vlrItem.vlrIpi + vlrItem.vlrTotIt - vlrItem.vlrDesc);
    diferenca.vlrNf = json.get("vlrNf") - totalItens;

    var jsonConvert = new com.google.gson.GsonBuilder().create();
    /* java.lang.System.out.println('diferenca.vlrTotProd  ' + diferenca.vlrTotProd
                                 +' diferenca.vlrDesc            ' + diferenca.vlrDesc
                                 +' diferenca.vlrBaseIcms       ' + diferenca.vlrBaseIcms
                                 +' diferenca.vlrIcmsSubs       ' + diferenca.vlrIcmsSubs
                                 +' diferenca.vlrBaseIcmsSubs   ' + diferenca.vlrBaseIcmsSubs
                                 +' diferenca.vlrIcmsDesonerado ' + diferenca.vlrIcmsDesonerado
                                 +' diferenca.vlrFrete          ' + diferenca.vlrFrete
                                 +' diferenca.vlrIpi            ' + diferenca.vlrIpi
                                 +' diferenca.vlrOutrasDespesas ' + diferenca.vlrOutrasDespesas
                                 +' diferenca.vlrNf               ' +  diferenca.vlrNf
                                 +' vlrItem.vlrDesc ' + vlrItem.vlrDesc
                                 +' vlrItem.vlrTotIt ' + vlrItem.vlrTotIt
     );
 */
    if (diferenca.vlrTotProd > 0) {
        throw {
            code: 599, message: "Valor total dos Produtos divergente do valor total do(s) item(ns); "
            + " Valor total produto nota ...: " + json.get("vlrTotProd")
            + " Valor total produto itens ..: " + vlrItem.vlrTotIt.toFixed(2)
            + " Diferença ..................: " + diferenca.vlrTotProd.toFixed(2)
        };
    }
    if (diferenca.vlrBaseIcms > 0) {
        throw {
            code: 599, message: "Valor total de Base ICMS divergente do valor total de Base ICMS do(s) item(ns); "
            + " Valor total Base ICMS nota ...:  " + json.get("vlrBaseIcms")
            + " Valor total Base ICMS itens ..:  " + vlrItem.vlrBaseIcms
            + " Diferença ....................:  " + diferenca.vlrBaseIcms.toFixed(2)
        };
    }
    if (diferenca.vlrIcmsSubs > 0) {
        throw {
            code: 599, message: "Valor total de ICMS Subst. divergente do valor total de ICMS Subst. do(s) item(ns); "
            + " Valor total Base ICMS Subst nota ...:  " + json.get("vlrIcmsSubs")
            + " Valor total Base ICMS Subst itens ..:  " + vlrItem.vlrIcmsSubs
            + " Diferença ..........................:  " + diferenca.vlrIcmsSubs.toFixed(2)
        };
    }
    if (diferenca.vlrBaseIcmsSubs > 0) {
        throw {
            code: 599, message: "Valor total de Base ICMS Subst. divergente do valor total de Base ICMS Subst. do(s) item(ns); "
            + " Valor total Base ICMS Subst nota ...:  " + json.get("vlrBaseIcmsSubs")
            + " Valor total Base ICMS Subst itens ..:  " + vlrItem.vlrBaseSubs
            + " Diferença ..........................:  " + diferenca.vlrBaseIcmsSubs.toFixed(2)
        };
    }
    if (diferenca.vlrIcmsDesonerado > 0) {
        throw {
            code: 599, message: "Valor total de Base ICMS divergente do valor total de Base ICMS do(s) item(ns); "
            + " Valor total Base ICMS nota ...:  " + json.get("vlrIcmsDesonerado")
            + " Valor total Base ICMS itens ..:  " + vlrItem.vlrIcmsDesonerado
            + " Diferença ....................:  " + diferenca.vlrIcmsDesonerado.toFixed(2)
        };
    }
    if (diferenca.vlrFrete > 0) {
        throw {
            code: 599, message: "Valor total de Frete divergente do valor total de Frete do(s) item(ns); "
            + " Valor total Frete nota ...:  " + json.get("vlrFrete")
            + " Valor total Frete itens ..:  " + vlrItem.vlrFreteIt
            + " Diferença ................:  " + diferenca.vlrFrete.toFixed(2)
        };
    }
    if (diferenca.vlrIpi > 0) {
        throw {
            code: 599, message: "Valor total de IPI divergente do valor total de IPI do(s) item(ns); "
            + " Valor total IPI nota .....:   " + json.get("vlrIpi")
            + " Valor total IPI itens ....:   " + vlrItem.vlrIpi
            + " Diferença ................:  " + diferenca.vlrIpi.toFixed(2)
        };
    }
    if (diferenca.vlrOutrasDespesas > 0) {
        throw {
            code: 599, message: "Valor total de Outras despesasas divergente do valor total de Outras despesasas do(s) item(ns); "
            + " Valor total Outras despesasas nota ...:  " + json.get("vlrOutrasDespesas")
            + " Valor total Outras despesasas itens ..:  " + vlrItem.vlrOutrasDespesas
            + " Diferença ............................: " + diferenca.vlrOutrasDespesas.toFixed(2)
        };
    }
    if (diferenca.vlrNf > 0) {
        throw {
            code: 599, message: "Valor total da Nota divergente do somatório do(s) Produto(s); "
            + " Valor total Nota ...: " + json.get("vlrNf")
            + " Valor total Itens ..: " + totalItens
            + " Diferença ..........: " + diferenca.vlrNf.toFixed(2)
        };
    }

    delete itens;
    delete i;
    delete vlrItem;
    delete diferenca;

};


NotaSaida.prototype.defaultData = function (json) {
    if (!json.aliqIcms || json.aliqIcms === null || json.aliqIcms === undefined) {
        json.aliqIcms = 0;
    }
    if (!json.aplicativo || json.aplicativo === null || json.aplicativo === undefined) {
        json.aplicativo = "";
    }
    if (!json.bairroDestinatario || json.bairroDestinatario === null || json.bairroDestinatario === undefined) {
        json.bairroDestinatario = "";
    }
    if (!json.bairroEmitente || json.bairroEmitente === null || json.bairroEmitente === undefined) {
        json.bairroEmitente = "";
    }
    if (!json.cdCidDestinatario || json.cdCidDestinatario === null || json.cdCidDestinatario === undefined) {
        json.cdCidDestinatario = 0;
    }
    if (!json.cdCidEmitente || json.cdCidEmitente === null || json.cdCidEmitente === undefined) {
        json.cdCidEmitente = 0;
    }
    if (!json.cdCidTransp || json.cdCidTransp === null || json.cdCidTransp === undefined) {
        json.cdCidTransp = 0;
    }
    if (!json.cdCli || json.cdCli === null || json.cdCli === undefined) {
        json.cdCli = 0;
    }
    if (!json.cdCondPgto || json.cdCondPgto === null || json.cdCondPgto === undefined) {
        json.cdCondPgto = 0;
    }
    if (!json.cdEmp || json.cdEmp === null || json.cdEmp === undefined) {
        json.cdEmp = 0;
    }
    if (!json.cdFilial || json.cdFilial === null || json.cdFilial === undefined) {
        json.cdFilial = 0;
    }
    if (!json.cdMotEmisNf || json.cdMotEmisNf === null || json.cdMotEmisNf === undefined) {
        json.cdMotEmisNf = 0;
    }
    if (!json.cdMtCancel || json.cdMtCancel === null || json.cdMtCancel === undefined) {
        json.cdMtCancel = 0;
    }
    if (!json.cdNf || json.cdNf === null || json.cdNf === undefined) {
        json.cdNf = 0;
    }
    if (!json.cdNfEnt || json.cdNfEnt === null || json.cdNfEnt === undefined) {
        json.cdNfEnt = 0;
    }
    if (!json.cdNfSerie || json.cdNfSerie === null || json.cdNfSerie === undefined) {
        json.cdNfSerie = 0;
    }
    if (!json.cdNtMov || json.cdNtMov === null || json.cdNtMov === undefined) {
        json.cdNtMov = 0;
    }
    if (!json.cdNtOpTransfEntrada || json.cdNtOpTransfEntrada === null || json.cdNtOpTransfEntrada === undefined) {
        json.cdNtOpTransfEntrada = 0;
    }
    if (!json.cdPed || json.cdPed === null || json.cdPed === undefined) {
        json.cdPed = 0;
    }
    if (!json.cdTransp || json.cdTransp === null || json.cdTransp === undefined) {
        json.cdTransp = 0;
    }
    if (!json.cdUsu || json.cdUsu === null || json.cdUsu === undefined) {
        json.cdUsu = 0;
    }
    if (!json.cdVend || json.cdVend === null || json.cdVend === undefined) {
        json.cdVend = 0;
    }
    if (!json.cepDestinatario || json.cepDestinatario === null || json.cepDestinatario === undefined) {
        json.cepDestinatario = "";
    }
    if (!json.cepEmitente || json.cepEmitente === null || json.cepEmitente === undefined) {
        json.cepEmitente = "";
    }
    if (!json.cgcCpfTransp || json.cgcCpfTransp === null || json.cgcCpfTransp === undefined) {
        json.cgcCpfTransp = "";
    }
    if (!json.cidadeDestinatario || json.cidadeDestinatario === null || json.cidadeDestinatario === undefined) {
        json.cidadeDestinatario = "";
    }
    if (!json.cidadeEmitente || json.cidadeEmitente === null || json.cidadeEmitente === undefined) {
        json.cidadeEmitente = "";
    }
    if (!json.cnpjDestinatario || json.cnpjDestinatario === null || json.cnpjDestinatario === undefined) {
        json.cnpjDestinatario = "";
    }
    if (!json.cnpjEmitente || json.cnpjEmitente === null || json.cnpjEmitente === undefined) {
        json.cnpjEmitente = "";
    }
    if (!json.cob || json.cob === null || json.cob === undefined) {
        json.cob = 0;
    }
    if (!json.dev || json.dev === null || json.dev === undefined) {
        json.dev = 0;
    }
    if (!json.dsCidTransp || json.dsCidTransp === null || json.dsCidTransp === undefined) {
        json.dsCidTransp = "";
    }
    if (!json.dsTransp || json.dsTransp === null || json.dsTransp === undefined) {
        json.dsTransp = "";
    }
    if (!json.dtCad || json.dtCad === null || json.dtCad === undefined) {
        json.dtCad = "";
    }
    if (!json.dtCancel || json.dtCancel === null || json.dtCancel === undefined) {
        json.dtCancel = "";
    }
    if (!json.dtEmiNf || json.dtEmiNf === null || json.dtEmiNf === undefined) {
        json.dtEmiNf = "";
    }
    // if(!json.dtHrCad || json.dtHrCad === null || json.dtHrCad === undefined){
    //     json.dtHrCad = getdate;
    // }
    if (!json.dtUltAlt || json.dtUltAlt === null || json.dtUltAlt === undefined) {
        json.dtUltAlt = "";
    }
    if (!json.emailTransp || json.emailTransp === null || json.emailTransp === undefined) {
        json.emailTransp = "";
    }
    if (!json.endDestinatario || json.endDestinatario === null || json.endDestinatario === undefined) {
        json.endDestinatario = "";
    }
    if (!json.endEmitente || json.endEmitente === null || json.endEmitente === undefined) {
        json.endEmitente = "";
    }
    if (!json.endeTransp || json.endeTransp === null || json.endeTransp === undefined) {
        json.endeTransp = "";
    }
    if (!json.espVol || json.espVol === null || json.espVol === undefined) {
        json.espVol = "";
    }
    if (!json.flagIgnorarControl || json.flagIgnorarControl === null || json.flagIgnorarControl === undefined) {
        json.flagIgnorarControl = 0;
    }
    if (!json.flagNfProdTotalBruto || json.flagNfProdTotalBruto === null || json.flagNfProdTotalBruto === undefined) {
        json.flagNfProdTotalBruto = 0;
    }
    if (!json.flagNotaIntegracao || json.flagNotaIntegracao === null || json.flagNotaIntegracao === undefined) {
        json.flagNotaIntegracao = 0;
    }
    //if(!json.hrEmiNf || json.hrEmiNf === null || json.hrEmiNf === undefined){
    //    json.hrEmiNf = CONVERT[varchar],getdate,108;
    //}
    if (!json.infDesconto || json.infDesconto === null || json.infDesconto === undefined) {
        json.infDesconto = "";
    }
    if (!json.inscEstTransp || json.inscEstTransp === null || json.inscEstTransp === undefined) {
        json.inscEstTransp = "";
    }
    if (!json.inscEstadualDestinatario || json.inscEstadualDestinatario === null || json.inscEstadualDestinatario === undefined) {
        json.inscEstadualDestinatario = "";
    }
    if (!json.inscEstadualEmitente || json.inscEstadualEmitente === null || json.inscEstadualEmitente === undefined) {
        json.inscEstadualEmitente = "";
    }
    if (!json.lancEfetu || json.lancEfetu === null || json.lancEfetu === undefined) {
        json.lancEfetu = 0;
    }
    if (!json.mcVol || json.mcVol === null || json.mcVol === undefined) {
        json.mcVol = "";
    }
    if (!json.nfManual || json.nfManual === null || json.nfManual === undefined) {
        json.nfManual = 0;
    }
    if (!json.nfNf || json.nfNf === null || json.nfNf === undefined) {
        json.nfNf = 0;
    }
    if (!json.nfProdServ || json.nfProdServ === null || json.nfProdServ === undefined) {
        json.nfProdServ = 0;
    }
    if (!json.nfeRejeitada || json.nfeRejeitada === null || json.nfeRejeitada === undefined) {
        json.nfeRejeitada = 0;
    }
    if (!json.nmComprador || json.nmComprador === null || json.nmComprador === undefined) {
        json.nmComprador = "";
    }
    if (!json.notaFiscalLivre || json.notaFiscalLivre === null || json.notaFiscalLivre === undefined) {
        json.notaFiscalLivre = 0;
    }
    if (!json.nrFormulario || json.nrFormulario === null || json.nrFormulario === undefined) {
        json.nrFormulario = 0;
    }
    if (!json.nrSeloSaida || json.nrSeloSaida === null || json.nrSeloSaida === undefined) {
        json.nrSeloSaida = 0;
    }
    if (!json.nrVol || json.nrVol === null || json.nrVol === undefined) {
        json.nrVol = 0;
    }
    if (!json.ntOperacao || json.ntOperacao === null || json.ntOperacao === undefined) {
        json.ntOperacao = "";
    }
    if (!json.obs1 || json.obs1 === null || json.obs1 === undefined) {
        json.obs1 = "";
    }
    if (!json.obs10 || json.obs10 === null || json.obs10 === undefined) {
        json.obs10 = "";
    }
    if (!json.obs11 || json.obs11 === null || json.obs11 === undefined) {
        json.obs11 = "";
    }
    if (!json.obs2 || json.obs2 === null || json.obs2 === undefined) {
        json.obs2 = "";
    }
    if (!json.obs3 || json.obs3 === null || json.obs3 === undefined) {
        json.obs3 = "";
    }
    if (!json.obs4 || json.obs4 === null || json.obs4 === undefined) {
        json.obs4 = "";
    }
    if (!json.obs5 || json.obs5 === null || json.obs5 === undefined) {
        json.obs5 = "";
    }
    if (!json.obs6 || json.obs6 === null || json.obs6 === undefined) {
        json.obs6 = "";
    }
    if (!json.obs7 || json.obs7 === null || json.obs7 === undefined) {
        json.obs7 = "";
    }
    if (!json.obs8 || json.obs8 === null || json.obs8 === undefined) {
        json.obs8 = "";
    }
    if (!json.obs9 || json.obs9 === null || json.obs9 === undefined) {
        json.obs9 = "";
    }
    if (!json.pendEntrada || json.pendEntrada === null || json.pendEntrada === undefined) {
        json.pendEntrada = 0;
    }
    if (!json.percIssqn || json.percIssqn === null || json.percIssqn === undefined) {
        json.percIssqn = 0;
    }
    if (!json.pesoLiqVol || json.pesoLiqVol === null || json.pesoLiqVol === undefined) {
        json.pesoLiqVol = 0;
    }
    if (!json.pesoVol || json.pesoVol === null || json.pesoVol === undefined) {
        json.pesoVol = 0;
    }
    if (!json.placaUf || json.placaUf === null || json.placaUf === undefined) {
        json.placaUf = "";
    }
    if (!json.placaVeic || json.placaVeic === null || json.placaVeic === undefined) {
        json.placaVeic = "";
    }
    if (!json.qtCxVol || json.qtCxVol === null || json.qtCxVol === undefined) {
        json.qtCxVol = 0;
    }
    if (!json.qtVol || json.qtVol === null || json.qtVol === undefined) {
        json.qtVol = 0;
    }
    if (!json.rzDestinatario || json.rzDestinatario === null || json.rzDestinatario === undefined) {
        json.rzDestinatario = "";
    }
    if (!json.rzEmitente || json.rzEmitente === null || json.rzEmitente === undefined) {
        json.rzEmitente = "";
    }
    if (!json.rzTransportador || json.rzTransportador === null || json.rzTransportador === undefined) {
        json.rzTransportador = "";
    }
    if (!json.stsNf || json.stsNf === null || json.stsNf === undefined) {
        json.stsNf = 0;
    }
    if (!json.tpDevNf || json.tpDevNf === null || json.tpDevNf === undefined) {
        json.tpDevNf = 0;
    }
    if (!json.tpFrete || json.tpFrete === null || json.tpFrete === undefined) {
        json.tpFrete = 0;
    }
    if (!json.tpNf || json.tpNf === null || json.tpNf === undefined) {
        json.tpNf = 0;
    }
    if (!json.ufDestinatario || json.ufDestinatario === null || json.ufDestinatario === undefined) {
        json.ufDestinatario = "";
    }
    if (!json.ufEmitente || json.ufEmitente === null || json.ufEmitente === undefined) {
        json.ufEmitente = "";
    }
    if (!json.ufTransp || json.ufTransp === null || json.ufTransp === undefined) {
        json.ufTransp = "";
    }
    if (!json.versaoAplicativo || json.versaoAplicativo === null || json.versaoAplicativo === undefined) {
        json.versaoAplicativo = "";
    }
    if (!json.vlrBaseIcms || json.vlrBaseIcms === null || json.vlrBaseIcms === undefined) {
        json.vlrBaseIcms = 0;
    }
    if (!json.vlrBaseIcmsIt || json.vlrBaseIcmsIt === null || json.vlrBaseIcmsIt === undefined) {
        json.vlrBaseIcmsIt = 0;
    }
    if (!json.vlrBaseIcmsRet || json.vlrBaseIcmsRet === null || json.vlrBaseIcmsRet === undefined) {
        json.vlrBaseIcmsRet = 0;
    }
    if (!json.vlrBaseIcmsSubs || json.vlrBaseIcmsSubs === null || json.vlrBaseIcmsSubs === undefined) {
        json.vlrBaseIcmsSubs = 0;
    }
    if (!json.vlrDesc || json.vlrDesc === null || json.vlrDesc === undefined) {
        json.vlrDesc = 0;
    }
    if (!json.vlrDescCorpo || json.vlrDescCorpo === null || json.vlrDescCorpo === undefined) {
        json.vlrDescCorpo = 0;
    }
    if (!json.vlrFrete || json.vlrFrete === null || json.vlrFrete === undefined) {
        json.vlrFrete = 0;
    }
    if (!json.vlrIcms || json.vlrIcms === null || json.vlrIcms === undefined) {
        json.vlrIcms = 0;
    }
    if (!json.vlrIcmsDesonerado || json.vlrIcmsDesonerado === null || json.vlrIcmsDesonerado === undefined) {
        json.vlrIcmsDesonerado = 0;
    }
    if (!json.vlrIcmsRet || json.vlrIcmsRet === null || json.vlrIcmsRet === undefined) {
        json.vlrIcmsRet = 0;
    }
    if (!json.vlrIcmsSubs || json.vlrIcmsSubs === null || json.vlrIcmsSubs === undefined) {
        json.vlrIcmsSubs = 0;
    }
    if (!json.vlrIpi || json.vlrIpi === null || json.vlrIpi === undefined) {
        json.vlrIpi = 0;
    }
    if (!json.vlrIsentas || json.vlrIsentas === null || json.vlrIsentas === undefined) {
        json.vlrIsentas = 0;
    }
    if (!json.vlrIssqn || json.vlrIssqn === null || json.vlrIssqn === undefined) {
        json.vlrIssqn = 0;
    }
    if (!json.vlrNf || json.vlrNf === null || json.vlrNf === undefined) {
        json.vlrNf = 0;
    }
    if (!json.vlrOutras || json.vlrOutras === null || json.vlrOutras === undefined) {
        json.vlrOutras = 0;
    }
    if (!json.vlrOutros || json.vlrOutros === null || json.vlrOutros === undefined) {
        json.vlrOutros = 0;
    }
    if (!json.vlrProdIcmsSubs || json.vlrProdIcmsSubs === null || json.vlrProdIcmsSubs === undefined) {
        json.vlrProdIcmsSubs = 0;
    }
    if (!json.vlrServico || json.vlrServico === null || json.vlrServico === undefined) {
        json.vlrServico = 0;
    }
    if (!json.vlrSuframa || json.vlrSuframa === null || json.vlrSuframa === undefined) {
        json.vlrSuframa = 0;
    }
    if (!json.vlrTotProd || json.vlrTotProd === null || json.vlrTotProd === undefined) {
        json.vlrTotProd = 0;
    }
    if (!json.xpedNotaFiscal || json.xpedNotaFiscal === null || json.xpedNotaFiscal === undefined) {
        json.xpedNotaFiscal = "";
    }

    for (var cont = 0; cont < json.itens.length; cont++) {
        json.itens[cont] = this.itemDefaultData(json.itens[cont]);
		json.itens[cont].dtEmiNf = json.dtEmiNf;
		
    }

    return json;

}



NotaSaida.prototype.itemDefaultData = function (json) {
    if (!json.aliqIcms || json.aliqIcms === null || json.aliqIcms === undefined) {
        json.aliqIcms = 0;
    }
    if (!json.aliqIcmsInterno || json.aliqIcmsInterno === null || json.aliqIcmsInterno === undefined) {
        json.aliqIcmsInterno = 0;
    }
    if (!json.cdEmp || json.cdEmp === null || json.cdEmp === undefined) {
        json.cdEmp = 0;
    }
    if (!json.cdFilial || json.cdFilial === null || json.cdFilial === undefined) {
        json.cdFilial = 0;
    }
    if (!json.cdIt || json.cdIt === null || json.cdIt === undefined) {
        json.cdIt = 0;
    }
    if (!json.cdNf || json.cdNf === null || json.cdNf === undefined) {
        json.cdNf = 0;
    }
    if (!json.cdNtOp || json.cdNtOp === null || json.cdNtOp === undefined) {
        json.cdNtOp = 0;
    }
    if (!json.cdProd || json.cdProd === null || json.cdProd === undefined) {
        json.cdProd = 0;
    }
    if (!json.cdSitOperaSimplesNacio || json.cdSitOperaSimplesNacio === null || json.cdSitOperaSimplesNacio === undefined) {
        json.cdSitOperaSimplesNacio = 0;
    }
    if (!json.cdTrib || json.cdTrib === null || json.cdTrib === undefined) {
        json.cdTrib = 0;
    }
    if (!json.cstCofins || json.cstCofins === null || json.cstCofins === undefined) {
        json.cstCofins = 0;
    }
    if (!json.cstPis || json.cstPis === null || json.cstPis === undefined) {
        json.cstPis = 0;
    }
    if (!json.dsPercComis || json.dsPercComis === null || json.dsPercComis === undefined) {
        json.dsPercComis = "";
    }
    if (!json.dsProd || json.dsProd === null || json.dsProd === undefined) {
        json.dsProd = "";
    }
    if (!json.dsVlrComis || json.dsVlrComis === null || json.dsVlrComis === undefined) {
        json.dsVlrComis = "";
    }
    if (!json.dtEmiNf || json.dtEmiNf === null || json.dtEmiNf === undefined) {
        json.dtEmiNf = "";
    }
    if (!json.fecopRecalculado || json.fecopRecalculado === null || json.fecopRecalculado === undefined) {
        json.fecopRecalculado = 0;
    }
    if (!json.flagExcecaoPisCofins || json.flagExcecaoPisCofins === null || json.flagExcecaoPisCofins === undefined) {
        json.flagExcecaoPisCofins = 0;
    }
    if (!json.flagProdCestaBasica || json.flagProdCestaBasica === null || json.flagProdCestaBasica === undefined) {
        json.flagProdCestaBasica = 0;
    }
    if (!json.gerarDifal || json.gerarDifal === null || json.gerarDifal === undefined) {
        json.gerarDifal = 0;
    }
    if (!json.icmsDesoneradoMotivo || json.icmsDesoneradoMotivo === null || json.icmsDesoneradoMotivo === undefined) {
        json.icmsDesoneradoMotivo = 0;
    }
    if (!json.indTotal || json.indTotal === null || json.indTotal === undefined) {
        json.indTotal = 1;
    }
    if (!json.listaProd || json.listaProd === null || json.listaProd === undefined) {
        json.listaProd = 0;
    }
    if (!json.modaliBaseIcms || json.modaliBaseIcms === null || json.modaliBaseIcms === undefined) {
        json.modaliBaseIcms = 0;
    }
    if (!json.modaliBaseIcmsSubst || json.modaliBaseIcmsSubst === null || json.modaliBaseIcmsSubst === undefined) {
        json.modaliBaseIcmsSubst = 0;
    }
    if (!json.nItemPed || json.nItemPed === null || json.nItemPed === undefined) {
        json.nItemPed = 0;
    }
    if (!json.percAliqCofins || json.percAliqCofins === null || json.percAliqCofins === undefined) {
        json.percAliqCofins = 0;
    }
    if (!json.percAliqPis || json.percAliqPis === null || json.percAliqPis === undefined) {
        json.percAliqPis = 0;
    }
    if (!json.percComi || json.percComi === null || json.percComi === undefined) {
        json.percComi = 0;
    }
    if (!json.percComiCtr || json.percComiCtr === null || json.percComiCtr === undefined) {
        json.percComiCtr = 0;
    }
    if (!json.percDescCtr || json.percDescCtr === null || json.percDescCtr === undefined) {
        json.percDescCtr = 0;
    }
    if (!json.percDescFinan || json.percDescFinan === null || json.percDescFinan === undefined) {
        json.percDescFinan = 0;
    }
    if (!json.percDescIt || json.percDescIt === null || json.percDescIt === undefined) {
        json.percDescIt = 0;
    }
    if (!json.percDiferimento || json.percDiferimento === null || json.percDiferimento === undefined) {
        json.percDiferimento = 0;
    }
    if (!json.percFecop || json.percFecop === null || json.percFecop === undefined) {
        json.percFecop = 0;
    }
    if (!json.percIcmsDestinoDifal || json.percIcmsDestinoDifal === null || json.percIcmsDestinoDifal === undefined) {
        json.percIcmsDestinoDifal = 0;
    }
    if (!json.percIcmsLucroReal || json.percIcmsLucroReal === null || json.percIcmsLucroReal === undefined) {
        json.percIcmsLucroReal = 0;
    }
    if (!json.percIcmsOp || json.percIcmsOp === null || json.percIcmsOp === undefined) {
        json.percIcmsOp = 0;
    }
    if (!json.percIcmsOrigemDifal || json.percIcmsOrigemDifal === null || json.percIcmsOrigemDifal === undefined) {
        json.percIcmsOrigemDifal = 0;
    }
    if (!json.percIcmsSimplesNacional || json.percIcmsSimplesNacional === null || json.percIcmsSimplesNacional === undefined) {
        json.percIcmsSimplesNacional = 0;
    }
    if (!json.percIpi || json.percIpi === null || json.percIpi === undefined) {
        json.percIpi = 0;
    }
    if (!json.percIva || json.percIva === null || json.percIva === undefined) {
        json.percIva = 0;
    }
    if (!json.percReduBaseIcms || json.percReduBaseIcms === null || json.percReduBaseIcms === undefined) {
        json.percReduBaseIcms = 0;
    }
    if (!json.percReduBaseSubs || json.percReduBaseSubs === null || json.percReduBaseSubs === undefined) {
        json.percReduBaseSubs = 0;
    }
    if (!json.pisCofins || json.pisCofins === null || json.pisCofins === undefined) {
        json.pisCofins = 0;
    }
    if (!json.pisCofinsRecalculado || json.pisCofinsRecalculado === null || json.pisCofinsRecalculado === undefined) {
        json.pisCofinsRecalculado = 0;
    }
    if (!json.qtEstAnt || json.qtEstAnt === null || json.qtEstAnt === undefined) {
        json.qtEstAnt = 0;
    }
    if (!json.qtIt || json.qtIt === null || json.qtIt === undefined) {
        json.qtIt = 0;
    }
    if (!json.qtdeProdDevolucao || json.qtdeProdDevolucao === null || json.qtdeProdDevolucao === undefined) {
        json.qtdeProdDevolucao = 0;
    }
    if (!json.siglaExcecaoPisCofins || json.siglaExcecaoPisCofins === null || json.siglaExcecaoPisCofins === undefined) {
        json.siglaExcecaoPisCofins = "";
    }
    if (!json.tipoTributacaoPisCofins || json.tipoTributacaoPisCofins === null || json.tipoTributacaoPisCofins === undefined) {
        json.tipoTributacaoPisCofins = 0;
    }
    if (!json.tpProd || json.tpProd === null || json.tpProd === undefined) {
        json.tpProd = 0;
    }
    if (!json.un || json.un === null || json.un === undefined) {
        json.un = "";
    }
    if (!json.vlrBaseCofins || json.vlrBaseCofins === null || json.vlrBaseCofins === undefined) {
        json.vlrBaseCofins = 0;
    }
    if (!json.vlrBaseIcmsIt || json.vlrBaseIcmsIt === null || json.vlrBaseIcmsIt === undefined) {
        json.vlrBaseIcmsIt = 0;
    }
    if (!json.vlrBaseIcmsOp || json.vlrBaseIcmsOp === null || json.vlrBaseIcmsOp === undefined) {
        json.vlrBaseIcmsOp = 0;
    }
    if (!json.vlrBaseIcmsRet || json.vlrBaseIcmsRet === null || json.vlrBaseIcmsRet === undefined) {
        json.vlrBaseIcmsRet = 0;
    }
    if (!json.vlrBasePis || json.vlrBasePis === null || json.vlrBasePis === undefined) {
        json.vlrBasePis = 0;
    }
    if (!json.vlrBaseSubs || json.vlrBaseSubs === null || json.vlrBaseSubs === undefined) {
        json.vlrBaseSubs = 0;
    }
    if (!json.vlrCofins || json.vlrCofins === null || json.vlrCofins === undefined) {
        json.vlrCofins = 0;
    }
    if (!json.vlrComissaoFabric || json.vlrComissaoFabric === null || json.vlrComissaoFabric === undefined) {
        json.vlrComissaoFabric = 0;
    }
    if (!json.vlrCredBaseSn || json.vlrCredBaseSn === null || json.vlrCredBaseSn === undefined) {
        json.vlrCredBaseSn = 0;
    }
    if (!json.vlrCredIcmsSn || json.vlrCredIcmsSn === null || json.vlrCredIcmsSn === undefined) {
        json.vlrCredIcmsSn = 0;
    }
    if (!json.vlrCusto || json.vlrCusto === null || json.vlrCusto === undefined) {
        json.vlrCusto = 0;
    }
    if (!json.vlrCustoAcerto || json.vlrCustoAcerto === null || json.vlrCustoAcerto === undefined) {
        json.vlrCustoAcerto = 0;
    }
    if (!json.vlrCustoGerencialTransf || json.vlrCustoGerencialTransf === null || json.vlrCustoGerencialTransf === undefined) {
        json.vlrCustoGerencialTransf = 0;
    }
    if (!json.vlrCustoMd || json.vlrCustoMd === null || json.vlrCustoMd === undefined) {
        json.vlrCustoMd = 0;
    }
    if (!json.vlrDescFinan || json.vlrDescFinan === null || json.vlrDescFinan === undefined) {
        json.vlrDescFinan = 0;
    }
    if (!json.vlrDescIt || json.vlrDescIt === null || json.vlrDescIt === undefined) {
        json.vlrDescIt = 0;
    }
    if (!json.vlrIcmsDesonerado || json.vlrIcmsDesonerado === null || json.vlrIcmsDesonerado === undefined) {
        json.vlrIcmsDesonerado = 0;
    }
    if (!json.vlrIcmsDiferimento || json.vlrIcmsDiferimento === null || json.vlrIcmsDiferimento === undefined) {
        json.vlrIcmsDiferimento = 0;
    }
    if (!json.vlrIcmsIt || json.vlrIcmsIt === null || json.vlrIcmsIt === undefined) {
        json.vlrIcmsIt = 0;
    }
    if (!json.vlrIcmsLucroReal || json.vlrIcmsLucroReal === null || json.vlrIcmsLucroReal === undefined) {
        json.vlrIcmsLucroReal = 0;
    }
    if (!json.vlrIcmsOp || json.vlrIcmsOp === null || json.vlrIcmsOp === undefined) {
        json.vlrIcmsOp = 0;
    }
    if (!json.vlrIcmsRet || json.vlrIcmsRet === null || json.vlrIcmsRet === undefined) {
        json.vlrIcmsRet = 0;
    }
    if (!json.vlrIcmsSubs || json.vlrIcmsSubs === null || json.vlrIcmsSubs === undefined) {
        json.vlrIcmsSubs = 0;
    }
    if (!json.vlrIsento || json.vlrIsento === null || json.vlrIsento === undefined) {
        json.vlrIsento = 0;
    }
    if (!json.vlrIt || json.vlrIt === null || json.vlrIt === undefined) {
        json.vlrIt = 0;
    }
    if (!json.vlrOutros || json.vlrOutros === null || json.vlrOutros === undefined) {
        json.vlrOutros = 0;
    }
    if (!json.vlrOutrosDespesas || json.vlrOutrosDespesas === null || json.vlrOutrosDespesas === undefined) {
        json.vlrOutrosDespesas = 0;
    }
    if (!json.vlrPis || json.vlrPis === null || json.vlrPis === undefined) {
        json.vlrPis = 0;
    }
    if (!json.vlrPmc || json.vlrPmc === null || json.vlrPmc === undefined) {
        json.vlrPmc = 0;
    }
    if (!json.vlrProdFrete || json.vlrProdFrete === null || json.vlrProdFrete === undefined) {
        json.vlrProdFrete = 0;
    }
    if (!json.vlrProdPed || json.vlrProdPed === null || json.vlrProdPed === undefined) {
        json.vlrProdPed = 0;
    }
    if (!json.vlrRessarcimentoIcms || json.vlrRessarcimentoIcms === null || json.vlrRessarcimentoIcms === undefined) {
        json.vlrRessarcimentoIcms = 0;
    }
    if (!json.vlrSuframa || json.vlrSuframa === null || json.vlrSuframa === undefined) {
        json.vlrSuframa = 0;
    }
    if (!json.vlrTotIt || json.vlrTotIt === null || json.vlrTotIt === undefined) {
        json.vlrTotIt = 0;
    }
    if (!json.xpedIt || json.xpedIt === null || json.xpedIt === undefined) {
        json.xpedIt = "";
    }


    return json;
}

NotaSaida.prototype.javaToJavaScript = function(movOp){
	
	var json = {};
	json.alqIcms = movOp.get("alqIcms");
	json.atuEst = movOp.get("atuEst");
	json.atuEstFlut = movOp.get("atuEstFlut");
	json.bxEst = movOp.get("bxEst");
	json.bxEstFlut = movOp.get("bxEstFlut");
	json.calcCustoMedio = movOp.get("calcCustoMedio");
	json.cdMovOp = movOp.get("cdMovOp");
	json.cdUsu = movOp.get("cdUsu");
	json.cfop = movOp.get("cfop");
	json.clasMov = movOp.get("clasMov");
	json.destOrig = movOp.get("destOrig");
	json.dsMovOp = movOp.get("dsMovOp");
	json.dsMovOpUsual = movOp.get("dsMovOpUsual");
	json.envioOperadorLog = movOp.get("envioOperadorLog");
	json.flagContabilizarComoDespesas = movOp.get("flagContabilizarComoDespesas");
	json.flagCustoZeroEnt = movOp.get("flagCustoZeroEnt");
	json.flagDescTpListaLinha = movOp.get("flagDescTpListaLinha");
	json.flagDescTpListaNcm = movOp.get("flagDescTpListaNcm");
	json.flagEntradaOperadorLog = movOp.get("flagEntradaOperadorLog");
	json.flagGeraDare = movOp.get("flagGeraDare");
	json.flagGerarIcmsRetido = movOp.get("flagGerarIcmsRetido");
	json.flagGerarIcmsRetidoParaRessarcimento = movOp.get("flagGerarIcmsRetidoParaRessarcimento");
	json.flagIcmsRetidoComoOutrasDepesas = movOp.get("flagIcmsRetidoComoOutrasDepesas");
	json.flagMotivo = movOp.get("flagMotivo");
	json.flagMovImportacao = movOp.get("flagMovImportacao");
	json.flagMovOpNfeCpl = movOp.get("flagMovOpNfeCpl");
	json.flagNAparecerManutencao = movOp.get("flagNAparecerManutencao");
	json.flagNaoAnalisarCustoNaEntrada = movOp.get("flagNaoAnalisarCustoNaEntrada");
	json.flagNaoCreditaImposto = movOp.get("flagNaoCreditaImposto");
	json.flagNaoCreditoImpostoDifal = movOp.get("flagNaoCreditoImpostoDifal");
	json.flagNaoCrossDocking = movOp.get("flagNaoCrossDocking");
	json.flagNaoExigePedidoCompras = movOp.get("flagNaoExigePedidoCompras");
	json.flagNaoGerarArqSped = movOp.get("flagNaoGerarArqSped");
	json.flagNaoRealizarProcAutomatico = movOp.get("flagNaoRealizarProcAutomatico");
	json.flagNaoTributarPisCofins = movOp.get("flagNaoTributarPisCofins");
	json.flagNaoValidaLoteProduto = movOp.get("flagNaoValidaLoteProduto");
	json.flagNaoValidaVenctoLote = movOp.get("flagNaoValidaVenctoLote");
	json.flagPisCofinsCompoemBaseIcms = movOp.get("flagPisCofinsCompoemBaseIcms");
	json.flagRealizaDifAliquota = movOp.get("flagRealizaDifAliquota");
	json.flagRespeitarTribCadXml = movOp.get("flagRespeitarTribCadXml");
	json.flagRetornoOperadorLog = movOp.get("flagRetornoOperadorLog");
	json.geraComi = movOp.get("geraComi");
	json.geraContrExpFut = movOp.get("geraContrExpFut");
	json.geraDp = movOp.get("geraDp");
	json.geraDpPg = movOp.get("geraDpPg");
	json.geraIcmsSubs = movOp.get("geraIcmsSubs");
	json.grlFinan = movOp.get("grlFinan");
	json.permitAltPreco = movOp.get("permitAltPreco");
	json.permiteAltBaseCalc = movOp.get("permiteAltBaseCalc");
	json.possuiProd = movOp.get("possuiProd");
	json.ratDesp = movOp.get("ratDesp");
	json.stsMov = movOp.get("stsMov");
	json.tpEstq = movOp.get("tpEstq");
	json.tpMov = movOp.get("tpMov");
	json.tpMovOpTransa = movOp.get("tpMovOpTransa");
	json.tpPreco = movOp.get("tpPreco");
	json.tpTransa = movOp.get("tpTransa");
	
	return json;
}