/*
 Funções de validação de dados de Nota Fiscal de Entrada
 Data de Criação: 25/10/2016
 */

load('/basicos/validaCpfCnpj.js');
load('/rules/filial/validaDados.js');
load('/rules/fornecedor/validaDados.js');
load('/rules/produto/validaDados.js');
load('/rules/empresa/buscaParametros.js');
load('/model/erro/admErroEstNfIntegracoes.js');

var NotaEntrada = function() {
   //this.mapper = mapperFactory.createMapperMult(["EstNfEnt","AdmErroEstNfIntegracoes","GlbMovOp","EstNfSerie"]);
};

NotaEntrada.prototype.validaDadosNotaEntrada = function(json){

    var mapper = mapperFactory.createMapperMult(["EstNfEnt","AdmErroEstNfIntegracoes","GlbMovOp","EstNfSerie"]);
    try{
        if(json === null){
            return {error : true, code: 599, message: "Dados passados ao servidor inválido!"};
        }else{
			
			///setando valores default
		
			json = this.defaultData(json);
			

            //Valida se a nota já deu entrada no sistema e se ja foi importada anteriormente
            var jaImportada = this.isNotaImportadaForJson(mapper, json);
            if (jaImportada){
                return {error : true, code: 599, message: "Nota " + jaImportada.get("nrNf") + " Com entrada ja realizada na data " + jaImportada.get("dtEnt")};
            }else{
                //######### Valida Dados da Filial #########
                var validaFilial = new ValidaFilial();
                var filial = validaFilial.validaDadosFilialByJSON(json);
                
                if(filial.error){
                    return filial;
                }else{
                    if (json.dtEnt < filial.get("dtIniSistema")) {
                        return {error : true, code: 599, message: "Filial "+ json.cdFilial + ' - ' + filial.get("rzFilial") + ' com data de inicio de sistema posterior a data de entrada da nota fiscal. Data de inicio do sistema: '
                            + filial.get("dtIniSistema") + ' Data de entrada da nota fiscal :' + json.dtEnt
                        };
                    }else{

                        //######### Valida Dados da Natureza de Movimentaçâo #########
                        if (!json.cdNtMov || json.cdNtMov === null || json.cdNtMov === undefined){
                            return {error : true, code: 599, message: 'Natureza de movimentacao nao informada'};
                        }else{
                            var movOp = mapper.selectOne("GlbMovOp.listarGlbMovOp", {cdMovOp  : json.cdNtMov});

                            if (!movOp){
                                return {error : true, code: 599, message: 'Natureza de movimentacao '+ json.cdNtMov + ' nao cadastrada.'};
                            }else{
                                json.movOp = this.javaToJavaScript(movOp);
								
                                if (json.cdNfSerie === null || json.cdNfSerie === undefined){
                                    return {error : true, code: 599, message: 'Serie de Nota Fiscal nao informado'};
                                }else{
                                    
                                    variaveis = {};
                                    if(parseInt(json.flagNotaIntegracao) > 0 ){
                                        variaveis.serie     = String(parseInt(json.cdNfSerie));
                                        variaveis.espc      = 'NFE';
                                        variaveis.codModelo = '55';
                                    }else{
                                        variaveis.cdNfSerie = json.cdNfSerie;
                                    }

                                    var serieNfe = mapper.selectList("EstNfSerie.listarEstNfSerie",variaveis);
                                    if (serieNfe.size() === 0 ){
                                        return {error : true, code: 599, message: 'Serie de nota fiscal eletronica (modelo 55) '+ json.cdNfSerie + ' nao cadastrada.'};
                                    }else {
										// pega a primeira serie do Retorno, pois pode haver mais de uma serie cadastrada com a mesma numeração
										json.cdNfSerie = serieNfe.get(0).get("cdNfSerie");     
                                        return json;
                                    }
                                }
                            }
                        }
                    }
                }
            }        
        }
        
    }finally{
        mapper.close();
    }
};

NotaEntrada.prototype.isNotaImportadaForJson = function(mapper, json){
    if(json === null){
        return {error : true, code: 599, message: "Dados passados ao servidor inválido!"};
    }
    
	var variaveis  = {};
    variaveis.cdEmp     = json.cdEmp;
    variaveis.cdFilial  = json.cdFilial;
    variaveis.cdForn    = json.cdForn;
    variaveis.nrNf      = json.nrNf;
    variaveis.dtEmiNf   = json.dtEmiNf;
	
    return mapper.selectOne("EstNfEnt.listarEstNfEnt", variaveis);
}


NotaEntrada.prototype.validaRemetenteDestinatarioTransport = function(json){
    if(!json.get("cnpjDestinatario"))
    {
        throw {code: 900, message: "CPF/CNPJ do destinatário nao informado"};
    }else{
        if(validarCNPJ(json.get("cnpjDestinatario")) === false )
        {
            throw {code: 900, message: "CPF/CNPJ do destinatário inválido"};
        }
    }
    if(!json.get("cnpjEmitente"))
    {
        throw {code: 900, message: "CPF/CNPJ do emitente nao informado"};
    }else{
        if( validarCNPJ(json.get("cnpjEmitente")) === false )
        {
            throw {code: 900, message: "CPF/CNPJ do emitente inválido"};
        }
    }
    if(!json.get("cgcCpfTransp"))
    {
        throw {code: 900, message: "CPF/CNPJ da transportadora nao informado"};
    }else{
        if( validarCNPJ(json.get("cgcCpfTransp")) === false )
        {
            throw {code: 900, message: "CPF/CNPJ da transportadora inválido"};
        }
    }

};


NotaEntrada.prototype.validaItens = function(json){
    var itens       = json.itens;

    var variaveis   = {};
    var prod        = [];
    var filial      = [];
    for (var iItem = 0; iItem < itens.length; iItem++){
        prod[iItem]     = itens[iItem].cdProd;
    }
    filial[0]   = json.cdFilial;
    variaveis.cdProd    = prod;
    variaveis.cdFilial  = filial;

    var validaProduto =  new ValidaProduto();
    var validaProdutoResult = validaProduto.validaStatusProdutosByJson(variaveis);
	if(validaProdutoResult.error){
		return validaProdutoResult;
	}else{
		return this.validaValoresItens(json);
	}
	
    
};

NotaEntrada.prototype.validaValoresItens = function(json){
    itens       = json.itens;
    i           = 0;
    vlrItem     = {};
    diferenca   = {};

    //INICIA AS VARIAVEIS
    vlrItem.vlrTotIt             = 0 ;
    vlrItem.vlrDesc              = 0 ;
    vlrItem.vlrBaseIcms          = 0 ;
    vlrItem.vlrIcmsSubs          = 0 ;
    vlrItem.vlrBaseSubs          = 0 ;
    vlrItem.vlrIcmsDesonerado    = 0 ;
    vlrItem.vlrFreteIt           = 0 ;
    vlrItem.vlrIpi               = 0 ;
    vlrItem.vlrOutrasDespesas    = 0 ;
    diferenca.vlrTotProd         = 0 ;
    diferenca.vlrDesc            = 0 ;
    diferenca.vlrBaseIcms        = 0 ;
    diferenca.vlrIcmsSubs        = 0 ;
    diferenca.vlrBaseIcmsSubs    = 0 ;
    diferenca.vlrIcmsDesonerado  = 0 ;
    diferenca.vlrFrete           = 0 ;
    diferenca.vlrIpi             = 0 ;
    diferenca.vlrOutrasDespesas  = 0 ;
    diferenca.vlrNf              = 0 ;

    for (i = 0; i < itens.size(); i++)
    {
        var item = itens[i];

        vlrItem.vlrTotIt            += item.vlrIt   * item.qtIt;
        vlrItem.vlrDesc             += item.vlrDesc * item.qtIt;
        vlrItem.vlrBaseIcms         += item.vlrBaseIcms;
        vlrItem.vlrIcmsSubs         += item.vlrIcmsSubs;
        vlrItem.vlrBaseSubs         += item.vlrBaseSubs;
        vlrItem.vlrIcmsDesonerado   += item.vlrIcmsDesonerado;
        vlrItem.vlrFreteIt          += item.vlrFreteIt;
        vlrItem.vlrIpi              += item.vlrIpi;
        vlrItem.vlrOutrasDespesas   += item.vlrOutrasDespesas;
    }

    diferenca.vlrTotProd        = json.vlrTotProd         - (vlrItem.vlrTotIt);
    diferenca.vlrDesc           = json.vlrDesc            - vlrItem.vlrDesc;
    diferenca.vlrBaseIcms       = json.vlrBaseIcms        - vlrItem.vlrBaseIcms;
    diferenca.vlrIcmsSubs       = json.vlrIcmsSubs        - vlrItem.vlrIcmsSubs;
    diferenca.vlrBaseIcmsSubs   = json.vlrBaseIcmsSubs    - vlrItem.vlrBaseSubs;
    diferenca.vlrIcmsDesonerado = json.vlrIcmsDesonerado  - vlrItem.vlrIcmsDesonerado;
    diferenca.vlrFrete          = json.vlrFrete           - vlrItem.vlrFreteIt;
    diferenca.vlrIpi            = json.vlrIpi             - vlrItem.vlrIpi;
    diferenca.vlrOutrasDespesas = json.vlrOutrasDespesas  - vlrItem.vlrOutrasDespesas;
    var totalItens              = ( vlrItem.vlrOutrasDespesas + vlrItem.vlrFreteIt + vlrItem.vlrIcmsSubs + vlrItem.vlrIpi + vlrItem.vlrTotIt - vlrItem.vlrDesc);
    diferenca.vlrNf             = json.vlrNf - totalItens;

    if (diferenca.vlrTotProd > 0.02 ){
        return {error : true, code: 599, message: "Valor total dos Produtos divergente do valor total do(s) item(ns); "
        +" Valor total produto nota ...: " + json.vlrTotProd
        +" Valor total produto itens ..: " + vlrItem.vlrTotIt.toFixed(2)
        +" Diferença ..................: " + diferenca.vlrTotProd.toFixed(2) };
    }
    if (diferenca.vlrBaseIcms > 0.02 ){
        return {error : true, code: 599, message: "Valor total de Base ICMS divergente do valor total de Base ICMS do(s) item(ns); "
        +" Valor total Base ICMS nota ...:  " + json.vlrBaseIcms
        +" Valor total Base ICMS itens ..:  " + vlrItem.vlrBaseIcms
        +" Diferença ....................:  " + diferenca.vlrBaseIcms.toFixed(2) };
    }
    if (diferenca.vlrIcmsSubs > 0.02  ){
        return {error : true, code: 599, message: "Valor total de ICMS Subst. divergente do valor total de ICMS Subst. do(s) item(ns); "
        +" Valor total Base ICMS Subst nota ...:  " + json.vlrIcmsSubs
        +" Valor total Base ICMS Subst itens ..:  " + vlrItem.vlrIcmsSubs
        +" Diferença ..........................:  " + diferenca.vlrIcmsSubs.toFixed(2) };
    }
    if (diferenca.vlrBaseIcmsSubs > 0.02  ){
        return {error : true, code: 599, message: "Valor total de Base ICMS Subst. divergente do valor total de Base ICMS Subst. do(s) item(ns); "
        +" Valor total Base ICMS Subst nota ...:  " + json.vlrBaseIcmsSubs
        +" Valor total Base ICMS Subst itens ..:  " + vlrItem.vlrBaseSubs
        +" Diferença ..........................:  " + diferenca.vlrBaseIcmsSubs.toFixed(2)};
    }
    if (diferenca.vlrIcmsDesonerado > 0.02  ){
        return {error : true, code: 599, message: "Valor total de Base ICMS divergente do valor total de Base ICMS do(s) item(ns); "
        +" Valor total Base ICMS nota ...:  " + json.vlrIcmsDesonerado
        +" Valor total Base ICMS itens ..:  " + vlrItem.vlrIcmsDesonerado
        +" Diferença ....................:  " + diferenca.vlrIcmsDesonerado.toFixed(2)};
    }
    if (diferenca.vlrFrete > 0.02  ){
        return {error : true, code: 599, message: "Valor total de Frete divergente do valor total de Frete do(s) item(ns); "
        +" Valor total Frete nota ...:  " + json.vlrFrete
        +" Valor total Frete itens ..:  " + vlrItem.vlrFreteIt
        +" Diferença ................:  " + diferenca.vlrFrete.toFixed(2) };
    }
    if (diferenca.vlrIpi > 0.02  ){
        return {error : true, code: 599, message: "Valor total de IPI divergente do valor total de IPI do(s) item(ns); "
        +" Valor total IPI nota .....:   " + json.vlrIpi
        +" Valor total IPI itens ....:   " + vlrItem.vlrIpi
        +" Diferença ................:  "  + diferenca.vlrIpi.toFixed(2) };
    }
    if (diferenca.vlrOutrasDespesas > 0.02  ){
        return {error : true, code: 599, message: "Valor total de Outras despesasas divergente do valor total de Outras despesasas do(s) item(ns); "
        +" Valor total Outras despesasas nota ...:  " + json.vlrOutrasDespesas
        +" Valor total Outras despesasas itens ..:  " + vlrItem.vlrOutrasDespesas
        +" Diferença ............................: "  + diferenca.vlrOutrasDespesas.toFixed(2) };
    }
    if (diferenca.vlrNf > 0.02  ){
        return {error : true, code: 599, message: "Valor total da Nota divergente do somatório do(s) Produto(s); "
        +" Valor total Nota ...: " + json.vlrNf
        +" Valor total Itens ..: " + totalItens
        +" Diferença ..........: " + diferenca.vlrNf.toFixed(2)};
    }

	return {error : false};
	
};


NotaEntrada.prototype.defaultData = function(json){
	//if(!json.dtEnt || json.dtEnt === null || json.dtEnt === undefined){json.dtEnt = new Date();}
	//if(!json.dtCad || json.dtCad === null || json.dtCad === undefined){json.dtCad = "";}
	//if(!json.dtEmiNf || json.dtEmiNf === null || json.dtEmiNf === undefined){json.dtEmiNf = "";}
	//if(!json.dtEnt || json.dtEnt === null || json.dtEnt === undefined){json.dtEnt = "";}
	
	if(!json.aliqIcms || json.aliqIcms === null || json.aliqIcms === undefined){json.aliqIcms = 0;}
	if(!json.aplicativo || json.aplicativo === null || json.aplicativo === undefined){json.aplicativo = "";}
	if(!json.bairroDestinatario || json.bairroDestinatario === null || json.bairroDestinatario === undefined){json.bairroDestinatario = "";}
	if(!json.bairroEmitente || json.bairroEmitente === null || json.bairroEmitente === undefined){json.bairroEmitente = "";}
	if(!json.bairroTransp || json.bairroTransp === null || json.bairroTransp === undefined){json.bairroTransp = "";}
	if(!json.calcSubsPmc || json.calcSubsPmc === null || json.calcSubsPmc === undefined){json.calcSubsPmc = 0;}
	if(!json.cdAntt || json.cdAntt === null || json.cdAntt === undefined){json.cdAntt = 0;}
	if(!json.cdCidDestinatario || json.cdCidDestinatario === null || json.cdCidDestinatario === undefined){json.cdCidDestinatario = 0;}
	if(!json.cdCidEmitente || json.cdCidEmitente === null || json.cdCidEmitente === undefined){json.cdCidEmitente = 0;}
	if(!json.cdCidTransp || json.cdCidTransp === null || json.cdCidTransp === undefined){json.cdCidTransp = 0;}
	if(!json.cdEmp || json.cdEmp === null || json.cdEmp === undefined){json.cdEmp = 0;}
	if(!json.cdFilial || json.cdFilial === null || json.cdFilial === undefined){json.cdFilial = 0;}
	if(!json.cdForn || json.cdForn === null || json.cdForn === undefined){json.cdForn = 0;}
	if(!json.cdMtCancel || json.cdMtCancel === null || json.cdMtCancel === undefined){json.cdMtCancel = 0;}
	if(!json.cdMtDevVd || json.cdMtDevVd === null || json.cdMtDevVd === undefined){json.cdMtDevVd = 0;}
	if(!json.cdNf || json.cdNf === null || json.cdNf === undefined){json.cdNf = 0;}
	if(!json.cdNfProd || json.cdNfProd === null || json.cdNfProd === undefined){json.cdNfProd = 0;}
	if(!json.cdNfSaida || json.cdNfSaida === null || json.cdNfSaida === undefined){json.cdNfSaida = 0;}
	if(!json.cdNfSerie || json.cdNfSerie === null || json.cdNfSerie === undefined){json.cdNfSerie = 0;}
	if(!json.cdNtMov || json.cdNtMov === null || json.cdNtMov === undefined){json.cdNtMov = 0;}
	if(!json.cdNtOp || json.cdNtOp === null || json.cdNtOp === undefined){json.cdNtOp = 0;}
	if(!json.cdPed || json.cdPed === null || json.cdPed === undefined){json.cdPed = 0;}
	if(!json.cdUsu || json.cdUsu === null || json.cdUsu === undefined){json.cdUsu = 0;}
	if(!json.cdUsuLiberouCustoVariacao || json.cdUsuLiberouCustoVariacao === null || json.cdUsuLiberouCustoVariacao === undefined){json.cdUsuLiberouCustoVariacao = 0;}
	if(!json.cdUsuLiberouDesacordo || json.cdUsuLiberouDesacordo === null || json.cdUsuLiberouDesacordo === undefined){json.cdUsuLiberouDesacordo = 0;}
	if(!json.cdVal || json.cdVal === null || json.cdVal === undefined){json.cdVal = 0;}
	if(!json.cepDestinatario || json.cepDestinatario === null || json.cepDestinatario === undefined){json.cepDestinatario = "";}
	if(!json.cepEmitente || json.cepEmitente === null || json.cepEmitente === undefined){json.cepEmitente = "";}
	if(!json.cgcCpfTransp || json.cgcCpfTransp === null || json.cgcCpfTransp === undefined){json.cgcCpfTransp = "";}
	if(!json.cidadeDestinatario || json.cidadeDestinatario === null || json.cidadeDestinatario === undefined){json.cidadeDestinatario = "";}
	if(!json.cidadeEmitente || json.cidadeEmitente === null || json.cidadeEmitente === undefined){json.cidadeEmitente = "";}
	if(!json.cidadeTransp || json.cidadeTransp === null || json.cidadeTransp === undefined){json.cidadeTransp = "";}
	if(!json.cnpjDestinatario || json.cnpjDestinatario === null || json.cnpjDestinatario === undefined){json.cnpjDestinatario = "";}
	if(!json.cnpjEmitente || json.cnpjEmitente === null || json.cnpjEmitente === undefined){json.cnpjEmitente = "";}
	if(!json.cnpjTransp || json.cnpjTransp === null || json.cnpjTransp === undefined){json.cnpjTransp = "";}
	if(!json.cob || json.cob === null || json.cob === undefined){json.cob = 0;}
	if(!json.crt || json.crt === null || json.crt === undefined){json.crt = 3;}
	if(!json.dev || json.dev === null || json.dev === undefined){json.dev = 0;}
	if(!json.dsCidTransp || json.dsCidTransp === null || json.dsCidTransp === undefined){json.dsCidTransp = "";}
	if(!json.dsTransp || json.dsTransp === null || json.dsTransp === undefined){json.dsTransp = "";}
	if(!json.dtEntradaEst || json.dtEntradaEst === null || json.dtEntradaEst === undefined){json.dtEntradaEst = "";}
	if(!json.dtUltAlt || json.dtUltAlt === null || json.dtUltAlt === undefined){json.dtUltAlt = "";}
	if(!json.emailTransp || json.emailTransp === null || json.emailTransp === undefined){json.emailTransp = "";}
	if(!json.encgTrib || json.encgTrib === null || json.encgTrib === undefined){json.encgTrib = 0;}
	if(!json.endDestinatario || json.endDestinatario === null || json.endDestinatario === undefined){json.endDestinatario = "";}
	if(!json.endEmitente || json.endEmitente === null || json.endEmitente === undefined){json.endEmitente = "";}
	if(!json.endTransp || json.endTransp === null || json.endTransp === undefined){json.endTransp = "";}
	if(!json.endeTransp || json.endeTransp === null || json.endeTransp === undefined){json.endeTransp = "";}
	if(!json.espcieVol || json.espcieVol === null || json.espcieVol === undefined){json.espcieVol = "";}
	if(!json.especie || json.especie === null || json.especie === undefined){json.especie = "";}
	if(!json.flagDesacordo || json.flagDesacordo === null || json.flagDesacordo === undefined){json.flagDesacordo = 0;}
	if(!json.flagNGerarDar || json.flagNGerarDar === null || json.flagNGerarDar === undefined){json.flagNGerarDar = 0;}
	if(!json.flagNfProdTotalBruto || json.flagNfProdTotalBruto === null || json.flagNfProdTotalBruto === undefined){json.flagNfProdTotalBruto = 0;}
	if(!json.flagNotaIntegracao || json.flagNotaIntegracao === null || json.flagNotaIntegracao === undefined){json.flagNotaIntegracao = 0;}
	if(!json.flagRateioDif || json.flagRateioDif === null || json.flagRateioDif === undefined){json.flagRateioDif = 0;}
	if(!json.freteIncideBaseIcms || json.freteIncideBaseIcms === null || json.freteIncideBaseIcms === undefined){json.freteIncideBaseIcms = 0;}
	if(!json.hist || json.hist === null || json.hist === undefined){json.hist = "";}
	if(!json.hist2 || json.hist2 === null || json.hist2 === undefined){json.hist2 = "";}
	if(!json.hrEnt || json.hrEnt === null || json.hrEnt === undefined){json.hrEnt = "";}
	if(!json.ignorarGeracaoFinan || json.ignorarGeracaoFinan === null || json.ignorarGeracaoFinan === undefined){json.ignorarGeracaoFinan = 0;}
	if(!json.impNf || json.impNf === null || json.impNf === undefined){json.impNf = 0;}
	if(!json.infDesconto || json.infDesconto === null || json.infDesconto === undefined){json.infDesconto = "";}
	if(!json.inscEstTransp || json.inscEstTransp === null || json.inscEstTransp === undefined){json.inscEstTransp = "";}
	if(!json.inscEstadualDestinatario || json.inscEstadualDestinatario === null || json.inscEstadualDestinatario === undefined){json.inscEstadualDestinatario = "";}
	if(!json.inscEstadualEmitente || json.inscEstadualEmitente === null || json.inscEstadualEmitente === undefined){json.inscEstadualEmitente = "";}
	if(!json.inscEstadualTransp || json.inscEstadualTransp === null || json.inscEstadualTransp === undefined){json.inscEstadualTransp = "";}
	if(!json.marca || json.marca === null || json.marca === undefined){json.marca = "";}
	if(!json.mcVol || json.mcVol === null || json.mcVol === undefined){json.mcVol = "";}
	if(!json.nfIpiBaseCalc || json.nfIpiBaseCalc === null || json.nfIpiBaseCalc === undefined){json.nfIpiBaseCalc = 0;}
	if(!json.nfeRejeitada || json.nfeRejeitada === null || json.nfeRejeitada === undefined){json.nfeRejeitada = 0;}
	if(!json.nrConhTransp || json.nrConhTransp === null || json.nrConhTransp === undefined){json.nrConhTransp = 0;}
	if(!json.nrFormulario || json.nrFormulario === null || json.nrFormulario === undefined){json.nrFormulario = 0;}
	if(!json.nrNf || json.nrNf === null || json.nrNf === undefined){json.nrNf = 0;}
	if(!json.nrPedForn || json.nrPedForn === null || json.nrPedForn === undefined){json.nrPedForn = "";}
	if(!json.nrSeloSaida || json.nrSeloSaida === null || json.nrSeloSaida === undefined){json.nrSeloSaida = 0;}
	if(!json.nrVol || json.nrVol === null || json.nrVol === undefined){json.nrVol = 0;}
	if(!json.numeracao || json.numeracao === null || json.numeracao === undefined){json.numeracao = 0;}
	if(!json.obs4 || json.obs4 === null || json.obs4 === undefined){json.obs4 = "";}
	if(!json.obs5 || json.obs5 === null || json.obs5 === undefined){json.obs5 = "";}
	if(!json.origLanc || json.origLanc === null || json.origLanc === undefined){json.origLanc = 0;}
	if(!json.percIcmsEncgFin || json.percIcmsEncgFin === null || json.percIcmsEncgFin === undefined){json.percIcmsEncgFin = 0;}
	if(!json.percIpiFrete || json.percIpiFrete === null || json.percIpiFrete === undefined){json.percIpiFrete = 0;}
	if(!json.percReduSubsPmc || json.percReduSubsPmc === null || json.percReduSubsPmc === undefined){json.percReduSubsPmc = 0;}
	if(!json.pesoBrt || json.pesoBrt === null || json.pesoBrt === undefined){json.pesoBrt = 0;}
	if(!json.pesoBruto || json.pesoBruto === null || json.pesoBruto === undefined){json.pesoBruto = 0;}
	if(!json.pesoLiq || json.pesoLiq === null || json.pesoLiq === undefined){json.pesoLiq = 0;}
	if(!json.pgtoVistaPrazo || json.pgtoVistaPrazo === null || json.pgtoVistaPrazo === undefined){json.pgtoVistaPrazo = 0;}
	if(!json.placaUf || json.placaUf === null || json.placaUf === undefined){json.placaUf = "";}
	if(!json.placaVeic || json.placaVeic === null || json.placaVeic === undefined){json.placaVeic = "";}
	if(!json.qtVol || json.qtVol === null || json.qtVol === undefined){json.qtVol = 0;}
	if(!json.qtdeVolume || json.qtdeVolume === null || json.qtdeVolume === undefined){json.qtdeVolume = 0;}
	if(!json.rzDestinatario || json.rzDestinatario === null || json.rzDestinatario === undefined){json.rzDestinatario = "";}
	if(!json.rzEmitente || json.rzEmitente === null || json.rzEmitente === undefined){json.rzEmitente = "";}
	if(!json.rzTransportador || json.rzTransportador === null || json.rzTransportador === undefined){json.rzTransportador = "";}
	if(!json.stsNf || json.stsNf === null || json.stsNf === undefined){json.stsNf = 0;}
	if(!json.tpDevNf || json.tpDevNf === null || json.tpDevNf === undefined){json.tpDevNf = 0;}
	if(!json.tpFrete || json.tpFrete === null || json.tpFrete === undefined){json.tpFrete = 0;}
	if(!json.tpLanc || json.tpLanc === null || json.tpLanc === undefined){json.tpLanc = 0;}
	if(!json.tpNf || json.tpNf === null || json.tpNf === undefined){json.tpNf = 0;}
	if(!json.tpSubsTrib || json.tpSubsTrib === null || json.tpSubsTrib === undefined){json.tpSubsTrib = 0;}
	if(!json.ufDestinatario || json.ufDestinatario === null || json.ufDestinatario === undefined){json.ufDestinatario = "";}
	if(!json.ufEmitente || json.ufEmitente === null || json.ufEmitente === undefined){json.ufEmitente = "";}
	if(!json.ufTransp || json.ufTransp === null || json.ufTransp === undefined){json.ufTransp = "";}
	if(!json.ufVeic || json.ufVeic === null || json.ufVeic === undefined){json.ufVeic = "";}
	if(!json.versaoAplicativo || json.versaoAplicativo === null || json.versaoAplicativo === undefined){json.versaoAplicativo = "";}
	if(!json.vlrBaseIcms || json.vlrBaseIcms === null || json.vlrBaseIcms === undefined){json.vlrBaseIcms = 0;}
	if(!json.vlrBaseIcmsSubs || json.vlrBaseIcmsSubs === null || json.vlrBaseIcmsSubs === undefined){json.vlrBaseIcmsSubs = 0;}
	if(!json.vlrDesc || json.vlrDesc === null || json.vlrDesc === undefined){json.vlrDesc = 0;}
	if(!json.vlrDescCab || json.vlrDescCab === null || json.vlrDescCab === undefined){json.vlrDescCab = 0;}
	if(!json.vlrEncgFin || json.vlrEncgFin === null || json.vlrEncgFin === undefined){json.vlrEncgFin = 0;}
	if(!json.vlrEstorno || json.vlrEstorno === null || json.vlrEstorno === undefined){json.vlrEstorno = 0;}
	if(!json.vlrFrete || json.vlrFrete === null || json.vlrFrete === undefined){json.vlrFrete = 0;}
	if(!json.vlrIcms || json.vlrIcms === null || json.vlrIcms === undefined){json.vlrIcms = 0;}
	if(!json.vlrIcmsDesonerado || json.vlrIcmsDesonerado === null || json.vlrIcmsDesonerado === undefined){json.vlrIcmsDesonerado = 0;}
	if(!json.vlrIcmsSubs || json.vlrIcmsSubs === null || json.vlrIcmsSubs === undefined){json.vlrIcmsSubs = 0;}
	if(!json.vlrIpi || json.vlrIpi === null || json.vlrIpi === undefined){json.vlrIpi = 0;}
	if(!json.vlrNf || json.vlrNf === null || json.vlrNf === undefined){json.vlrNf = 0;}
	if(!json.vlrOutros || json.vlrOutros === null || json.vlrOutros === undefined){json.vlrOutros = 0;}
	if(!json.vlrPercIpiFrete || json.vlrPercIpiFrete === null || json.vlrPercIpiFrete === undefined){json.vlrPercIpiFrete = 0;}
	if(!json.vlrProdIcmsSubs || json.vlrProdIcmsSubs === null || json.vlrProdIcmsSubs === undefined){json.vlrProdIcmsSubs = 0;}
	if(!json.vlrTotProd || json.vlrTotProd === null || json.vlrTotProd === undefined){json.vlrTotProd = 0;}
	if(!json.vrlIsentas || json.vrlIsentas === null || json.vrlIsentas === undefined){json.vrlIsentas = 0;}
	
	for(var dfx= 0; dfx < json.itens.length; dfx++){
		json.itens[dfx] = this.itemDefaultData(json.itens[dfx]);
	}
	
	return json;
}

NotaEntrada.prototype.itemDefaultData = function(json){
	
	if(!json.aliqIcms || json.aliqIcms === null || json.aliqIcms === undefined){json.aliqIcms = 0;}
	if(!json.aliqIcmsInterno || json.aliqIcmsInterno === null || json.aliqIcmsInterno === undefined){json.aliqIcmsInterno = 0;}
	if(!json.cdCtrCotVigente || json.cdCtrCotVigente === null || json.cdCtrCotVigente === undefined){json.cdCtrCotVigente = 0;}
	if(!json.cdEmp || json.cdEmp === null || json.cdEmp === undefined){json.cdEmp = 0;}
	if(!json.cdFilial || json.cdFilial === null || json.cdFilial === undefined){json.cdFilial = 0;}
	if(!json.cdNf || json.cdNf === null || json.cdNf === undefined){json.cdNf = 0;}
	if(!json.cdNtOp || json.cdNtOp === null || json.cdNtOp === undefined){json.cdNtOp = 0;}
	if(!json.cdProd || json.cdProd === null || json.cdProd === undefined){json.cdProd = 0;}
	if(!json.cdSigla || json.cdSigla === null || json.cdSigla === undefined){json.cdSigla = 0;}
	if(!json.cdSitOperaSimplesNacio || json.cdSitOperaSimplesNacio === null || json.cdSitOperaSimplesNacio === undefined){json.cdSitOperaSimplesNacio = 0;}
	if(!json.cdTrib || json.cdTrib === null || json.cdTrib === undefined){json.cdTrib = 0;}
	if(!json.cdUsuLiberouValidadeLote || json.cdUsuLiberouValidadeLote === null || json.cdUsuLiberouValidadeLote === undefined){json.cdUsuLiberouValidadeLote = 0;}
	if(!json.cstCofins || json.cstCofins === null || json.cstCofins === undefined){json.cstCofins = 0;}
	if(!json.cstPis || json.cstPis === null || json.cstPis === undefined){json.cstPis = 0;}
	if(!json.dsProd || json.dsProd === null || json.dsProd === undefined){json.dsProd = "";}
	if(!json.fecopRecalculado || json.fecopRecalculado === null || json.fecopRecalculado === undefined){json.fecopRecalculado = 0;}
	if(!json.flagCfopAlteradoManual || json.flagCfopAlteradoManual === null || json.flagCfopAlteradoManual === undefined){json.flagCfopAlteradoManual = 0;}
	if(!json.flagExcecaoPisCofins || json.flagExcecaoPisCofins === null || json.flagExcecaoPisCofins === undefined){json.flagExcecaoPisCofins = 0;}
	if(!json.flagIcmsRetidoCalculado || json.flagIcmsRetidoCalculado === null || json.flagIcmsRetidoCalculado === undefined){json.flagIcmsRetidoCalculado = 0;}
	if(!json.flagNGerarDar || json.flagNGerarDar === null || json.flagNGerarDar === undefined){json.flagNGerarDar = 0;}
	if(!json.flagProdCestaBasica || json.flagProdCestaBasica === null || json.flagProdCestaBasica === undefined){json.flagProdCestaBasica = 0;}
	if(!json.gerarDifal || json.gerarDifal === null || json.gerarDifal === undefined){json.gerarDifal = 0;}
	if(!json.icmsDesoneradoMotivo || json.icmsDesoneradoMotivo === null || json.icmsDesoneradoMotivo === undefined){json.icmsDesoneradoMotivo = 0;}
	if(!json.indTotal || json.indTotal === null || json.indTotal === undefined){json.indTotal = 1;}
	if(!json.listaProd || json.listaProd === null || json.listaProd === undefined){json.listaProd = 0;}
	if(!json.modaliBaseIcms || json.modaliBaseIcms === null || json.modaliBaseIcms === undefined){json.modaliBaseIcms = 0;}
	if(!json.modaliBaseIcmsSubst || json.modaliBaseIcmsSubst === null || json.modaliBaseIcmsSubst === undefined){json.modaliBaseIcmsSubst = 0;}
	if(!json.nItemPed || json.nItemPed === null || json.nItemPed === undefined){json.nItemPed = 0;}
	if(!json.percAliqCofins || json.percAliqCofins === null || json.percAliqCofins === undefined){json.percAliqCofins = 0;}
	if(!json.percAliqPis || json.percAliqPis === null || json.percAliqPis === undefined){json.percAliqPis = 0;}
	if(!json.percDesc || json.percDesc === null || json.percDesc === undefined){json.percDesc = 0;}
	if(!json.percDescComercial || json.percDescComercial === null || json.percDescComercial === undefined){json.percDescComercial = 0;}
	if(!json.percDescFinan || json.percDescFinan === null || json.percDescFinan === undefined){json.percDescFinan = 0;}
	if(!json.percDiferimento || json.percDiferimento === null || json.percDiferimento === undefined){json.percDiferimento = 0;}
	if(!json.percFecop || json.percFecop === null || json.percFecop === undefined){json.percFecop = 0;}
	if(!json.percIcmsDestinoDifal || json.percIcmsDestinoDifal === null || json.percIcmsDestinoDifal === undefined){json.percIcmsDestinoDifal = 0;}
	if(!json.percIcmsLucroReal || json.percIcmsLucroReal === null || json.percIcmsLucroReal === undefined){json.percIcmsLucroReal = 0;}
	if(!json.percIcmsOp || json.percIcmsOp === null || json.percIcmsOp === undefined){json.percIcmsOp = 0;}
	if(!json.percIcmsOrigemDifal || json.percIcmsOrigemDifal === null || json.percIcmsOrigemDifal === undefined){json.percIcmsOrigemDifal = 0;}
	if(!json.percIcmsRet || json.percIcmsRet === null || json.percIcmsRet === undefined){json.percIcmsRet = 0;}
	if(!json.percIcmsSimplesNacional || json.percIcmsSimplesNacional === null || json.percIcmsSimplesNacional === undefined){json.percIcmsSimplesNacional = 0;}
	if(!json.percIpi || json.percIpi === null || json.percIpi === undefined){json.percIpi = 0;}
	if(!json.percIva || json.percIva === null || json.percIva === undefined){json.percIva = 0;}
	if(!json.percIvaRet || json.percIvaRet === null || json.percIvaRet === undefined){json.percIvaRet = 0;}
	if(!json.percReduBaseIcms || json.percReduBaseIcms === null || json.percReduBaseIcms === undefined){json.percReduBaseIcms = 0;}
	if(!json.percReduBaseSubs || json.percReduBaseSubs === null || json.percReduBaseSubs === undefined){json.percReduBaseSubs = 0;}
	if(!json.pisCofins || json.pisCofins === null || json.pisCofins === undefined){json.pisCofins = 0;}
	if(!json.pisCofinsRecalculado || json.pisCofinsRecalculado === null || json.pisCofinsRecalculado === undefined){json.pisCofinsRecalculado = 0;}
	if(!json.przDescFin || json.przDescFin === null || json.przDescFin === undefined){json.przDescFin = 0;}
	if(!json.qtEmb || json.qtEmb === null || json.qtEmb === undefined){json.qtEmb = 0;}
	if(!json.qtEstAnt || json.qtEstAnt === null || json.qtEstAnt === undefined){json.qtEstAnt = 0;}
	if(!json.qtIt || json.qtIt === null || json.qtIt === undefined){json.qtIt = 0;}
	if(!json.seqItem || json.seqItem === null || json.seqItem === undefined){json.seqItem = 0;}
	if(!json.siglaExcecaoPisCofins || json.siglaExcecaoPisCofins === null || json.siglaExcecaoPisCofins === undefined){json.siglaExcecaoPisCofins = "";}
	if(!json.tipoTributacaoPisCofins || json.tipoTributacaoPisCofins === null || json.tipoTributacaoPisCofins === undefined){json.tipoTributacaoPisCofins = 0;}
	if(!json.tpProd || json.tpProd === null || json.tpProd === undefined){json.tpProd = 0;}
	if(!json.un || json.un === null || json.un === undefined){json.un = "";}
	if(!json.vlrBaseCofins || json.vlrBaseCofins === null || json.vlrBaseCofins === undefined){json.vlrBaseCofins = 0;}
	if(!json.vlrBaseIcms || json.vlrBaseIcms === null || json.vlrBaseIcms === undefined){json.vlrBaseIcms = 0;}
	if(!json.vlrBaseIcmsLucroReal || json.vlrBaseIcmsLucroReal === null || json.vlrBaseIcmsLucroReal === undefined){json.vlrBaseIcmsLucroReal = 0;}
	if(!json.vlrBaseIcmsOp || json.vlrBaseIcmsOp === null || json.vlrBaseIcmsOp === undefined){json.vlrBaseIcmsOp = 0;}
	if(!json.vlrBaseIcmsRet || json.vlrBaseIcmsRet === null || json.vlrBaseIcmsRet === undefined){json.vlrBaseIcmsRet = 0;}
	if(!json.vlrBaseIcmsSimplesNacional || json.vlrBaseIcmsSimplesNacional === null || json.vlrBaseIcmsSimplesNacional === undefined){json.vlrBaseIcmsSimplesNacional = 0;}
	if(!json.vlrBasePis || json.vlrBasePis === null || json.vlrBasePis === undefined){json.vlrBasePis = 0;}
	if(!json.vlrBaseSubs || json.vlrBaseSubs === null || json.vlrBaseSubs === undefined){json.vlrBaseSubs = 0;}
	if(!json.vlrCofins || json.vlrCofins === null || json.vlrCofins === undefined){json.vlrCofins = 0;}
	if(!json.vlrCredBaseSn || json.vlrCredBaseSn === null || json.vlrCredBaseSn === undefined){json.vlrCredBaseSn = 0;}
	if(!json.vlrCredIcmsSn || json.vlrCredIcmsSn === null || json.vlrCredIcmsSn === undefined){json.vlrCredIcmsSn = 0;}
	if(!json.vlrCustoAcerto || json.vlrCustoAcerto === null || json.vlrCustoAcerto === undefined){json.vlrCustoAcerto = 0;}
	if(!json.vlrCustoAntRecalc || json.vlrCustoAntRecalc === null || json.vlrCustoAntRecalc === undefined){json.vlrCustoAntRecalc = 0;}
	if(!json.vlrCustoGer || json.vlrCustoGer === null || json.vlrCustoGer === undefined){json.vlrCustoGer = 0;}
	if(!json.vlrCustoGerencialTransf || json.vlrCustoGerencialTransf === null || json.vlrCustoGerencialTransf === undefined){json.vlrCustoGerencialTransf = 0;}
	if(!json.vlrCustoMd || json.vlrCustoMd === null || json.vlrCustoMd === undefined){json.vlrCustoMd = 0;}
	if(!json.vlrCustoSemSt || json.vlrCustoSemSt === null || json.vlrCustoSemSt === undefined){json.vlrCustoSemSt = 0;}
	if(!json.vlrDesc || json.vlrDesc === null || json.vlrDesc === undefined){json.vlrDesc = 0;}
	if(!json.vlrDescFinan || json.vlrDescFinan === null || json.vlrDescFinan === undefined){json.vlrDescFinan = 0;}
	if(!json.vlrFreteIt || json.vlrFreteIt === null || json.vlrFreteIt === undefined){json.vlrFreteIt = 0;}
	if(!json.vlrIcmsDesonerado || json.vlrIcmsDesonerado === null || json.vlrIcmsDesonerado === undefined){json.vlrIcmsDesonerado = 0;}
	if(!json.vlrIcmsDiferimento || json.vlrIcmsDiferimento === null || json.vlrIcmsDiferimento === undefined){json.vlrIcmsDiferimento = 0;}
	if(!json.vlrIcmsIt || json.vlrIcmsIt === null || json.vlrIcmsIt === undefined){json.vlrIcmsIt = 0;}
	if(!json.vlrIcmsLucroReal || json.vlrIcmsLucroReal === null || json.vlrIcmsLucroReal === undefined){json.vlrIcmsLucroReal = 0;}
	if(!json.vlrIcmsOp || json.vlrIcmsOp === null || json.vlrIcmsOp === undefined){json.vlrIcmsOp = 0;}
	if(!json.vlrIcmsRet || json.vlrIcmsRet === null || json.vlrIcmsRet === undefined){json.vlrIcmsRet = 0;}
	if(!json.vlrIcmsSimplesNacional || json.vlrIcmsSimplesNacional === null || json.vlrIcmsSimplesNacional === undefined){json.vlrIcmsSimplesNacional = 0;}
	if(!json.vlrIcmsSubs || json.vlrIcmsSubs === null || json.vlrIcmsSubs === undefined){json.vlrIcmsSubs = 0;}
	if(!json.vlrImpostoRea || json.vlrImpostoRea === null || json.vlrImpostoRea === undefined){json.vlrImpostoRea = 0;}
	if(!json.vlrIpi || json.vlrIpi === null || json.vlrIpi === undefined){json.vlrIpi = 0;}
	if(!json.vlrIsento || json.vlrIsento === null || json.vlrIsento === undefined){json.vlrIsento = 0;}
	if(!json.vlrIt || json.vlrIt === null || json.vlrIt === undefined){json.vlrIt = 0;}
	if(!json.vlrOutrasDespesas || json.vlrOutrasDespesas === null || json.vlrOutrasDespesas === undefined){json.vlrOutrasDespesas = 0;}
	if(!json.vlrOutros || json.vlrOutros === null || json.vlrOutros === undefined){json.vlrOutros = 0;}
	if(!json.vlrPis || json.vlrPis === null || json.vlrPis === undefined){json.vlrPis = 0;}
	if(!json.vlrPrcCusto || json.vlrPrcCusto === null || json.vlrPrcCusto === undefined){json.vlrPrcCusto = 0;}
	if(!json.vlrPrcCustoAnt || json.vlrPrcCustoAnt === null || json.vlrPrcCustoAnt === undefined){json.vlrPrcCustoAnt = 0;}
	if(!json.vlrProdFrete || json.vlrProdFrete === null || json.vlrProdFrete === undefined){json.vlrProdFrete = 0;}
	if(!json.vlrProdPmc || json.vlrProdPmc === null || json.vlrProdPmc === undefined){json.vlrProdPmc = 0;}
	if(!json.vlrRessarcimentoIcms || json.vlrRessarcimentoIcms === null || json.vlrRessarcimentoIcms === undefined){json.vlrRessarcimentoIcms = 0;}
	if(!json.vlrTotIt || json.vlrTotIt === null || json.vlrTotIt === undefined){json.vlrTotIt = 0;}
	if(!json.xpedIt || json.xpedIt === null || json.xpedIt === undefined){json.xpedIt = "";}
	
	return json;
}

NotaEntrada.prototype.javaToJavaScript = function(movOp){
	
	var json = {};
	json.alqIcms = movOp.get("alqIcms");
	json.atuEst = movOp.get("atuEst");
	json.atuEstFlut = movOp.get("atuEstFlut");
	json.bxEst = movOp.get("bxEst");
	json.bxEstFlut = movOp.get("bxEstFlut");
	json.calcCustoMedio = movOp.get("calcCustoMedio");
	json.cdMovOp = movOp.get("cdMovOp");
	json.cdUsu = movOp.get("cdUsu");
	json.cfop = movOp.get("cfop");
	json.clasMov = movOp.get("clasMov");
	json.destOrig = movOp.get("destOrig");
	json.dsMovOp = movOp.get("dsMovOp");
	json.dsMovOpUsual = movOp.get("dsMovOpUsual");
	json.envioOperadorLog = movOp.get("envioOperadorLog");
	json.flagContabilizarComoDespesas = movOp.get("flagContabilizarComoDespesas");
	json.flagCustoZeroEnt = movOp.get("flagCustoZeroEnt");
	json.flagDescTpListaLinha = movOp.get("flagDescTpListaLinha");
	json.flagDescTpListaNcm = movOp.get("flagDescTpListaNcm");
	json.flagEntradaOperadorLog = movOp.get("flagEntradaOperadorLog");
	json.flagGeraDare = movOp.get("flagGeraDare");
	json.flagGerarIcmsRetido = movOp.get("flagGerarIcmsRetido");
	json.flagGerarIcmsRetidoParaRessarcimento = movOp.get("flagGerarIcmsRetidoParaRessarcimento");
	json.flagIcmsRetidoComoOutrasDepesas = movOp.get("flagIcmsRetidoComoOutrasDepesas");
	json.flagMotivo = movOp.get("flagMotivo");
	json.flagMovImportacao = movOp.get("flagMovImportacao");
	json.flagMovOpNfeCpl = movOp.get("flagMovOpNfeCpl");
	json.flagNAparecerManutencao = movOp.get("flagNAparecerManutencao");
	json.flagNaoAnalisarCustoNaEntrada = movOp.get("flagNaoAnalisarCustoNaEntrada");
	json.flagNaoCreditaImposto = movOp.get("flagNaoCreditaImposto");
	json.flagNaoCreditoImpostoDifal = movOp.get("flagNaoCreditoImpostoDifal");
	json.flagNaoCrossDocking = movOp.get("flagNaoCrossDocking");
	json.flagNaoExigePedidoCompras = movOp.get("flagNaoExigePedidoCompras");
	json.flagNaoGerarArqSped = movOp.get("flagNaoGerarArqSped");
	json.flagNaoRealizarProcAutomatico = movOp.get("flagNaoRealizarProcAutomatico");
	json.flagNaoTributarPisCofins = movOp.get("flagNaoTributarPisCofins");
	json.flagNaoValidaLoteProduto = movOp.get("flagNaoValidaLoteProduto");
	json.flagNaoValidaVenctoLote = movOp.get("flagNaoValidaVenctoLote");
	json.flagPisCofinsCompoemBaseIcms = movOp.get("flagPisCofinsCompoemBaseIcms");
	json.flagRealizaDifAliquota = movOp.get("flagRealizaDifAliquota");
	json.flagRespeitarTribCadXml = movOp.get("flagRespeitarTribCadXml");
	json.flagRetornoOperadorLog = movOp.get("flagRetornoOperadorLog");
	json.geraComi = movOp.get("geraComi");
	json.geraContrExpFut = movOp.get("geraContrExpFut");
	json.geraDp = movOp.get("geraDp");
	json.geraDpPg = movOp.get("geraDpPg");
	json.geraIcmsSubs = movOp.get("geraIcmsSubs");
	json.grlFinan = movOp.get("grlFinan");
	json.permitAltPreco = movOp.get("permitAltPreco");
	json.permiteAltBaseCalc = movOp.get("permiteAltBaseCalc");
	json.possuiProd = movOp.get("possuiProd");
	json.ratDesp = movOp.get("ratDesp");
	json.stsMov = movOp.get("stsMov");
	json.tpEstq = movOp.get("tpEstq");
	json.tpMov = movOp.get("tpMov");
	json.tpMovOpTransa = movOp.get("tpMovOpTransa");
	json.tpPreco = movOp.get("tpPreco");
	json.tpTransa = movOp.get("tpTransa");
	
	return json;
}

