/**
 * Created by maurodouglas on 01/11/16.
 */
load('/basicos/validaCpfCnpj.js');
 var ValidaFabricante = function() {
     this.mapper = mapperFactory.createMapperMult(["EstProdFabric","EstProd"]);
 };

 ValidaFabricante.prototype.validaDadosFabricante = function(json){
 	if(!json){
 		 throw {code: 599, message: "Dados passados ao servidor inválido!"};
 	}
  if(json.get("cgcFabric") && json.get("cgcFabric").length >= 13){
    this.validaDadosCnpj(json);
    this.validaJaCadastrado(json);
  }  
  dadosDefault = this.validaDadosDefault(json);
  return dadosDefault;
 };

ValidaFabricante.prototype.validaDadosDefault = function(json){
  if(!json.get("cgcFabric") || json.get("cgcFabric") === null || json.get("cgcFabric") === undefined){
    json.put("cgcFabric", " ");
  }
  if(!json.get("cdComprador") || json.get("cdComprador") === null || json.get("cdComprador") === undefined){
    json.put("cdComprador", 0);
  }
  if(!json.get("freqRev") || json.get("freqRev") === null || json.get("freqRev") === undefined){
    json.put("freqRev", 0);
  }
  if(!json.get("leadTime") || json.get("leadTime") === null || json.get("leadTime") === undefined){
    json.put("leadTime", 0);
  }
  if(!json.get("tipoFrete") || json.get("tipoFrete") === null || json.get("tipoFrete") === undefined){
    json.put("tipoFrete", 0);
  }
  if(!json.get("compraEmbalado") || json.get("compraEmbalado") === null || json.get("compraEmbalado") === undefined){
    json.put("compraEmbalado", 0);
  }
  if(!json.get("compraMultiplo") || json.get("compraMultiplo") === null || json.get("compraMultiplo") === undefined){
    json.put("compraMultiplo", 0);
  }
  if(!json.get("percDescComercial") || json.get("percDescComercial") === null || json.get("percDescComercial") === undefined){
    json.put("percDescComercial", 0);
  }
  if(!json.get("percDescFinanceiro") || json.get("percDescFinanceiro") === null || json.get("percDescFinanceiro") === undefined){
    json.put("percDescFinanceiro", 0);
  }
  if(!json.get("przPgto") || json.get("przPgto") === null || json.get("przPgto") === undefined){
    json.put("przPgto", 0);
  }
  if(!json.get("segunda") || json.get("segunda") === null || json.get("segunda") === undefined){
    json.put("segunda", 0);
  }
  if(!json.get("terca") || json.get("terca") === null || json.get("terca") === undefined){
    json.put("terca", 0);
  }
  if(!json.get("quarta") || json.get("quarta") === null || json.get("quarta") === undefined){
    json.put("quarta", 0);
  }
  if(!json.get("quinta") || json.get("quinta") === null || json.get("quinta") === undefined){
    json.put("quinta", 0);
  }
  if(!json.get("sexta") || json.get("sexta") === null || json.get("sexta") === undefined){
    json.put("sexta", 0);
  }
  if(!json.get("sabado") || json.get("sabado") === null || json.get("sabado") === undefined){
    json.put("sabado", 0);
  }
  if(!json.get("domingo") || json.get("domingo") === null || json.get("domingo") === undefined){
    json.put("domingo", 0);
  }
  if(!json.get("paramEst") || json.get("paramEst") === null || json.get("paramEst") === undefined){
    json.put("paramEst", 0);
  }
  if(!json.get("indicadorSuprimento") || json.get("indicadorSuprimento") === null || json.get("indicadorSuprimento") === undefined){
    json.put("indicadorSuprimento", 0);
  }
  if(!json.get("cdUsu") || json.get("cdUsu") === null || json.get("cdUsu") === undefined){
    json.put("cdUsu", 1);
  }
  if(!json.get("qtDiasAcresAgenda") || json.get("qtDiasAcresAgenda") === null || json.get("qtDiasAcresAgenda") === undefined){
    json.put("qtDiasAcresAgenda", 0);
  }
  if(!json.get("flagGerarAgenda") || json.get("flagGerarAgenda") === null || json.get("flagGerarAgenda") === undefined){
    json.put("flagGerarAgenda", 0);
  }
  if(!json.get("flagExportaNeogrid") || json.get("flagExportaNeogrid") === null || json.get("flagExportaNeogrid") === undefined){
    json.put("flagExportaNeogrid", 0);
  }
  return json;
};

ValidaFabricante.prototype.validaDadosCnpj = function(json){
  if(json.get("cgcFabric")){
    if(validarCNPJ(json.get("cgcFabric")) === false ){
        throw {code: 599, message: "CNPJ " +  json.get("cgcFabric") + " inválido."};
    }
  }
};

ValidaFabricante.prototype.validaJaCadastrado = function(json){
  if(json.get("cgcFabric")){
    variaveis = {};
    variaveis.cgcFabric = json.get("cgcFabric");
    if(this.mapper.selectOne("EstProdFabric.listarEstProdFabric",variaveis)){
        throw {code: 599, message: "Fabricanete " + json.get("cgcFabric") + " já cadastrado."};
    }
  }
};
