/**
 * Created by victor vieira garcia on 07/11/2017.
 */
load('/model/cliente/insereRegistro.js');
load('/model/convenio/gerenciarCartao.js');
var Colaborador = function () {
    this.mapper = mapperFactory.createMapperMult(["RcCli", "RcCliConv", "RcCliConvRcCli", "WebConvUsuRcCliConvRcCli",
        "WebAdodbLogsql", "PrcEmpConfig", "RcCliConvRcCliUpdateSenha", "GlbCid", "RcVdConv", "RcCliFideliCartao"
    ]);
    this.jsonConvert = new com.google.gson.GsonBuilder().create();
    this.cliente = new Cliente();
    this.gerenciarCartao = new GerenciarCartao();

};

/**
 * Metodo bloquear colaboradores
 * @param {HashMap JAVA} json - parametro passado no momento da requisicao
 * @throws {InvalidArgumentException}
 * @throws {SQLException}
 */

Colaborador.prototype.bloquearColaborador = function (json) {
    if (!json) {
        throw {
            code: 599,
            message: "Dados passados ao servidor inválido!"
        };
    }

    try {

        let logSql = {
            'cdUsu': json.get('cdUsu'),
            'tpUsu': 0,
            'cdConv': json.get("cdConv"),
            'stsCred': json.get("stsCred"),
            'cdCli': 0,
            'cdProc': 7,
            'tbSql': ''
        }

        let cdUsu = json.get('cdUsu');
        if (json.get('tipoUsuario') == 'webconvenio') {
            logSql.tpUsu = 1;
            cdUsu = 0;
        }

        for (let i = 0; i < json.get("cdCli").size(); i++) {

            var objCli = {
                'cdEmp': 1,
                'cdCli': json.get("cdCli").get(i),
                'cdConv': json.get("cdConv"),
                'stsCred': json.get("stsCred"),
                'cdPrecoClasCliente': json.get("cdPrecoClasCliente"),
                'cdUsuAlt': cdUsu
            }

            this.mapper.update("WebConvUsuRcCliConvRcCli.alterarWebConvUsuRcCliConvRcCli", {
                'cdEmp': 1,
                'cdCli': json.get("cdCli").get(i),
                'cdConv': json.get("cdConv"),
                'ativo': 0,
                'tpUsu': logSql.tpUsu
            });

            this.mapper.update('RcCli.alterarRcCli', objCli);
            this.mapper.update('RcCliConvRcCli.alterarRcCliConvRcCli', objCli);

            logSql.tbSql = 'UPDATE - RcCli - RcCliConvRcCli' + this.jsonConvert.toJson(objCli) + 'UPDATE - WebConvUsuRcCliConvRcCli - ' + this.jsonConvert.toJson({
                'cdEmp': 1,
                'tpUsu': logSql.tpUsu,
                'cdConv': json.get("cdConv"),
                'cdCli': json.get("cdCli").get(i)
            });

            logSql.cdCli = json.get("cdCli").get(i);

            this.mapper.insert("WebAdodbLogsql.incluirWebAdodbLogsql", logSql);

        }

        this.mapper.commit();
        return true;
    } catch (err) {
        this.mapper.rollback();
        throw err;
    }
};

Colaborador.prototype.desbloquearColaborador = function (json) {
    if (!json) {
        throw {
            code: 599,
            message: "Dados passados ao servidor inválido!"
        };
    }

    try {

        let logSql = {
            'cdUsu': json.get('cdUsu'),
            'tpUsu': 0,
            'cdConv': json.get("cdConv"),
            'stsCred': json.get("stsCred"),
            'cdCli': 0,
            'cdProc': 8,
            'tbSql': ''
        }

        let cdUsu = json.get('cdUsu');
        if (json.get('tipoUsuario') == 'webconvenio') {
            logSql.tpUsu = 1;
            cdUsu = 0;
        }

        let cdPrecoClasCliente = this.mapper.selectOne("RcCli.listarRcCli", {
            'cdCli': json.get("cdCliConvenio"),
            'cdEmp': 1
        });

        for (let i = 0; i < json.get("cdCli").size(); i++) {
            var objCli = {
                'cdEmp': 1,
                'cdCli': json.get("cdCli").get(i),
                'cdConv': json.get("cdConv"),
                'stsCred': json.get("stsCred"),
                'cdPrecoClasCliente': cdPrecoClasCliente.get('cdPrecoClasCliente'),
                'cdUsuAlt': cdUsu
            }

            this.mapper.update('RcCli.alterarRcCli', objCli);
            this.mapper.update('RcCliConvRcCli.alterarRcCliConvRcCli', objCli);

            logSql.cdCli = json.get("cdCli").get(i);
            logSql.tbSql = 'UPDATE - RcCli - RcCliConvRcCli' + this.jsonConvert.toJson(objCli);

            this.mapper.insert("WebAdodbLogsql.incluirWebAdodbLogsql", logSql);

        }

        this.mapper.commit();
        return true;
    } catch (err) {
        this.mapper.rollback();
        throw err;
    }
};

Colaborador.prototype.editarColaborador = function (json) {
    if (!json) {
        throw {
            code: 599,
            message: "Dados passados ao servidor inválido!"
        };
    }

    try {

        let logSql = {
            'cdUsu': json.get("clienteConvenio").get('cdUsuAlt'),
            'tpUsu': 0,
            'cdConv': json.get("clienteConvenio").get('cdConv'),
            'stsCred': json.get("clienteConvenio").get('stsCred'),
            'cdCli': json.get("clienteConvenio").get('cdCli'),
            'cdProc': 10,
            'tbSql': ''
        }

        let cdUsu = json.get('cdUsuAlt');
        if (json.get("clienteConvenio").get('tipoUsuario') == 'webconvenio') {
            logSql.tpUsu = 1;
            cdUsu = 0;
        }

        let conveniosColaborador = this.mapper.selectList("RcCliConvRcCli.listarRcCliConvRcCli", {
            'cdCli': json.get("clienteConvenio").get('cdCli')
        });

        let metodoInsertOuUpdate = 'insert';
        if (conveniosColaborador.size() > 0) {
            if (json.get("flags").get('flagBloquearColaboradorEmMaisDeUmConvenio') == true) {
                if (conveniosColaborador.get(0).get('cdConv') == json.get("clienteConvenio").get('cdConv')) {
                    metodoInsertOuUpdate = 'update';
                } else {
                    this.mapper.insert("RcCliConvRcCli.excluirRcCliConvRcCli", {
                        'cdEmp': 1,
                        'cdConv': conveniosColaborador.get(0).get('cdConv'),
                        'cdCli': json.get("clienteConvenio").get('cdCli')
                    });
                }
            } else {
                for (var i = 0; i < conveniosColaborador.size(); i++) {
                    if (conveniosColaborador.get(i).get('cdConv') == json.get("clienteConvenio").get('cdConv')) {
                        metodoInsertOuUpdate = 'update';
                        break;
                    }
                }
            }
        }

        this.mapper.update("RcCli.alterarRcCli", json.get("cliente"));
        if (metodoInsertOuUpdate == 'insert') {
            json.get("clienteConvenio").put("cdUsu", cdUsu);
            json.get("clienteConvenio").put('vlrDeb', 0);
            this.mapper.insert("RcCliConvRcCli.incluirRcCliConvRcCli", json.get("clienteConvenio"));
        } else {
            json.get("clienteConvenio").put("cdUsu", cdUsu);
            this.mapper.update("RcCliConvRcCli.alterarRcCliConvRcCli", json.get("clienteConvenio"));
        }

        logSql.tbSql = 'UPDATE - RcCli - ' + this.jsonConvert.toJson(json.get("cliente")) + ', ' + metodoInsertOuUpdate + ' - RcCliConvRcCli - ' + this.jsonConvert.toJson(json.get("clienteConvenio"));

        this.mapper.insert("WebAdodbLogsql.incluirWebAdodbLogsql", logSql);
        this.mapper.commit();

        if (metodoInsertOuUpdate == 'insert') {

            if (json.get("flags").get('flagGeraNumeroCartaoAutomatico')) {
                var dateMais7 = new Date();
                dateMais7.setDate(dateMais7.getDate() + 7);
                var dataPrev = dateMais7.getFullYear() + "/" + (dateMais7.getMonth() + 1) + "/" + dateMais7.getDate();
                var objGerarCartao = mapperFactory.createMap();
                objGerarCartao.put('cdEmp', 1);
                objGerarCartao.put('cdCli', json.get("clienteConvenio").get('cdCli'));
                objGerarCartao.put('cdConv', json.get("clienteConvenio").get('cdConv'));
                objGerarCartao.put('cdUsu', logSql.cdUsu);
                objGerarCartao.put('tipoUsuario', json.get("clienteConvenio").get('tipoUsuario'));
                objGerarCartao.put('dataPrev', dataPrev);
                objGerarCartao.put('clienteFidelidade', true);

                this.gerenciarCartao.gerarCartao(objGerarCartao);
            }
        }

    } catch (err) {
        this.mapper.rollback();
        throw err;
    }
};

Colaborador.prototype.adicionarColaborador = function (json) {
    if (!json) {
        throw {
            code: 599,
            message: "Dados passados ao servidor inválido!"
        };
    }

    try {

        let logSql = {
            'cdUsu': json.get("cliente").get('cdUsuAlt'),
            'tpUsu': 0,
            'cdConv': json.get("cliente").get('cdConv'),
            'stsCred': json.get("cliente").get('stsCred'),
            'cdCli': json.get("cliente").get('cdCli'),
            'cdProc': 9,
            'tbSql': ''
        }

        let chave = this.mapper.selectOne("PrcEmpConfig.listarPrcEmpConfig", {
            'cdChave': "CD_CLASS_TP_LANC_BC_CONVD"
        });

        if (chave) {
            json.get("cliente").put("cdTpLanc", chave.get('valor'));
        } else {
            json.get("cliente").put("cdTpLanc", 0);
        }

        json.get("cliente").put("cdUsu", json.get("cliente").get('cdUsuAlt'));
        json.get("clienteConvenio").put("cdUsu", json.get("clienteConvenio").get('cdUsuAlt'));

        if (json.get("clienteConvenio").get('tipoUsuario') == 'webconvenio') {
            json.get("clienteConvenio").put("cdUsu", 0);
            json.get("cliente").put("cdUsu", 0);
            json.get("clienteConvenio").put("cdUsuAlt", 0);
            json.get("cliente").put("cdUsuAlt", 0);
            logSql.tpUsu = 1;
        }

        this.mapper.insert("RcCli.incluirRcCli", json.get("cliente"));
        json.get("clienteConvenio").put("cdCli", json.get("cliente").get('cdCli'));

        this.mapper.insert("RcCliConvRcCli.incluirRcCliConvRcCli", json.get("clienteConvenio"));

        this.mapper.insert("RcCliConvRcCliUpdateSenha.incluirRcCliConvRcCliUpdateSenha", json.get("cliente"));

        logSql.tbSql = 'INSERT - RcCli, RcCliConvRcCli, RcCliConvRcCliUpdateSenha - ' + this.jsonConvert.toJson(json.get("cliente"));
        logSql.cdCli = json.get("clienteConvenio").get('cdCli');

        this.mapper.insert("WebAdodbLogsql.incluirWebAdodbLogsql", logSql);
        this.mapper.commit();

        if (json.get("flags").get('flagGeraNumeroCartaoAutomatico')) {
            var dateMais7 = new Date();
            dateMais7.setDate(dateMais7.getDate() + 7);
            var dataPrev = dateMais7.getFullYear() + "/" + (dateMais7.getMonth() + 1) + "/" + dateMais7.getDate();
            var objGerarCartao = mapperFactory.createMap();
            objGerarCartao.put('cdEmp', 1);
            objGerarCartao.put('cdCli', json.get("cliente").get('cdCli'));
            objGerarCartao.put('cdConv', json.get("cliente").get('cdConv'));
            objGerarCartao.put('cdUsu', logSql.cdUsu);
            objGerarCartao.put('tipoUsuario', json.get("cliente").get('tipoUsuario'));
            objGerarCartao.put('dataPrev', dataPrev);

            this.gerenciarCartao.gerarCartao(objGerarCartao);
        }

    } catch (err) {
        this.mapper.rollback();
        throw err;
    }
};

Colaborador.prototype.validarCpfColaborador = function (json) {
    let json = json.get("obj");

    if (!json) {
        throw {
            code: 599,
            message: "Dados passados ao servidor inválido!"
        };
    }

    try {
        let objDadosColaborador = mapperFactory.createMap();
        objDadosColaborador.put('cdEmp', 1);

        let validaCpfJaCadastrado;

        validaCpfJaCadastrado = this.mapper.selectList("RcCli.listarRcCli", {
            'cgcCpf': json.get("cgcCpf"),
            'cdEmp': 1
        });

        if (validaCpfJaCadastrado.size() > 1) {
            let resposta = {
                'openModal': true,
                'dados': []
            };

            for (let i = 0; i < validaCpfJaCadastrado.size(); i++) {

                let numeroCartao = this.mapper.selectList("RcCliFideliCartao.listarRcCliFideliCartao", {
                    'cdEmp': 1,
                    'cdCli': validaCpfJaCadastrado.get(i).get('cdCli')
                });

                let codigoConvenio = this.mapper.selectList("RcCliConvRcCli.listarRcCliConvRcCli", {
                    'cdEmp': 1,
                    'cdCli': validaCpfJaCadastrado.get(i).get('cdCli')
                });

                let nomeConvenio = new java.util.ArrayList();

                if (codigoConvenio.size() > 0) {
                    nomeConvenio = this.mapper.selectList("RcCliConv.listarRcCliConv", {
                        'cdEmp': 1,
                        'cdConv': codigoConvenio.get(0).get('cdConv')
                    });
                }

                let cidade = this.mapper.selectOne("GlbCid.listarGlbCid", {
                    'cdCid': validaCpfJaCadastrado.get(i).get('cdCid')
                });

                resposta.dados.push({
                    'cdCli': validaCpfJaCadastrado.get(i).get('cdCli'),
                    'rzCli': validaCpfJaCadastrado.get(i).get('rzCli'),
                    'nrCartao': numeroCartao.get(0).get('nrCartao'),
                    'dsConv': nomeConvenio.size() > 0 ? nomeConvenio.get(0).get('dsConv') : '',
                    'cgcCpf': validaCpfJaCadastrado.get(i).get('cgcCpf'),
                    'cidade': cidade ? cidade.get('dsCid') : ''
                })
            }
            return resposta;
        }


        if (validaCpfJaCadastrado.size() > 0) {
            objDadosColaborador.put('cdCli', validaCpfJaCadastrado.get(0).get('cdCli'));
            objDadosColaborador.put('rzCli', validaCpfJaCadastrado.get(0).get('rzCli'));
            objDadosColaborador.put('matricula', validaCpfJaCadastrado.get(0).get('matricula'));
            objDadosColaborador.put('obs', validaCpfJaCadastrado.get(0).get('obs'));
            objDadosColaborador.put('cep', validaCpfJaCadastrado.get(0).get('cep'));
            objDadosColaborador.put('endCli', validaCpfJaCadastrado.get(0).get('endCli'));
            objDadosColaborador.put('numero', validaCpfJaCadastrado.get(0).get('numero'));
            objDadosColaborador.put('complemento', validaCpfJaCadastrado.get(0).get('complemento'));
            objDadosColaborador.put('bairro', validaCpfJaCadastrado.get(0).get('bairro'));
            objDadosColaborador.put('cdCid', validaCpfJaCadastrado.get(0).get('cdCid'));
            objDadosColaborador.put('tel', validaCpfJaCadastrado.get(0).get('tel'));
            objDadosColaborador.put('email', validaCpfJaCadastrado.get(0).get('email'));

            if (!objDadosColaborador.get('vlrCred'))
                objDadosColaborador.put('vlrCred', 0.01);

            if (objDadosColaborador.get('matricula') == 0)
                objDadosColaborador.put('matricula', "");


            var convenioColaborador = this.mapper.selectList("RcCliConvRcCli.listarRcCliConvRcCli", {
                'cdEmp': 1,
                'cdCli': objDadosColaborador.get('cdCli')
            });

            if (json.get("flag") == true) {
                
                if (convenioColaborador.size() > 0 && convenioColaborador.get(0).get('cdConv') != json.get("cdConv")) {

                    if (convenioColaborador.get(0).get('flagConveniadoDemissao') == 0) {

                        if (json.get("gestao") == true) {

                            var dsConv = this.mapper.selectOne("RcCliConv.listarRcCliConv", {
                                'cdConv': convenioColaborador.get(0).get('cdConv'),
                                'cdEmp': 1
                            });

                            throw {
                                code: 599,
                                message: "Colaborador já esta vinculado ao convênio(s) de código: " + convenioColaborador.get(0).get('cdConv') + " Nome : " + dsConv.get('dsConv') + " Entre em contato com a equipe " + json.get("nomeEmpresaWebconvenio")
                            };

                        } else {
                            throw {
                                code: 599,
                                message: "Colaborador já esta vinculado a outro convênio, entre em contato com a equipe " + json.get("nomeEmpresaWebconvenio")
                            };
                        }
                    }

                    var debitoCompra = this.mapper.selectOne("RcVdConv.validaCompra", {
                        'cdCli': objDadosColaborador.get('cdCli')
                    });

                    if (convenioColaborador.get(0).get('flagConveniadoDemissao') == 1 && debitoCompra) {
                        throw {
                            code: 599,
                            message: "Funciónario com compra(s) ativa(s) em outra empresa. Entre em contato com a equipe " + json.get("nomeEmpresaWebconvenio") + "!"
                        };
                    } else {
                        objDadosColaborador.put('matricula', "");
                        objDadosColaborador.put('vlrCred', 0.01);
                        objDadosColaborador.put('stsAtivo', 0);
                        objDadosColaborador.put('cdPlanoVenda', 1);
                        objDadosColaborador.put('obs', "");
                    }
                }

                if (convenioColaborador.size() > 0 && convenioColaborador.get(0).get('cdConv') == json.get("cdConv") && convenioColaborador.get(0).get('flagConveniadoDemissao') == 1) {
                    throw {
                        code: 599,
                        message: "Colaborador demitido no convênio, realize a Readimissão."
                    };
                }

                if (convenioColaborador.size() > 0 && convenioColaborador.get(0).get('cdConv') == json.get("cdConv")) {
                    objDadosColaborador.put('vlrCred', convenioColaborador.get(0).get('vlrCred'));
                    objDadosColaborador.put('cdPlanoVenda', convenioColaborador.get(0).get('cdPlanoVenda'));
                }
            } else {
                if (convenioColaborador.size() > 0) {
                    for (var i = 0; i < convenioColaborador.size(); i++) {
                        if (convenioColaborador.get(i).get('cdConv') == json.get("cdConv")) {
                            objDadosColaborador.put('vlrCred', convenioColaborador.get(i).get('vlrCred'));
                            objDadosColaborador.put('cdPlanoVenda', convenioColaborador.get(i).get('cdPlanoVenda'));
                            break;
                        }
                    }
                }
            }

            if (objDadosColaborador.get('cdCid')) {
                var cidade = this.mapper.selectOne("GlbCid.listarGlbCid", {
                    'cdCid': objDadosColaborador.get('cdCid')
                });

                if (cidade) {
                    objDadosColaborador.put('dsCid', cidade.get('dsCid'));
                    objDadosColaborador.put('uf', cidade.get('uf'));
                }
            }

            return objDadosColaborador;

        } else {
            return false;
        }

    } catch (err) {
        this.mapper.rollback();
        throw err;
    }

};