/**
 * Created by maurodouglas on 07/11/16.
 */

var CheckOutRessuprimento = function() {
    this.mapper = mapperFactory.createMapperMult(["EstProdTransConf","EstProdTransConfFases","EstProdTransConfFasesItens"]);
    this.fornecedoresVinculado = [];
};

CheckOutRessuprimento.prototype.gerenciarConf = function(metodo, json){
    if(json === null || json.size() === 0){
        throw {code: 599, message: "Dados passados ao servidor inválido!"};
    }
    try{
        switch(metodo) {
            case 'POST':
                this.mapper.insert("EstProdTransConf.incluirEstProdTransConf", json);
                this.mapper.commit();
                break;
            case 'PUT':
                this.mapper.update("EstProdTransConf.alterarEstProdTransConf", json);
                this.mapper.commit();
                break;
            case 'DELETE':
                //this.mapper.update("EstProdTransConf.alterarEstPedVd", json);
                //this.mapper.commit();
                break;
        }

    }catch(err){
        this.mapper.rollback();
        throw err;
    }

};

CheckOutRessuprimento.prototype.gerenciarConfFases = function(metodo, json){
    if(json === null || json.size() === 0){
        throw {code: 599, message: "Dados passados ao servidor inválido!"};
    }
    try{
        switch(metodo) {
            case 'POST':
                this.mapper.insert("EstProdTransConfFases.incluirEstProdTransConfFases", json);
                this.mapper.commit();
                break;
            case 'PUT':
                this.mapper.update("EstProdTransConfFases.alterarEstProdTransConfFases", json);
                this.mapper.commit();
                break;
            case 'DELETE':
                //this.mapper.update("EstProdTransConfFases.alterarEstPedVdIt", json);
                //this.mapper.commit();
                break;
        }

    }catch(err){
        this.mapper.rollback();
        throw err;
    }

};

CheckOutRessuprimento.prototype.gerenciarConfFasesItens = function(metodo, json){
    if(json === null || json.size() === 0){
        throw {code: 599, message: "Dados passados ao servidor inválido!"};
    }
    try{
        switch(metodo) {
            case 'POST':
                this.mapper.insert("EstProdTransConfFasesItens.incluirEstProdTransConfFasesItens", json);
                this.mapper.commit();
                break;
            case 'PUT':
                this.mapper.update("EstProdTransConfFasesItens.alterarEstProdTransConfFasesItens", json);
                this.mapper.commit();
                break;
            case 'DELETE':
                //this.mapper.update("EstProdTransConfFasesItens.alterarEstProdTransConfFasesItens", json);
                //this.mapper.commit();
                break;
        }

    }catch(err){
        this.mapper.rollback();
        throw err;
    }

};
