var Dicionario = function () {
    this.mapper = mapperFactory.createMapperMult(["EstProdForn"]);
};

Dicionario.prototype.getDicionarioDoFornecedor = function (json) {
    if(json == null || json.size() == 0)
        return [];

    if(json.get('cdEmp') == null || json.get('cdForn') == null)
        throw {code: 599, message: "Dados passados ao servidor inválido!"};


    if(json.get('filtrarPelaTblTemp') > 0)
        return this.mapper.selectList("EstProdForn.getDicionarioByTblTemp", json);
    else
        return this.mapper.selectList("EstProdForn.listarEstProdFornComNomeDoProdutoEFornecedor", {'cdEmp': json.get('cdEmp'), 'cdForn': json.get('cdForn')});
};
