var PendenciaPorArquivo = function () {
    this.mapper = mapperFactory.createMapperMult(["VestPendenteEntrada", "EstPedCpPendencia", "EstPedCpItCancelSld", "EstPedCp", "EstPedEltr", "EstPedEltrAtivaCpEstPedEltr", "EstProdTransf",
    "EstNfEntDanfeProvisorio", "EstNfEntDanfeProvisorioSuspenso", "EstNfEntDanfeProvisorioPendente", "EstNfEntPedCp", "EstPedEltrFornCtrEnvPgFornIntegracaoArqPendente", "PgFornIntegracaoArqPendente", "EstPedEltrAtivaCpHistParam"]);
    this.jsonConvert = new com.google.gson.GsonBuilder().create();
    this.pendenciaNaoRemovidas = [];
};

PendenciaPorArquivo.prototype.removerPendenciaPorArquivo = function (json) {
    if (!json || !json.get('documentos')) {
        throw {
            code: 599,
            message: "Dados passados ao servidor inválido!"
        };
    }

    try{
        for(let i=0; i<json.get('documentos').size(); i++){
             let metodo = 'tipoDoc' + json.get('documentos').get(i).get('tipoDoc');
             this[metodo]({'documento':json.get('documentos').get(i), 'cdUsu':json.get('cdUsu'), 'flagExecTipo6':json.get('flagExecTipo6')});
        }

        this.mapper.commit();
        return this.pendenciaNaoRemovidas;

    }catch(err){
        this.mapper.rollback();
    	throw err;
    }
};

PendenciaPorArquivo.prototype.cancelarSaldoPedidoDeCompra = function(param){
        let produtos = this.mapper.selectList("VestPendenteEntrada.listarInfoProdutoDocumento", {
            'nrDoc': param.cdPed,
            'cdFilial': param.cdFilial,
            'tipoDoc': 1
        });

        for (let i = 0; i < produtos.size(); i++) {
            var saldoCanceladoProd = this.mapper.selectOne("EstPedCpItCancelSld.listarEstPedCpItCancelSld", {
                'cdEmp': 1,
                'cdFilial': param.cdFilial,
                'cdPed': param.cdPed,
                'cdProd': produtos.get(i).get('cdProd')
            });

            if (saldoCanceladoProd) {
                this.mapper.update("EstPedCpItCancelSld.alterarEstPedCpItCancelSld", {
                    'cdEmp': 1,
                    'cdFilial': param.cdFilial,
                    'cdPed': param.cdPed,
                    'cdProd': produtos.get(i).get('cdProd'),
                    'cdUsu': param.cdUsu,
                    'qtProd': parseInt(saldoCanceladoProd.get('qtProd')) + parseInt(produtos.get(i).get('qtIt'))
                });
            } else {
                this.mapper.insert("EstPedCpItCancelSld.incluirEstPedCpItCancelSld", {
                    'cdEmp': 1,
                    'cdFilial': param.cdFilial,
                    'cdPed': param.cdPed,
                    'cdProd': produtos.get(i).get('cdProd'),
                    'cdUsu': param.cdUsu,
                    'qtProd': produtos.get(i).get('qtIt')
                });
            }
        };
};

//PEDIDO DE COMPRA
PendenciaPorArquivo.prototype.tipoDoc1 = function (obj) {
        /*var produtos = this.mapper.selectList("VestPendenteEntrada.listarInfoProdutoDocumento", {
            'nrDoc': obj.documento.get('nrDoc'),
            'cdFilial': obj.documento.get('cdFilialDest'),
            'tipoDoc': obj.documento.get('tipoDoc')
        });

        for (var i = 0; i < produtos.size(); i++) {
            var saldoCanceladoProd = this.mapper.selectOne("EstPedCpItCancelSld.listarEstPedCpItCancelSld", {
                'cdEmp': 1,
                'cdFilial': obj.documento.get('cdFilialDest'),
                'cdPed': obj.documento.get('nrDoc'),
                'cdProd': produtos.get(i).get('cdProd')
            });

            if (saldoCanceladoProd) {
                this.mapper.insert("EstPedCpItCancelSld.alterarEstPedCpItCancelSld", {
                    'cdEmp': 1,
                    'cdFilial': obj.documento.get('cdFilialDest'),
                    'cdPed': obj.documento.get('nrDoc'),
                    'cdProd': produtos.get(i).get('cdProd'),
                    'cdUsu': obj.cdUsu,
                    'qtProd': parseInt(saldoCanceladoProd.get('qtProd')) + parseInt(produtos.get(i).get('qtIt'))
                });
            } else {
                this.mapper.update("EstPedCpItCancelSld.incluirEstPedCpItCancelSld", {
                    'cdEmp': 1,
                    'cdFilial': obj.documento.get('cdFilialDest'),
                    'cdPed': obj.documento.get('nrDoc'),
                    'cdProd': produtos.get(i).get('cdProd'),
                    'cdUsu': obj.cdUsu,
                    'qtProd': produtos.get(i).get('qtIt')
                });
            }
        };*/

        if(this.mapper.selectOne('EstNfEntDanfeProvisorioPendente.temDanfePendenteNoPedido', {'cdPed': obj.documento.get('nrDoc'), 'cdFilial': obj.documento.get('cdFilialDest')}) == 1){
            //TODO DAR SAIDA DOS PEDIDOS NÂO CANCELADOS POR DANFE PROVISORIO PENDENTE
            this.pendenciaNaoRemovidas.push({'nrDoc': obj.documento.get('nrDoc'), 'cdFilialDest': obj.documento.get('cdFilialDest')});
        }else{
            if(this.mapper.selectList('EstNfEntPedCp.listarEstNfEntPedCp', {'cdEmp':1, 'cdPed': obj.documento.get('nrDoc'), 'cdFilial': obj.documento.get('cdFilialDest')}).size() == 0){
                //TODO CANCELAR PEDIDO
                this.mapper.update("EstPedCp.alterarEstPedCp", {
                    'stsPed': 2,
                    'cdUsuCancel': obj.cdUsu,
                    'cdUsu': obj.cdUsu,
                    'cdPed': obj.documento.get('nrDoc'),
                    'cdFilial': obj.documento.get('cdFilialDest'),
                    'cdEmp': 1
                });

            }else{
                //TODO CANCELAR SALDO E PENDENCIA
                let param = {'cdPed':obj.documento.get('nrDoc'),
                            'cdFilial': obj.documento.get('cdFilialDest'),
                            'cdUsu': obj.cdUsu};

                this.cancelarSaldoPedidoDeCompra(param);
                this.mapper.update("EstPedCpPendencia.excluirEstPedCpPendencia", {
                    'cdPed': obj.documento.get('nrDoc'),
                    'cdFilial': obj.documento.get('cdFilialDest'),
                    'cdEmp': 1
                });

            }
        }

          /*this.mapper.update("EstPedCpPendencia.excluirEstPedCpPendencia", {
                            'cdPed': obj.documento.get('nrDoc'),
                            'cdFilial': obj.documento.get('cdFilialDest'),
                            'cdEmp': 1
                        });

                        this.mapper.update("EstPedCp.alterarEstPedCp", {
                            'stsPed': 2,
                            'cdUsuCancel': obj.cdUsu,
                            'cdUsu': obj.cdUsu,
                            'cdPed': obj.documento.get('nrDoc'),
                            'cdFilial': obj.documento.get('cdFilialDest'),
                            'cdEmp': 1
                        });*/


};


PendenciaPorArquivo.prototype.tipoDoc5 = function (obj) {
        this.mapper.update("EstProdTransf.alterarEstProdTransf", {
            'cdCtr': obj.documento.get('cdDocOric'),
            'cdFilial': obj.documento.get('cdFilialDest'),
            'cdEmp': 1,
            'stsTransf': 4,
            'cdUsu': obj.cdUsu
        });
};

PendenciaPorArquivo.prototype.tipoDoc6 = function (obj) {
    if (obj.flagExecTipo6 == 0) {
        this.mapper.update("EstNfEntDanfeProvisorio.pExcluirEstProdDanfeProvisorio", {
            'cdCtr': obj.documento.get('cdDocOric')
        });
    }

    if (obj.flagExecTipo6 == 1) {
            var tipoMetodo = this.mapper.selectOne("EstNfEntDanfeProvisorioSuspenso.listarEstNfEntDanfeProvisorioSuspenso", {
                'cdCtr': obj.documento.get('cdDocOric')
            });

            if (tipoMetodo) {
                this.mapper.update("EstNfEntDanfeProvisorioSuspenso.excluirEstNfEntDanfeProvisorioSuspenso", {
                    'cdCtr': obj.documento.get('cdDocOric')
                });
            } else {
                this.mapper.insert("EstNfEntDanfeProvisorioSuspenso.incluirEstNfEntDanfeProvisorioSuspenso", {
                    'cdCtr': obj.documento.get('cdDocOric'),
                    'cdUsu': obj.cdUsu
                });
            }
    }
};

PendenciaPorArquivo.prototype.tipoDoc8 = function (obj) {
    this.mapper.update("EstNfEntCrossDockingPendente.excluirEstNfEntCrossDockingPendente", {
        'cdEmp': 1,
        'cdNf': obj.documento.get('nrDoc'),
        'cdFilial': obj.documento.get('cdFilialDest')
    });
};

//DEMANDA DE COMPRAS
PendenciaPorArquivo.prototype.tipoDoc10 = function (obj) {
    this.mapper.update("EstPedEltr.alterarEstPedEltr", {
        'cdPedSol': obj.documento.get('nrDoc'),
        'cdEmp': 1,
        'stsPed': 3,
        'flagFechar': 1,
        'cdUsu': obj.cdUsu
    });

    this.mapper.update("EstPedEltrAtivaCpEstPedEltr.alterarEstPedEltrAtivaCpEstPedEltr", {
        'cdPedSol': obj.documento.get('nrDoc'),
        'cdEmp': 1,
        'flagFechar': 1
    });

    this.mapper.update("EstPedEltrFornCtrEnvPgFornIntegracaoArqPendente.cancelarStatusPelaDemanda", {
        'cdPedSol': obj.documento.get('nrDoc'),
        'cdEmp': 1
    });

    this.mapper.update("EstPedEltrAtivaCpHistParam.cancelarStatusPelaDemanda", {
        'cdPedSol': obj.documento.get('nrDoc'),
        'cdEmp': 1
    });

    this.mapper.update("PgFornIntegracaoArqPendente.cancelarStatusPelaDemanda", {
        'cdPedSol': obj.documento.get('nrDoc'),
        'cdEmp': 1
    });
};