load( "/rules/funcionario/validaDados.js" );
load( '/model/erro/admErroCadBasicosIntegracoes.js' );
/**
 * Created by Mauro Douglas on 04/01/17.
 */
var Funcionario = function( ) {
	this.mapper = mapperFactory.createMapperMult([ "FpFunc", "GlbUsu", "GlbUsuFilial" ]);
	this.validaFuncionario = new ValidaFuncionario();
	this.gravaErro = new AdmErroIntegracoes( );
	this.jsonConvert = new com.google.gson.GsonBuilder( ).create( );
	this.i = 0;
};

/**
 * Metodo faz controle das inserções de familia a serem feitas
 * @param {HashMap JAVA} json - parametro passado no momento da requisicao
 * @throws {InvalidArgumentException}
 * @return retorna objeto com todos os dados que foram inseridos
 */
Funcionario.prototype.insereFuncionario = function( json ) {
	if ( !json ) {
		throw { code: 599, message: "Dados passados ao servidor inválido!" };
	}
	if (json.get( "obj" )) {
		var obj = json.get( "obj" );
	} else {
		var obj = mapperFactory.createMap( );
		obj.put( 0, json );
	}

	try {
		for ( this.i = 0; this.i < obj.size( ); this.i++ ) {
			var item = obj.get( this.i );

      var usuario = mapperFactory.createMap( );
      usuario.put("nmUsu",item.get("nmFun"))
      var usuarioValidado = this.validaFuncionario.validaDadosParaCadastroUsuario( usuario );
      this.mapper.insert( "GlbUsu.incluirGlbUsu", usuarioValidado );

	  	var funcionarioValidado = this.validaFuncionario.validaDadosParaCadastroFuncionario( item );
      funcionarioValidado.put("cdFuncUsu",usuarioValidado.get("cdUsu"));
      this.mapper.insert( "FpFunc.incluirFpFunc", funcionarioValidado );

			if(itemValidado.get("importador") == 1 ){
      	funcionarioValidado.put("tabela","FP_FUNC");
      	funcionarioValidado.put("codigo",funcionarioValidado.get("cdFun"));
				this.gravaSucesso(itemValidado);
			}
		}
		this.mapper.commit();
		if(obj.size() == 1){
			obj.get(0).get("cdFun");
		}else{
			obj;
		}
  }catch ( err ) {
		java.lang.System.out.println( err );
		this.mapper.rollback( );
		//gravaErro(itemValidado,err);
		if ( err.code ) {
			throw JSON.stringify( err );
		}
		throw "{erro:true,  message:'" + escape( err ) + "'}";
	}
};


Funcionario.prototype.gravaSucesso = function( json ) {
	var metodo = 'POST';
	var msgErro = {};
	msgErro.id             = parseInt(json.get( "codigo" ));
	msgErro.tabela         = json.get( "tabela" );
	msgErro.jsonEnviado    = this.jsonConvert.toJson( json );
	msgErro.stsErro        = 1; // Importado com sucesso
	msgErro.cdUsuCorrecao  = 0;
	msgErro.laudo          = 'Registro ' + json.get( "codigo" ) + ' inserido com sucesso.';
	this.gravaErro.gerenciaErro( metodo, msgErro );
};

Funcionario.prototype.gravaErro = function( json ) {
	java.lang.System.out.println( 'itemValidado ' + itemValidado );
	var metodo = 'POST';
	var msgErro = {};
	msgErro.id = json.get( "cdConv" ) || 0;
	msgErro.tabela = json.get( "tabela" );
	msgErro.jsonEnviado = this.jsonConvert.toJson( json );
	msgErro.stsErro = 2; // Erro
	msgErro.cdUsuCorrecao = 0;
	msgErro.laudo = jsonConvert.toJson( err );
	this.gravaErro.gerenciaErro( metodo, msgErro );
};
