load("/rules/fornecedor/validaDados.js");
load('/model/erro/admErroCadBasicosIntegracoes.js');
/**
 * Created by Mauro Douglas on 04/01/17.
 */
var Fornecedor = function( ) {
	this.mapper 					= mapperFactory.createMapperMult(["PgForn", "PgFornImposto", "PgFornCnt", "PgFornRcCli", "PgFornEstNfSerie"]);
	this.validaFornecedor = new ValidaFornecedor();
	this.gravaErro 				= new AdmErroIntegracoes( );
	this.jsonConvert 			= new com.google.gson.GsonBuilder( ).create( );
	this.i 								= 0;
};

/**
 * Metodo faz controle das inserções de Fornecedor a serem feitas
 * @param {HashMap JAVA} json - parametro passado no momento da requisicao
 * @throws {InvalidArgumentException}
 * @return retorna objeto com todos os dados que foram inseridos
 */
Fornecedor.prototype.insereFornecedor = function( json ) {
	if ( !json ) {
		throw { code: 599, message: "Dados passados ao servidor inválido!" };
	}
	if (json.get( "obj" )) {
		var obj = json.get( "obj" );
		var importacao = true;
	} else {
		var obj = mapperFactory.createMap( );
		obj.put( 0, json );
		var importacao = false;
	}

	try {
	    java.lang.System.out.println( 'obj.size()  ' + obj.size() );
		for (this.i = 0; this.i < obj.size(); this.i++) {
				var itemValidado = this.validaFornecedor.validaDadosBasicos(obj.get(this.i));
				this.inserirFornecedor(itemValidado);
				this.gerenciarVinculoImposto(itemValidado);
				this.gerenciarVinculoConta(itemValidado);
				this.gerenciarVinculoCliente(itemValidado);
				this.gerenciarVinculoNfSerie(itemValidado);
				if(itemValidado.get("importador") == 1 ){
						this.gravaSucesso(itemValidado);
				}
		}
		this.mapper.commit();
		
		if(importacao)
			return obj;
		else
			return obj.get(0);
		
	} catch ( err ) {
		java.lang.System.out.println( err );
		this.mapper.rollback( );
		//gravaErro(itemValidado,err);
		throw err;
	}
};


Fornecedor.prototype.inserirFornecedor = function( json ) {
    this.mapper.insert("PgForn.incluirPgForn", json);
};

Fornecedor.prototype.gerenciarVinculoImposto = function( json ) {
    if(json.get("impostos")){
	    var impostos = json.get("impostos");
       this.mapper.update("PgFornImposto.excluirPgFornImposto", {'cdForn':json.get("cdForn"), 'cdEmp':json.get("cdEmp")});
    		for (var i = 0; i < impostos.size(); i++) {
    			impostos.get(i).put("cdEmp", json.get("cdEmp"));
    			impostos.get(i).put("cdForn", json.get("cdForn"));
    			this.mapper.insert("PgFornImposto.incluirPgFornImposto", impostos.get(i));
    		}
    }
};

Fornecedor.prototype.gerenciarVinculoConta = function( json ) {
    if(json.get("contasBancarias")){
    	var contasBancarias = json.get("contasBancarias");
    	this.mapper.update("PgFornCnt.excluirPgFornCnt", {'cdForn':json.get("cdForn"), 'cdEmp':json.get("cdEmp")});

    	for (var i = 0; i < contasBancarias.size(); i++) {
    		contasBancarias.get(i).put("cdEmp", json.get("cdEmp"));
    		contasBancarias.get(i).put("cdForn", json.get("cdForn"));
    		this.mapper.insert("PgFornCnt.incluirPgFornCnt", contasBancarias.get(i));
    	}
    }
};

Fornecedor.prototype.gerenciarVinculoCliente = function( json ) {
    if(json.get("fornCliente")){
		var cliente = json.get("fornCliente");
		cliente.put("cdForn",json.get("cdForn"));
		cliente.put("cdEmp",json.get("cdEmp"));
		var clienteJaVinculado = this.mapper.selectList("PgFornRcCli.listarPgFornRcCliPorCodigoFornecedor", cliente);

		//relacionamento 1 para 1
		if(clienteJaVinculado.size()>0 && cliente.get("cdCli")!=null && cliente.get("cdForn")!= null){
			//update
			this.mapper.update("PgFornRcCli.alterarPgFornRcCli", cliente);
		}else if(clienteJaVinculado.size() == 0 && cliente.get("cdCli")!=null && cliente.get("cdForn")!= null){
			//insert
			this.mapper.insert("PgFornRcCli.incluirPgFornRcCli", cliente);
		}else if(cliente.get("cdCli") == null && clienteJaVinculado.size()>0 && cliente.get("cdForn")!= null){
			//delete
			this.mapper.update("PgFornRcCli.excluirPgFornRcCli", cliente);

		}
    }
};

Fornecedor.prototype.gerenciarVinculoNfSerie = function( json ) {
    if(json.get("nfSeries")){
    	var nfSeries = json.get("nfSeries");
    	this.mapper.update("PgFornEstNfSerie.excluirPgFornEstNfSeriePorCdForn", {'cdForn':json.get("cdForn"), 'cdEmp':json.get("cdEmp")});

    	for (var i = 0; i < nfSeries.size(); i++) {
    		nfSeries.get(i).put("cdEmp", json.get("cdEmp"));
    		nfSeries.get(i).put("cdForn", json.get("cdForn"));
    		this.mapper.insert("PgFornEstNfSerie.incluirPgFornEstNfSerie", nfSeries.get(i));
    	}
    }
};

Fornecedor.prototype.gravaSucesso = function( json ) {
  var metodo            = 'POST';
  var msgErro           = {};
  msgErro.id            = parseInt(json.get("cdForn"));
  msgErro.tabela        = 'PG_FORN';
  msgErro.jsonEnviado   = this.jsonConvert.toJson(json);
  msgErro.stsErro       = 1; // Importado com sucesso
  msgErro.cdUsuCorrecao = 0;
  msgErro.laudo         = 'Fornecedor ' + json.get("cdForn") + ' inserido com sucesso.';
  this.gravaErro.gerenciaErro(metodo,msgErro);
};

Fornecedor.prototype.gravaErro = function( json ) {
  java.lang.System.out.println('itemValidado ' +itemValidado);
  var metodo            = 'POST';
  var msgErro           = {};
  msgErro.id            = json.get("cdForn") || 0;
  msgErro.tabela        = 'PG_FORN';
  msgErro.jsonEnviado   = this.jsonConvert.toJson(json);
  msgErro.stsErro       = 2; // Erro
  msgErro.cdUsuCorrecao = 0;
  msgErro.laudo         = jsonConvert.toJson(err);
  this.gravaErro.gerenciaErro(metodo,msgErro);
};
