/**
 * Created by willian batista on 04/11/16.
 */
var MensagemRetornoFornecedorPedidoEletronico = function() {
    this.mapper = mapperFactory.createMapperMult(["PgFornMsgRet"]);
};

/**
 * Metodo realiza insert na tabela PG_FORN_MSG_RET
 * @param {HashMap JAVA} json - parametro passado no momento da requisicao
 * @throws {InvalidArgumentException}
 * @throws {SQLException}
 */
MensagemRetornoFornecedorPedidoEletronico.prototype.post = function(json){
	if(json === null || json.size() === 0){
		 throw {code: 599, message: "Dados passados ao servidor inválido!"};
	}
	
	try{
		this.mapper.insert('PgFornMsgRet.incluirPgFornMsgRet', json);
		this.mapper.commit();
	}catch(err){
		this.mapper.rollback();
		throw err;
	}
};

/**
 * Metodo realiza update na tabela PG_FORN_MSG_RET
 * @param {HashMap JAVA} json - parametro passado no momento da requisicao
 * @throws {InvalidArgumentException}
 * @throws {SQLException}
 */
MensagemRetornoFornecedorPedidoEletronico.prototype.put = function(json){
	if(json === null || json.size() === 0){
		 throw {code: 599, message: "Dados passados ao servidor inválido!"};
	}
	
	try{
		this.mapper.update('PgFornMsgRet.alterarPgFornMsgRet', json);
		this.mapper.commit();
	}catch(err){
		this.mapper.rollback();
		throw err;
	}
};

/**
 * Metodo realiza delete na tabela PG_FORN_MSG_RET
 * @param {HashMap JAVA} json - parametro passado no momento da requisicao
 * @throws {InvalidArgumentException}
 * @throws {SQLException}
 */
MensagemRetornoFornecedorPedidoEletronico.prototype.del = function(json){
	if(json === null || json.size() === 0){
		 throw {code: 599, message: "Dados passados ao servidor inválido!"};
	}
	
	try{
		this.mapper.update('PgFornMsgRet.excluirPgFornMsgRet', json);
		this.mapper.commit();
	}catch(err){
		this.mapper.rollback();
		throw err;
	}
};