/**
 * Created by willian batista on 04/11/16.
 */
var Fornecedor = function() {
    this.mapper = mapperFactory.createMapperMult(["PgForn", "PgFornFornVinculado", "PgFornCdFilForn"]);
    this.fornecedoresVinculado = [];
};

/**
 * Metodo retorna a lista de fornecedores vinculados a outro
 * @param {HashMap JAVA} json - parametro passado no momento da requisicao
 * @throws {InvalidArgumentException}
 */
Fornecedor.prototype.getFornecedoresVinculados = function(json){
	if(json === null || json.size() === 0){
		 throw {code: 599, message: "Dados passados ao servidor inválido!"};
	}
	
	fornecedoresVinculado = this.mapper.selectList("PgForn.listarFornecedoresVinculados", json);
	return this.fornecedoresVinculado;
};

/**
 * Metodo gerenciar os fornecedores vinculados de acordo com o metodo solicitado
 * @param {String} metodo - método solicitado durante a requisição do serviço
 * @param {HashMap JAVA} json - parametro passado no momento da requisicao
 * @throws {InvalidArgumentException}
 * @throws {SqlException}
 */
Fornecedor.prototype.gerenciarFornecedoresVinculados = function(metodo, json){
	if(json === null || json.size() === 0){
		 throw {code: 599, message: "Dados passados ao servidor inválido!"};
	}
	try{
		if(metodo == 'POST'){
			this.mapper.insert("PgFornFornVinculado.incluirPgFornFornVinculado", json);
		}else if(metodo == 'PUT'){
			this.mapper.update("PgFornFornVinculado.alterarPgFornFornVinculado", json);
		}else if(metodo == 'DELETE'){
			this.mapper.update("PgFornFornVinculado.excluirPgFornFornVinculado", {"cdEmp":json.get("cdEmp") , "cdForn":json.get("cdForn") , "cdFornVinculado":json.get("cdFornVinculado")});
		}else{
			throw {code: 599, message: "Método de requisição não encontrado!"};
		}
		
		this.mapper.commit();
	}catch(err){
		this.mapper.rollback();
		throw err;
	}

};

/**
 * Metodo gerenciar as filiais vinculadas de acordo com o metodo solicitado
 * @param {String} metodo - método solicitado durante a requisição do serviço
 * @param {HashMap JAVA} json - parametro passado no momento da requisicao
 * @throws {InvalidArgumentException}
 * @throws {SqlException}
 */
Fornecedor.prototype.gerenciarFiliaisVinculadas = function(metodo, json){
	if(json === null || json.size() === 0){
		 throw {code: 599, message: "Dados passados ao servidor inválido!"};
	}
	try{
		if(metodo == 'POST'){
			this.mapper.insert("PgFornCdFilForn.incluirPgFornCdFilForn", json);
		}else if(metodo == 'PUT'){
			this.mapper.update("PgFornCdFilForn.alterarPgFornCdFilForn", json);
		}else if(metodo == 'DELETE'){
			this.mapper.update("PgFornCdFilForn.excluirPgFornCdFilForn", json);
		}else{
			throw {code: 599, message: "Método de requisição não encontrado!"};
		}
		
		this.mapper.commit();
	}catch(err){
		this.mapper.rollback();
		throw err;
	}

};