/**
 * Created by willian batista on 21/11/16.
 */
var Filial = function() {
    this.mapper = mapperFactory.createMapperMult(["PrcFilial", "PrcFilialRcCli", "PrcFilialPgForn"]);
};


/**
 * Metodo valida se cliente está habilitado para realizar vinculo com a filial,
 * sendo que um cliente pode estar vinculado apenas a uma filial
 * @param {HashMap JAVA} json - parametro de código de empresa e cliente passados no momento da requisicao
 * @throws {InvalidArgumentException}
 */
Filial.prototype.isClienteJaVinculado = function(json){
	if(json === null){
		 throw {code: 599, message: "Dados passados ao servidor inválido!"};
	}
	
	var cliente = this.mapper.selectOne("PrcFilialRcCli.listarPrcFilialRcCli", json);
	return (cliente ? true : false);
};


/**
 * Metodo valida se fornecedor está habilitado para realizar vinculo com a filial,
 * sendo que um fornecedor pode estar vinculado apenas a uma filial
 * @param {HashMap JAVA} json - parametro de código de empresa e fornecedor passados no momento da requisicao
 * @throws {InvalidArgumentException}
 */
Filial.prototype.isFornecedorJaVinculado = function(json){
	if(json === null){
		 throw {code: 599, message: "Dados passados ao servidor inválido!"};
	}
	
	var fornecedor = this.mapper.selectOne("PrcFilialPgForn.listarPrcFilialPgForn", json);
	return (fornecedor ? true : false);
};
