/**
 * Created by Victor Vieira Garcia on 09/08/2017
 */
var GerenciarCartao = function () {
    this.mapper = mapperFactory.createMapperMult(["RcCliConvRcCli", "RcCliFideliCartaoSolic", "RcCliFideliCartao",
        "RcCli", "PrcEmp", "WebConvenio", "WebAdodbLogsql", "WebConvDemite", "WebConvDemiteRcCli", "RcCliFideliCartaoConfSolic",
        "WebConvUsuRcCliConvRcCli"
    ]);
    this.jsonConvert = new com.google.gson.GsonBuilder().create();

};

/**
 * Metodo faz controle de geração de cartão
 * @param {HashMap JAVA} json - parametro passado no momento da requisicao
 * @throws {InvalidArgumentException}
 * @return retorna objeto com todos os dados que foram inseridos
 */
GerenciarCartao.prototype.gerarCartao = function (json) {
    if (!json) {
        throw {
            code: 599,
            message: "Dados passados ao servidor inválido!"
        };
    }

    try {
        let logSql = {
            cdUsu: json.get('cdUsu'),
            tpUsu: 0,
            cdConv: json.get('cdConv'),
            cdProc: 12,
            cdCli: json.get('cdCli'),
            tbSql: ''
        }

        if (json.get('tipoUsuario') == 'webconvenio')
            logSql.tpUsu = 1;

        let verificaClienteBloqueado = this.mapper.selectOne("RcCliConvRcCli.listarRcCliConvRcCli", {
            'cdCli': json.get('cdCli'),
            'cdEmp': json.get('cdEmp'),
            'cdConv': json.get('cdConv')
        });

        if (verificaClienteBloqueado.get('stsCred') > 0) {
            throw {
                code: 599,
                message: "Solicitação cancelada, convenio bloqueado!"
            };
        }

        let codigoMotivoSolicitacao = 2; //SEGUNDA VIA
        let verificaCartaoSolicitado = this.mapper.selectList("RcCliFideliCartaoSolic.listarRcCliFideliCartaoSolic", {
            'cdCli': json.get('cdCli'),
            'cdEmp': json.get('cdEmp')
        });

        if (verificaCartaoSolicitado.size() > 0) {
            for (var i = 0; i < verificaCartaoSolicitado.size(); i++) {
                if (verificaCartaoSolicitado.get(i).get('stsSolic') == 0) {
                    throw {
                        code: 599,
                        message: "Solicitação cancelada, cliente já contem solicitação aberta!"
                    };
                }
            }
        } else {
            codigoMotivoSolicitacao = 0; //PRIMEIRA VIA
        }

        let objCartaoSolic = {
            'cdEmp': json.get('cdEmp'),
            'cdCli': json.get('cdCli'),
            'cdMot': codigoMotivoSolicitacao,
            'datPrev': json.get('dataPrev'),
            'cdUsu': json.get('cdUsu'),
            'nrCartao': 0,
            'stsSolic': 0
        }

        if (json.get('tipoUsuario') == 'webconvenio')
            objCartaoSolic.cdUsu = 0;

        let verificaPossuiCartao = this.mapper.selectOne("RcCliFideliCartao.listarRcCliFideliCartao", {
            'cdCli': json.get('cdCli')
        });

        if (verificaPossuiCartao) {
            objCartaoSolic.nrCartao = verificaPossuiCartao.get('nrCartao');
            this.mapper.insert("RcCliFideliCartaoSolic.incluirRcCliFideliCartaoSolic", objCartaoSolic);

            let codigoUsuario = json.get('cdUsu');
            if (json.get('tipoUsuario') == 'webconvenio')
                codigoUsuario = 0;

            this.mapper.update("RcCliFideliCartao.alterarRcCliFideliCartao", {
                'cdEmp': json.get('cdEmp'),
                'cdCli': json.get('cdCli'),
                'stsCartao': 0,
                'senha': '827ccb0eea8a706c4c34a16891f84e7b',
                'cdUsu': codigoUsuario
            });

            this.mapper.update("RcCli.alterarRcCli", {
                'cdEmp': json.get('cdEmp'),
                'cdCli': json.get('cdCli'),
                'senha': '827ccb0eea8a706c4c34a16891f84e7b',
                'cdUsuAlt': codigoUsuario
            });


            if (!json.get('tipoUsuario'))
                logSql.cdProc = 13;

            logSql.tbSql = 'INSERT - RcCliFideliCartaoSolic -' + this.jsonConvert.toJson(objCartaoSolic) + 'UPDATE - RcCliFideliCartao - ' + this.jsonConvert.toJson({
                'cdEmp': json.get('cdEmp'),
                'cdCli': json.get('cdCli'),
                'stsCartao': 0,
                'senha': '827ccb0eea8a706c4c34a16891f84e7b',
                'cdUsu': codigoUsuario
            }) + 'UPDATE - RcCli ' + this.jsonConvert.toJson({
                'cdEmp': json.get('cdEmp'),
                'cdCli': json.get('cdCli'),
                'senha': '827ccb0eea8a706c4c34a16891f84e7b',
                'cdUsuAlt': codigoUsuario
            });

        } else {
            var lastNrCartao = this.mapper.selectOne("WebConvenio.maxFideliCartao", {});
            var nrBinEmp = this.mapper.selectOne("PrcEmp.listarPrcEmp", {
                'cdEmp': json.get('cdEmp')
            });

            var objCartao = {
                'cdEmp': json.get('cdEmp'),
                'cdCli': json.get('cdCli'),
                'stsCartao': 0,
                'nrControleCartao': lastNrCartao.get('nrControle'),
                'cdUsu': json.get('cdUsu'),
                'nrCartao': 0
            }

            if (json.get('tipoUsuario') == 'webconvenio')
                objCartao.cdUsu = 0;

            if (nrBinEmp.get('nrBinCartao') > 0) {
                var nrBinCartao = nrBinEmp.get('nrBinCartao') + "" + java.lang.String.format("%010d", lastNrCartao.get('nrControle')) + "00";
                nrBinCartao += "" + this.modulo10(nrBinCartao);
                objCartaoSolic.nrCartao = nrBinCartao;
                objCartao.nrCartao = nrBinCartao;
                this.mapper.insert("RcCliFideliCartao.incluirRcCliFideliCartao", objCartao);
                this.mapper.insert("RcCliFideliCartaoSolic.incluirRcCliFideliCartaoSolic", objCartaoSolic);
                logSql.tbSql = 'INSERT - RcCliFideliCartaoSolic -' + this.jsonConvert.toJson(objCartaoSolic) + 'INSERT - RcCliFideliCartao - ' + this.jsonConvert.toJson(objCartao);
            } else {
                objCartaoSolic.nrCartao = lastNrCartao.get('nrControle');
                objCartao.nrCartao = lastNrCartao.get('nrControle');
                this.mapper.insert("RcCliFideliCartaoSolic.incluirRcCliFideliCartaoSolic", objCartaoSolic);
                this.mapper.insert("RcCliFideliCartao.incluirRcCliFideliCartao", objCartao);
                logSql.tbSql = 'INSERT - RcCliFideliCartaoSolic -' + this.jsonConvert.toJson(objCartaoSolic) + 'INSERT - RcCliFideliCartao - ' + this.jsonConvert.toJson(objCartao);
            }
        }

        this.mapper.insert("WebAdodbLogsql.incluirWebAdodbLogsql", logSql);

        this.mapper.commit();
        return 'Cartão solicitado com sucesso!';
    } catch (err) {
        java.lang.System.out.println(err);
        this.mapper.rollback();
        //gravaErro(itemValidado,err);
        throw err;
    }
};

GerenciarCartao.prototype.deletarCartao = function (json) {
    try {
        let logSql = {
            'cdUsu': json.get('cdUsuAlt'),
            'tpUsu': 0,
            'cdConv': json.get('cdConv'),
            'cdProc': 14,
            'cdCli': 0,
            'tbSql': ''
        }

        let objWebConvDemite = {
            'cdEmp': 1,
            'cdConv': json.get('cdConv'),
            'cdUsu': null,
            'cdCli': null
        };

        if (json.get('usuario') == 'webconvenio') {
            logSql.tpUsu = 1;
            objWebConvDemite.cdCli = json.get('cdUsuAlt');
        } else {
            objWebConvDemite.cdUsu = json.get('cdUsuAlt');
        }


        let objUpdate = mapperFactory.createMap();
        objUpdate.put('cdEmp', json.get('cdEmp'));
        objUpdate.put('cdConv', json.get('cdConv'));
        objUpdate.put('stsCred', 1);
        objUpdate.put('stsAtivo', 1);
        objUpdate.put('flagConveniadoDemissao', 1);
        objUpdate.put('cdUsuAlt', json.get('cdUsuAlt'));
        objUpdate.put('cdPrecoClasCliente', json.get("cdPrecoClasCliente"));

        this.mapper.insert("WebConvDemite.incluirWebConvDemite", objWebConvDemite);
        let cdConvDemite = this.mapper.selectOne("WebConvDemite.maxDemite", {});
        objWebConvDemite.cdConvDemite = cdConvDemite.get('cdConvDemite');

        for (let i = 0; i < json.get('cdCli').size(); i++) {
            objWebConvDemite.cdCli = json.get('cdCli').get(i);

            this.mapper.update("WebConvUsuRcCliConvRcCli.alterarWebConvUsuRcCliConvRcCli", {
                'cdEmp': 1,
                'cdCli': objWebConvDemite.cdCli,
                'cdConv': json.get('cdConv'),
                'ativo': 0
            });

            this.mapper.insert("WebConvDemiteRcCli.incluirWebConvDemiteRcCli", objWebConvDemite);

            if (json.get('usuario') == 'webconvenio')
                objUpdate.put('cdUsuAlt', 0);

            objUpdate.put('cdCli', json.get('cdCli').get(i));
            if(json.get('flagBloqueiaColaboradorEmMaisDeUmConvenio'))
                objUpdate.put('senha', '81dc9bdb52d04dc20036dbd8313ed055');

            this.mapper.update("RcCli.alterarRcCli", objUpdate);
            this.mapper.update("RcCliConvRcCli.alterarRcCliConvRcCli", objUpdate);
            // DELETAR SOLICITAÇÃO DE CARTAO //
            var cdSolic = this.mapper.selectList("RcCliFideliCartaoSolic.listarRcCliFideliCartaoSolic", {
                'cdCli': json.get('cdCli').get(i),
                'stsSolic': 0
            });

            if (cdSolic.size() > 0) {
                for (let i = 0; i < cdSolic.size(); i++) {
                    this.mapper.insert("RcCliFideliCartaoConfSolic.excluirRcCliFideliCartaoConfSolic", {
                        'cdSolic': cdSolic.get(i).get('cdSolic')
                    });
                }

                this.mapper.insert("RcCliFideliCartaoSolic.excluirRcCliFideliCartaoSolic", {
                    'cdCli': json.get('cdCli').get(i),
                    'stsSolic': 0
                });
            }

            logSql.cdCli = json.get('cdCli').get(i);

            logSql.tbSql = 'UPDATE - RcCli e RcCliConvRcCli' + this.jsonConvert.toJson(objUpdate) +
                'DELETE - RcCliFideliCartaoSolic - ' + this.jsonConvert.toJson({
                    'cdCli': json.get('cdCli').get(i),
                    'stsSolic': 0
                });

            this.mapper.insert("WebAdodbLogsql.incluirWebAdodbLogsql", logSql);
        }

        this.mapper.commit();
        return 'Colaborador demitido com sucesso!'
    } catch (err) {
        java.lang.System.out.println(err);
        this.mapper.rollback();
        throw err;
    }
}

GerenciarCartao.prototype.readmitirColaborador = function (json) {
    try {
        let logSql = {
            'cdUsu': json.get('cdUsuAlt'),
            'tpUsu': 0,
            'cdConv': json.get('cdConv'),
            'cdProc': 15,
            'cdCli': 0,
            'tbSql': ''
        }

        let objUpdate = mapperFactory.createMap();
        objUpdate.put('cdEmp', json.get('cdEmp'));
        objUpdate.put('cdConv', json.get('cdConv'));
        objUpdate.put('stsCred', 0);
        objUpdate.put('stsAtivo', 0);
        objUpdate.put('flagConveniadoDemissao', 0);
        objUpdate.put('cdUsuAlt', json.get('cdUsuAlt'));

        let dateAtual = new Date();
        let dataPrev = dateAtual.getFullYear() + "/" + (dateAtual.getMonth() + 1) + "/" + dateAtual.getDate();
        for (let i = 0; i < json.get('cdCli').size(); i++) {
            for (var e = 0; e < json.get('convDemite').size(); e++) {
                if (json.get('cdCli').get(i) == json.get('convDemite').get(e).get('cdCli')) {
                    this.mapper.update("WebConvDemiteRcCli.alterarWebConvDemiteRcCli", {
                        'cdConvDemite': json.get('convDemite').get(e).get('cdConvDemite'),
                        'dtReadmissao': dataPrev,
                        'cdEmp': 1,
                        'cdCli': json.get('cdCli').get(i)
                    });
                }
            }

            objUpdate.put('cdCli', json.get('cdCli').get(i));
            let cdPrecoClasCliente = this.mapper.selectOne("RcCli.listarRcCli", {
                'cdCli': json.get('cdConvCli')
            });

            objUpdate.put('cdPrecoClasCliente', cdPrecoClasCliente.get('cdPrecoClasCliente'));

            logSql.tbSql = 'UPDATE - RcCli e RcCliConvRcCli -' + this.jsonConvert.toJson(objUpdate);

            if (json.get('tipoUsuario') == 'webconvenio') {
                objUpdate.put('cdUsuAlt', 0);
                logSql.tpUsu = 1;
            }

            this.mapper.update("RcCli.alterarRcCli", objUpdate);

            this.mapper.update("RcCliConvRcCli.alterarRcCliConvRcCli", objUpdate);

            logSql.cdCli = json.get('cdCli').get(i);

            this.mapper.insert("WebAdodbLogsql.incluirWebAdodbLogsql", logSql);
        }

        this.mapper.commit();
        return 'Colaborador readmitido com sucesso!'
    } catch (err) {
        java.lang.System.out.println(err);
        this.mapper.rollback();
        throw err;
    }
}

GerenciarCartao.prototype.modulo10 = function (num) {
    let numtotal10 = 0;
    let fator = 2;
    let numeros = [];
    let parcial10 = [];
    // Separacao dos numeros
    for (i = num.length; i > 0; i--) {
        // pega cada numero isoladamente
        numeros[i] = num.substring(i - 1, 1);
        // Efetua multiplicacao do numero pelo (fator 10)
        var temp = numeros[i] * fator;
        var n = temp.toString();
        let temp0 = n.split('').reduce(function (p, c) {
            return parseInt(p) + parseInt(c);
        }, 0);
        parcial10[i] = temp0; //$numeros[$i] * $fator;
        // monta sequencia para soma dos digitos no (modulo 10)
        numtotal10 += parcial10[i];
        if (fator == 2) {
            fator = 1;
        } else {
            fator = 2; // intercala fator de multiplicacao (modulo 10)
        }
    }
    // Calculo do modulo 10
    resto = numtotal10 % 10;
    digito = 10 - resto;
    if (resto == 0) {
        digito = 0;
    }

    return digito;
};