/**
 * Created by Victor Vieira Garcia on 15/01/2018
 */
var AdministrarConvenio = function () {
    this.mapper = mapperFactory.createMapperMult(["WebConvenio", "RcCliConv", "RcCli", "RcCliConvGlosa", "RcCliConvContato", "GlbCid", "RcCliConvAgdFech"]);
    this.jsonConvert = new com.google.gson.GsonBuilder().create();

};

/**
 * Metodo busca dados administrar Convenio
 * @param {HashMap JAVA} json - parametro passado no momento da requisicao
 * @throws {InvalidArgumentException}
 * @return retorna objeto com dados
 */
AdministrarConvenio.prototype.pesquisaDadosAdministrarConvenio = function (json) {
    if (!json) {
        throw {
            code: 599,
            message: "Dados passados ao servidor inválido!"
        };
    } else {
        json = json.get("obj");
    }

    try {

        let administradoresDeConvenios = this.mapper.selectList("WebConvenio.listarWebConvUsuRcCliConvRcCli", {
            'cdConv': json.get('cdConv'),
            'cdEmp': 1
        });

        let colaboradores = this.mapper.selectList("WebConvenio.listClientesConv", {
            'cdConv': json.get('cdConv'),
            'cdEmp': 1,
            'rzCli': json.get('rzCli')
        });

        let convenio = this.mapper.selectOne("RcCliConv.listarRcCliConv", {
            'cdConv': json.get('cdConv'),
            'cdEmp': 1
        });

        let convenioCliente = this.mapper.selectOne("RcCli.listarRcCli", {
            'cdCli': convenio.get('cdCli'),
            'cdEmp': 1
        });

        let saldoGlosa = this.mapper.selectOne("RcCliConvGlosa.listarRcCliConvGlosa", {
            'cdConv': convenio.get('cdConv'),
            'cdEmp': 1
        });

        let contatos = this.mapper.selectList("RcCliConvContato.listarRcCliConvContato", {
            'cdConv': convenio.get('cdConv'),
            'cdEmp': 1
        });

        let cidade = this.mapper.selectOne("GlbCid.listarGlbCid", {
            'cdCid': parseInt(convenioCliente.get('cdCid'))
        });


        let resposta = {
            'administradoresDeConvenios': administradoresDeConvenios,
            'colaboradores': colaboradores,
            'convenio': convenio,
            'convenioCliente': convenioCliente,
            'saldoGlosa': saldoGlosa,
            'contatos': contatos,
            'dsCid': cidade
        };

        return resposta;
    } catch (err) {
        java.lang.System.out.println(err);
        this.mapper.rollback();
        throw err;
    }
};

AdministrarConvenio.prototype.gerarRelatorioDemitidosComRecSemRec = function (json) {
    if (!json) {
        throw {
            code: 599,
            message: "Dados passados ao servidor inválido!"
        };
    }

    try {
        var resposta = [];
        var convenio = this.mapper.selectOne("RcCliConv.listarRcCliConv", {
            'cdConv': json.get('cdConv'),
            'cdEmp': 1
        });

        for (let i = 0; i < json.get('objCliente').size(); i++) {
            let dataDemissao = new Date(json.get('objCliente').get(i).get('dtDemissao'));
            let diaAgd;

            let agdFech = this.mapper.selectList("RcCliConvAgdFech.listarRcCliConvAgdFech", {
                'cdEmp': 1,
                'cdConv': json.get('cdConv'),
                'dtFechConv': dataDemissao.getFullYear() + '' + (dataDemissao.getMonth() + 1)
            });

            if (agdFech.size() > 0) {
                diaAgd = new Date(agdFech.get(i).get('dtFechAgd'));
                diaFat = dataDemissao.getFullYear() + '/' + (dataDemissao.getMonth() + 1) + '/' + diaAgd.getDate();
            } else {
                var ultimoDiaMes;
                if (convenio.get('diaFat') >= dataDemissao.getDate()) {
                    if (dataDemissao.getMonth() == 0) {
                        diaFat = (dataDemissao.getFullYear() - 1) + '/12' + '/' + convenio.get('diaFat');
                    } else {
                        ultimoDiaMes = new Date(dataDemissao.getFullYear(), dataDemissao.getMonth(), 0);

                        ultimoDiaMes = convenio.get('diaFat') > ultimoDiaMes.getDate() ? ultimoDiaMes.getDate() : convenio.get('diaFat');

                        diaFat = dataDemissao.getFullYear() + '/' + (dataDemissao.getMonth()) + '/' + ultimoDiaMes;
                    }
                } else {
                    ultimoDiaMes = new Date(dataDemissao.getFullYear(), dataDemissao.getMonth() + 1, 0);

                    ultimoDiaMes = convenio.get('diaFat') > ultimoDiaMes.getDate() ? ultimoDiaMes.getDate() : convenio.get('diaFat');

                    diaFat = dataDemissao.getFullYear() + '/' + (dataDemissao.getMonth() + 1) + '/' + ultimoDiaMes;
                }
            }

            var comprasColaborador = this.mapper.selectOne("WebConvenio.relatorioVendasColaborador", {
                'cdEmp': json.get('cdEmp'),
                'cdConv': json.get('cdConv'),
                'dataDemissao': true,
                'diaFat': diaFat,
                'dataDemissao': json.get('objCliente').get(i).get('dataFim'),
                'compColaboradoresStatus': -1,
                'cdCli': json.get('objCliente').get(i).get('cdCli'),
            });

            if (comprasColaborador == null) {
                comprasColaborador = {
                    'cdCli': json.get('objCliente').get(i).get('cdCli'),
                    'rzCli': json.get('objCliente').get(i).get('rzCli'),
                    'matricula': ' ',
                    'VLR_CONV': 0,
                    'VLR_CONV_COM_REC': 0,
                    'VLR_CONV_SEM_REC': 0
                };
            }

            resposta.push(comprasColaborador);
        }

        return resposta;
    } catch (err) {
        java.lang.System.out.println(err);
        this.mapper.rollback();
        throw err;
    }
}