/**
 * Created by willian batista on 30/01/16.
 */
load('/basicos/utilNumber.js');
load('/basicos/utilDate.js');
var PedidoDeCompra = function() {
  this.mapper = mapperFactory.createMapperMult(["EstPedCp", "EstPedCpIt"]);
  this.utilNumber = new UtilNumber();
  this.utilDate = new UtilDate();
};


PedidoDeCompra.prototype.exportarDadosDoPedido = function(json){
	var dados = {'logo':null, 'pedidos':[]};
	var pedidos = this.mapper.selectList('EstPedCp.exportarPedidosDeCompra', json);
	dados.logo = pedidos.get(0).get('logoEmp');
	
	for(var item = 0; item < pedidos.size(); item++){
			if(dados.pedidos.length == 0 || pedidos.get(item).get('filPed') != pedidos.get(item-1).get('filPed') ){
				
					let caixa = pedidos.get(item).get('qtIt');
				
					dados.pedidos.push({
							'cdPed': pedidos.get(item).get('cdPed'),
							'cdFilial': pedidos.get(item).get('cdFilial'),
							'nmFant': pedidos.get(item).get('nmFant'),
							'cnpjFilial': pedidos.get(item).get('cnpjFilial'),
							'cdForn': pedidos.get(item).get('cdForn'),
							'rzForn': pedidos.get(item).get('rzForn'),
							'dsMovOp': pedidos.get(item).get('dsMovOp'),
							'dsCondPgto': pedidos.get(item).get('dsCondPgto'),
							'dsCid': pedidos.get(item).get('dsCid'),
							'uf': pedidos.get(item).get('uf'),
							'dtEmi': pedidos.get(item).get('dtEmi'),
							'endFilial': pedidos.get(item).get('endFililal'),
							'bairro': pedidos.get(item).get('bairro'),
							'cep': pedidos.get(item).get('cep'),
							'totalItensPedidos': parseInt(pedidos.get(item).get('qtIt')),
							'vlrPedido': parseFloat(pedidos.get(item).get('tot')),
							'vlrPedidoBruto': parseFloat(pedidos.get(item).get('totBruto')),
							'vlrBaseIcmsPedido': parseFloat(pedidos.get(item).get('vlrBaseIcms')),
							'vlrIcmsPedido': parseFloat(pedidos.get(item).get('vlrIcms')),
							'vlrBaseSubsPedido': parseFloat(pedidos.get(item).get('vlrBaseSubs')),
							'vlrIcmsSubsPedido': parseFloat(pedidos.get(item).get('vlrIcmsSubs')),
							'vlrIpiPedido': parseFloat(pedidos.get(item).get('vlrIpiProd')),
							'produtos': [{
														'cdProd': pedidos.get(item).get('cdProd'),
														'dsProd': pedidos.get(item).get('dsProd'),
														'nmFabric': pedidos.get(item).get('nmFabric'),
														'dsUn': pedidos.get(item).get('dsUn'),
														'apresEmbCp': pedidos.get(item).get('apresEmbCp'),
														'apresQtCp': pedidos.get(item).get('apresQtCp'),
														'qtIt': caixa,
														'qtCaixa': caixa,
														'percDesc': pedidos.get(item).get('percDesc'),
														'vlrIt': this.utilNumber.formatMoneyJava(pedidos.get(item).get('vlrIt')),
														'vlrIpi': this.utilNumber.formatMoneyJava(pedidos.get(item).get('vlrIpi')),
														'tot': this.utilNumber.formatMoneyJava(pedidos.get(item).get('tot')),
														'aliqIcms': pedidos.get(item).get('aliqIcms')
													}]
					});
					
			}else{
				let caixa = pedidos.get(item).get('qtIt');
				
				dados.pedidos[dados.pedidos.length-1].produtos.push({
							'cdProd': pedidos.get(item).get('cdProd'),
							'dsProd': pedidos.get(item).get('dsProd'),
							'nmFabric': pedidos.get(item).get('nmFabric'),
							'dsUn': pedidos.get(item).get('dsUn'),
							'apresEmbCp': pedidos.get(item).get('apresEmbCp'),
							'apresQtCp': pedidos.get(item).get('apresQtCp'),
							'qtIt': caixa,
							'qtCaixa': caixa,
							'percDesc': pedidos.get(item).get('percDesc'),
							'vlrIt': this.utilNumber.formatMoneyJava(pedidos.get(item).get('vlrIt')),
							'vlrIpi': this.utilNumber.formatMoneyJava(pedidos.get(item).get('vlrIpi')),
							'tot': this.utilNumber.formatMoneyJava(pedidos.get(item).get('tot')),
							'aliqIcms': pedidos.get(item).get('aliqIcms')
				});
				
				dados.pedidos[dados.pedidos.length-1].totalItensPedidos +=  parseInt(pedidos.get(item).get('qtIt'));
				dados.pedidos[dados.pedidos.length-1].vlrPedido += parseFloat(pedidos.get(item).get('tot'));
				dados.pedidos[dados.pedidos.length-1].vlrPedidoBruto += parseFloat(pedidos.get(item).get('totBruto'));
				dados.pedidos[dados.pedidos.length-1].vlrBaseIcmsPedido += parseFloat(pedidos.get(item).get('vlrBaseIcms'));
				dados.pedidos[dados.pedidos.length-1].vlrIcmsPedido += parseFloat(pedidos.get(item).get('vlrIcms'));
				dados.pedidos[dados.pedidos.length-1].vlrBaseSubsPedido += parseFloat(pedidos.get(item).get('vlrBaseSubs'));
				dados.pedidos[dados.pedidos.length-1].vlrIcmsSubsPedido += parseFloat(pedidos.get(item).get('vlrIcmsSubs'));
				dados.pedidos[dados.pedidos.length-1].vlrIpiPedido += parseFloat(pedidos.get(item).get('vlrIpiProd'));
				
			}
	}
	
	dados.pedidos.forEach(function(item){
			
			item.vlrPedidoTotal = (item.vlrPedido + item.vlrIcmsSubsPedido + item.vlrIpiPedido).formatMoneyJS(2, "", ".", ",");
			item.vlrDescPedido = (item.vlrPedidoBruto - item.vlrPedido).formatMoneyJS(2, "", ".", ",");
		
			item.vlrPedido = item.vlrPedido.formatMoneyJS(2, "", ".", ",");
			item.vlrBaseIcmsPedido = item.vlrBaseIcmsPedido.formatMoneyJS(2, "", ".", ",");
			item.vlrIcmsPedido = item.vlrIcmsPedido.formatMoneyJS(2, "", ".", ",");
			item.vlrBaseSubsPedido = item.vlrBaseSubsPedido.formatMoneyJS(2, "", ".", ",");
			item.vlrIcmsSubsPedido = item.vlrIcmsSubsPedido.formatMoneyJS(2, "", ".", ",");
			item.vlrIpiPedido = item.vlrIpiPedido.formatMoneyJS(2, "", ".", ",");
	});
	
	return dados;
	
};


PedidoDeCompra.prototype.exportarPedidoParaCsv = function(json){
	var pedidos = this.mapper.selectList('EstPedCp.exportarPedidosDeCompra', json);
	var cdFilial = 0;
	var codFornPed = '';
	var conteudo = '';
	var contadorItem = 0;
	var contadorProd = 0;
	var totalDesc = 0;
	var totalPed = 0;
	
	for(var item = 0; item < pedidos.size(); item++){
		if(cdFilial != pedidos.get(item).get('cdFilial')){
				cdFilial = pedidos.get(item).get('cdFilial');
				conteudo += '01;';
				conteudo += pedidos.get(item).get('cgc').replace('/','').replace('-','')+';';
				conteudo += pedidos.get(item).get('rzFilial')+';';
				conteudo += pedidos.get(item).get('endFililal')+';';
				conteudo += pedidos.get(item).get('bairro')+';';
				conteudo += pedidos.get(item).get('cep')+';';
				conteudo += pedidos.get(item).get('dsCid')+';';
				conteudo += pedidos.get(item).get('uf')+'\n';
		}
		
		if(codFornPed != ''+pedidos.get(item).get('cdForn')+pedidos.get(item).get('cdPed')){
				conteudo += '02;';
				conteudo += pedidos.get(item).get('cgcCpf').replace('/','').replace('-','')+';';
				conteudo += pedidos.get(item).get('rzForn')+';';
				conteudo += pedidos.get(item).get('cdPed')+';';
				conteudo += this.utilDate.formatDateJava(pedidos.get(item).get('dtEmi'), 'ddMMyyyy')+'\n';
				
				codFornPed = ''+(pedidos.get(item).get('cdForn')+pedidos.get(item).get('cdPed'));
				contadorProd = 0;
				totalDesc = 0;
				totalPed = 0;
		}
		
		contadorItem++;
		contadorProd++;
		
		conteudo += '03;';
		conteudo += pedidos.get(item).get('cdProd')+';';
		conteudo += pedidos.get(item).get('dsProd')+';';
		conteudo += pedidos.get(item).get('dsUn')+';';
		conteudo += pedidos.get(item).get('qtIt')+';';
		conteudo += this.utilNumber.formatMoneyJava(pedidos.get(item).get('vlrIt'))+';';
		
		if(pedidos.get(item).get('percDesc') > 0){
			conteudo += this.utilNumber.formatMoneyJava((pedidos.get(item).get('vlrIt')/pedidos.get(item).get('percDesc'))*100)+';';
			totalDesc += ( pedidos.get(item).get('vlrIt') / pedidos.get(item).get('percDesc') )*100;
		}else{
			conteudo += '0;';
		}
		
		conteudo += this.utilNumber.formatMoneyJava(pedidos.get(item).get('tot'))+'\n';
		totalPed += parseFloat(pedidos.get(item).get('tot'));
		
		if(contadorItem == pedidos.size() || codFornPed != pedidos.get(contadorItem).get('cdForn')+pedidos.get(contadorItem).get('cdPed')){
				conteudo += '4;';
				conteudo += contadorProd+';';
				conteudo += totalDesc+';';
				conteudo += totalPed.formatMoneyJS(2, "", ",", ".")+'\n';
		}
	}
	
	return conteudo;

};


PedidoDeCompra.prototype.gerarPedidoPelaDanfe = function(json){
	if(!json || !json.get('cdUsu') || !json.get('cdEmp') || !json.get('danfes') || json.get('danfes').size() == 0)
		throw {code: 599, message: "Não foi identificado nenhuma danfe provisório para processamento!"};
		
	try{
		let danfesProcessados = [];
		let danfesJaProcessados = [];
			
		for(i = 0; i<json.get('danfes').size(); i++){
			let danfe = json.get('danfes').get(i);
			
			let pedidoGerado = this.mapper.selectList('EstPedCp.listarEstPedCp', {'cdEmp':danfe.get('cdEmp'), 'cdFilial':danfe.get('cdFilial'), 'cdForn':danfe.get('cdForn'), 'cdPedForn':danfe.get('cdPedForn')});
			
			if(pedidoGerado.size() > 0){
				danfe.put('cdPed', pedidoGerado.get(0).get('cdPed'));
				danfesJaProcessados.push(danfe);
			}else{
				danfe.put('cdUsu', json.get('cdUsu'));
				danfe.put('cdEmp', json.get('cdEmp'));
				this.mapper.insert("EstPedCpIt.insertByDanfeProvisorio", danfe);
				pedidoGerado = this.mapper.selectList('EstPedCp.listarEstPedCp', {'cdEmp':danfe.get('cdEmp'), 'cdFilial':danfe.get('cdFilial'), 'cdForn':danfe.get('cdForn'), 'cdPedForn':danfe.get('cdPedForn')});
				danfe.put('cdPed', pedidoGerado.get(0).get('cdPed'));
				danfesProcessados.push(danfe);
			}
		}
		
		if(danfesProcessados.length > 0)
			this.mapper.commit();
		
		return {'danfesProcessados':danfesProcessados, 'danfesJaProcessados':danfesJaProcessados};
		
	}catch(err){
		this.mapper.rollback();
		throw err;
	}	
};