load('/basicos/utilDate.js');
var MelhorCondicaoDeCompra = function() {
    this.mapper = mapperFactory.createMapperMult(["PgFornProcMcc", "PgForn", "EstProdCondCpPgForn", "EstProdCdBarra", "EstProdForn"]);
    this.utilDate = new UtilDate();
};


MelhorCondicaoDeCompra.prototype.validarImportacaoDosFornecedor = function(json){
	
	let dataAtual = this.utilDate.formatDateJava(new java.util.Date(), 'yyyy-MM-dd');
	let historicos = this.mapper.selectList("PgForn.historicoImportacaoMcc", {'cdEmp':json.get('cdEmp'), 'dtIni': dataAtual, 'dtFim':dataAtual});
	
	if(historicos.size() == 0)
		throw {code: 599, message: "Não possui fornecedores configurados para importação automática!"};
		
	for(let i = 0; i<historicos.size(); i++){
		if(historicos.get(i).get("dtProc") == null)
			return false;
	}
	
	return true;
};

MelhorCondicaoDeCompra.prototype.fecharHistoricoMccProcessadas = function(json){
	this.mapper.update("PgFornProcMcc.fecharHistoricoMccProcessadas", json);
};

/**
 * Metodo processar as mcc importadas, as condições importadas ficam gravadas
 * na tabela EST_PROD_COND_CP_PG_FORN, sendo que as pendente de processamento
 * são gravadas na tabela EST_PROD_COND_CP_PG_FORN_VIGENTE.
 * @param {HashMap JAVA} json - parametro passado no momento da requisicao
 * @throws {InvalidArgumentException}
 * @throws {SQLException}
 */
MelhorCondicaoDeCompra.prototype.processarMcc = function(json){
	if(json === null || json.size() === 0)
		 throw {code: 599, message: "Dados passados ao servidor inválido!"};
		 
	try{
		if(json.get("forcarProcessamento") == 1){
			this.mapper.update("PgFornProcMcc.processarImportacaoMcc", {});
			this.fecharHistoricoMccProcessadas(json);
		}else{
			if(this.validarImportacaoDosFornecedor(json)){
				this.mapper.update("PgFornProcMcc.processarImportacaoMcc", {});
				this.fecharHistoricoMccProcessadas(json);
			}
			else
				throw {code: 599, message: "Não foram importados todos os arquivos de mcc de hoje!"};
		}
		
		this.mapper.commit();
	
	}catch(err){
		this.mapper.rollback();
		throw err;
	}
};


MelhorCondicaoDeCompra.prototype.deletarHistoricoDeImportacaoDeMcc = function(json){
	if(json === null || json.size() === 0)
		 throw {code: 599, message: "Dados passados ao servidor inválido!"};
		 
	try{
	
		this.mapper.update("PgFornProcMcc.deletarObservacoesHistoricoDeImportacaoDeMcc", json);
		this.mapper.update("PgFornProcMcc.deletarHistoricoDeImportacaoDeMcc", json);
		this.mapper.commit();
	
	}catch(err){
		this.mapper.rollback();
		throw err;
	}
};


MelhorCondicaoDeCompra.prototype.validarCondicao = function(condicao){
	
	condicao.dtIniVld = this.utilDate.formatDateJava(this.utilDate.parseStringToDateJava(condicao.dtIniVld, 'dd/MM/yyyy'), 'yyyy-MM-dd');
	condicao.dtFimVld = this.utilDate.formatDateJava(this.utilDate.parseStringToDateJava(condicao.dtFimVld, 'dd/MM/yyyy'), 'yyyy-MM-dd');
	condicao.vlrCusto = parseFloat(condicao.vlrCusto);
	condicao.percDesc = parseFloat(condicao.percDesc);
	
	let dh = this.utilDate.formatDateJava(new java.util.Date(), 'yyyy-MM-dd');
	
	if(condicao.dtFimVld < dh || condicao.dtIniVld > condicao.dtFimVld)
		throw "Intervalo de data de vigência inválido";
	
	if(!condicao.dtIniVld)
		throw "Informação da data de inicio da vigência está inválida";
	
	if(!condicao.dtFimVld)
		throw "Informação da data de fim da vigência está inválida";
	
	if(!condicao.vlrCusto)
		throw "Informação do custo do produto está inválida";
	
	if(!condicao.percDesc && condicao.percDesc != 0)
		throw "Informação do desconto do produto está inválida";
	
};


MelhorCondicaoDeCompra.prototype.insertCondicoes = function(condicoes){
	try{
		
		this.mapper.insert('EstProdCondCpPgForn.insertCondicoes', {'condicoes': condicoes});

	}catch(err){
		java.lang.System.out.println(err);
	}
}


MelhorCondicaoDeCompra.prototype.processarLinhas = function(arrayDeLinhas, cdEmp, cdForn){
	let resultado = false;
	let condicoes = [];
	let numMarkers = 7;
		
	for(let i = 0; i<arrayDeLinhas.length; i++){

		if((condicoes.length+1) * numMarkers > 2000){
			this.insertCondicoes(condicoes);
			condicoes = [];
			resultado = true;
			i--;
		}else{
			let arrayDeCampos = arrayDeLinhas[i].split(';');
			if(arrayDeCampos.length == 6){
				try{
					let condicao = {
						'cdEmp': cdEmp,
						'cdForn': cdForn,
						'codigo': arrayDeCampos[0],
						'descricao': arrayDeCampos[1],
						'vlrCusto': arrayDeCampos[2].replace(",", "."),
						'percDesc': arrayDeCampos[3].replace(",", "."),
						'dtIniVld': arrayDeCampos[4],
						'dtFimVld': arrayDeCampos[5],
						'linha': i,
						'cdOrdem': 99,
						'stCondCp': 1,
						'tpCondCp': 0
					};
					
					this.validarCondicao(condicao);
					condicoes.push(condicao);

				}catch(err){
					java.lang.System.out.println(err);
				}
			}	
		}
	}

	if(condicoes.length > 0){
		this.insertCondicoes(condicoes);
		condicoes = [];
		resultado = true;
	}
	
	return resultado;
};


MelhorCondicaoDeCompra.prototype.importarMcc = function(json){
	if(json === null || json.size() === 0)
		throw {code: 599, message: "Dados passados ao servidor inválido!"};	 
	if(json.get('cdForn') == null)
		throw {code: 599, message: "Não foi encontrado o fornecedor para realizar a importação!"};
	if(json.get('conteudo') == null || json.get('conteudo').length == 0 || json.get('conteudo').trim() == '')
		throw {code: 599, message: "Arquivo importado está vazio!"};
	
	let linhasDoArquivo = json.get('conteudo').split('\r\n');
	if(linhasDoArquivo.length == 0)
		throw {code: 599, message: "Nenhuma linha do arquivo foi válida para o layout!"};
		
	let historico = this.mapper.selectOne("PgFornProcMcc.temHistoricoImportadoHoje", json);
	if(historico == 1)
		throw {code: 599, message: "Arquivo já importado para o fornecedor!"};
		
	try{
		let dtImpInico = this.utilDate.formatDateJava(new java.util.Date(), 'yyyy-MM-dd HH:mm:ss');
		
		let resultado = this.processarLinhas(linhasDoArquivo, json.get('cdEmp'), json.get('cdForn'));
		
		let dtImpFim = this.utilDate.formatDateJava(new java.util.Date(), 'yyyy-MM-dd HH:mm:ss');
		
		if(resultado)
			this.mapper.insert('PgFornProcMcc.incluirPgFornProcMcc', {'cdEmp':json.get('cdEmp'), 'cdForn':json.get('cdForn'), 'cdUsu': json.get('cdUsu'), 'stsProc':0, 'dtImpInico':dtImpInico, 'dtImpFim':dtImpFim});
		else
			this.mapper.insert('PgFornProcMcc.incluirPgFornProcMcc', {'cdEmp':json.get('cdEmp'), 'cdForn':json.get('cdForn'), 'cdUsu': json.get('cdUsu'), 'stsProc':0, 'dtImpInico':dtImpInico, 'dtImpFim':dtImpFim});
		
		this.mapper.commit();
		
	}catch(err){
		this.mapper.rollback();
		throw err;	
	}	
};