/**
 * Created by Victor vieira garcia on 04/06/2018
 */
var ImportacaoMediaF = function () {
    this.mappers = mapperFactory.createMapperMult(["GlbScheduleJob", "EstProdCplMediaf", "EstProdCplMediap"]);
    this.jsonConvert = new com.google.gson.GsonBuilder().create();
};

/* sts 0 = arquivo inserido, 1 termino do precessamento, 2 em precossamento, 3 error no processamento */

ImportacaoMediaF.prototype.getArquivo = function () {
    try {
        var cdCtrArquivoProcessar = this.mappers.selectOne("GlbScheduleJob.listarCdCtrProcessar", {'nmSchedule':'IMPORTACAO_MEDIAF'});

        if (cdCtrArquivoProcessar && cdCtrArquivoProcessar.get('cdCtr') > 0) {

            var arquivo64 = this.mappers.selectOne("GlbScheduleJob.listarArquivosMediaF", {
                cdCtr: cdCtrArquivoProcessar.get('cdCtr')
            });

            if (!arquivo64)
                return;

            this.mappers.update("GlbScheduleJob.alterarGlbScheduleJob", {
                'cdCtrArquivo': cdCtrArquivoProcessar.get('cdCtr'),
                'sts': 2
            });

            let json = JSON.parse(arquivo64.get('arquivo'));
            var arr = new java.util.ArrayList();

            for (let i = 0; i < (json.length - 1); i++) {
                arr.add({
                    'cdEmp': json[i].cdEmp,
                    'cdFilial': json[i].cdFilial,
                    'cdProd': json[i].cdProd,
                    'valor': json[i].valor.replace(',','.')
                });
            }

            let cdCtrHeader;
            if (arr.size() > 0) {
                let objReqHeader = mapperFactory.createMap();
                objReqHeader.put('cdUsu', json[json.length - 1].cdUsu);
                objReqHeader.put('dtProc', json[json.length - 1].dtProc);
                objReqHeader.put('cdCtrScheduleJob',cdCtrArquivoProcessar.get('cdCtrJob'));

                this.mappers.insert('EstProdCplMediap.incluirEstProdCplDemandaProcMediaF', objReqHeader);
                cdCtrHeader = objReqHeader.get("cdCtr");

                if (arr.size() < 401) {
                    this.processarAllItens(arr);
                } else {
                    //Validar tamanho de pull de thread
                    let tamanhoPullAllProd = Math.ceil(arr.size() / 400);
                    if ((arr.size() / 400) > 400)
                        tamanhoPullAllProd = 400;

                    let contadorAllProdutos = Math.ceil(arr.size() / tamanhoPullAllProd);

                    let service = java.util.concurrent.Executors.newFixedThreadPool(tamanhoPullAllProd);
                    let futureList = new java.util.ArrayList();

                    for (let i = 0; i < tamanhoPullAllProd; i++) {
                        let parteAllProdutos;
                        if (i == (tamanhoPullAllProd - 1)) {
                            parteAllProdutos = arr.subList(i * contadorAllProdutos, arr.size());
                            let param = {
                                'i': i,
                                'produtos': parteAllProdutos,
                                'obj': this,
                                'call': function () {
                                    this.obj.processarAllItens(this.produtos);
                                }
                            };

                            let callable = new java.util.concurrent.Callable(param);
                            futureList.add(callable);
                        } else {
                            parteAllProdutos = arr.subList(i * contadorAllProdutos, (i * contadorAllProdutos) + (contadorAllProdutos));
                            let param = {
                                'i': i,
                                'produtos': parteAllProdutos,
                                'obj': this,
                                'call': function () {
                                    this.obj.processarAllItens(this.produtos);
                                }
                            };

                            let callable = new java.util.concurrent.Callable(param);
                            futureList.add(callable);
                        }
                    }
                    service.invokeAll(futureList);
                    service.shutdown();
                }
            }

            this.mappers.insert('EstProdCplMediaf.verificaIndex', {});
            
            this.mappers.insert('EstProdCplMediap.incluirEstProdCplDemandaProcCplMediaF', {
                'cdCtr': cdCtrHeader
            });
            
            this.mappers.insert('EstProdCplMediap.incluirEstProdCplDemandaProcCplNaoEncontrado', {
                'cdCtr': cdCtrHeader
            });

            this.mappers.update("GlbScheduleJob.alterarGlbScheduleJob", {
                'cdCtrArquivo': cdCtrArquivoProcessar.get('cdCtr'),
                'sts': 1
            });

            this.mappers.update("EstProdCplMediaf.truncateVerificarProdutos", {});

            this.mappers.commit();
            result = {
                'listaDeProdutosEncontrados': [],
                'listaDeProdutosNaoEncontrados': []
            };
        } else {
            return;
        }
    } catch (err) {
        this.mappers.rollback();

        println(cdCtrArquivoProcessar.get('cdCtr') + ' - 3')
        this.mappers.update("GlbScheduleJob.alterarGlbScheduleJob", {
            'sts': 3,
            'cdCtrArquivo': cdCtrArquivoProcessar.get('cdCtr')
        });

        this.mappers.commit();

        java.lang.System.out.println('====== ERRO =====');
        java.lang.System.out.println(err);
        if (err.code)
            throw JSON.stringify(err);
        else
            throw err;
    }

};

ImportacaoMediaF.prototype.processarAllItens = function (todosProdutos) {
    try {
        let param = {
            'lista': []
        };
        let numMarkers = 0;

        // 5 - tamanho parametros na query, 4 tamanho do item (cdEmp,cdProd,cdFilial,valor);
        for (let i = 0; i < todosProdutos.size(); i++) {

            let item = todosProdutos.get(i);
            if ((numMarkers + 4 + 4) > 2000) {
                this.mappers.selectList('inserirListaImportadaVerificar', param);
                param.lista = [];
                numMarkers = 0;
                i--;
            } else {
                param.lista.push(item);
                numMarkers = numMarkers + 4 + 4;
            }
        }

        if (param.lista.length > 0)
            this.mappers.selectList('inserirListaImportadaVerificar', param);


    } catch (err) {
        println(err);
    }
};