/**
 * Created by willian batista on 01/02/18.
 */
load('/model/produto/Produto.js');
var Arquivo = function(dados) {
  this.mapper = mapperFactory.createMapperMult(["PgFornIntegracaoArqPendente", "PgFornMsgRet"]);
  this.dados = dados;
  this.produto = new Produto();
};

Arquivo.prototype.getMegRet = function(codigo, msgRet){
    if(msgRet == null || msgRet.size() == 0)
        return 'NÃO DEFINIDO';

    for(let c =0; c<msgRet.size(); c++){
        if(msgRet.get(c).get('cdMsgForn') == codigo)
            return msgRet.get(c).get('dsMsgForn');
    }

    return 'NÃO DEFINIDO';
};

Arquivo.prototype.parseLayoutGestaoV3Retorno = function(conteudo, msgRet){
    let pedidos = [];

    //let linhas = conteudo.split('\r\n');
    let linhas = conteudo.replaceAll("\r\n" , "\n").split("\n");
    for(let i=0; i<linhas.length; i++){
        if(linhas[i].substring(4, 6) == '01'){

            let header = {
                'cdFilFornCnpj': linhas[i].substring(6, 20),
                'data': linhas[i].substring(20, 32),
                'cdCtrEnv': linhas[i].substring(32, 38),
                'cdPedForn': linhas[i].substring(39, linhas[i].length())
            };

            pedidos.push({'header': header, 'itens':[], 'footer': null});

        }else if(linhas[i].substring(4, 6) == '02'){
            let item = {
             'dicionarioEan': linhas[i].substring(6, 19),
             'cdProdForn': linhas[i].substring(6, 19).trim().replaceFirst("^0+(?!$)", ""),
             'ean': linhas[i].substring(6, 19),
             'vlrProd': linhas[i].substring(19, 32),
             'qtIt': linhas[i].substring(32, 36),
             'percDesc': linhas[i].substring(36, 45),
             'cdRetorno': linhas[i].substring(45, linhas[i].length()),
             'msgRet': this.getMegRet(linhas[i].substring(45, linhas[i].length()), msgRet),
             'linha': i+1
            };
            pedidos[pedidos.length - 1].itens.push(item);


        }
    }

    return pedidos;
};


Arquivo.prototype.parseLayoutPharmalinkRetorno = function(conteudo){
    let pedidos = [];

    //let linhas = conteudo.split('\r\n');
    let linhas = conteudo.replaceAll("\r\n" , "\n").split("\n");
    for(let i=0; i<linhas.length; i++){
        if(linhas[i].substring(0, 2) == '01'){

            let header = {
                'cnpj': linhas[i].substring(2, 16),
                'cdCtrEnv': linhas[i].substring(16, 24),
                'cdPedForn': linhas[i].substring(24, 32)
            };

            pedidos.push({'header': header, 'itens':[], 'footer': null});

        }else if(linhas[i].substring(0, 2) == '02'){

            pedidos[pedidos.length - 1].header.data = linhas[i].substring(2, 10);

        }else if(linhas[i].substring(0, 2) == '06'){
            let item = {
             'ean': linhas[i].substring(2, 15),
             'qtIt': linhas[i].substring(15, 19),
             'cdRetorno': 'PH'+linhas[i].substring(30, 32),
             'linha': i+1
            };
            pedidos[pedidos.length - 1].itens.push(item);

        }
    }

    return pedidos;
};

Arquivo.prototype.parseLayoutGestaoV4Retorno = function(conteudo){
    let pedidos = [];

    //let linhas = conteudo.split('\r\n');
    let linhas = conteudo.replaceAll("\r\n" , "\n").split("\n");
    for(let i=0; i<linhas.length; i++){
        if(linhas[i].substring(7, 9) == '01'){

            let header = {
                'cdFilForn': linhas[i].substring(9, 23),
                'data': linhas[i].substring(23, 35),
                'cdCtrEnv': linhas[i].substring(35, 49),
                'cdPedForn': linhas[i].substring(50, 64)
            };

            pedidos.push({'header': header, 'itens':[], 'footer': null});

        }else if(linhas[i].substring(7, 9) == '02'){
            let item = {
             'dicionarioEan': linhas[i].substring(9, 22),
             'cdProdForn': linhas[i].substring(9, 22).trim().replaceFirst("^0+(?!$)", ""),
             'ean': linhas[i].substring(9, 22),
             'vlrProd': linhas[i].substring(22, 35),
             'qtIt': linhas[i].substring(35, 39),
             'percDesc': linhas[i].substring(39, 48),
             'linha': i+1
            };
            pedidos[pedidos.length - 1].itens.push(item);

        }
    }

    return pedidos;
};


Arquivo.prototype.parseLayoutWebolRetorno = function(conteudo){
    let pedidos = [];

    //let linhas = conteudo.split('\r\n');
    let linhas = conteudo.replaceAll("\r\n" , "\n").split("\n");
    for(let i=0; i<linhas.length; i++){
        let campos = linhas[i].split(';');

        if(campos[0] == '1'){
            let header = {
                'cdPedForn': campos[1],
                'data': campos[2],
                'cnpj': campos[3],
                'cdCtrEnv': campos[4]
            };

            pedidos.push({'header': header, 'itens':[], 'footer': null});

        }else if(campos[0] == '2'){

            let item = {
                 'ean': campos[1],
                 'qtIt': campos[2],
                 'percDesc': campos[3],
                 'vlrDesc': campos[4],
                 'vlrProd': campos[5],
                 'cdRetorno': campos[6],
                 'qtItNaoAtendido': campos[7],
                 'linha': i+1
            };

            pedidos[pedidos.length - 1].itens.push(item);

        }else if(campos[0] == '3'){
            pedidos[pedidos.length - 1].header.cnpjForn = campos[1];
        }

    }

    return pedidos;
};

Arquivo.prototype.getArquivoDeRetorno = function(arquivo, msgRet){
    if(arquivo.get('fileArqRetorno') == null)
        return [];

    if(arquivo.get('tpLayout') == 9)
        return this.parseLayoutGestaoV3Retorno(arquivo.get('fileArqRetorno'), msgRet);
    else if(arquivo.get('tpLayout') == 10)
        return this.parseLayoutPharmalinkRetorno(arquivo.get('fileArqRetorno'));
    else if(arquivo.get('tpLayout') == 12)
        return this.parseLayoutGestaoV4Retorno(arquivo.get('fileArqRetorno'));
    else if(arquivo.get('tpLayout') == 15)
        return this.parseLayoutWebolRetorno(arquivo.get('fileArqRetorno'));
    else
        return [];

};

Arquivo.prototype.parseLayoutGestaoV3Envio = function(conteudo){
    let pedidos = [];

    //let linhas = conteudo.split('\r\n');
    let linhas = conteudo.replaceAll("\r\n" , "\n").split("\n");
    for(let i=0; i<linhas.length; i++){
        if(linhas[i].substring(4, 6) == '01'){

            let header = {
                'cdFilFornCnpj': linhas[i].substring(6, 20),
                'data': linhas[i].substring(20, 28),
                'hora': linhas[i].substring(28, 32),
                'cdCtrEnv': linhas[i].substring(32, 38),
                'condicao': linhas[i].substring(39, 48),
                'filial': linhas[i].substring(48, 53)
            };

            pedidos.push({'header': header, 'itens':[], 'footer': null});

        }else if(linhas[i].substring(4, 6) == '02'){
            let item = {
             'dicionarioEan': linhas[i].substring(6, 19),
             'cdProdForn': linhas[i].substring(6, 19).trim().replaceFirst("^0+(?!$)", ""),
             'ean': linhas[i].substring(6, 19),
             'qtSaldo': linhas[i].substring(32, 36),
             'linha': i+1
            };
            pedidos[pedidos.length - 1].itens.push(item);

        }
    }

    return pedidos;
};

Arquivo.prototype.parseLayoutPharmalinkEnvio = function(conteudo){
    let pedidos = [];

        //let linhas = conteudo.split('\r\n');
        let linhas = conteudo.replaceAll("\r\n" , "\n").split("\n");
        for(let i=0; i<linhas.length; i++){
            if(linhas[i].substring(0, 1) == '1'){

                let header = {'cnpj': linhas[i].substring(1, 15)};
                pedidos.push({'header': header, 'itens':[], 'footer': null});

            }else if(linhas[i].substring(0, 1) == '2'){

                pedidos[pedidos.length - 1].header.cnpjForn = linhas[i].substring(9, 23);
                pedidos[pedidos.length - 1].header.cdCtrEnv = linhas[i].substring(23, 31);

            }else if(linhas[i].substring(0, 1) == '5'){

                pedidos[pedidos.length - 1].header.data = linhas[i].substring(1, 9);

            }else if(linhas[i].substring(0, 1) == '6'){

                pedidos[pedidos.length - 1].header.hora = linhas[i].substring(1, 7);

            }else if(linhas[i].substring(0, 1) == '7'){
                let item = {
                 'ean': linhas[i].substring(1, 14),
                 'qtSaldo': linhas[i].substring(14, 18),
                 'linha': i+1
                };
                pedidos[pedidos.length - 1].itens.push(item);

            }
        }

        return pedidos;
};

Arquivo.prototype.parseLayoutGestaoV4Envio = function(conteudo){
   let pedidos = [];

   //let linhas = conteudo.split('\r\n');
   let linhas = conteudo.replaceAll("\r\n" , "\n").split("\n");
   for(let i=0; i<linhas.length; i++){
       if(linhas[i].substring(7, 9) == '01'){

           let header = {
               'cdFilForn': linhas[i].substring(9, 23),
               'data': linhas[i].substring(23, 31),
               'hora': linhas[i].substring(31, 35),
               'cdCtrEnv': linhas[i].substring(35, 49),
               'condicao': linhas[i].substring(50, 59),
               'filial': linhas[i].substring(59, 64)
           };

           pedidos.push({'header': header, 'itens':[], 'footer': null});

       }else if(linhas[i].substring(7, 9) == '02'){
           let item = {
            'dicionarioEan': linhas[i].substring(9, 22),
            'cdProdForn': linhas[i].substring(9, 22).trim().replaceFirst("^0+(?!$)", ""),
            'ean': linhas[i].substring(9, 22),
            'qtSaldo': linhas[i].substring(35, 40),
            'linha': i+1
           };
           pedidos[pedidos.length - 1].itens.push(item);

       }
   }

   return pedidos;
};


Arquivo.prototype.parseLayoutWebolEnvio = function(conteudo){
    let pedidos = [];

    //let linhas = conteudo.split('\r\n');
    let linhas = conteudo.replaceAll("\r\n" , "\n").split("\n");
    for(let i=0; i<linhas.length; i++){
        let campos = linhas[i].split(';');

        if(campos[0] == '1'){
            let header = {
                'cnpj': campos[1],
                'email': campos[2],
                'prazo': campos[3],
                'cdCond': campos[4],
                'cdCtrEnv': campos[5]
            };

            pedidos.push({'header': header, 'itens':[], 'footer': null});

        }else if(campos[0] == '2'){

            let item = {
                 'ean': campos[1],
                 'qtSaldo': campos[2],
                 'percDesc': campos[3],
                 'vlrProd': campos[4],
                 'prazo': campos[5],
                 'linha': i+1
            };

            pedidos[pedidos.length - 1].itens.push(item);

        }else if(campos[0] == '3'){
            pedidos[pedidos.length - 1].header.cnpjForn = campos[1];
        }

    }

    return pedidos;
};


Arquivo.prototype.getArquivoDeEnvio = function(arquivo){
    if(arquivo.get('fileArqEnvio') == null)
        return [];

    if(arquivo.get('tpLayout') == 9)
        return this.parseLayoutGestaoV3Envio(arquivo.get('fileArqEnvio'));
    else if(arquivo.get('tpLayout') == 10)
        return this.parseLayoutPharmalinkEnvio(arquivo.get('fileArqEnvio'));
    else if(arquivo.get('tpLayout') == 12)
        return this.parseLayoutGestaoV4Envio(arquivo.get('fileArqEnvio'));
    else if(arquivo.get('tpLayout') == 15)
        return this.parseLayoutWebolEnvio(arquivo.get('fileArqEnvio'));
    else
        return [];

};

/*
@description
Recupera os dados do produto como código e descrição para o array de itens do conteudo do arquivo.

@param arquivo HashMap Java
@param conteudo Array Js
*/
Arquivo.prototype.getDadosDoProduto = function(arquivo, conteudo){
    try{
        if(conteudo == null || conteudo.length == 0 || arquivo == null)
            return;

        if(arquivo.get('tpLayout') == 9 && arquivo.get('utilizaCnpjEan') == 0){
            conteudo[0].itens = this.produto.getDadosDoProdutoByDicionarioDoFornecedor({'cdForn': arquivo.get('cdForn') , 'produtos': conteudo[0].itens});

        }else if(arquivo.get('tpLayout') == 9 && arquivo.get('utilizaCnpjEan') == 1){
            conteudo[0].itens = this.produto.getDadosDoProdutoByEan({'produtos': conteudo[0].itens});

        }else if(arquivo.get('tpLayout') == 10){
            conteudo[0].itens = this.produto.getDadosDoProdutoByEan({'produtos': conteudo[0].itens});

        }else if(arquivo.get('tpLayout') == 12 && arquivo.get('utilizaCnpjEan') == 0){
            conteudo[0].itens = this.produto.getDadosDoProdutoByDicionarioDoFornecedor({'cdForn': arquivo.get('cdForn') , 'produtos': conteudo[0].itens});

        }else if(arquivo.get('tpLayout') == 12 && arquivo.get('utilizaCnpjEan') == 1){
            conteudo[0].itens = this.produto.getDadosDoProdutoByEan({'produtos': conteudo[0].itens});

        }else if(arquivo.get('tpLayout') == 15){
            conteudo[0].itens = this.produto.getDadosDoProdutoByEan({'produtos': conteudo[0].itens});

        }

    }catch(err){
        java.lang.System.out.println('Caso haja alguma exception o conteudo não é alterado e o processo segue o fluxo sem os dados do produto');
        java.lang.System.out.println(err);
    }
};

Arquivo.prototype.getConteudo = function(){
    if(this.dados == null || this.dados.get('cdCtr') == null || this.dados.get('cdEmp') == null || this.dados.get('tipo') == null)
		throw {code: 599, message: "Dados passados ao servidor inválido!"};

	let arquivo = this.mapper.selectOne('PgFornIntegracaoArqPendente.getConteudo', this.dados);
	let msgRet = this.mapper.selectList('PgFornMsgRet.listarPgFornMsgRet', {'cdForn': this.dados.get('cdForn')});
	let conteudo = [];

	if(arquivo == null)
	    return conteudo;

    try{
        if(this.dados.get('tipo') == 1)
            conteudo = this.getArquivoDeRetorno(arquivo, msgRet);
        else
            conteudo = this.getArquivoDeEnvio(arquivo);

        this.getDadosDoProduto(arquivo, conteudo);

        return conteudo;

    }catch(err){
        throw {code: 599, message: "Layout fora do padrão esperado!"};
    }

};
