/**
 * Created by willian batista on 06/01/16.
 */
var AgendaDeCompra = function() {
    this.mapper = mapperFactory.createMapperMult(["EstProdAgendaCompra", "EstProdAgendaCompraAgendamento", "GlbUsuAgenda", "EstProdAgendaCompraAuditoria", "EstProdAgendaCompraPrcFilial",
                                                  "EstProdAgendaCompraEstArvMercLinha", "EstProdAgendaCompraEstArvMercCategoria", "EstProdAgendaCompraEstProdFabric", "EstProdAgendaCompraEstProd",
                                                  "EstProdAgendaCompraPrcBandeira", "EstProdAgendaCompraEstCurva"]);
};


/**
 * Metodo recupera informações da agenda de compra, assim como seus
 * vinculos e dados de auditoria.
 * @param {HashMap JAVA} json - parametro passado no momento da requisicao
 * @throws {InvalidArgumentException}
 * @throws {SQLException}
 */
AgendaDeCompra.prototype.get = function(json){
	if(json === null || json.size() === 0){
		 throw {code: 599, message: "Dados passados ao servidor inválido!"};
	}
	
	var listaAgendaDeCompra = this.mapper.selectList("EstProdAgendaCompra.listarAgendaDeCompra", json);
	var agendasDeCompras = [];

	for(var i=0; i<listaAgendaDeCompra.size(); i++){
		var agendaDeCompraEVinculo = {
				agendaDeCompra: listaAgendaDeCompra.get(i),
				filiais: [],
				linhas:[],
				categorias:[],
				fabricantes:[],
				produtos:[],
				bandeiras:[],
				curvas:[]
		};
		
		var cdCtrAgenda = {'cdCtrAgenda':listaAgendaDeCompra.get(i).get("cdCtrAgenda")};
		
		agendaDeCompraEVinculo.filiais = this.mapper.selectList("EstProdAgendaCompraPrcFilial.listarEstProdAgendaCompraPrcFilialComNomeFantasia", cdCtrAgenda);
		agendaDeCompraEVinculo.linhas =  this.mapper.selectList("EstProdAgendaCompraEstArvMercLinha.listarEstProdAgendaCompraEstArvMercLinhaComDescricao", cdCtrAgenda);
		agendaDeCompraEVinculo.categorias = this.mapper.selectList("EstProdAgendaCompraEstArvMercCategoria.listarEstProdAgendaCompraEstArvMercCategoriaComDescricao", cdCtrAgenda);
		agendaDeCompraEVinculo.fabricantes = this.mapper.selectList("EstProdAgendaCompraEstProdFabric.listarEstProdAgendaCompraEstProdFabricComNomeFabric", cdCtrAgenda);
		agendaDeCompraEVinculo.produtos = this.mapper.selectList("EstProdAgendaCompraEstProd.listarEstProdAgendaCompraEstProdComDescricao", cdCtrAgenda);
		agendaDeCompraEVinculo.bandeiras = this.mapper.selectList("EstProdAgendaCompraPrcBandeira.listarEstProdAgendaCompraPrcBandeira", cdCtrAgenda);
		agendaDeCompraEVinculo.auditorias = this.mapper.selectList("EstProdAgendaCompraAuditoria.listarEstProdAgendaCompraAuditoria", cdCtrAgenda);
		agendaDeCompraEVinculo.curvas = this.mapper.selectList("EstProdAgendaCompraEstCurva.listarEstProdAgendaCompraCurva", cdCtrAgenda);
		
		agendasDeCompras.push(agendaDeCompraEVinculo);
	}
	
	return agendasDeCompras;
};


/**
 * Metodo vincula um novo agendamento para uma agenda de compra, grava na tabela EST_PROD_AGENDA_COMPRA_AGENDAMENTO
 * @param {HashMap Java} agendamento - Objeto passado para ser gravado {cdCtrAgenda, dtAgenda, status}
 * @throws {InvalidArgumentException}
 * @throws {SQLException}
 */
AgendaDeCompra.prototype.vincularAgendamento = function(agendamento){
	if(agendamento === null){
		 throw {code: 599, message: "Dados passados ao servidor inválido!"};
	}
	this.mapper.insert('EstProdAgendaCompraAgendamento.incluirEstProdAgendaCompraAgendamento', agendamento);
};


/**
 * Metodo realiza vinculo entre a agenda de compra e os eventos do usuario apresentados no calendario,
 * esse registro fica gravado na tabela GLB_USU_AGENDA
 * @param {Objeto JS} json - parametro passado no momento da requisicao
 * @throws {InvalidArgumentException}
 * @throws {SQLException}
 */
AgendaDeCompra.prototype.vincularAoCalendarioDoUsuario = function(agendaUsuario){
	if(agendaUsuario === null){
		 throw {code: 599, message: "Dados passados ao servidor inválido!"};
	}
	this.mapper.insert('GlbUsuAgenda.incluirGlbUsuAgenda', agendaUsuario);
};


/**
 * Metodo realiza insert de uma agenda de compra na tabela EST_PROD_AGENDA_COMPRA,
 * grava tambem os dados sobre a movimentação desse agendamento na EST_PROD_AGENDA_COMPRA_AGENDAMENTO,
 * por fim, caso a agenda seja diferente de ressuprimento, manda gravar uma agenda de usuario vinculado a compra na GLB_USU_AGENDA.
 * @param {HashMap JAVA} json - parametro passado no momento da requisicao
 * @throws {InvalidArgumentException}
 * @throws {SQLException}
 */
AgendaDeCompra.prototype.post = function(json){
	if(json === null || json.size() === 0){
		 throw {code: 599, message: "Dados passados ao servidor inválido!"};
	}
	
	try{
		json.put("stsAgenda", 0);
		this.mapper.insert('EstProdAgendaCompra.incluirEstProdAgendaCompra', json);
		
		var agendamento = mapperFactory.createMap();
		agendamento.put('cdCtrAgenda', json.get("cdCtrAgenda"));
		agendamento.put('dtAgenda', json.get("dtAgendamentoDefault"));
		agendamento.put('status', 0);
		this.vincularAgendamento(agendamento);
		
		if(json.get("tipoAgenda") != 2){	
				var agendaUsuario = {
						'cdUsu':json.get("cdUsu"),
						'title': 'AGENDA DE COMPRA ' + json.get("dsAgendamento"),
						'color' : '#00cc00',
						'start' : json.get("dtAgendamentoDefault"),
						'end' : json.get("dtAgendamentoDefault"),
						'url': 'app.compras.demanda',
						'parametros': 'cdEmp: ' + json.get("cdEmp") + ' ,cdCtrAgenda: ' + json.get("cdCtrAgenda"),
						'allDay': '1',
						'eventBloqEdicaoAnteriormente': '0',
						'editable': '1',
						'dtCad': json.get("dtCad"),
						'cdCtrAgenda':json.get("cdCtrAgenda")
				};
			
				this.vincularAoCalendarioDoUsuario(agendaUsuario);
		}
		
		this.mapper.commit();
	}catch(err){
		this.mapper.rollback();
		throw err;
	}

};


/**
 * Metodo realiza inserção de auditoria quando modificado uma agenda de compra
 * @param {Objeto JS} json - parametro passado no momento da requisicao
 * @throws {InvalidArgumentException}
 * @throws {SQLException}
 */
AgendaDeCompra.prototype.persistirAuditoriaAgendaDeCompra = function(json){
	if(json === null){
		 throw {code: 599, message: "Dados passados ao servidor inválido!"};
	}

	let mapper =  mapperFactory.createMapperMult(['EstProdAgendaCompra']);
	let agendaDeCompra = mapper.selectOne('EstProdAgendaCompra.listarEstProdAgendaCompra', {"cdCtrAgenda":json.get("cdCtrAgenda")});

	agendaDeCompra.put('justificativa', json.get('justificativa'));
	if(agendaDeCompra.get('cdUsuAlt') == null ||  agendaDeCompra.get('cdUsuAlt') == 0)
        agendaDeCompra.put('cdUsuAlt', json.get('cdUsuAlt'));

	this.mapper.insert('EstProdAgendaCompraAuditoria.incluirEstProdAgendaCompraAuditoria', agendaDeCompra);
};


/**
 * Metodo altera uma agenda de compra na EST_PROD_AGENDA_COMPRA,
 * caso a agenda de compa seja  de ressuprimento ocorre apenas a alteração dos dados da agenda de compra,
 * caso a agenda for de tipo diferente de ressuprimento e esteja sendo inativada a
 * movimentação de agendamento também será inativada na EST_PROD_AGENDA_COMPRA_AGENDAMENTO,
 * e agenda do usuario vinculada na GLB_USU_AGENDA é deletada,
 * caso a agenda de compra continue sendo ativa ocorre o mesmo passa anterior porem,
 * um novo agendamento e uma nova agenda de usuario é gravada.
 * @param {HashMap JAVA} json - parametro passado no momento da requisicao
 * @throws {InvalidArgumentException}
 * @throws {SQLException}
 */
AgendaDeCompra.prototype.put = function(json){
	if(json === null || json.size() === 0){
		 throw {code: 599, message: "Dados passados ao servidor inválido!"};
	}
	
	try{
			this.persistirAuditoriaAgendaDeCompra(json);
			this.mapper.update('EstProdAgendaCompra.alterarEstProdAgendaCompra', json);
			if((json.get('stsAgenda') == 1 && json.get('tipoAgenda') != 2) || json.get('tipoAgenda') == 2){//AGENDA DIFERENTE DE RESSUPRIMENTO E INATIVADA OU AGENDA DE RESSUPRIMENTO
				
				this.mapper.update('EstProdAgendaCompraAgendamento.inativarEstProdAgendaCompraAgendamento', {'cdCtrAgenda':json.get('cdCtrAgenda')});
				this.mapper.update('GlbUsuAgenda.excluirGlbUsuAgenda', {'cdCtrAgenda':json.get('cdCtrAgenda')});
				
			}else if(json.get('stsAgenda') == 0 && json.get('tipoAgenda') != 2){//AGENDA DIFERENTE DE RESSUPRIMENTO ATIVADA
				
				this.mapper.update('EstProdAgendaCompraAgendamento.inativarEstProdAgendaCompraAgendamento', {'cdCtrAgenda':json.get('cdCtrAgenda')});
				this.mapper.update('GlbUsuAgenda.excluirGlbUsuAgenda', {'cdCtrAgenda':json.get('cdCtrAgenda')});
				
				var agendamento = mapperFactory.createMap();
				agendamento.put('cdCtrAgenda', json.get("cdCtrAgenda"));
				agendamento.put('dtAgenda', json.get("dtAgendamentoDefault"));
				agendamento.put('status', 0);
				
				this.vincularAgendamento(agendamento);
				
				var agendaUsuario = {
						'cdUsu':json.get("cdUsu"),
						'title': 'AGENDA DE COMPRA ' + json.get("dsAgendamento"),
						'color' : '#00cc00',
						'start' : json.get("dtAgendamentoDefault"),
						'end' : json.get("dtAgendamentoDefault"),
						'url': 'app.compras.demanda',
						'parametros': 'cdEmp: ' + json.get("cdEmp") + ' ,cdCtrAgenda: ' + json.get("cdCtrAgenda"),
						'allDay': '1',
						'eventBloqEdicaoAnteriormente': '0',
						'editable': '1',
						'dtCad': json.get("dtCad"),
						'cdCtrAgenda':json.get("cdCtrAgenda")
				};
				this.vincularAoCalendarioDoUsuario(agendaUsuario);
				
			}
			
			this.mapper.commit();
	}catch(err){
		this.mapper.rollback();
		throw err;
	}

};


/**
 * Metodo realiza alteração na data da agenda pela interção do usuario no calendario
 * @param {HashMap Java} json - parametro passado no momento da requisicao
 * @throws {InvalidArgumentException}
 * @throws {SQLException}
 */
AgendaDeCompra.prototype.alterarAgendaDeCompraPeloCalendario = function(json){
	if(json === null || json.get("cdCtrAgenda") === null){
		 throw {code: 599, message: "Dados passados ao servidor inválido!"};
	}
	
	let agendaDeCompra = this.mapper.selectOne('EstProdAgendaCompra.listarEstProdAgendaCompra', {"cdCtrAgenda":json.get("cdCtrAgenda")});

	let sdf = new java.text.SimpleDateFormat('yyyy-MM-dd');
    let diaDaSemanaNovo = sdf.parse(json.get("start"));

    let sdf2 = new java.text.SimpleDateFormat("EEEE MMM d HH:mm:ss z yyyy", java.util.Locale.US);
    let diaDaSemanaAtual = sdf2.parse(agendaDeCompra.get("dtAgendamentoDefault"));

    switch(diaDaSemanaAtual.getDay()){
        case 0:
            agendaDeCompra.put('domingo', 0);
            break;
        case 1:
            agendaDeCompra.put('segunda', 0);
            break;
        case 2:
            agendaDeCompra.put('terca', 0);
            break;
        case 3:
            agendaDeCompra.put('quarta', 0);
            break;
        case 4:
            agendaDeCompra.put('quinta', 0);
            break;
        case 5:
            agendaDeCompra.put('sexta', 0);
            break;
        case 6:
            agendaDeCompra.put('sabado', 0);
            break;
        default:
            break;
        }

	switch(diaDaSemanaNovo.getDay()){
        case 0:
            throw {code: 599, message: "Dia do próximo agendamento inválido. Não é possivel programar agendas para os sábados!"};
            break;
        case 1:
            agendaDeCompra.put('segunda', 1);
            break;
        case 2:
            agendaDeCompra.put('terca', 1);
            break;
        case 3:
            agendaDeCompra.put('quarta', 1);
            break;
        case 4:
            agendaDeCompra.put('quinta', 1);
            break;
        case 5:
            agendaDeCompra.put('sexta', 1);
            break;
        case 6:
            throw {code: 599, message: "Dia do próximo agendamento inválido. Não é possivel programar agendas para os domingos!"};
            break;
        default:
            break;
    }

    agendaDeCompra.put("cdUsuAlt",json.get("cdUsuAlt"));
    agendaDeCompra.put("justificativa",json.get("justificativa"));
    agendaDeCompra.put("dtAgendamentoDefault",json.get("start"));

	this.put(agendaDeCompra);
};