load('/model/erro/admErroCadBasicosIntegracoes.js');
load("/rules/cliente/validaDados.js");
load("/rules/convenio/validaDados.js");

var Cliente = function () {
    this.validaCliente = new ValidaCliente();
    this.validaConvenio = new ValidaConvenio();
    this.gravaErro = new AdmErroIntegracoes();
    this.jsonConvert = new com.google.gson.GsonBuilder().create();
    this.mapper = mapperFactory.createMapperMult(["RcCli", "RcCliConvRcCli", "RcCliCrediario"]);
    this.i           = 0;
};

/**
 * Metodo faz controle das inserções a serem feitas
 * @param {HashMap JAVA} json - parametro passado no momento da requisicao
 * @throws {InvalidArgumentException}
 * @return retorna um array de Objeto com os dados que foram inseridos
 */
Cliente.prototype.insereRegistro = function (json) {
    if (!json) {
        throw {code: 599, message: "Dados passados ao servidor inválido!"};
    }
    if (json.get("obj")) {
        var obj = json.get("obj");
    } else {
        var obj = mapperFactory.createMap();
        obj.put(0, json);
    }

    try {
        for (this.i = 0; this.i < obj.size(); this.i++) {
            var item         = obj.get(this.i);
            var itemValidado = this.validaCliente.validaDadosParaCadastro(item);
            this.inserirCliente(itemValidado);
            if (item.get("espCli")) {
                switch (parseInt(item.get("espCli"))) {
                    case 1:
                        this.inserirCrediario(item);
                        break;
                    case 2:
                        this.inserirConvenio(item);
                        break;
                }
            }
            if(itemValidado.get("importador") == 1 ){
    						this.gravaSucesso(itemValidado);
    				}
    		}
    		this.mapper.commit();
    		
    		if(obj.size() == 1){
    			return obj.get(0).get("cdCli");
    		}else{
    			return obj;
    		}
    
    } catch (err) {
        java.lang.System.out.println(err);
        this.mapper.rollback();
        //gravaErro(itemValidado,err);
        if (err.code) {
            throw JSON.stringify(err);
        }
        throw "{erro:true,  message:'" + escape(err) + "'}";
    }
};

Cliente.prototype.gravaSucesso = function (json) {
        var metodo = 'POST';
        var msgErro = {};
        msgErro.id            = parseInt(json.get("cdCli"));
        msgErro.tabela        = 'RC_CLI';
        msgErro.jsonEnviado   = this.jsonConvert.toJson(json);
        msgErro.stsErro       = 1; // Importado com sucesso
        msgErro.cdUsuCorrecao = 0;
        msgErro.laudo         = 'Cliente ' + json.get("cdCli") + ' inserido com sucesso.';
        this.gravaErro.gerenciaErro(metodo, msgErro);
    };

Cliente.prototype.gravaErro = function (json,err) {
        java.lang.System.out.println('itemValidado ' + itemValidado);
        var metodo = 'POST';
        var msgErro = {};
        msgErro.id            = json.get("cdCli") || 0;
        msgErro.tabela        = 'RC_CLI';
        msgErro.jsonEnviado   = this.jsonConvert.toJson(json);
        msgErro.stsErro       = 2; // Erro
        msgErro.cdUsuCorrecao = 0;
        msgErro.laudo         = this.jsonConvert.toJson(err);
        this.gravaErro.gerenciaErro(metodo, msgErro);
    };

Cliente.prototype.inserirCliente = function (json) {
        this.mapper.insert("RcCli.incluirRcCli", json);
    };

Cliente.prototype.inserirCrediario = function (json) {
        var variaveis                 = {};
        variaveis.cdEmp           = json.get("cdEmp");
        variaveis.cdCli           = json.get("cdCli");
        variaveis.vlrLimCred      = json.get("vlrLimCred");
        variaveis.diaFechaCred    = 0;
        variaveis.diaVenctoCred   = 0;
        variaveis.stsCred         = json.get("stsCred");
        variaveis.vlrDebCred      = 0;
        variaveis.vlrLimParcCred  = 0;
        variaveis.cdMdlVd         = json.get("cdMdlVd");
        variaveis.flagNGeraFat    = 0;
        variaveis.flagNCartaCob   = 0;
        variaveis.flagNTelCob     = 0;
        variaveis.diasCarenAtraso = 0;
        variaveis.diasCarenBloq   = 0;
        variaveis.cdMotBloqCli    = 0;
        variaveis.vlrDebParcCred  = 0;
        variaveis.vlrDebFatCred   = 0;
        variaveis.vlrLimFatCred   = 0;
        today                     = new Date();
        dd                        = today.getDate();
        mm                        = today.getMonth() + 1; //January is 0!
        yyyy                      = today.getFullYear();
        if (dd < 10) {
            dd = '0' + dd;
        }
        if (mm < 10) {
            mm = '0' + mm;
        }
        hoje                  = yyyy + '/' + mm + '/' + dd;
        variaveis.dtProxFecha = hoje;
        variaveis.dtUltFecha  = hoje;

        this.mapper.insert("RcCliCrediario.incluirRcCliCrediario", variaveis);
    };

Cliente.prototype.inserirConvenio = function (json) {
        var variaveis       = mapperFactory.createMap();
        variaveis.put("cdEmp", json.get("cdEmp"));
        variaveis.put("cdCli", json.get("cdCli"));
        variaveis.put("cdConv", json.get("cdConv"));
        variaveis.put("vlrCred", json.get("vlrCred"));
        variaveis.put("matricula", json.get("matricula"));
        variaveis.put("stsCred", json.get("stsCred"));
        variaveis.put("vlrDeb", 0);
        variaveis.put("cdUsuAlt", 0);
        variaveis.put("cdPlanoVenda", json.get("cdPlanoVenda"));
    
        var variaveisValidas = this.validaConvenio.conveniadoDadosDefault(variaveis);
        this.mapper.insert("RcCliConvRcCli.incluirRcCliConvRcCli", variaveisValidas);

    };
