/**
 * Created by willian batista on 13/03/17.
 */
 var ControleDeAcesso = function() {
    this.mapper = mapperFactory.createMapperMult(["ControleDeAcesso", "RcCli"]);
};

ControleDeAcesso.prototype.definirAcessoGrupoDeUsuario = function(json){
	try{
	
			var funcionalidadesCorrente = this.mapper.selectList('ControleDeAcesso.listarFuncionalidadesPorGrupoDeUsuarioIndividual', {'cdGrp': json.get('cdGrp')});
			if(funcionalidadesCorrente.size() === 0 && json.get('funcionalidades').size() > 0){//INSERIR FUNCIONALIDADES PASSDAS PELA REQUISICAO AO GRUPO
				this.mapper.insert('ControleDeAcesso.alterarControleDeAcessoPorGrupoDeUsuario', {'cdGrp': json.get('cdGrp'), 'inserir': json.get('funcionalidades')});
			}
			else if(funcionalidadesCorrente.size() > 0 && json.get('funcionalidades').size() === 0){//REMOVER FUNCIONALIDADE JÀ EXISTENTES AO GRUPO
				this.mapper.update('ControleDeAcesso.excluirControleDeAcessoPorGrupoDeUsuario', {'cdGrp': json.get('cdGrp'), 'remover': funcionalidadesCorrente});
			}
			else{
				
				for(var i = 0; i<funcionalidadesCorrente.size(); i++){
					for(var j = 0; j<json.get('funcionalidades').size(); j++){
							if(funcionalidadesCorrente.get(i).get('cdCtr') == json.get('funcionalidades').get(j).get('cdCtr')){
								funcionalidadesCorrente.remove(i);
								json.get('funcionalidades').remove(j);
								i--;
								j--;
								break;
							}
					}
				}
				
				if(funcionalidadesCorrente.size()>0)//REMOVER ITENS
					this.mapper.update('ControleDeAcesso.excluirControleDeAcessoPorGrupoDeUsuario', {'cdGrp': json.get('cdGrp'), 'remover': funcionalidadesCorrente});
				
				if(json.get('funcionalidades').size()>0)//INSERIR ITENS
					this.mapper.insert('ControleDeAcesso.alterarControleDeAcessoPorGrupoDeUsuario', {'cdGrp': json.get('cdGrp'), 'inserir': json.get('funcionalidades')});
			}
			
			this.mapper.commit();
			
	}catch(err){
		this.mapper.rollback();
		throw err;
	}
};

ControleDeAcesso.prototype.getMenuPadrao = function(){
	let menus = {
		'dashBoard':0,
		'dashBoardVendas':0,
		'dashBoardNotaFiscal':0,

		'cadastro':0,
		'cadastroEmpresa':0,
		'cadastroFabricante':0,
		'cadastroFilial':0,
		'cadastroFornecedor':0,
		'cadastroFornecedorCadastro':0,
		'cadastroFornecedorDicionario':0,
		'cadastroProduto':0,
		'cadastroProdutoAtributo':0,
		'cadastroProdutoArvoreMercadologica':0,
		'cadastroProdutoMotivoStatus':0,
		'cadastroProdutoPrincipioAtivo':0,
		'cadastroProdutoCadastro':0,
		'cadastroImportador':0,
		'cadastroImportadorFornecedor':0,

		'compras':0,
		'comprasCadastro':0,
		'comprasCadastroParametro':0,
		'comprasCadastroParametroEletronico':0,
		'comprasCadastroParametroEletronicoParametro':0,
		'comprasCadastroParametroEletronicoRoteiro':0,
		'comprasCadastroParametroMediaf': 0,
		'comprasCadastroParametroMediaPFacFinLim':0,
		'comprasCadastroParametroDetalhamentoMediaP':0,
		'comprasCadastroParametroCurva':0,
		'comprasCadastroParametroReforcoReducao':0,
		'comprasCadastroParametroReforcoReducaoGerar':0,
		'comprasCadastroParametroPerfilDeLoja':0,
		'comprasCadastroParametroPerfilDeLojaCadastro':0,
		'comprasCadastroParametroPerfilDeLojaVinculo':0,
		'comprasCadastroParametroPercVariacaoDemanda':0,
		'comprasComprador':0,
		'comprasAgenda':0,
		'comprasAlcada':0,
		'comprasDemanda':0,
		'comprasDemandaGerar':0,
		'comprasDemandaConsulta':0,
		'comprasPedidoDeCompra':0,
		'comprasPedidoEletronico':0,
		'comprasPedidoEletronicoAtivacao':0,
		'comprasPedidoEletronicoAcompanhamento':0,
		'comprasPedidoEletronicoImportacaoMcc':0,
		'comprasCotacao':0,
		'comprasCotacaoRemessaRetorno':0,
		'comprasEncomenda':0,
		'comprasEncomendaGerar':0,
		'comprasEncomendaConsultar':0,
		'comprasRelatorio':0,
		'comprasRelatorioCompraXVendas':0,
		'comprasRelatorioMapaFabricante':0,
		'comprasRelatorioAuditoriaDeDemanda':0,
		'comprasRelatorioAnaliseRessuprimento':0,
		'comprasRelatorioCalendarioEntrega':0,
		'comprasRelatorioAnaliseDeVenda':0,
		'comprasRelatorioAnaliseDeVendaGeral':0,
		'comprasRelatorioAnaliseDeVendaLojaXTelevendas':0,
		'comprasRelatorioAnaliseDeFalta':0,
		'comprasRelatorioAnaliseDeExcesso':0,

		'configuracao':0,
		'configuracaoControleDeAcesso':0,
		'configuracaoEnvioEmail': 0,

		'atualizacao':0,
		'atualizacaoProduto':0,

		'arquivos':0,
		'arquivosImportar':0,
		'arquivosConsultarImportacao':0,
		'arquivosPmcPmd':0,

		'convenio':0,
		'convenioCadastro':0,
		'convenioCadastroConvenio':0,
		'convenioRelatorio':0,
		'convenioRelatorioCompras':0,
		'convenioRelatorioCartoesSolicitados':0,
		'convenioRelatorioFidelidade':0,
		'convenioRelatorioLogs':0,
		'convenioArquivo':0,
		'convenioDuplicatas':0,
		'convenioXmlDanfe':0,

		'movimentacoes':0,
		'movimentacoesIntegracao':0,
		'movimentacoesIntegracaoCupomFiscal':0,
		'movimentacoesIntegracaoNotaFiscal':0,
		'movimentacoesIntegracaoPosConnect':1,
		'movimentacoesIntegracaoSuperTroco':0,
		'movimentacoesEntrada':0,
		'movimentacoesEntradaCheckIn':0,
		'movimentacoesCupomFiscal':0,
		'movimentacoesPendencia':0,
		'movimentacoesLancamentoDeVendas':0,

		'sngpc':0,
		'sngpcPainel':0,
		'sngpcPendencia':0,
		'sngpcPendenciaManutencaoDePendencia':0,
		'sngpcFarmaceutico':0,
		'sngpcRegistrar':0,
		'sngpcRegistrarInventarioInicial':0,
		'sngpcRegistrarMedicos':0,
		'sngpcRelatorio':0,
		'sngpcRelatorioMovimentacaoAnvisa':0,
		'sngpcRelatorioBalancoEstoque':0,

		'precificacao':0,
		'precificacaoParametro':0,
		'precificacaoParametroImportacaoPmcPmd':0,
		'precificacaoParametroMetaMargemBruta':0,
		'precificacaoPendencia':0,
		'precificacaoPendenciaPrecoDeVenda':0,
		'precificacaoRelatorio':0,
		'precificacaoRelatorioDetalhamentoAtulizacaoDePreco':0,
		'precificacaoRelatorioPrecoDeVenda':0,

		'agendaDeUsuario': 1,
		'alteracaoDeSenha': 0,
		'bloqueioTemporario': 0,

		'iqvia': 0,

		'fidelidade':1,
	    'fidelidadeDOTZ':1,
	    'fidelidadeDOTZconfiguracao':1,
	    'fidelidadeDOTZconfiguracaoprodutos':1,
	    'fidelidadeDOTZconfiguracaoprodutosanonimizados':1,
	    'fidelidadeDOTZcontasapagar':1,
	    'fidelidadeDOTZcontasareceber':1,
	    'fidelidadeDOTZarquivossku':1,
	    'fidelidadePROPZ':1,
		'selfcheckout':0,

		'financeiro': 1,
		'financeiroContaDigitalIntegrada': 1,
		'financeiroContaDigitalIntegradaContaBancaria': 1,
		'contaDigitalCriarConta': 0,
		'contaDigitalVincularConta': 0,
		'contaDigitalConsultaExtrato': 0,
		'contaDigitalVincularCarteiraCobranca': 0,
		'contaDigitalAtivarDesativarDDA': 0,
		'contaDigitalVincularRegistroTaxaDeLiquidacao': 0,

		'ecommerce': 0,
		'ecommerceConfiguracao': 0,
		'ConfLogistica': 0,
		'ecommerceCadastroProdutos': 0,
		'promocoes': 0,

		'integracoes' : 0,
		'integracoesEdelivery': 0,
		'integracoesEdeliveryConfiguracao': 0,
		'integracoesEdeliveryPainelEnvio': 0,
		'integracoesOpencashback': 1,		
		
		'controleDeAcessos':0,
		'controleDeAcessosGestao':0,
		'controleDeAcessosLog':0,
		'controleDeAcessosGestaoCadastro':0,
		'controleDeAcessosGestaoRelatorio':0,

		'cadastroCliente':1,
		'cadastroClienteConfiguracaoLGPD':1,

		'financeiroPortalFinanceiro':0,

		'carimboDigital':0,

		'conciliacao':1,
		'conciliacaoVendas':1,
		'conciliacaoPagamentos':1,
		'conciliacaoEqualsConf':1

	};
	return menus;
};

ControleDeAcesso.prototype.getMenus = function(permissoes){

	let menus = this.getMenuPadrao();
	
	for(let i = 0; i<permissoes.size(); i++){
		switch(java.lang.Integer.parseInt(permissoes.get(i).get('cdCtr').toString())){
			case 1:
				menus.dashBoard = 1;
				menus.dashBoardVendas = 1;
				break;
			case 4:
				menus.dashBoard = 1;
				menus.dashBoardNotaFiscal = 1;
				break;
			case 5:
			case 6:
				menus.cadastro = 1;
				menus.cadastroEmpresa = 1;
				menus.cadastroFabricante = 1;
				break;
			case 7:
			case 8:
				menus.cadastro = 1;
				menus.cadastroEmpresa = 1;
				menus.cadastroFilial = 1;
				break;
			case 9:
			case 10:
				menus.cadastro = 1;
				menus.cadastroEmpresa = 1;
				menus.cadastroFornecedor = 1;
				menus.cadastroFornecedorCadastro = 1;
				menus.cadastroFornecedorDicionario = 1;
				break;
			case 11:
			case 12:
				menus.compras = 1;
				menus.comprasCadastro = 1;
				menus.comprasComprador = 1;
				break;
			case 13:
			case 14:
				menus.cadastro = 1;
				menus.cadastroProduto = 1;
				menus.cadastroProdutoAtributo = 1;
				menus.cadastroProdutoArvoreMercadologica = 1;
				break;
			case 17:
			case 18:
				menus.cadastro = 1;
				menus.cadastroProduto = 1;
				menus.cadastroProdutoAtributo = 1;
				menus.cadastroProdutoPrincipioAtivo = 1;
				break;
			case 19:
			case 20:
				menus.cadastro = 1;
				menus.cadastroProduto = 1;
				menus.cadastroProdutoCadastro = 1;
				break;
			case 22:
			case 23:
				menus.compras = 1;
				menus.comprasCadastro = 1;
				menus.comprasCadastroParametro = 1;
				menus.comprasCadastroParametroEletronico = 1;
				menus.comprasCadastroParametroEletronicoParametro = 1;
				break;
			case 24:
			case 25:
				menus.compras = 1;
				menus.comprasCadastro = 1;
				menus.comprasCadastroParametro = 1;
				menus.comprasCadastroParametroEletronico = 1;
				menus.comprasCadastroParametroEletronicoRoteiro = 1;
				break;
			case 26:
			case 27:
				menus.compras = 1;
				menus.comprasCadastro = 1;
				menus.comprasCadastroParametro = 1;
				menus.comprasCadastroParametroMediaf= 1;
				break;
			case 28:
			case 29:
				menus.compras = 1;
				menus.comprasCadastro = 1;
				menus.comprasCadastroParametro = 1;
				menus.comprasCadastroParametroMediaPFacFinLim= 1;
				break;
			case 30:
			case 31:
				menus.compras = 1;
				menus.comprasCadastro = 1;
				menus.comprasCadastroParametro = 1;
				menus.comprasCadastroParametroCurva = 1;
				break;
			case 32:
			case 33:
				menus.compras = 1;
				menus.comprasCadastro = 1;
				menus.comprasCadastroParametro = 1;
				menus.comprasCadastroParametroPerfilDeLoja = 1;
				menus.comprasCadastroParametroPerfilDeLojaCadastro = 1;
				menus.comprasCadastroParametroPerfilDeLojaVinculo = 1;
				break;
			case 34:
				menus.compras = 1;
				menus.comprasCadastro = 1;
				menus.comprasCadastroParametro = 1;
				menus.comprasCadastroParametroPerfilDeLoja = 1;
				menus.comprasCadastroParametroPerfilDeLojaVinculo = 1;
				break;
			case 35:
			case 36:
				menus.compras = 1;
				menus.comprasCadastro = 1;
				menus.comprasAgenda = 1;
				break;
			case 37:
				menus.compras = 1;
				menus.comprasDemanda = 1;
				menus.comprasDemandaGerar = 1;
				menus.comprasDemandaConsulta = 1;
				break;
			case 38:
				menus.compras = 1;
				menus.comprasPedidoEletronico = 1;
				menus.comprasPedidoEletronicoAtivacao = 1;
				break;
			case 39:
				menus.compras = 1;
				menus.comprasPedidoEletronico = 1;
				menus.comprasPedidoEletronicoAcompanhamento = 1;
				break;
			case 40:
				menus.configuracao = 1;
				menus.configuracaoControleDeAcesso = 1;
				break;
			case 41:
				menus.precificacao = 1;
				menus.precificacaoParametro = 1;
				menus.precificacaoParametroImportacaoPmcPmd = 1;
				menus.precificacaoPendencia = 1;
				menus.precificacaoPendenciaPrecoDeVenda = 1;
				menus.precificacaoRelatorio = 1;
				menus.precificacaoRelatorioDetalhamentoAtulizacaoDePreco = 1;
				menus.precificacaoRelatorioPrecoDeVenda = 1;
				menus.arquivos = 1;
				menus.arquivosPmcPmd = 1;
				break;
			case 42:
				menus.atualizacao = 1;
				menus.atualizacaoProduto = 1;
				break;
			case 43:
				menus.convenio = 1;
				menus.convenioCadastro = 1;
				menus.convenioCadastroConvenio = 1;
				menus.convenioRelatorio = 1;
				menus.convenioRelatorioCompras = 1;
				menus.convenioRelatorioCartoesSolicitados = 1;
				menus.convenioRelatorioFidelidade = 1;
				menus.convenioRelatorioLogs = 1;
				menus.convenioArquivo = 1;
				menus.convenioXmlDanfe = 1;
				break;
			case 44:
				menus.movimentacoes = 1;
				menus.movimentacoesIntegracao = 1;
				menus.movimentacoesIntegracaoCupomFiscal = 1;
				menus.movimentacoesIntegracaoNotaFiscal = 1;
				menus.movimentacoesIntegracaoSuperTroco = 1;				
				menus.movimentacoesEntrada = 1;
				menus.movimentacoesEntradaCheckIn =1;
				menus.movimentacoesCupomFiscal = 1;
				menus.movimentacoesPendencia = 1;
				menus.movimentacoesLancamentoDeVendas = 1;
				break;
			case 45:
				menus.compras = 1;
				menus.comprasCadastro = 1;
				menus.comprasAlcada = 1;
				break;
			case 46:
			case 47:
				menus.cadastro = 1;
				menus.cadastroProduto = 1;
				menus.cadastroProdutoAtributo = 1;
				menus.cadastroProdutoMotivoStatus = 1;
				break;
			case 48:
				menus.compras = 1;
				menus.comprasPedidoEletronico = 1;
				menus.comprasPedidoEletronicoImportacaoMcc = 1;
				break;
			case 49:
				menus.compras = 1;
				menus.comprasRelatorio = 1;
				menus.comprasRelatorioCompraXVendas = 1;
				break;
			case 50:
				menus.compras = 1;
				menus.comprasRelatorio = 1;
				menus.comprasRelatorioMapaFabricante = 1;
				break;
			case 52:
				menus.compras = 1;
				menus.comprasPedidoDeCompra = 1;
				break;
			case 53:
				menus.cadastro = 1;
				menus.cadastroImportador = 1;
				menus.cadastroImportadorFornecedor = 1;
				break;
			case 54:
				menus.compras = 1;
				menus.comprasRelatorio = 1;
				menus.comprasRelatorioAnaliseRessuprimento = 1;
				break;
			case 55:
				menus.compras = 1;
				menus.comprasRelatorio = 1;
				menus.comprasRelatorioCalendarioEntrega = 1;
				break;
			case 56:
				menus.sngpc = 1;
				menus.sngpcPainel = 1;
				menus.sngpcPendencia = 1;
				menus.sngpcPendenciaManutencaoDePendencia = 1;
				menus.sngpcFarmaceutico = 1;
				menus.sngpcRegistrar = 1;
				menus.sngpcRegistrarInventarioInicial = 1;
				menus.sngpcRegistrarMedicos = 1;
				menus.sngpcRelatorio=1;
				menus.sngpcRelatorio=1;
				menus.sngpcRelatorioMovimentacaoAnvisa =1;
				menus.sngpcRelatorioBalancoEstoque=1;
				break;
			case 57:
				menus.compras = 1;
				menus.comprasRelatorio = 1;
				menus.comprasRelatorioAnaliseDeVenda = 1;
				menus.comprasRelatorioAnaliseDeVendaGeral = 1;
				menus.comprasRelatorioAnaliseDeVendaLojaXTelevendas = 1;
				break;
			case 58:
				menus.compras = 1;
				menus.comprasRelatorio = 1;
				menus.comprasRelatorioAnaliseDeFalta = 1;
				break;
			case 59:
				menus.compras = 1;
				menus.comprasRelatorio = 1;
				menus.comprasRelatorioAnaliseDeExcesso= 1;
				break;
			case 60:
				menus.convenio = 1;
				menus.convenioArquivo = 1;
				menus.convenioDuplicatas = 1;
				break;
			case 61:
				menus.compras = 1;
				menus.comprasRelatorio = 1;
				menus.comprasRelatorioAuditoriaDeDemanda= 1;
				break;
			case 62:
			case 63:
				menus.compras = 1;
				menus.comprasCadastro = 1;
				menus.comprasCadastroParametro = 1;
				menus.comprasCadastroParametroPercVariacaoDemanda = 1;
				break;
			case 64:
			case 65:
				menus.precificacao = 1;
				menus.precificacaoParametro = 1;
				menus.precificacaoParametroMetaMargemBruta = 1;
				break;
			case 66:
				menus.compras= 1;
				menus.comprasEncomenda=1;
				menus.comprasEncomendaConsultar =1;
				menus.comprasEncomendaGerar =1;
				break;
			case 67:
				menus.compras= 1;
				menus.comprasEncomenda=1;
				menus.comprasEncomendaConsultar =1;
				break;
			case 68:
				menus.arquivos = 1;
				menus.arquivosImportar = 1;
				menus.arquivosConsultarImportacao = 1;
				break;
			case 69:
				menus.compras = 1;
				menus.comprasCotacao = 1;
				menus.comprasCotacaoRemessaRetorno = 1;
				break;
			case 70:
				menus.compras = 1;
				menus.comprasCadastro = 1;
				menus.comprasCadastroParametro = 1;
				menus.comprasCadastroParametroReforcoReducao = 1;
				menus.comprasCadastroParametroReforcoReducaoGerar = 1;
				break;
			case 79:
				menus.iqvia = 1;
				break;
			case 80:
				menus.contaDigitalCriarConta = 1;
				break;
			case 81:
				menus.contaDigitalVincularConta = 1;
				break;
			case 82:
				menus.contaDigitalConsultaExtrato = 1;
				break;
			case 83:
				menus.contaDigitalVincularCarteiraCobranca = 1;
				break;
			case 84:
				menus.contaDigitalAtivarDesativarDDA = 1;
				break;
			case 85:
				menus.contaDigitalVincularRegistroTaxaDeLiquidacao = 1;
				break;
			case 86:
				menus.ecommerce = 1;
				break;
			case 87:
		    	menus.ecommerceConfiguracao = 1;
				break;
			case 88:
		        menus.ConfLogistica = 1;
				break;
			case 89:
		        menus.ecommerceCadastroProdutos = 1;
				break;
			case 90:
		        menus.promocoes = 1;
				break;
			case 91:
				menus.configuracaoEnvioEmail = 1;
				break;
			case 92:
		        menus.integracoes = 1;
				break;
			case 93:
		        menus.integracoesEdelivery = 1;
				break;
			case 94:
				menus.integracoesEdeliveryConfiguracao = 1;
				break;
			case 95:
				menus.integracoesEdeliveryPainelEnvio = 1;
				break;
			case 96:
		        menus.controleDeAcessos = 1;
				break;
			case 97:
		        menus.controleDeAcessosGestao = 1;
				break;
			case 98:
		        menus.controleDeAcessosLog = 1;
				break;
			case 99:
		        menus.controleDeAcessosGestaoCadastro = 1;
				break;
			case 100:
		        menus.controleDeAcessosGestaoRelatorio = 1;
				break;
			case 101:
                menus.financeiroPortalFinanceiro = 1;
                break;
			case 102:
				menus.carimboDigital = 1;
				break;	
			default:
				break;

		}
	}

	return menus;
};

ControleDeAcesso.prototype.getPerfil = function(dados){
	dados.put('cgcCpf', dados.get('login'));
	var usuario = this.mapper.selectOne("RcCli.loginWebConvenio", dados);
	
	if(usuario === null){
	
		dados.remove('cgcCpf');
		dados.put('nrCartao', dados.get('login'));
		usuario = this.mapper.selectOne("RcCli.loginWebConvenio", dados);
	
			if(usuario === null){
				dados.remove('cgcCpf');
				dados.put('email', this.dados.get('login'));
				usuario = this.mapper.selectOne("RcCli.loginWebConvenio", dados);
			}
	}
	
	if(usuario !== null && dados.get("isFidelidade") == 1){//FIDELIDADE
		usuario.put("rule", "fidelidade");
		usuario.put("cdCtr", 1);
	
	}else if(usuario !== null && parseInt(usuario.get("administrador")) === 1 && parseInt(usuario.get("tpUsu")) === 1){//ADM. CONVENIADO
		usuario.put("rule", "administrador");
		usuario.put("cdCtr", 3);
	
	}else if(usuario !== null){//CONVENIADO
	  usuario.put("rule", "conveniado");
	  usuario.put("cdCtr", 2);
	
	}else{
		usuario.put("rule", "");
		usuario.put("cdCtr", 0);
	}
	
	return {'usuario': usuario};
	
};

ControleDeAcesso.prototype.getMenusWebConvenio = function(perfil){
	var menus = this.getMenuPadrao();

	if(perfil == 'administrador'){
		menus.convenio = 1;
		menus.convenioCadastro = 1;
		menus.convenioCadastroConvenio = 1;
		menus.convenioRelatorio = 1;
		menus.convenioRelatorioCompras = 1;
		menus.convenioRelatorioCartoesSolicitados = 1;
		menus.convenioRelatorioFidelidade = 1;
		menus.convenioArquivo = 1;
		menus.convenioXmlDanfe = 1;
		menus.convenioDuplicatas = 1;
		menus.alteracaoDeSenha = 1;
	}else if(perfil == 'conveniado'){
		menus.convenio = 1;
		menus.convenioRelatorio = 1;
		menus.convenioRelatorioCompras = 1;
		menus.convenioRelatorioFidelidade = 1;
		menus.alteracaoDeSenha = 1;
		menus.bloqueioTemporario = 1;
	}else if(perfil == 'fidelidade'){
		menus.convenio = 1;
		menus.convenioRelatorio = 1;
		menus.convenioRelatorioFidelidade = 1;
	}

	return menus;
};