load('/model/filial/Filial.js');
var filial = new Filial();
var mapper = mapperFactory.createMapperMult(["PrcFilial", "PrcFilialRcCli", "PrcFilialPgForn","PrcFilialNfSeries"]);
message.put("cdCli", message.get("cliente").get("cdCli"));
message.put("cdForn", message.get("fornecedor").get("cdForn"));

var validarVinculoCliente = function(){
	if(filial.isClienteJaVinculado({'cdEmp': message.get("cdEmp"), 'cdCli': message.get("cdCli")})){
		throw {code: 599, message: "Cliente já está vinculado a outra filial!"};
	}
};

var validarVinculoFornecedor = function(){
	if(filial.isFornecedorJaVinculado({'cdEmp': message.get("cdEmp"), 'cdForn': message.get("cdForn")})){
		throw {code: 599, message: "Fornecedor já está vinculado a outra filial!"};
	}
};

try{
	var cliente = mapper.selectOne("PrcFilial.listarRcCli", message);
	var fornecedor = mapper.selectOne("PrcFilial.listarPgForn", message);
	
	
	if(message.get("cdCli") != null && cliente == null){
		validarVinculoCliente();
		mapper.insert("PrcFilialRcCli.incluirPrcFilialRcCli", message);
	}else if(message.get("cdCli") == null && cliente != null){
		mapper.update("PrcFilialRcCli.excluirPrcFilialRcCli", message);
	}else if(message.get("cdCli") != null && cliente.get("cdCli") != message.get("cdCli")){
		validarVinculoCliente();
		mapper.update("PrcFilialRcCli.alterarPrcFilialRcCli", message);
	}
	
	if(message.get("cdForn") != null && fornecedor == null){
		validarVinculoFornecedor();
		mapper.insert("PrcFilialPgForn.incluirPrcFilialPgForn", message);
	}else if(message.get("cdForn") == null && fornecedor != null){
		mapper.update("PrcFilialPgForn.excluirPrcFilialPgForn", message);
	}else if(message.get("cdForn") != null && fornecedor.get("cdForn") != message.get("cdForn")){
		validarVinculoFornecedor();
		mapper.update("PrcFilialPgForn.alterarPrcFilialPgForn", message);
	}

	if(message.get("series") != null){
		this.mapper.update("PrcFilialNfSeries.excluirPrcFilialNfSeries", {"cdEmp":message.get("cdEmp"), "cdFilial": message.get("cdFilial")});
		if(message.get("series").size() > 0)
			this.mapper.insert("PrcFilialNfSeries.incluirPrcFilialNfSeriesEmLote", {"cdEmp":message.get("cdEmp"), "cdFilial": message.get("cdFilial"), "series":message.get("series")});
	}
	
	mapper.update("PrcFilial.alterarPrcFilial", message);
	mapper.commit();
	
}catch(err){
	if(err.code){
    throw JSON.stringify(err);
	}else{
		mapper.rollback();
	  throw " Ocorreu um erro: " + err;
	}
}