/**
 * Autenticacao ocorre no script pre-request.js, nesse script é recuperados os dados
 * do usuario e parametros da empresa, para montagem das telas do usuario
 */
load('/model/acesso/ControleDeAcesso.js');
var controleDeAcesso = new ControleDeAcesso();
var mapper = mapperFactory.createMapperMult(["Login", "PrcEmpConfig", "ControleDeAcesso", "PrcFilial", "GlbFuncionalidade", "GlbApps"]);
var usuario = mapper.selectOne("Login.carregarDadosDeUsuario", message);

if(usuario.get('sit') == 1)
	throw JSON.stringify({code: 599, message: "Usuário inativo no sistema!"});

var parametrosEmpresa = mapper.selectList("PrcEmpConfig.listarPrcEmpConfig", null);
var permissoes = new java.util.HashMap();

if(usuario.get('cdUsu') != 1){
    if(usuario.get('gruposDeUsuario').size() > 0)
        permissoes = mapper.selectList("ControleDeAcesso.listarFuncionalidadesPorGrupoDeUsuario", {'gruposDeUsuario': usuario.get('gruposDeUsuario')});

}else{
    permissoes = mapper.selectList("GlbFuncionalidade.listarFuncionalidadesAtivas", {});
}

var menus = controleDeAcesso.getMenus(permissoes);

var filiais = mapper.selectList("PrcFilial.listarFiliaisDeAcessoDoUsuario", {'cdUsu': usuario.get('cdUsu')});

var apps = mapper.selectList("GlbApps.listarGlbApps", {'sts': 1});

var result = {'usuario': usuario, 'parametrosEmpresa':parametrosEmpresa, 'permissoes':permissoes, 'filiais': filiais, 'apps': apps, 'menus':menus};
result;
