load('/model/compras/DemandaDeCompra.js');
var mapper =  mapperFactory.createMapperMult(['EstProdSuprimentoEntregaLoja']);


try{

let param = new java.util.HashMap();
param.put('cdEmp', message.get('cdEmp'));
param.put('cdUsu', message.get('cdUsu'));
param.put('produtosAlterados', new java.util.ArrayList());
param.put('produtosInseridos', new java.util.ArrayList());

let listaDeProdutosPorFilial = mapper.selectList("EstProdSuprimentoEntregaLoja.listarProdutosPorFilial", {
    'cdEmp': message.get('cdEmp'),
    'cdUsu': message.get('cdUsu'),
    'cdProd': message.get('produtoAlterado').get('cdProd')
});

if(listaDeProdutosPorFilial.size() == 0)
    throw {code: 599, message: "Não foi identificado as filiais da demanda"};

for(let i = 0; i<listaDeProdutosPorFilial.size(); i++){

    param.get('produtosAlterados').add({'cdFilial': listaDeProdutosPorFilial.get(i).get('cdFilial'), 
    'quantidade': 0, 
    'cdProd':  message.get('produtoAlterado').get('cdProd'), 
    'justificativa': message.get('produtoAlterado').get('justificativa')});

    param.get('produtosInseridos').add({'cdFilial': listaDeProdutosPorFilial.get(i).get('cdFilial'), 
    'quantidade': listaDeProdutosPorFilial.get(i).get('qtdeProd'), 
    'cdProd':  message.get('produtoInserido').get('cdProd'), 
    'justificativa': message.get('produtoInserido').get('justificativa')});
}

var demandaDeCompra = new DemandaDeCompra();
demandaDeCompra.adicionarNovosProduto(param);

}catch(err){
    if(err.code)
        throw JSON.stringify(err);
    else
        throw err;
}