var mapper =  mapperFactory.createMapperMult(['EstProdSuprimentoEntregaLoja']);

var inserirNovoProdutos = function(){
    println("=== INSERT === "+message.get('produtosInseridos').size());
     if(message.get('produtosInseridos').size() == 0)
        return;

    let param = {
        'produtos': [],
        'cdEmp': message.get('cdEmp'),
        'cdUsu': message.get('cdUsu'),
        'isEncomenda':  message.get('isEncomenda'),
        'listaPreco': dadosComplementares.get('listaPreco'),
        'consideraEstCd':  dadosComplementares.get('consideraEstCd'),
        'cdAgenda':  dadosComplementares.get('cdAgenda'),
        'cdDepoEntrega':  dadosComplementares.get('cdDepoEntrega'),
        'paramEstAA' :  dadosComplementares.get('paramEstAA'),
        'paramEstA':  dadosComplementares.get('paramEstA'),
        'paramEstB':  dadosComplementares.get('paramEstB'),
        'paramEstC':  dadosComplementares.get('paramEstC'),
        'paramEstD':  dadosComplementares.get('paramEstD'),
        'cdSiglaCurva':  dadosComplementares.get('cdSiglaCurva'),
        'tipoCompra':  dadosComplementares.get('tipoCompra'),
        'tpReq':  dadosComplementares.get('tpReq'),
        'leadTime':  dadosComplementares.get('leadTime'),
        'dtProxAgenda':  dadosComplementares.get('dtProxAgenda'),
        'acresDiasProxAgenda':  dadosComplementares.get('acresDiasProxAgenda'),
        'consideraFace':  dadosComplementares.get('consideraFace'),
        'naoUtilizaAgdFace':  dadosComplementares.get('naoUtilizaAgdFace'),
        'listaFiliais':  dadosComplementares.get('listaFiliais'),
        'listaProduto':  dadosComplementares.get('listaProduto'),
        'listaDeposito':  dadosComplementares.get('listaDeposito'),
        'ignorarExcessoDemandaIntegrada':  dadosComplementares.get('ignorarExcessoDemandaIntegrada')
    };

    let numMarkers = 0;

     for(let i = 0; i < message.get('produtosInseridos').size(); i++){
         let item = message.get('produtosInseridos').get(i);
         if((numMarkers + 6) > 2000){

             mapper.insert('EstProdSuprimentoEntregaLoja.incluirProdutosEmLote', param);
             param.produtos = [];
             numMarkers = 0;
             i --;
         }else{
             param.produtos.push(item);
             numMarkers = numMarkers + 6;
         }
     }

     if(param.produtos.length > 0){
        try{
            mapper.insert('EstProdSuprimentoEntregaLoja.incluirProdutosEmLote', param);
         }catch(err){
            println(err);
         }
     }
};

var alterarProdutos = function(){
    println("=== UPDATE === "+message.get('produtosAlterados').size());
    if(message.get('produtosAlterados').size() == 0)
        return;

    let param = {
        'produtos': [],
        'cdEmp': message.get('cdEmp'),
        'cdUsu': message.get('cdUsu'),
        'isEncomenda': message.get('isEncomenda')
    };
    let numMarkers = 0;

    for(let i = 0; i < message.get('produtosAlterados').size(); i++){
        let item = message.get('produtosAlterados').get(i);
        if((numMarkers + 6) > 2000){

            mapper.update('EstProdSuprimentoEntregaLoja.alterarQuantidadeDeProdutoEmLote', param);
            param.produtos = [];
            numMarkers = 0;
            i --;
        }else{
            param.produtos.push(item);
            numMarkers = numMarkers + 6;
        }
    }

    if(param.produtos.length > 0)
        mapper.update('EstProdSuprimentoEntregaLoja.alterarQuantidadeDeProdutoEmLote', param);

};


try{

    if(message == null || message.get('cdEmp') == null || message.get('cdUsu') == null || message.get('produtosAlterados') == null || message.get('produtosInseridos') == null)
        throw {code: 599, message: "Dados passados ao servidor inválido!"};

    var dadosComplementares = mapper.selectOne('EstProdSuprimentoEntregaLoja.listarDadosComplementares', {'cdEmp': message.get('cdEmp'), 'cdUsu': message.get('cdUsu')});

    let service = java.util.concurrent.Executors.newFixedThreadPool(2);
    let futureList = new java.util.ArrayList();
    let callableInsert = new java.util.concurrent.Callable({'call': inserirNovoProdutos });
    let callableUpdate = new java.util.concurrent.Callable({'call': alterarProdutos });
    futureList.add(callableInsert);
    futureList.add(callableUpdate);

    service.invokeAll(futureList);
    service.shutdown();

    mapper.commit();

}catch(err){
    mapper.rollback();
    println(err);
    if(err.code)
        throw JSON.stringify(err);
    else
        throw err;
}