load('/rules/fabricante/validaDados.js');
load('/model/erro/admErroCadBasicosIntegracoes.js');

/*
 * recupera o mapper mybatis definido no arquivo XML
 */
var validaFabricante = new ValidaFabricante();
var gravaErro        = new AdmErroIntegracoes();
var estProdFabricMapper = mapperFactory.createMapper("EstProdFabric");
/*
 * objeto message é um hashmap que contem a chave nome do atirbuto JSON e seu respectivos valores
 */

var flagImportacao = false;

 if(message.get("obj")){
    var obj = message.get("obj");
    flagImportacao = true;
 }

 
try{
	
		if(flagImportacao){
	
		    for (i = 0; i < obj.size(); i++) {
		      item = obj.get(i);
		      itemValidado = validaFabricante.validaDadosFabricante(item);
		      estProdFabricMapper.insert("incluirEstProdFabric", itemValidado);
		      gravaSucesso(itemValidado);
		    }
		    
		}else{
			
			 validaFabricante.validaDadosFabricante(message);
			 estProdFabricMapper.insert("incluirEstProdFabric", message);
		}
		
		estProdFabricMapper.commit();
		
		if(!flagImportacao)
			 message.get("cdFabric");

}catch(err) {
  java.lang.System.out.println(err);
  estProdFabricMapper.rollback();
  //gravaErro(itemValidado,err);
  if(err.code)
      throw JSON.stringify(err);
  else
    	throw err;
}

var gravaSucesso = function (json){
  var jsonConvert       = new com.google.gson.GsonBuilder().create();
  var metodo            = 'POST';
  var msgErro           = {};
  msgErro.id            = json.get("cdFabric");
  msgErro.tabela        = 'EST_PROD_FABRIC';
  msgErro.jsonEnviado   = jsonConvert.toJson(json);
  msgErro.stsErro       = 1; // Importado com sucesso
  msgErro.cdUsuCorrecao = 0;
  msgErro.laudo         = 'Fabricante ' + json.get("cdFabric") + ' inserido com sucesso.';
  gravaErro.gerenciaErro(metodo,msgErro);
};

var gravaErro = function(json,err){
  var jsonConvert       = new com.google.gson.GsonBuilder().create();
  java.lang.System.out.println('itemValidado ' +itemValidado);
  var metodo            = 'POST';
  var msgErro           = {};
  msgErro.id            = json.get("cdFabric") || 0;
  msgErro.tabela        = 'EST_PROD_FABRIC';
  msgErro.jsonEnviado   = jsonConvert.toJson(json);
  msgErro.stsErro       = 2; // Erro
  msgErro.cdUsuCorrecao = 0;
  msgErro.laudo         = jsonConvert.toJson(err);
  gravaErro.gerenciaErro(metodo,msgErro);
};
