load('/model/compras/DemandaDeCompra.js');
var mapper = mapperFactory.createMapperMult(["EstProd"]);
var demandaDeCompra = new DemandaDeCompra();

try{

	if(message.get('cdDepoEntrega') == 0){//Direto loja
		mapper.update('EstProd.realizarArrendondamentoPorProduto', message);
		mapper.commit();
		
	}else{//Integrado

		let justificativa = 'ARREDONDAMENTO DE EMBALAGEM INDUSTRIAL';
		let produtos = mapper.selectList('EstProd.resultadoDemandaByProduto', {'cdUsu': message.get('cdUsu'), 'cdEmp': message.get('cdEmp')});
		
		for(i = 0; i<produtos.size(); i++){
			let produto = produtos.get(i);
			let qtdeArredondada = Math.round(produto.get('qtdeProd'), 0);
			
			if(produto.get('qtEmbFechadaCp') > 0 && Math.round((qtdeArredondada/produto.get('qtEmbFechadaCp')),0) > 0){
				qtdeArredondada = produto.get('qtEmbFechadaCp') * Math.round((produto.get('qtdeProd')/produto.get('qtEmbFechadaCp')),0);
				
			}else{
				if(message.get('forcarCaixaFechada') == 1 && produto.get('qtEmbFechadaCp') > 0 && Math.round(produto.get('qtdeProd')) > 0){
					qtdeArredondada = produto.get('qtEmbFechadaCp');
				}else{
					if(produto.get('qtEmbAlternativaCp') > 0 && Math.round((qtdeArredondada/produto.get('qtEmbAlternativaCp')),0) > 0){
						qtdeArredondada =  produto.get('qtEmbAlternativaCp') * Math.round(qtdeArredondada / produto.get('qtEmbAlternativaCp'),0);
					}else{
						qtdeArredondada = 0;
					}
				}
			}

			if(qtdeArredondada != Math.round(produto.get('qtdeProd'), 0)){
                if(qtdeArredondada <= 0)
                    demandaDeCompra.setProdutoZerado(message.get('cdEmp'), message.get('cdUsu'), produto.get('cdProd'), justificativa);
                else if(qtdeArredondada > Math.round(produto.get('qtdeProd'), 0))
                    demandaDeCompra.incrementarRateioItem(qtdeArredondada, Math.round(produto.get('qtdeProd'), 0), produto.get('cdProd'), message.get('cdEmp'), message.get('cdUsu'), justificativa);
                else if (qtdeArredondada < Math.round(produto.get('qtdeProd'), 0))
                    demandaDeCompra.decrementarRateioItem(qtdeArredondada, Math.round(produto.get('qtdeProd'), 0), produto.get('cdProd'), message.get('cdEmp'), message.get('cdUsu'), justificativa);
            }
				
		}
		
		demandaDeCompra.mapper.commit();
		
	}
	
	

		
}catch(err){
	mapper.rollback();
	demandaDeCompra.mapper.rollback();
	if(err.code)
	  throw JSON.stringify(err);
	else
		throw err;
}