oauth.init();
var usuario = JSON.parse(oauth.getConsumerKey());
var parametros = mapperFactory.createMap();
var mapper = mapperFactory.createMapperMult(["SenhaSha1", "ControleDeAcesso", "RcCli"]);
headers.put("requestUrl", headers.get('requestUrl').replace(usuario.urlBase, ''));
var senhaSha1 = '';

var convertMetodoEmIndex = function(metodo){
	switch(metodo+''){
		case 'GET':
			return 1;
		case 'POST':
			return 2;
		case 'PUT':
			return 3;
		case 'DELETE':
			return 4;
		default:
			return 0;
	}
};

var validarUsuario = function(){	
	if(usuario.app === 'gestao'){
			parametros.put("cdUsu", usuario.user);
			senhaSha1= mapper.selectOne("SenhaSha1.listarSenhaSha1", parametros).get("sha1");

			if(!oauth.checkSignature(senhaSha1, senhaSha1))
				oauth.breakRequest("acesso negado, usuário: " + usuario.user + " - " + senhaSha1);

	}else{
		
		if(usuario.isFidelidade == 1){
			
			let fidelidade = mapper.selectOne("RcCli.loginWebConvenio", {'nrCartao': usuario.user , 'stsCartao':0});
			if(fidelidade == null)
				oauth.breakRequest("acesso negado, usuário: " + usuario.user);
			
		}else{
	
			parametros.put("cgcCpf", usuario.user);
			parametros.put("email", usuario.user);
			
		}
		
		parametros.put("nrCartao", usuario.user);
		senhaSha1 = mapper.selectOne("SenhaSha1.listarSenhaSha1WebConvenio", parametros).get("sha1");
		
		if(!oauth.checkSignature(senhaSha1, senhaSha1))
			oauth.breakRequest("acesso negado, usuário: " + usuario.user + " - " + senhaSha1);

	}
};

var validarAcessoDoUsuario = function(){
	if(usuario.app == 'gestao' && usuario.user == 1)
		return;
	
	if(mapper.selectOne("ControleDeAcesso.isServicoPublico", {'url': headers.get("requestUrl"), 'metodo': convertMetodoEmIndex(headers.get("method"))}) == 1)
		return;

    let temPermissao = 0;
    if(usuario.app == 'gestao'){
	   temPermissao = mapper.selectOne("ControleDeAcesso.validarControleDeAcessoAoServicoPorUsuario", {'cdUsu': usuario.user, 'url': headers.get("requestUrl"), 'metodo': convertMetodoEmIndex(headers.get("method"))});

    }else if(usuario.app == 'webconvenio'){
		if(usuario.isFidelidade == 1)
			 temPermissao = mapper.selectOne("ControleDeAcesso.validarControleDeAcessoWebConvenio", {'cdCtr': 1, 'url': headers.get("requestUrl"), 'metodo': convertMetodoEmIndex(headers.get("method"))});
		 else     
			 temPermissao = mapper.selectOne("ControleDeAcesso.validarControleDeAcessoWebConvenio", {'cdCtr': usuario.cdCtr, 'url': headers.get("requestUrl"), 'metodo': convertMetodoEmIndex(headers.get("method"))});
	}

	/*java.lang.System.out.println("=============== TEM PERMISSAO ============================");
    java.lang.System.out.println(temPermissao);
    java.lang.System.out.println("=================== URL ============================");
    java.lang.System.out.println(headers.get("requestUrl"));
    java.lang.System.out.println("=================== METODO ============================");
    java.lang.System.out.println(headers.get("method"));*/
    
	if(temPermissao == 0)
		throw JSON.stringify({code: 402, message: "Usuário sem permissão ao servico "+headers.get("method")+" / "+headers.get("requestUrl")});
};

validarUsuario();
validarAcessoDoUsuario();