var mapper =  mapperFactory.createMapperMult(['GlbScheduleArquivos', 'GlbScheduleJob', 'EstProdSuprimentoEntregaLojaQtdeDefinidaPorFilial', 'EstProd', 'EstProdSuprimentoEntregaLoja']);
var job = new java.util.HashMap();
var scheduleArquivo = new java.util.HashMap();

var setItemEncontrado = function(valor, array){
    for(let c in array){
        if(array[c] == valor)
            return ;
    }

    array.push(valor);
};

var isProdutoRepetidoNafilial = function(produto, produtos){
    for(let c in produtos){
        if(produtos[c].cdProd == produto.cdProd && produtos[c].cdFilial == produto.cdFilial){
            return true;
        }
    }
    return false;
};

var processar = function(){
    mapper.update("GlbScheduleJob.alterarGlbScheduleJob", {'sts': 2, 'cdCtr': job.get('cdCtrJob')});
    scheduleArquivo =  mapper.selectOne("GlbScheduleArquivos.listarGlbScheduleArquivos", {'cdCtr': job.get('cdCtr')});
    let produtosEncontrados = [];
    let filiaisEncontradas = [];
    let paramGeracaoDemanda = {
        'cdEmp': 1,
        'cdAgenda': 0,
        'listDepositos': '',
        'cdUsu': scheduleArquivo.get('cdUsu'),
        'listaPreco': '',
        'listaCurvas': '1,2,3,4,5',
        'ignorarFaceamento': 1,
        'prodQtdeDefinida': 2,
        'produtos': '',
        'tipoDeCompra': '',
        'filiais': '',
        'curva':{
            'aa':{
                'somaCurva': 0,
                'vlr': 0
            },
            'a':{
                'somaCurva': 0,
                'vlr': 0
            },
            'b':{
                'somaCurva': 0,
                'vlr': 0
            },
            'c':{
                'somaCurva': 0,
                'vlr': 0
            },
            'd':{
                'somaCurva': 0,
                'vlr': 0
            }
        },
        'cdDepoEntrega': 0,
        'naoUtilizarFacAgendado':0,
        'tipoRequisicao': 0,
        'ledtime': 0,
        'acresDiasProxAgenda': 0,
        'ignorarExcessoDemandaIntegrada': 0
    };

    let produtos = [];
    let linhas = scheduleArquivo.get('arquivo').split('\r\n');

    mapper.update('EstProdSuprimentoEntregaLojaQtdeDefinidaPorFilial.delete', {'cdUsu': scheduleArquivo.get('cdUsu')});

    for(let i = 0; i<linhas.length; i++){
        let campos = linhas[i].split(';');
        if(campos.length == 5){

            if(produtos.length == 333){//(2000/6)
                mapper.insert("EstProdSuprimentoEntregaLojaQtdeDefinidaPorFilial.insert", {'produtos': produtos});
                produtos = [];
            }

            let produto = {
                'cdUsu': scheduleArquivo.get('cdUsu'),
                'cdProd': campos[0],
                'cdFilial': campos[1],
                'qtdeProd': campos[2],
                'vlrProd': parseFloat(campos[3].replace(',','.')),
                'percDesc': parseFloat(campos[4].replace(',','.'))
            };

            setItemEncontrado(campos[0], produtosEncontrados);
            setItemEncontrado(campos[1], filiaisEncontradas);
            if(!isProdutoRepetidoNafilial(produto, produtos))
                produtos.push(produto);
        }
    }


    if(produtos.length > 0){
        mapper.insert("EstProdSuprimentoEntregaLojaQtdeDefinidaPorFilial.insert", {'produtos': produtos});
        produtos = [];
    }

    paramGeracaoDemanda.produtos = produtosEncontrados.toString();
    paramGeracaoDemanda.filiais = filiaisEncontradas.toString();

    mapper.update("EstProd.geraDemandaAgenda", paramGeracaoDemanda);
    mapper.insert('EstProdSuprimentoEntregaLoja.auditoriaInicial', {'cdEmp': 1, 'cdUsu': scheduleArquivo.get('cdUsu')});

    mapper.update("GlbScheduleJob.alterarGlbScheduleJob", {'sts': 1, 'cdCtr': job.get('cdCtrJob')});
};

try{
    java.lang.System.out.println("Iniciando schedule de processamento de demanda");
    job = mapper.selectOne("GlbScheduleJob.listarCdCtrProcessar", {'nmSchedule': 'IMPORTACAO_DEMANDA'});
    if(job != null && job.get('cdCtrJob') != null){
        processar();
        mapper.commit();
    }
    

}catch(err){
    mapper.rollback();

    var mapperError =  mapperFactory.createMapperMult(['GlbScheduleJob']);
    mapperError.update("GlbScheduleJob.alterarGlbScheduleJob", {'sts': 3, 'cdCtr': job.get('cdCtrJob')});
    mapperError.commit();

    java.lang.System.out.println(err);
}