/**
 * Created by maurodouglas on 01/11/16.
 */

var ValidaPreco = function( ) {
	this.mapper = mapperFactory.createMapperMult([ "EstProdPreco", "EstProd" ]);
};

/**
  * Metodo valida os dados enviados para o cadasto do Codigo de Barra
  * @param {HashMap JAVA} json
  * @throws {InvalidArgumentException}
  */
ValidaPreco.prototype.validaDadosParaCadastro = function( json ) {
	if ( !json ) {
		throw { code: 599, message: "Dados passados ao servidor inválido!" };
	}
	var dadosDefault = this.dadosDefault( json );
	return dadosDefault;
};

ValidaPreco.prototype.dadosDefault = function( json ) {

	if(!json.get("cdCtr") || json.get("cdCtr") === null || json.get("cdCtr") === undefined){
		json.put("cdCtr", 0);
	}
	if(!json.get("cdEmp") || json.get("cdEmp") === null || json.get("cdEmp") === undefined){
		json.put("cdEmp", 1);
	}
	if(!json.get("cdFilial") || json.get("cdFilial") === null || json.get("cdFilial") === undefined){
		json.put("cdFilial", 0);
	}
	if(!json.get("cdProd") || json.get("cdProd") === null || json.get("cdProd") === undefined){
		json.put("cdProd", 0);
	}
	if(!json.get("cdUsu") || json.get("cdUsu") === null || json.get("cdUsu") === undefined){
		json.put("cdUsu", 0);
	}
	if(!json.get("percComis") || json.get("percComis") === null || json.get("percComis") === undefined){
		json.put("percComis", 0);
	}
	if(!json.get("percDesp") || json.get("percDesp") === null || json.get("percDesp") === undefined){
		json.put("percDesp", 0);
	}
	if(!json.get("percIcms") || json.get("percIcms") === null || json.get("percIcms") === undefined){
		json.put("percIcms", 0);
	}
	if(!json.get("percImp") || json.get("percImp") === null || json.get("percImp") === undefined){
		json.put("percImp", 0);
	}
	if(!json.get("percMargem") || json.get("percMargem") === null || json.get("percMargem") === undefined){
		json.put("percMargem", 0);
	}
	if(!json.get("precoEspecifico") || json.get("precoEspecifico") === null || json.get("precoEspecifico") === undefined){
		json.put("precoEspecifico", 0);
	}
	if(!json.get("stsImpEtqGond") || json.get("stsImpEtqGond") === null || json.get("stsImpEtqGond") === undefined){
		json.put("stsImpEtqGond", 0);
	}
	if(!json.get("stsPreco") || json.get("stsPreco") === null || json.get("stsPreco") === undefined){
		json.put("stsPreco", 0);
	}
	if(!json.get("tipoMajoracao") || json.get("tipoMajoracao") === null || json.get("tipoMajoracao") === undefined){
		json.put("tipoMajoracao", 0);
	}
	if(!json.get("vlrCusto") || json.get("vlrCusto") === null || json.get("vlrCusto") === undefined){
		json.put("vlrCusto", 0);
	}
	if(!json.get("vlrCustoGer") || json.get("vlrCustoGer") === null || json.get("vlrCustoGer") === undefined){
		json.put("vlrCustoGer", 0);
	}
	if(!json.get("vlrOferta") || json.get("vlrOferta") === null || json.get("vlrOferta") === undefined){
		json.put("vlrOferta", 0);
	}
	if(!json.get("vlrOfertaAnt") || json.get("vlrOfertaAnt") === null || json.get("vlrOfertaAnt") === undefined){
		json.put("vlrOfertaAnt", 0);
	}
	if(!json.get("vlrOfertaAvista") || json.get("vlrOfertaAvista") === null || json.get("vlrOfertaAvista") === undefined){
		json.put("vlrOfertaAvista", 0);
	}
	if(!json.get("vlrTabela") || json.get("vlrTabela") === null || json.get("vlrTabela") === undefined){
		json.put("vlrTabela", 0);
	}
	if(!json.get("vlrTabelaAnt") || json.get("vlrTabelaAnt") === null || json.get("vlrTabelaAnt") === undefined){
		json.put("vlrTabelaAnt", 0);
	}

	return json;
};
