/**
* Created by maurodouglas on 01/11/16.
*/

load( '/basicos/validaCpfCnpj.js' );
var ValidaFuncionario = function( ) {
	this.mapper = mapperFactory.createMapperMult([ "FpFunc", "GlbUsu" ]);
};


/**
  * Metodo valida os dados enviados para o cadasto do funcionario
  * @param {HashMap JAVA} json - parametro de código de empresa e cliente passados no momento da requisicao
  * @throws {InvalidArgumentException}
  */
ValidaFuncionario.prototype.validaDadosParaCadastroFuncionario = function( json ) {
	if ( !json ) {
		throw { code: 599, message: "Dados passados ao servidor inválido!" };
	}

  if (json.get( "cpfFun") !== null && json.get( "cpfFun").length() >= 11 && !validarCPF(json.get("cpfFun"))) {
    throw { code: 599, message: "CPF " + json.get("cpfFun") + " informado no cadastro não é um CPF Valido!" };
  }
  if (json.get( "cpfFun") !== null && json.get( "cpfFun").length() >= 11 && this.isFuncionarioJaCadastrado({'cpfFun': json.get( "cpfFun" )})) {
		throw { code: 599, message: "Funcionario " + json.get("cdFun") + ' - ' + json.get("nmFun") + " já cadastrado!" };
	}

  var dadosDefault = this.dadosDefaultFpFunc(json);
  return dadosDefault;
};

/**
  * Metodo valida se o funcionario já esta cadastrado no sistema
  * @param {HashMap JAVA} json - Cpf do funcionario
  * @throws {InvalidArgumentException}
  */
ValidaFuncionario.prototype.isFuncionarioJaCadastrado = function( json ) {
	if ( json === null ) {
		throw { code: 599, message: "Dados passados ao servidor inválido!" };
	}

	var funcionario = this.mapper.selectOne( "FpFunc.listarFpFunc", json );
	return ( funcionario ? true : false );
};


/**
  * Metodo valida os dados enviados para o cadasto do Usuario
  * @param {HashMap JAVA} json - parametro de código de empresa e cliente passados no momento da requisicao
  * @throws {InvalidArgumentException}
  */
ValidaFuncionario.prototype.validaDadosParaCadastroUsuario = function( json ) {
	if ( !json ) {
		throw { code: 599, message: "Dados passados ao servidor inválido!" };
	}

  var dadosDefault = this.dadosDefaultGlbUsu(json);
  return dadosDefault;
};

ValidaFuncionario.prototype.dadosDefaultFpFunc = function( json ) {
	if ( !json.get( "agcCnt" ) || json.get( "agcCnt" ) === null || json.get( "agcCnt" ) === undefined ) {
		json.put("agcCnt", " ");
	}
	if ( !json.get( "bairroFun" ) || json.get( "bairroFun" ) === null || json.get( "bairroFun" ) === undefined ) {
		json.put("bairroFun", " ");
	}
	if ( !json.get( "cdBc" ) || json.get( "cdBc" ) === null || json.get( "cdBc" ) === undefined ) {
		json.put("cdBc", 0);
	}
	if ( !json.get( "cdCargo" ) || json.get( "cdCargo" ) === null || json.get( "cdCargo" ) === undefined ) {
		json.put("cdCargo", 0);
	}
	if ( !json.get( "cdCid" ) || json.get( "cdCid" ) === null || json.get( "cdCid" ) === undefined ) {
		json.put("cdCid", 0);
	}
	if ( !json.get( "cdEmp" ) || json.get( "cdEmp" ) === null || json.get( "cdEmp" ) === undefined ) {
		json.put("cdEmp", 1);
	}
	if ( !json.get( "cdFilial" ) || json.get( "cdFilial" ) === null || json.get( "cdFilial" ) === undefined ) {
		json.put("cdFilial", 0);
	}
	if ( !json.get( "cdFun" ) || json.get( "cdFun" ) === null || json.get( "cdFun" ) === undefined ) {
		json.put("cdFun", 0);
	}
	if ( !json.get( "cdFuncUsu" ) || json.get( "cdFuncUsu" ) === null || json.get( "cdFuncUsu" ) === undefined ) {
		json.put("cdFuncUsu", 0);
	}
	if ( !json.get( "cdUsu" ) || json.get( "cdUsu" ) === null || json.get( "cdUsu" ) === undefined ) {
		json.put("cdUsu", 0);
	}
	if ( !json.get( "cpfFun" ) || json.get( "cpfFun" ) === null || json.get( "cpfFun" ) === undefined ) {
		json.put("cpfFun", " ");
	}
	if ( !json.get( "ctps" ) || json.get( "ctps" ) === null || json.get( "ctps" ) === undefined ) {
		json.put("ctps", " ");
	}
	if ( !json.get( "email" ) || json.get( "email" ) === null || json.get( "email" ) === undefined ) {
		json.put("email", " ");
	}
	if ( !json.get( "endFun" ) || json.get( "endFun" ) === null || json.get( "endFun" ) === undefined ) {
		json.put("endFun", " ");
	}
	if ( !json.get( "fer" ) || json.get( "fer" ) === null || json.get( "fer" ) === undefined ) {
		json.put("fer", 0);
	}
	if ( !json.get( "funSubs" ) || json.get( "funSubs" ) === null || json.get( "funSubs" ) === undefined ) {
		json.put("funSubs", " ");
	}
	if ( !json.get( "liberaDesc" ) || json.get( "liberaDesc" ) === null || json.get( "liberaDesc" ) === undefined ) {
		json.put("liberaDesc", 0);
	}
	if ( !json.get( "matric" ) || json.get( "matric" ) === null || json.get( "matric" ) === undefined ) {
		json.put("matric", 0);
	}
	if ( !json.get( "nmFun" ) || json.get( "nmFun" ) === null || json.get( "nmFun" ) === undefined ) {
		json.put("nmFun", " ");
	}
	if ( !json.get( "nrCnt" ) || json.get( "nrCnt" ) === null || json.get( "nrCnt" ) === undefined ) {
		json.put("nrCnt", " ");
	}
	if ( !json.get( "percComi" ) || json.get( "percComi" ) === null || json.get( "percComi" ) === undefined ) {
		json.put("percComi", 0);
	}
	if ( !json.get( "percDesc" ) || json.get( "percDesc" ) === null || json.get( "percDesc" ) === undefined ) {
		json.put("percDesc", 0);
	}
	if ( !json.get( "percDescCred" ) || json.get( "percDescCred" ) === null || json.get( "percDescCred" ) === undefined ) {
		json.put("percDescCred", 0);
	}
	if ( !json.get( "priNm" ) || json.get( "priNm" ) === null || json.get( "priNm" ) === undefined ) {
		json.put("priNm", " ");
	}
	if ( !json.get( "rgFun" ) || json.get( "rgFun" ) === null || json.get( "rgFun" ) === undefined ) {
		json.put("rgFun", " ");
	}
	if ( !json.get( "senha" ) || json.get( "senha" ) === null || json.get( "senha" ) === undefined ) {
		json.put("senha", " ");
	}
	if ( !json.get( "stsFun" ) || json.get( "stsFun" ) === null || json.get( "stsFun" ) === undefined ) {
		json.put("stsFun", 0);
	}
	if ( !json.get( "telCel" ) || json.get( "telCel" ) === null || json.get( "telCel" ) === undefined ) {
		json.put("telCel", " ");
	}
	if ( !json.get( "telFun" ) || json.get( "telFun" ) === null || json.get( "telFun" ) === undefined ) {
		json.put("telFun", " ");
	}
	if ( !json.get( "telRes" ) || json.get( "telRes" ) === null || json.get( "telRes" ) === undefined ) {
		json.put("telRes", " ");
	}
	if ( !json.get( "titElei" ) || json.get( "titElei" ) === null || json.get( "titElei" ) === undefined ) {
		json.put("titElei", " ");
	}
	if ( !json.get( "tpVend" ) || json.get( "tpVend" ) === null || json.get( "tpVend" ) === undefined ) {
		json.put("tpVend", 0);
	}
	if ( !json.get( "vlrGratif" ) || json.get( "vlrGratif" ) === null || json.get( "vlrGratif" ) === undefined ) {
		json.put("vlrGratif", 0);
	}
	if ( !json.get( "vlrSal" ) || json.get( "vlrSal" ) === null || json.get( "vlrSal" ) === undefined ) {
		json.put("vlrSal", 0);
	}
	if ( !json.get( "vlrVlRef" ) || json.get( "vlrVlRef" ) === null || json.get( "vlrVlRef" ) === undefined ) {
		json.put("vlrVlRef", 0);
	}
	if ( !json.get( "vlrVlTransp" ) || json.get( "vlrVlTransp" ) === null || json.get( "vlrVlTransp" ) === undefined ) {
		json.put("vlrVlTransp", 0);
	}

	return json;
};

ValidaFuncionario.prototype.dadosDefaultGlbUsu = function( json ) {
	if ( !json.get( "cdCargo" ) || json.get( "cdCargo" ) === null || json.get( "cdCargo" ) === undefined ) {
		json.put("cdCargo", 0);
	}
	if ( !json.get( "cdFilial" ) || json.get( "cdFilial" ) === null || json.get( "cdFilial" ) === undefined ) {
		json.put("cdFilial", 0);
	}
	if ( !json.get( "dba" ) || json.get( "dba" ) === null || json.get( "dba" ) === undefined ) {
		json.put("dba", 0);
	}
	//if ( !json.get( "dtSenhaAlterada" ) || json.get( "dtSenhaAlterada" ) === null || json.get( "dtSenhaAlterada" ) === undefined ) {
	//	json.put("dtSenhaAlterada", getdate( ));
	//}
	if ( !json.get( "nmUsu" ) || json.get( "nmUsu" ) === null || json.get( "nmUsu" ) === undefined ) {
		json.put("nmUsu", " ");
	}
	if ( !json.get( "senha" ) || json.get( "senha" ) === null || json.get( "senha" ) === undefined ) {
		json.put("senha", " ");
	}
	if ( !json.get( "sit" ) || json.get( "sit" ) === null || json.get( "sit" ) === undefined ) {
		json.put("sit", 0);
	}
	if ( !json.get( "usuTele" ) || json.get( "usuTele" ) === null || json.get( "usuTele" ) === undefined ) {
		json.put("usuTele", 0);
	}
	return json;
};
