load( "/rules/produto/preco/validaDados.js" );
load( '/model/erro/admErroCadBasicosIntegracoes.js' );
/**
 * Created by Mauro Douglas on 04/01/17.
 */
var Preco = function( ) {
	this.mapper        = mapperFactory.createMapperMult([ "EstProdPreco", "EstProd" ]);
	this.validaPreco   = new ValidaPreco( );
	this.gravaErro     = new AdmErroIntegracoes( );
	this.jsonConvert   = new com.google.gson.GsonBuilder( ).create( );
	this.i             = 0;
};

/**
 * Metodo faz controle das inserções de preço a serem feitas
 * @param {HashMap JAVA} json - parametro passado no momento da requisicao
 * @throws {InvalidArgumentException}
 * @return retorna objeto com todos os dados que foram inseridos
 */
Preco.prototype.inserePreco = function( json ) {
	if ( !json ) {
		throw { code: 599, message: "Dados passados ao servidor inválido!" };
	}
	if (json.get( "obj" )) {
		var obj = json.get( "obj" );
	} else {
		var obj = mapperFactory.createMap( );
		obj.put( 0, json );
	}

	try {
		for ( this.i = 0; this.i < obj.size( ); this.i++ ) {
			var item         = obj.get( this.i );
      var itemValidado = this.validaPreco.validaDadosParaCadastro(item);
      this.mapper.insert("EstProdPreco.inserirEstProdPreco", itemValidado);
      //this.gravaSucesso( itemValidado );
		}

    this.mapper.commit( );
    return obj;
	} catch ( err ) {
		java.lang.System.out.println( err );
		this.mapper.rollback( );
		//gravaErro(itemValidado,err);
		if ( err.code ) {
			throw JSON.stringify( err );
		}
		throw "{erro:true,  message:'" + escape( err ) + "'}";
	}
};

Preco.prototype.gravaSucesso = function( json ) {
	var metodo = 'POST';
	var msgErro = {};
	msgErro.id             = parseInt(json.get( "cdProd" ));
	msgErro.tabela         = "EST_PROD_CD_BARRA";
	msgErro.jsonEnviado    = this.jsonConvert.toJson( json );
	msgErro.stsErro        = 1; // Importado com sucesso
	msgErro.cdUsuCorrecao  = 0;
	msgErro.laudo          = 'Registro ' + json.get( "cdProd" ) + ' inserido com sucesso.';
	this.gravaErro.gerenciaErro( metodo, msgErro );
};

Preco.prototype.gravaErro = function( json ) {
	java.lang.System.out.println( 'itemValidado ' + itemValidado );
	var metodo = 'POST';
	var msgErro = {};
	msgErro.id = json.get( "cdConv" ) || 0;
	msgErro.tabela = json.get( "tabela" );
	msgErro.jsonEnviado = this.jsonConvert.toJson( json );
	msgErro.stsErro = 2; // Erro
	msgErro.cdUsuCorrecao = 0;
	msgErro.laudo = jsonConvert.toJson( err );
	this.gravaErro.gerenciaErro( metodo, msgErro );
};
