load( "/rules/produto/validaDados.js" );
load( '/model/erro/admErroCadBasicosIntegracoes.js' );
/**
 * Created by Mauro Douglas on 04/01/17.
 */
var Produto = function( ) {
	this.mapper        = mapperFactory.createMapperMult([ "EstProdCdBarra", "EstProd","EstProdCpl" ]);
	this.validaProduto = new ValidaProduto( );
	this.gravaErro     = new AdmErroIntegracoes( );
	this.jsonConvert   = new com.google.gson.GsonBuilder( ).create( );
	this.i             = 0;
};

/**
 * Metodo faz controle das inserções de produto a serem feitas
 * @param {HashMap JAVA} json - parametro passado no momento da requisicao
 * @throws {InvalidArgumentException}
 * @return retorna objeto com todos os dados que foram inseridos
 */
Produto.prototype.insereProduto = function(json) {
	if (!json)
		throw {code: 599, message: "Dados passados ao servidor inválido!"};

	if (json.get("obj")){
		var obj = json.get("obj");
	}else{
		var obj = new java.util.ArrayList();
		obj.add(json);
	}

	try{
		
		for(this.i = 0; this.i < obj.size(); this.i++){
			var item = obj.get(this.i);
			var itemValidado = this.validaProduto.validaDadosParaCadastro(item);
			this.mapper.insert("EstProd.inserirEstProd", itemValidado);
			this.gravarTributacao(itemValidado);

			if(itemValidado.get("importador") == 1)
                this.gravaSucesso(itemValidado);
		}
		
		this.mapper.commit();
		
		if(obj.size() == 1)
			return obj.get(0).get("cdProd");
		else
			return obj;
		
	}catch (err) {
		this.mapper.rollback();
		throw err;
	}
};


Produto.prototype.gravarTributacao = function(json) {
	if(json.get('isMvp') == 1){
        let tributacao = {
			'cdEmp': json.get('cdEmp'),
			'cdUsu': json.get('cdUsu'),
            'cdProd': json.get('cdProd'),
            'cdFilial':1,
            'tributacao': json.get('tributacao')
        }
        this.mapper.update("EstProd.alterarTributacaoMvp", tributacao);
    }
}

/**
 * Metodo faz controle do fechamento de estoque
 * @param {HashMap JAVA} json - parametro passado no momento da requisicao
 * @throws {InvalidArgumentException}
 * @return retorna objeto com todos os dados que foram inseridos
 */
Produto.prototype.insereFechamentoEstoque = function( json ) {
	if ( !json ) {
		throw { code: 599, message: "Dados passados ao servidor inválido!" };
	}
	if (json.get( "obj" )) {
		var obj = json.get( "obj" );
	} else {
		var obj = mapperFactory.createMap( );
		obj.put( 0, json );
	}

	try {
		for ( this.i = 0; this.i < obj.size( ); this.i++ ) {
			var item         = obj.get( this.i );
			this.mapper.insert("EstProdCpl.alterarEstProdCpl", {"cdEmp":json.get("cdEmp") , "cdFilial":json.get("cdFilial") , "qtEst":json.get("qtEst")});

			var itemValidado = this.validaProduto.validaDadosParaCadastroFechamentoEstoque(item);

      this.mapper.insert("EstFecha.inserirEstFecha", itemValidado);
      this.gravaSucesso( itemValidado );
		}

    this.mapper.commit( );
    return obj;
	} catch ( err ) {
		java.lang.System.out.println( err );
		this.mapper.rollback( );
		//gravaErro(itemValidado,err);
		if ( err.code ) {
			throw JSON.stringify( err );
		}
		throw "{erro:true,  message:'" + escape( err ) + "'}";
	}
};

Produto.prototype.gravaSucesso = function( json ) {
	var metodo = 'POST';
	var msgErro = {};
	msgErro.id             = parseInt(json.get( "cdProd" ));
	msgErro.tabela         =  "EST_PROD" ;
	msgErro.jsonEnviado    = this.jsonConvert.toJson( json );
	msgErro.stsErro        = 1; // Importado com sucesso
	msgErro.cdUsuCorrecao  = 0;
	msgErro.laudo          = 'Registro ' + json.get( "cdProd" ) + ' inserido com sucesso.';
	this.gravaErro.gerenciaErro( metodo, msgErro );
};

Produto.prototype.gravaErro = function( json ) {
	java.lang.System.out.println( 'itemValidado ' + itemValidado );
	var metodo = 'POST';
	var msgErro = {};
	msgErro.id = json.get( "cdProd" ) || 0;
	msgErro.tabela = "EST_PROD";
	msgErro.jsonEnviado = this.jsonConvert.toJson( json );
	msgErro.stsErro = 2; // Erro
	msgErro.cdUsuCorrecao = 0;
	msgErro.laudo = jsonConvert.toJson( err );
	this.gravaErro.gerenciaErro( metodo, msgErro );
};


/**
 * Metodo faz controle da atualização de estoque dos produtos
 * @param {HashMap JAVA} json - parametro passado no momento da requisicao
 * 		  int metodo - 1 - adiciona estoque, 2 - diminui estoque
 * @throws {InvalidArgumentException}
 */
Produto.prototype.atualizaEstoque = function( json,metodo) {
	if ( !json ) {
		throw { code: 599, message: "Dados passados ao servidor inválido!" };
	}

	this.mapper.insert("EstProdCpl.alterarEstoqueProdCpl", {"cdEmp":json.get("cdEmp") , "cdFilial":json.get("cdFilial") , "qtEst":json.get("qtEst"), "cdProd":json.get("cdProd"),"tipoAtu":parseInt(metodo)});		

}