load( "/rules/produto/arvoreMercadologica/validaDados.js" );
load( '/model/erro/admErroCadBasicosIntegracoes.js' );
/**
 * Created by Mauro Douglas on 04/01/17.
 */
var ArvoreMercadologica = function( ) {
	this.mapper        = mapperFactory.createMapperMult([ "EstArvMercLinha", "EstArvMercFamilia" ]);
	this.validaArvore  = new ValidaArvore( );
	this.gravaErro     = new AdmErroIntegracoes( );
	this.jsonConvert   = new com.google.gson.GsonBuilder( ).create( );
	this.i             = 0;
};

/**
 * Metodo faz controle das inserções de familia a serem feitas
 * @param {HashMap JAVA} json - parametro passado no momento da requisicao
 * @throws {InvalidArgumentException}
 * @return retorna objeto com todos os dados que foram inseridos
 */
ArvoreMercadologica.prototype.insereFamilia = function( json ) {
	if ( !json ) {
		throw { code: 599, message: "Dados passados ao servidor inválido!" };
	}
	if (json.get( "obj" )) {
		var obj = json.get( "obj" );
	} else {
		var obj = mapperFactory.createMap( );
		obj.put( 0, json );
	}

	try {
		for ( this.i = 0; this.i < obj.size( ); this.i++ ) {
			var item         = obj.get( this.i );
      var itemValidado = this.validaArvore.validaDadosParaCadastroFamilia(item);
      this.mapper.insert("EstArvMercFamilia.incluirEstArvMercFamilia", itemValidado);
      itemValidado.put("tabela","EST_ARV_MERC_FAMILIA");
      itemValidado.put("codigo",itemValidado.get("cdArvMercFamilia"));
      this.gravaSucesso( itemValidado );
		}

    this.mapper.commit( );
    return obj;
	} catch ( err ) {
		java.lang.System.out.println( err );
		this.mapper.rollback( );
		//gravaErro(itemValidado,err);
		throw err;
	}
};

/**
 * Metodo faz controle das inserções de Linha a serem feitas
 * @param {HashMap JAVA} json - parametro passado no momento da requisicao
 * @throws {InvalidArgumentException}
 * @return retorna objeto com todos os dados que foram inseridos
 */
ArvoreMercadologica.prototype.insereLinha = function( json ) {
	if (!json)
		throw { code: 599, message: "Dados passados ao servidor inválido!" };
	
	if(json.get( "obj" )) {
		var obj = json.get( "obj" );
	} else {
		var obj = mapperFactory.createMap( );
		obj.put( 0, json );
	}

	try {
		for ( this.i = 0; this.i < obj.size( ); this.i++ ) {
			var item         = obj.get( this.i );
      var itemValidado = this.validaArvore.validaDadosParaCadastroLinha(item);
      this.mapper.insert("EstArvMercLinha.incluirEstArvMercLinha", itemValidado);
      itemValidado.put("tabela","EST_ARV_MERC_LINHA");
      itemValidado.put("codigo",itemValidado.get("cdArvMercLinha"));
      this.gravaSucesso( itemValidado );
		}

    this.mapper.commit( );
    return obj;
    
	} catch ( err ) {
		java.lang.System.out.println( err );
		this.mapper.rollback( );
		//gravaErro(itemValidado,err);
		throw err;
	}
};


ArvoreMercadologica.prototype.gravaSucesso = function( json ) {
	var metodo = 'POST';
	var msgErro = {};
	msgErro.id             = parseInt(json.get( "codigo" ));
	msgErro.tabela         = json.get( "tabela" );
	msgErro.jsonEnviado    = this.jsonConvert.toJson( json );
	msgErro.stsErro        = 1; // Importado com sucesso
	msgErro.cdUsuCorrecao  = 0;
	msgErro.laudo          = 'Registro ' + json.get( "codigo" ) + ' inserido com sucesso.';
	this.gravaErro.gerenciaErro( metodo, msgErro );
};

ArvoreMercadologica.prototype.gravaErro = function( json ) {
	java.lang.System.out.println( 'itemValidado ' + itemValidado );
	var metodo = 'POST';
	var msgErro = {};
	msgErro.id = json.get( "cdConv" ) || 0;
	msgErro.tabela = json.get( "tabela" );
	msgErro.jsonEnviado = this.jsonConvert.toJson( json );
	msgErro.stsErro = 2; // Erro
	msgErro.cdUsuCorrecao = 0;
	msgErro.laudo = jsonConvert.toJson( err );
	this.gravaErro.gerenciaErro( metodo, msgErro );
};
