var Produto = function () {
    this.mapper = mapperFactory.createMapperMult(["ConsultaProduto", "EstProd", "EstProdEstArvMercadologica", "EstProdForn", "EstProdCdBarra",
        "EstProdPrincAtivosEstProd", "EstProdCpl", "EstProdPrecoAltUnico", "GlbScheduleArquivos", "GlbScheduleJob", "EstProdPrecoAlt"
    ]);
    this.jsonConvert = new com.google.gson.GsonBuilder().create();
};

Produto.prototype.clonar = function (json) {
    if (json == null || json.size() == 0 || json.get('cdUsu') == null || json.get('cdEmp') == null || json.get('cdProd') == null)
        throw {
            code: 599,
            message: "Dados passados ao servidor inválido!"
        };

    try {
        let produtosInseridos = [];
        let produtoFonte = this.mapper.selectOne('ConsultaProduto.listarProdutos', {
            'cdEmp': json.get('cdEmp'),
            'cdProd': json.get('cdProd')
        });
        let clones = json.get('clones');
        for (let i = 0; i < clones.size(); i++) {
            let produtoClone = produtoFonte.clone();
            produtoClone.put('cdProd', null);
            produtoClone.put('dsProd', clones.get(i).get('dsProd'));
            produtoClone.put('dsUsual', clones.get(i).get('dsUsual'));
            produtoClone.put('cdUsu', json.get('cdUsu'));
            produtoClone.put('nrRegMs', '');
            this.mapper.insert("EstProd.inserirEstProd", produtoClone);

            produtosInseridos.push(produtoClone);

            let arvoreMercadologica = {
                'cdEmp': json.get('cdEmp'),
                'cdProd': produtoClone.get('cdProd'),
                'cdUsu': json.get('cdUsu'),
                'cdArvMercCateg': produtoClone.get('arvMerc').get(0).get('cdArvMercCateg'),
                'cdArvMercSeg': produtoClone.get('arvMerc').get(0).get('cdArvMercSeg'),
                'cdArvMercPapel': produtoClone.get('arvMerc').get(0).get('cdArvMercPapel'),
                'cdArvMercMix': produtoClone.get('arvMerc').get(0).get('cdArvMercMix'),
                'cdArvMercConsumo': produtoClone.get('arvMerc').get(0).get('cdArvMercConsumo'),
                'cdArvMercLinha': produtoClone.get('arvMerc').get(0).get('cdArvMercLinha'),
                'cdArvMercMtzBcg': produtoClone.get('arvMerc').get(0).get('cdArvMercMtzBcg'),
                'cdMc': produtoClone.get('arvMerc').get(0).get('cdMc'),
                'cdArvMercFamilia': produtoClone.get('arvMerc').get(0).get('cdArvMercFamilia'),
                'cdArvMercEqui': produtoClone.get('arvMerc').get(0).get('cdArvMercEqui'),
                'cdApres': produtoClone.get('arvMerc').get(0).get('cdApres'),
                'cdGrpExpo': produtoClone.get('arvMerc').get(0).get('cdGrpExpo'),
                'cdArvMercClassificacao': produtoClone.get('arvMerc').get(0).get('cdArvMercClassificacao'),
                'cdArvMercFase': produtoClone.get('arvMerc').get(0).get('cdArvMercFase'),
                'cdArvMercGenero': produtoClone.get('arvMerc').get(0).get('cdArvMercGenero'),
                'gramatura': produtoClone.get('arvMerc').get(0).get('gramatura'),
                'cdArvMercCategSub': produtoClone.get('arvMerc').get(0).get('cdArvMercCategSub') 
            };
            this.mapper.update("EstProdEstArvMercadologica.alterarEstProdEstArvMercadologica", arvoreMercadologica);

            if (produtoClone.get('princAtivo').size() > 0) {
                let princAtivo = {
                    'cdEmp': json.get('cdEmp'),
                    'cdProd': produtoClone.get('cdProd'),
                    'cdUsu': json.get('cdUsu'),
                    'cdPrincAtivos': produtoClone.get('princAtivo').get(0).get('cdPrincAtivos')
                };

                this.mapper.insert("EstProdPrincAtivosEstProd.incluirEstProdPrincAtivosEstProd", princAtivo);
            }

            if (produtoClone.get('filial').size() > 0) {
                for (let j = 0; j < produtoClone.get('filial').size(); j++) {
                    this.mapper.insert('EstProdCpl.incluirEstProdCpl', {
                        'cdProd': produtoClone.get('cdProd'),
                        'cdFilial': produtoClone.get('filial').get(j).get('cdFilial')
                    });
                }
            }
        }

        this.mapper.commit();
        return produtosInseridos;

    } catch (err) {
        this.mapper.rollback();
        throw err;
    }
};


Produto.prototype.getDadosDoProdutoByDicionarioDoFornecedor = function (json) {
    let produtosEncontrados = this.mapper.selectList('EstProdForn.getDadosDoProdutoByDicionarioDoFornecedor', {
        'cdEmp': 1,
        'produtos': json.produtos,
        'cdForn': json.cdForn
    });
    if (produtosEncontrados.size() > 0) {
        for (let i = 0; i < produtosEncontrados.size(); i++) {
            for (let j = 0; i < json.produtos.length; j++) {
                if (produtosEncontrados.get(i).get('cdProdForn') == json.produtos[j].cdProdForn) {
                    json.produtos[j].cdProd = produtosEncontrados.get(i).get('cdProd');
                    json.produtos[j].dsUsual = produtosEncontrados.get(i).get('dsUsual');
                    break;
                }
            }
        }
    }
    return json.produtos;
};

Produto.prototype.getDadosDoProdutoByEan = function (json) {
    let produtosEncontrados = this.mapper.selectList('EstProdCdBarra.getDadosDoProdutoByEan', {
        'cdEmp': 1,
        'produtos': json.produtos
    });
    if (produtosEncontrados.size() > 0) {
        for (let i = 0; i < produtosEncontrados.size(); i++) {
            for (let j = 0; i < json.produtos.length; j++) {
                if (produtosEncontrados.get(i).get('ean') == json.produtos[j].ean) {
                    json.produtos[j].cdProd = produtosEncontrados.get(i).get('cdProd');
                    json.produtos[j].dsUsual = produtosEncontrados.get(i).get('dsUsual');
                    break;
                }
            }
        }
    }
    return json.produtos;
};

Produto.prototype.agendarAtualizacaoStatus = function (json) {
    try {
        let sdf = new java.text.SimpleDateFormat('dd/MM/yyyy HH:mm:ss');
        let dateString = sdf.format(new java.util.Date());

        let agendamento = new java.util.HashMap();
        agendamento.put('cdUsu', json.get('cdUsu'));
        agendamento.put('arquivo', json.get('arquivo'));
        agendamento.put('nmArquivo', 'IMPORTACAO_STATUS_PRODUTO '+ '_' + json.get('cdUsu') + '_' + dateString);

        this.mapper.insert("GlbScheduleArquivos.agendar", agendamento);

        let job = {
            'cdCtrArquivo': agendamento.get('cdCtr'),
            'nmSchedule': 'IMPORTACAO_STATUS_PRODUTO',
            'stepScript': 1,
            'sts': 0,
            'tpAgd': 1,
            'cdUsu': json.get('cdUsu')
        };

        this.mapper.insert('GlbScheduleJob.incluirGlbScheduleJob', job);
        this.mapper.commit();

    } catch (err) {
        this.mapper.rollback();
        throw err;
    }
};

Produto.prototype.atualizarEmbalagens = function (json) {
    try {
        let produtos = json.get('produtos');
        for (var i = 0; i < produtos.size(); i++) {
            if (produtos.get(i).get('cdEmp') != null && produtos.get(i).get('cdProd') != null)
                this.mapper.update('EstProd.atualizarEmbalagensProduto', {
                    'cdEmp': produtos.get(i).get('cdEmp'),
                    'cdProd': produtos.get(i).get('cdProd'),
                    'umm': produtos.get(i).get('umm'),
                    'qtEmbFechadaCp': produtos.get(i).get('qtEmbFechadaCp'),
                    'qtEmbAlternativaCp': produtos.get(i).get('qtEmbAlternativaCp'),
                    'cdUsu': json.get('cdUsu')
                });
        }

        this.mapper.commit();
    } catch (err) {
        this.mapper.rollback();
    }
};

Produto.prototype.atualizarFabricantes = function (json) {
    try {
        let produtos = json.get('produtos');
        for (var i = 0; i < produtos.size(); i++) {
            if (produtos.get(i).get('cdEmp') != null && produtos.get(i).get('cdProd') != null)
                this.mapper.update('EstProd.atualizarFabricantesProduto', {
                    'cdEmp': produtos.get(i).get('cdEmp'),
                    'cdProd': produtos.get(i).get('cdProd'),
                    'cdFabric': produtos.get(i).get('cdFabric'),
                    'cdUsu': json.get('cdUsu')
                });
        }

        this.mapper.commit();
    } catch (err) {
        this.mapper.rollback();
    }
};

Produto.prototype.agendarPreco = function (json) {

    let sdf = new java.text.SimpleDateFormat('dd/MM/yyyy HH:mm:ss');
    let dateString = sdf.format(new java.util.Date());

    let agendamento = new java.util.HashMap();
    agendamento.put('cdUsu', json.get('cdUsu'));
    agendamento.put('arquivo', json.get('arquivo'));
    agendamento.put('nmArquivo', 'IMPORTACAO_PRECO' + '_' + json.get('cdUsu') + '_' + dateString);

    this.mapper.insert("GlbScheduleArquivos.agendar", agendamento);
    
    let job = {
        'cdCtrArquivo': agendamento.get('cdCtr'),
        'nmSchedule': 'IMPORTACAO_PRECO',
        'stepScript': 1,
        'sts': 0,
        'tpAgd': 1,
        'cdUsu': json.get('cdUsu')
    };

    this.mapper.insert('GlbScheduleJob.incluirGlbScheduleJob', job);
};

Produto.prototype.atualizarPreco = function (json) {
    if (json.get('flagAgendamento') == 1) {
        this.agendarPreco(json);
    } else {
        for(let i=0; i<json.get("listaDePreco").size(); i++){
            let param = java.util.HashMap();
            param.put("cdEmp", json.get("cdEmp"));
            param.put("cdUsu", json.get("cdUsu"));
            param.put("cdProd", json.get("cdProd"));
            param.put("vlrTabela", json.get("listaDePreco").get(i).get("vlrTabela"));
            param.put("filiais", json.get("listaDePreco").get(i).get("filiais"));

            this.mapper.insert('EstProdPrecoAltUnico.inserirEstProdPrecoAlt', param);
            this.mapper.insert('EstProdPrecoAltUnico.inserirEstProdPrecoAltCpl', param);
        }
    }
};