/**
 * Created by victor vieira garcia on 18/12/2017.
 */

var Importador = function () {
    this.mapper = mapperFactory.createMapperMult(["EstProdPrecoCondCompra", "EstProdPrecoCondCompraCpl", "EstProd"]);
    this.jsonConvert = new com.google.gson.GsonBuilder().create();
};

/**
 * Metodo importar preco fornecedor
 * @param {HashMap JAVA} json - parametro passado no momento da requisicao
 * @throws {InvalidArgumentException}
 * @throws {SQLException}
 */

Importador.prototype.importaPrecoFornecedor = function (json) {
    if (!json) {
        throw {
            code: 599,
            message: "Dados passados ao servidor inválido!"
        };
    }

    try {

        var objProdCpl = {
            'cdEmp': json.get('cdEmp'),
            'cdCondCompra': 0,
            'cdProd': 0,
            'vlrCompra': 0,
            'percDesc': 0
        }

        if (json.get('cdCondCompra')) {
            this.mapper.update('EstProdPrecoCondCompra.alterarEstProdPrecoCondCompra', json);

            this.mapper.insert('EstProdPrecoCondCompraCpl.excluirEstProdPrecoCondCompraCpl', {
                'cdEmp': 1,
                'cdCondCompra': json.get('cdCondCompra')
            });

            objProdCpl.cdCondCompra = json.get('cdCondCompra');

            if (json.get('produtos').size() == 0) {
                throw {
                    code: 599,
                    message: "Lista de produtods está vazia!"
                };
            }

            for (var i = 0; i < json.get('produtos').size(); i++) {
                objProdCpl.cdProd = json.get('produtos').get(i).get('cdProd');
                if (json.get('chqZerarVlrProd') == true) {
                    objProdCpl.vlrProd = 0;
                    objProdCpl.percDesc = 0;
                } else {
                    objProdCpl.vlrProd = json.get('produtos').get(i).get('vlrCompra');
                    objProdCpl.percDesc = json.get('produtos').get(i).get('vlrDesc');
                }
                this.mapper.insert('EstProdPrecoCondCompraCpl.incluirEstProdPrecoCondCompraCpl', objProdCpl);
            }

        } else {
            var cdCondCompra = this.mapper.selectOne('EstProdPrecoCondCompra.maxCdCondCompra', {});

            json.put("cdCondCompra", cdCondCompra.get('cdCondCompra'));

            this.mapper.insert('EstProdPrecoCondCompra.incluirEstProdPrecoCondCompra', json);

            objProdCpl.cdCondCompra = json.get('cdCondCompra');

            var prodImpFornecedor = [];
            if (json.get('chqBuscaPrecoFabricante') == true) {
                var prodImpFornecedor = this.mapper.insert('EstProd.insereProdutosImportadosFornecedor', {
                    'cdFilial': json.get('cdFilial'),
                    'cdCtrGrp': json.get('cdCtrGrp'),
                    'cdCondCompra': json.get('cdCondCompra'),
                    'cdEmp': 1,
                    'chqZerarVlrProd': json.get('chqZerarVlrProd')
                });
            } else {
                if (json.get('produtos').size() == 0) {
                    throw {
                        code: 599,
                        message: "Lista de produtods está vazia!"
                    };
                }

                for (var i = 0; i < json.get('produtos').size(); i++) {
                    objProdCpl.cdProd = json.get('produtos').get(i).get('cdProd');
                    if (json.get('chqZerarVlrProd') == true) {
                        objProdCpl.vlrProd = 0;
                        objProdCpl.percDesc = 0;
                    } else {
                        objProdCpl.vlrProd = json.get('produtos').get(i).get('vlrCompra');
                        objProdCpl.percDesc = json.get('produtos').get(i).get('vlrDesc');
                    }
                    this.mapper.insert('EstProdPrecoCondCompraCpl.incluirEstProdPrecoCondCompraCpl', objProdCpl);
                }
            }
        }

        this.mapper.commit();
        return true;
    } catch (err) {
        this.mapper.rollback();
        throw err;
    }
};